/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.vfs.WriteStream;
import com.caucho.xml.CauchoNode;
import com.caucho.xml.QDOMException;
import com.caucho.xml.QDocument;
import com.caucho.xml.QNode;
import com.caucho.xml.XmlChar;
import com.caucho.xml.XmlPrinter;
import java.io.IOException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class QAbstractNode
implements CauchoNode {
    QDocument owner;
    QNode parent;
    QAbstractNode next;
    QAbstractNode previous;
    String filename;
    int line;
    int column;

    public void setLocation(String string, int n, int n2) {
        this.filename = string;
        this.line = n;
        this.column = n2;
    }

    public String getFilename() {
        if (this.filename != null) {
            return this.filename;
        }
        if (this.previous != null) {
            return this.previous.getFilename();
        }
        if (this.parent != null) {
            return this.parent.getFilename();
        }
        return null;
    }

    public int getLine() {
        if (this.filename != null) {
            return this.line;
        }
        if (this.previous != null) {
            return this.previous.getLine();
        }
        if (this.parent != null) {
            return this.parent.getLine();
        }
        return 0;
    }

    public int getColumn() {
        if (this.filename != null) {
            return this.column;
        }
        if (this.previous != null) {
            return this.previous.getColumn();
        }
        if (this.parent != null) {
            return this.parent.getColumn();
        }
        return 0;
    }

    public Document getOwnerDocument() {
        return this.owner;
    }

    public String getPrefixName() {
        return "";
    }

    public String getCanonicalName() {
        return this.getNodeName();
    }

    public String getLocalName() {
        return this.getNodeName();
    }

    public String getNamespace() {
        return "";
    }

    public String getNodeValue() {
        return null;
    }

    public void setNodeValue(String string) {
    }

    public Node getParentNode() {
        return this.parent;
    }

    public NodeList getChildNodes() {
        return null;
    }

    public Node getFirstChild() {
        return null;
    }

    public Node getLastChild() {
        return null;
    }

    public Node getPreviousSibling() {
        return this.previous;
    }

    public Node getNextSibling() {
        return this.next;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        throw new QDOMException(3, "");
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        throw new QDOMException(3, "");
    }

    public Node removeChild(Node node) throws DOMException {
        throw new QDOMException(3, "");
    }

    public Node appendChild(Node node) throws DOMException {
        throw new QDOMException(3, "");
    }

    public boolean hasChildNodes() {
        return false;
    }

    public boolean equals(Node node, boolean bl) {
        return this == node;
    }

    void remove() {
        if (this.previous != null) {
            this.previous.next = this.next;
        } else if (this.parent != null) {
            this.parent.firstChild = this.next;
        }
        if (this.next != null) {
            this.next.previous = this.previous;
        } else if (this.parent != null) {
            this.parent.lastChild = this.previous;
        }
        this.previous = null;
        this.next = null;
        this.parent = null;
    }

    public QAbstractNode getNextPreorder() {
        if (this.next != null) {
            return this.next;
        }
        QNode qNode = this.parent;
        while (qNode != null) {
            if (qNode.next != null) {
                return qNode.next;
            }
            qNode = qNode.parent;
        }
        return null;
    }

    public boolean hasContent() {
        return false;
    }

    public QAbstractNode getNextContent() {
        QAbstractNode qAbstractNode = this.next;
        while (qAbstractNode != null) {
            if (qAbstractNode.hasContent()) {
                return qAbstractNode;
            }
            qAbstractNode = qAbstractNode.next;
        }
        return null;
    }

    public QAbstractNode getPreviousContent() {
        QAbstractNode qAbstractNode = this.previous;
        while (qAbstractNode != null) {
            if (qAbstractNode.hasContent()) {
                return qAbstractNode;
            }
            qAbstractNode = qAbstractNode.previous;
        }
        return null;
    }

    public String getTextValue() {
        return this.getNodeValue();
    }

    boolean isNameValid(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (!XmlChar.isNameStart(string.charAt(0))) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!XmlChar.isNameChar(c)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean checkValid() throws Exception {
        if (this.parent == null) {
            if (this.next != null || this.previous != null) {
                throw new Exception("null bad: " + this);
            }
            return true;
        }
        if (this.parent.owner != this.owner) {
            throw new Exception("owner bad: " + this);
        }
        QAbstractNode qAbstractNode = this.parent.firstChild;
        while (qAbstractNode != null && qAbstractNode != this) {
            qAbstractNode = qAbstractNode.next;
        }
        if (qAbstractNode == null) {
            throw new Exception("not in parent: " + this);
        }
        qAbstractNode = this.parent.lastChild;
        while (qAbstractNode != null && qAbstractNode != this) {
            qAbstractNode = qAbstractNode.previous;
        }
        if (qAbstractNode == null) {
            throw new Exception("not in parent: " + this);
        }
        if (this.next == null && this.parent.lastChild != this) {
            throw new Exception("bad tail: " + this);
        }
        if (this.next != null && this.next.previous != this) {
            throw new Exception("bad link: " + this);
        }
        if (this.previous == null && this.parent.firstChild != this) {
            throw new Exception("bad head: " + this);
        }
        if (this.previous != null && this.previous.next != this) {
            throw new Exception("bad link: " + this);
        }
        return true;
    }

    void print(XmlPrinter xmlPrinter) throws IOException {
    }

    public void print(WriteStream writeStream) throws IOException {
        XmlPrinter.printXml(writeStream, this);
    }

    public void printPretty(WriteStream writeStream) throws IOException {
        XmlPrinter.printPrettyXml(writeStream, this);
    }

    public void printHtml(WriteStream writeStream) throws IOException {
        XmlPrinter.printHtml(writeStream, this);
    }

    public abstract String getNodeName();

    public abstract short getNodeType();

    public abstract Node cloneNode(boolean var1);

    QAbstractNode() {
    }
}

