/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.util.CharBuffer;
import com.caucho.util.CharCursor;
import com.caucho.util.CharScanner;
import com.caucho.util.IntMap;
import com.caucho.util.StringCharCursor;
import com.caucho.xml.CauchoNode;
import com.caucho.xml.Policy;
import com.caucho.xml.QName;
import com.caucho.xml.XmlParser;
import java.io.IOException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class HtmlPolicy
extends Policy {
    static final int DOCUMENT = 1;
    static final int COMMENT = 2;
    static final int TEXT = 3;
    static final int HTML = 4;
    static final int HEAD = 5;
    static final int TITLE = 6;
    static final int ISINDEX = 7;
    static final int BASE = 8;
    static final int SCRIPT = 9;
    static final int STYLE = 10;
    static final int META = 11;
    static final int LINK = 12;
    static final int OBJECT = 13;
    static final int BODY = 14;
    static final int BASEFONT = 15;
    static final int BR = 16;
    static final int AREA = 17;
    static final int IMG = 18;
    static final int PARAM = 19;
    static final int HR = 20;
    static final int INPUT = 21;
    static final int P = 22;
    static final int DT = 23;
    static final int DD = 24;
    static final int LI = 25;
    static final int OPTION = 26;
    static final int TABLE = 27;
    static final int CAPTION = 28;
    static final int THEAD = 29;
    static final int TFOOT = 30;
    static final int COL = 31;
    static final int COLGROUP = 32;
    static final int TBODY = 33;
    static final int TR = 34;
    static final int TD = 35;
    static final int TH = 36;
    static final int FRAME = 37;
    static final int BLOCK = 38;
    static final int INLINE = 39;
    static IntMap names;
    static IntMap cbNames;
    private static CharScanner charsetScanner;
    CharBuffer cb = new CharBuffer();

    QName getName(Node node, CharBuffer charBuffer) {
        this.cb.clear();
        this.cb.append(charBuffer);
        this.cb.toLowerCase();
        int n = cbNames.get(this.cb);
        if (n >= 0) {
            return super.getName(node, this.cb);
        }
        return super.getName(node, charBuffer);
    }

    QName getAttributeName(Node node, CharBuffer charBuffer) {
        int n = names.get(node.getNodeName());
        if (n >= 0) {
            return super.getName(node, charBuffer.toLowerCase());
        }
        return super.getName(node, charBuffer);
    }

    int openAction(XmlParser xmlParser, Node node, Node node2) {
        switch (node2.getNodeType()) {
            case 3: {
                if (!this.isWhitespaceOnly(node2.getNodeValue())) break;
                return 2;
            }
            case 7: 
            case 8: {
                return 2;
            }
        }
        switch (names.get(node.getNodeName())) {
            case 1: {
                switch (names.get(node2.getNodeName())) {
                    case 4: {
                        return 2;
                    }
                }
                this.opt = "html";
                return 4;
            }
            case 4: {
                switch (names.get(node2.getNodeName())) {
                    case 4: {
                        return 0;
                    }
                    case 2: 
                    case 5: 
                    case 14: {
                        return 2;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        this.opt = "head";
                        return 4;
                    }
                }
                this.opt = "body";
                return 4;
            }
            case 5: {
                switch (names.get(node2.getNodeName())) {
                    case 11: {
                        this.checkMetaEncoding((Element)node2);
                        return 3;
                    }
                    case 7: 
                    case 8: 
                    case 12: {
                        return 3;
                    }
                    case 6: 
                    case 9: 
                    case 10: 
                    case 13: {
                        return 2;
                    }
                    case 3: {
                        return 5;
                    }
                }
                return 5;
            }
            case 25: {
                switch (names.get(node2.getNodeName())) {
                    case 25: {
                        return 5;
                    }
                    case 7: 
                    case 8: 
                    case 11: 
                    case 12: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 31: 
                    case 37: {
                        return 3;
                    }
                }
                return 2;
            }
            case 26: {
                switch (names.get(node2.getNodeName())) {
                    case 2: 
                    case 3: {
                        return 2;
                    }
                }
                return 5;
            }
            case 24: {
                switch (names.get(node2.getNodeName())) {
                    case 23: 
                    case 24: {
                        return 5;
                    }
                    case 7: 
                    case 8: 
                    case 11: 
                    case 12: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 31: 
                    case 37: {
                        return 3;
                    }
                }
                return 2;
            }
            case 29: 
            case 30: 
            case 32: {
                switch (names.get(node2.getNodeName())) {
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: {
                        return 5;
                    }
                    case 7: 
                    case 8: 
                    case 11: 
                    case 12: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 37: {
                        return 3;
                    }
                }
                return 2;
            }
            case 34: {
                switch (names.get(node2.getNodeName())) {
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: {
                        return 5;
                    }
                    case 7: 
                    case 8: 
                    case 11: 
                    case 12: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 37: {
                        return 3;
                    }
                }
                return 2;
            }
            case 35: 
            case 36: {
                switch (names.get(node2.getNodeName())) {
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: {
                        return 5;
                    }
                    case 7: 
                    case 8: 
                    case 11: 
                    case 12: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 37: {
                        return 3;
                    }
                }
                return 2;
            }
            case 22: 
            case 23: {
                switch (names.get(node2.getNodeName())) {
                    case 22: 
                    case 23: 
                    case 25: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 38: {
                        return 5;
                    }
                    case 7: 
                    case 8: 
                    case 11: 
                    case 12: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 31: 
                    case 37: {
                        return 3;
                    }
                }
                return 2;
            }
            case 27: {
                switch (names.get(node2.getNodeName())) {
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: {
                        return 2;
                    }
                }
                this.opt = "tbody";
                return 4;
            }
        }
        switch (names.get(node2.getNodeName())) {
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 31: 
            case 37: {
                return 3;
            }
        }
        return 2;
    }

    private void checkMetaEncoding(Element element) {
        String string = element.getAttribute("http-equiv");
        String string2 = element.getAttribute("content");
        if (string.equals("") || string2.equals("") || !string.equalsIgnoreCase("content-type")) {
            return;
        }
        StringCharCursor stringCharCursor = new StringCharCursor(string2);
        charsetScanner.scan(stringCharCursor);
        charsetScanner.skip(stringCharCursor);
        CharBuffer charBuffer = CharBuffer.allocate();
        while (((CharCursor)stringCharCursor).current() != '\uffff') {
            charBuffer.clear();
            charsetScanner.scan(stringCharCursor, charBuffer);
            if (!charBuffer.toString().equalsIgnoreCase("charset")) continue;
            charsetScanner.skip(stringCharCursor);
            charBuffer.clear();
            charsetScanner.scan(stringCharCursor, charBuffer);
            if (charBuffer.length() <= 0) continue;
            try {
                this.is.setEncoding(charBuffer.close());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
    }

    int elementCloseAction(XmlParser xmlParser, Node node, String string) throws IOException {
        if (node.getNodeName().equals(string)) {
            return 5;
        }
        if (node.getNodeType() == 9 && string.equals("")) {
            return 5;
        }
        switch (names.get(node.getNodeName())) {
            case 4: 
            case 5: 
            case 14: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                return 6;
            }
        }
        String string2 = string.equals("") ? "end of file" : "`</" + string + ">'";
        switch (names.get(string)) {
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 31: 
            case 37: {
                throw xmlParser.error("`<" + string + ">' expects to be empty");
            }
        }
        if (this.forgiving) {
            Node node2 = node;
            while (node2 != null) {
                if (node2.getNodeName().equals(string)) {
                    return 6;
                }
                node2 = node2.getParentNode();
            }
            return 1;
        }
        String string3 = node.getNodeName();
        string3 = string3.equals("#document") ? "end of document" : "`</" + string3 + ">'";
        throw xmlParser.error("expected " + string3 + " at " + string2 + " (open at " + ((CauchoNode)node).getLine() + ")");
    }

    private static void addName(String string, int n) {
        names.put(string, n);
        cbNames.put(new CharBuffer(string), n);
    }

    HtmlPolicy() {
    }

    static {
        charsetScanner = new CharScanner(" \t=;");
        names = new IntMap();
        cbNames = new IntMap();
        HtmlPolicy.addName("#document", 1);
        HtmlPolicy.addName("#comment", 2);
        HtmlPolicy.addName("#text", 3);
        HtmlPolicy.addName("html", 4);
        HtmlPolicy.addName("head", 5);
        HtmlPolicy.addName("title", 6);
        HtmlPolicy.addName("isindex", 7);
        HtmlPolicy.addName("base", 8);
        HtmlPolicy.addName("script", 9);
        HtmlPolicy.addName("style", 10);
        HtmlPolicy.addName("meta", 11);
        HtmlPolicy.addName("link", 12);
        HtmlPolicy.addName("object", 13);
        HtmlPolicy.addName("body", 14);
        HtmlPolicy.addName("basefont", 15);
        HtmlPolicy.addName("br", 16);
        HtmlPolicy.addName("area", 17);
        HtmlPolicy.addName("link", 12);
        HtmlPolicy.addName("img", 18);
        HtmlPolicy.addName("param", 19);
        HtmlPolicy.addName("hr", 20);
        HtmlPolicy.addName("input", 21);
        HtmlPolicy.addName("frame", 37);
        HtmlPolicy.addName("p", 22);
        HtmlPolicy.addName("dt", 23);
        HtmlPolicy.addName("dd", 24);
        HtmlPolicy.addName("li", 25);
        HtmlPolicy.addName("option", 26);
        HtmlPolicy.addName("table", 27);
        HtmlPolicy.addName("caption", 28);
        HtmlPolicy.addName("thead", 29);
        HtmlPolicy.addName("tfoot", 30);
        HtmlPolicy.addName("col", 31);
        HtmlPolicy.addName("colgroup", 32);
        HtmlPolicy.addName("tbody", 33);
        HtmlPolicy.addName("tr", 34);
        HtmlPolicy.addName("th", 36);
        HtmlPolicy.addName("td", 35);
        HtmlPolicy.addName("h1", 38);
        HtmlPolicy.addName("h2", 38);
        HtmlPolicy.addName("h3", 38);
        HtmlPolicy.addName("h4", 38);
        HtmlPolicy.addName("h5", 38);
        HtmlPolicy.addName("h6", 38);
        HtmlPolicy.addName("ul", 38);
        HtmlPolicy.addName("ol", 38);
        HtmlPolicy.addName("dir", 38);
        HtmlPolicy.addName("menu", 38);
        HtmlPolicy.addName("pre", 38);
        HtmlPolicy.addName("dl", 38);
        HtmlPolicy.addName("div", 38);
        HtmlPolicy.addName("center", 38);
        HtmlPolicy.addName("noscript", 38);
        HtmlPolicy.addName("noframes", 38);
        HtmlPolicy.addName("blockquote", 38);
        HtmlPolicy.addName("form", 38);
        HtmlPolicy.addName("fieldset", 38);
        HtmlPolicy.addName("address", 38);
        HtmlPolicy.addName("tt", 39);
        HtmlPolicy.addName("i", 39);
        HtmlPolicy.addName("b", 39);
        HtmlPolicy.addName("u", 39);
        HtmlPolicy.addName("s", 39);
        HtmlPolicy.addName("strike", 39);
        HtmlPolicy.addName("big", 39);
        HtmlPolicy.addName("small", 39);
        HtmlPolicy.addName("em", 39);
        HtmlPolicy.addName("strong", 39);
        HtmlPolicy.addName("dfn", 39);
        HtmlPolicy.addName("code", 39);
        HtmlPolicy.addName("samp", 39);
        HtmlPolicy.addName("kbd", 39);
        HtmlPolicy.addName("var", 39);
        HtmlPolicy.addName("cite", 39);
        HtmlPolicy.addName("abbr", 39);
        HtmlPolicy.addName("acronym", 39);
        HtmlPolicy.addName("font", 39);
        HtmlPolicy.addName("iframe", 39);
        HtmlPolicy.addName("applet", 39);
        HtmlPolicy.addName("ins", 39);
        HtmlPolicy.addName("del", 39);
        HtmlPolicy.addName("a", 39);
        HtmlPolicy.addName("map", 39);
        HtmlPolicy.addName("q", 39);
        HtmlPolicy.addName("sub", 39);
        HtmlPolicy.addName("sup", 39);
        HtmlPolicy.addName("span", 39);
        HtmlPolicy.addName("bdo", 39);
        HtmlPolicy.addName("select", 39);
        HtmlPolicy.addName("textarea", 39);
        HtmlPolicy.addName("label", 39);
        HtmlPolicy.addName("optgroup", 39);
        HtmlPolicy.addName("button", 39);
        HtmlPolicy.addName("legend", 39);
        HtmlPolicy.addName("frameset", 39);
    }
}

