/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CauchoSystem;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamFilter;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.Utf16Writer;
import com.caucho.vfs.Utf8Writer;
import com.caucho.vfs.VfsWriteObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Locale;

public class WriteStream
extends OutputStream {
    private static byte[] lfBytes = "\n".getBytes();
    private static byte[] crBytes = "\r".getBytes();
    private static byte[] crlfBytes = "\r\n".getBytes();
    private TempBuffer tempWrite;
    private byte[] write_buffer;
    private int write_length;
    private StreamImpl source;
    private char[] chars;
    private byte[] bytes;
    private Writer writeEncoding;
    private String writeEncodingName;
    private boolean flushOnNewline;
    private boolean disableClose;
    private boolean disableFlush;
    private StreamWriter writer;
    private PrintWriter printWriter;
    private String newline;
    private byte[] newlineBytes;
    private int writePrefix;

    public void init(StreamImpl streamImpl) {
        this.disableClose = false;
        if (this.source != null) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (streamImpl == null) {
            throw new IllegalArgumentException();
        }
        this.source = streamImpl;
        if (streamImpl.canWrite()) {
            this.tempWrite = TempBuffer.allocate();
            this.write_buffer = this.tempWrite.buf;
        }
        this.write_length = 0;
        this.flushOnNewline = streamImpl.getFlushOnNewline();
        this.setNewlineString(CauchoSystem.getNewlineString());
        this.printWriter = null;
        this.writePrefix = 0;
        this.writeEncoding = null;
        this.writeEncodingName = "ISO-8859-1";
    }

    public StreamImpl getSource() {
        return this.source;
    }

    public void pushFilter(StreamFilter streamFilter) {
        streamFilter.init(this.source);
        this.source = streamFilter;
    }

    public boolean canWrite() {
        return this.source.canWrite();
    }

    public void clearWrite() {
        this.write_length = this.writePrefix;
        if (this.source != null) {
            this.source.clearWrite();
        }
    }

    public void setWritePrefix(int n) {
        if (this.write_length > this.writePrefix) {
            throw new IllegalStateException();
        }
        this.write_length = this.writePrefix = n;
    }

    public void write(int n) throws IOException {
        if (this.write_buffer == null) {
            return;
        }
        if (this.write_length >= this.write_buffer.length) {
            int n2 = this.write_length;
            this.write_length = this.writePrefix;
            this.source.write(this.write_buffer, 0, n2, false);
        }
        this.write_buffer[this.write_length++] = (byte)n;
    }

    /*
     * Unable to fully structure code
     */
    public void write(byte[] var1_1, int var2_2, int var3_3) throws IOException {
        if (this.write_buffer != null) ** GOTO lbl14
        return;
lbl-1000:
        // 1 sources

        {
            var4_4 = this.write_buffer.length - this.write_length;
            if (var4_4 > var3_3) {
                var4_4 = var3_3;
            }
            System.arraycopy(var1_1, var2_2, this.write_buffer, this.write_length, var4_4);
            this.write_length += var4_4;
            var2_2 += var4_4;
            var3_3 -= var4_4;
            if (this.write_length < this.write_buffer.length) continue;
            var5_5 = this.write_length;
            this.write_length = this.writePrefix;
            this.source.write(this.write_buffer, 0, var5_5, false);
lbl14:
            // 3 sources

            ** while (var3_3 > 0)
        }
lbl15:
        // 1 sources

    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void flush() throws IOException {
        if (this.disableFlush || this.source == null) {
            return;
        }
        if (this.write_length > this.writePrefix) {
            int n = this.write_length;
            this.write_length = this.writePrefix;
            this.source.write(this.write_buffer, 0, n, true);
        }
        this.source.flush();
    }

    public void setEncoding(String string) throws UnsupportedEncodingException {
        String string2 = Encoding.getJavaName(string);
        this.writeEncoding = string2 == null || string2.equalsIgnoreCase("ISO8859_1") ? null : (string2.equals("UTF16") ? new Utf16Writer(this) : (string2.equals("UTF8") ? new Utf8Writer(this) : new OutputStreamWriter((OutputStream)this, string2)));
        this.writeEncodingName = Encoding.getMimeName(string);
    }

    public void setLocale(Locale locale) throws UnsupportedEncodingException {
        if (this.writeEncoding == null && locale != null) {
            this.setEncoding(Encoding.getMimeName(locale));
        }
    }

    public String getEncoding() {
        return this.writeEncodingName;
    }

    public String getJavaEncoding() {
        return Encoding.getJavaName(this.writeEncodingName);
    }

    public void setFlushOnNewline(boolean bl) {
        this.flushOnNewline = bl;
    }

    public String getNewlineString() {
        return this.newline;
    }

    public void setNewlineString(String string) {
        if (string != null && this.newline != string && !string.equals(this.newline)) {
            if (string == "\n" || string.equals("\n")) {
                this.newlineBytes = lfBytes;
            } else if (string == "\r\n" || string.equals("\r\n")) {
                this.newlineBytes = crlfBytes;
            } else if (string == "\r" || string.equals("\r")) {
                this.newlineBytes = crBytes;
            } else {
                this.newlineBytes = string.getBytes();
                this.newline = string;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void print(char[] var1_1, int var2_2, int var3_3) throws IOException {
        var4_4 = this.write_buffer;
        if (var4_4 == null) {
            return;
        }
        if (this.writeEncoding == null) ** GOTO lbl26
        this.disableFlush = true;
        this.writeEncoding.write(var1_1, var2_2, var3_3);
        this.writeEncoding.flush();
        this.disableFlush = false;
        return;
lbl-1000:
        // 1 sources

        {
            var5_5 = this.write_length;
            var6_6 = var4_4.length - var5_5;
            if (var6_6 <= 0) {
                this.source.write(var4_4, 0, var5_5, false);
                var5_5 = 0;
                var6_6 = var4_4.length;
            }
            if (var3_3 < var6_6) {
                var6_6 = var3_3;
            }
            var7_7 = 0;
            while (var7_7 < var6_6) {
                var4_4[var5_5 + var7_7] = (byte)var1_1[var2_2 + var7_7];
                ++var7_7;
            }
            this.write_length = var5_5 + var6_6;
            var2_2 += var6_6;
            var3_3 -= var6_6;
lbl26:
            // 2 sources

            ** while (var3_3 > 0)
        }
lbl27:
        // 1 sources

    }

    public final void print(char c) throws IOException {
        if (this.writeEncoding != null) {
            this.disableFlush = true;
            this.writeEncoding.write(c);
            this.writeEncoding.flush();
            this.disableFlush = false;
            return;
        }
        this.write((byte)c);
    }

    public final void print(char[] cArray) throws IOException {
        this.print(cArray, 0, cArray.length);
    }

    public final void print(String string) throws IOException {
        if (string == null) {
            string = "null";
        }
        int n = string.length();
        int n2 = 0;
        while (n > 0) {
            int n3;
            int n4 = n3 = n < 1024 ? n : 1024;
            if (this.chars == null || this.chars.length < n3) {
                this.chars = new char[n3 < 32 ? 32 : n3];
            }
            string.getChars(n2, n2 + n3, this.chars, 0);
            this.print(this.chars, 0, n3);
            n -= n3;
            n2 += n3;
        }
    }

    public final void print(String string, int n, int n2) throws IOException {
        if (string == null) {
            string = "null";
        }
        if (this.chars == null || this.chars.length < n2) {
            this.chars = new char[n2 < 32 ? 32 : n2];
        }
        string.getChars(n, n + n2, this.chars, 0);
        this.print(this.chars, 0, n2);
    }

    public final void print(boolean bl) throws IOException {
        this.print(String.valueOf(bl));
    }

    public final void print(int n) throws IOException {
        if (n == Integer.MIN_VALUE) {
            this.print("-2147483648");
            return;
        }
        if (this.bytes == null) {
            this.bytes = new byte[32];
        }
        if (n < 0) {
            this.write(45);
            n = -n;
        } else if (n == 0) {
            this.write(48);
            return;
        }
        int n2 = 31;
        while (n > 0) {
            this.bytes[--n2] = (byte)(n % 10 + 48);
            n /= 10;
        }
        this.write(this.bytes, n2, 31 - n2);
    }

    public final void print(long l) throws IOException {
        if (l == Integer.MIN_VALUE) {
            this.print("-2147483648");
            return;
        }
        if (this.bytes == null) {
            this.bytes = new byte[32];
        }
        if (l < 0L) {
            this.write(45);
            l = -l;
        } else if (l == 0L) {
            this.write(48);
            return;
        }
        int n = 31;
        while (l > 0L) {
            this.bytes[--n] = (byte)(l % 10L + 48L);
            l /= 10L;
        }
        this.write(this.bytes, n, 31 - n);
    }

    public final void print(float f) throws IOException {
        this.print(String.valueOf(f));
    }

    public final void print(double d) throws IOException {
        this.print(String.valueOf(d));
    }

    public final void print(Object object) throws IOException {
        if (object == null) {
            this.print("null");
        } else if (object instanceof VfsWriteObject) {
            ((VfsWriteObject)object).print(this);
        } else {
            this.print(object.toString());
        }
    }

    public final void println() throws IOException {
        this.write(this.newlineBytes, 0, this.newlineBytes.length);
        if (this.flushOnNewline) {
            this.flush();
        }
    }

    public final void println(char[] cArray, int n, int n2) throws IOException {
        this.print(cArray, n, n2);
        this.write(this.newlineBytes, 0, this.newlineBytes.length);
        if (this.flushOnNewline) {
            this.flush();
        }
    }

    public final void println(String string) throws IOException {
        this.print(string);
        this.write(this.newlineBytes, 0, this.newlineBytes.length);
        if (this.flushOnNewline) {
            this.flush();
        }
    }

    public final void println(boolean bl) throws IOException {
        this.println(String.valueOf(bl));
    }

    public final void println(char c) throws IOException {
        this.write(c);
        this.write(this.newlineBytes, 0, this.newlineBytes.length);
        if (this.flushOnNewline) {
            this.flush();
        }
    }

    public final void println(int n) throws IOException {
        this.print(n);
        this.write(this.newlineBytes, 0, this.newlineBytes.length);
        if (this.flushOnNewline) {
            this.flush();
        }
    }

    public final void println(long l) throws IOException {
        this.print(l);
        this.write(this.newlineBytes, 0, this.newlineBytes.length);
        if (this.flushOnNewline) {
            this.flush();
        }
    }

    public final void println(float f) throws IOException {
        this.println(String.valueOf(f));
    }

    public final void println(double d) throws IOException {
        this.println(String.valueOf(d));
    }

    public final void println(Object object) throws IOException {
        if (object == null) {
            this.println("null");
        } else {
            this.println(object.toString());
        }
    }

    public PrintWriter getPrintWriter() {
        if (this.writer == null) {
            WriteStream writeStream = this;
            if (writeStream == null) {
                throw null;
            }
            this.writer = writeStream.new StreamWriter();
        }
        if (this.printWriter == null) {
            this.printWriter = new PrintWriter(this.writer);
        }
        return this.printWriter;
    }

    public final synchronized void log(String string) {
        try {
            this.println(string);
            this.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final synchronized void log(Throwable throwable) {
        try {
            throwable.printStackTrace(this.getPrintWriter());
            this.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeStream(InputStream inputStream) throws IOException {
        int n;
        int n2;
        if (this.write_buffer == null) {
            return;
        }
        int n3 = this.write_buffer.length;
        if (this.write_length >= n3) {
            n2 = this.write_length;
            this.write_length = this.writePrefix;
            this.source.write(this.write_buffer, 0, n2, false);
        }
        while ((n = inputStream.read(this.write_buffer, this.write_length, n3 - this.write_length)) >= 0) {
            this.write_length += n;
            if (this.write_length < n3) continue;
            n2 = this.write_length;
            this.write_length = this.writePrefix;
            this.source.write(this.write_buffer, 0, n2, false);
        }
        if (this.flushOnNewline) {
            this.flush();
        }
    }

    public void writeFile(Path path) throws IOException {
        ReadStream readStream;
        block5: {
            readStream = path.openRead();
            try {
                if (readStream == null) break block5;
                this.writeStream(readStream);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (readStream != null) {
                    ((InputStream)readStream).close();
                }
                throw throwable;
            }
        }
        Object var4_3 = null;
        if (readStream != null) {
            ((InputStream)readStream).close();
        }
        if (this.flushOnNewline) {
            this.flush();
        }
    }

    public void setDisableClose(boolean bl) {
        this.disableClose = bl;
    }

    public final void close() throws IOException {
        block8: {
            try {
                if (this.write_length <= this.writePrefix) break block8;
                int n = this.write_length;
                this.write_length = this.writePrefix;
                this.source.write(this.write_buffer, 0, n, true);
            }
            catch (Throwable throwable) {
                Object var2_5 = null;
                if (this.disableClose) {
                    this.printWriter = null;
                    return;
                }
                StreamImpl streamImpl = this.source;
                this.source = null;
                if (this.tempWrite != null) {
                    TempBuffer.free(this.tempWrite);
                }
                this.tempWrite = null;
                this.write_buffer = null;
                if (streamImpl != null) {
                    streamImpl.close();
                }
                throw throwable;
            }
        }
        Object var2_4 = null;
        if (this.disableClose) {
            this.printWriter = null;
            return;
        }
        StreamImpl streamImpl = this.source;
        this.source = null;
        if (this.tempWrite != null) {
            TempBuffer.free(this.tempWrite);
        }
        this.tempWrite = null;
        this.write_buffer = null;
        if (streamImpl != null) {
            streamImpl.close();
        }
    }

    public Object getAttribute(String string) throws IOException {
        return this.source.getAttribute(string);
    }

    public void setAttribute(String string, Object object) throws IOException {
        this.source.setAttribute(string, object);
    }

    public void removeAttribute(String string) throws IOException {
        this.source.removeAttribute(string);
    }

    public Iterator getAttributeNames() throws IOException {
        return this.source.getAttributeNames();
    }

    public Path getPath() {
        return this.source.getPath();
    }

    public String getUserPath() {
        return this.source.getPath().getUserPath();
    }

    public void setPath(Path path) {
        this.source.setPath(path);
    }

    static /* synthetic */ PrintWriter access$0(WriteStream writeStream) {
        return writeStream.printWriter;
    }

    public WriteStream() {
    }

    public WriteStream(StreamImpl streamImpl) {
        this.init(streamImpl);
    }

    private class StreamWriter
    extends Writer {
        public final void write(char c) throws IOException {
            WriteStream.this.print(c);
        }

        public final void write(char[] cArray, int n, int n2) throws IOException {
            WriteStream.this.print(cArray, n, n2);
        }

        public final void write(char[] cArray) throws IOException {
            WriteStream.this.print(cArray, 0, cArray.length);
        }

        public final void write(String string) throws IOException {
            WriteStream.this.print(string);
        }

        public final void write(String string, int n, int n2) throws IOException {
            WriteStream.this.print(string, n, n2);
        }

        public final void flush() throws IOException {
            WriteStream.this.flush();
        }

        public final void close() throws IOException {
            WriteStream.this.printWriter = null;
        }

        StreamWriter() {
        }
    }
}

