/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.FilePath;
import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.ReaderWriterStream;
import com.caucho.vfs.StringStream;
import com.caucho.vfs.VfsStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;

public final class Vfs {
    static FilesystemPath PWD;

    public static Path lookup(String string) {
        if (PWD == null) {
            PWD = new FilePath(null);
        }
        return PWD.lookup(string, null);
    }

    public static Path lookup() {
        if (PWD == null) {
            PWD = new FilePath(null);
        }
        return PWD;
    }

    public static Path lookup(String string, Map map) {
        if (PWD == null) {
            PWD = new FilePath(null);
        }
        return PWD.lookup(string, map);
    }

    public static Path lookupNative(String string) {
        if (PWD == null) {
            PWD = new FilePath(null);
        }
        return PWD.lookupNative(string, null);
    }

    public static Path lookupNative(String string, Map map) {
        if (PWD == null) {
            PWD = new FilePath(null);
        }
        return PWD.lookupNative(string, map);
    }

    public static ReadWritePair openReadWrite(InputStream inputStream, OutputStream outputStream) {
        VfsStream vfsStream = new VfsStream(inputStream, outputStream);
        WriteStream writeStream = new WriteStream(vfsStream);
        ReadStream readStream = new ReadStream(vfsStream, writeStream);
        return new ReadWritePair(readStream, writeStream);
    }

    public static ReadStream openRead(InputStream inputStream) {
        VfsStream vfsStream = new VfsStream(inputStream, null);
        return new ReadStream(vfsStream);
    }

    public static ReadStream openRead(InputStream inputStream, WriteStream writeStream) {
        VfsStream vfsStream = new VfsStream(inputStream, null);
        return new ReadStream(vfsStream, writeStream);
    }

    public static ReadStream openRead(Reader reader) {
        ReaderWriterStream readerWriterStream = new ReaderWriterStream(reader, null);
        ReadStream readStream = new ReadStream(readerWriterStream);
        try {
            readStream.setEncoding("utf-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return readStream;
    }

    public static ReadStream openRead(String string) {
        return StringStream.open(string);
    }

    public static WriteStream openWrite(OutputStream outputStream) {
        VfsStream vfsStream = new VfsStream(null, outputStream);
        return new WriteStream(vfsStream);
    }

    public static WriteStream openWrite(Writer writer) {
        ReaderWriterStream readerWriterStream = new ReaderWriterStream(null, writer);
        WriteStream writeStream = new WriteStream(readerWriterStream);
        try {
            writeStream.setEncoding("utf-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return writeStream;
    }

    public static WriteStream openWrite(String string) throws IOException {
        return Vfs.lookup(string).openWrite();
    }

    public static WriteStream openAppend(String string) throws IOException {
        return Vfs.lookup(string).openAppend();
    }

    private Vfs() {
    }
}

