/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import java.io.CharConversionException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

class Utf8Reader
extends Reader {
    private InputStream is;

    public int read() throws IOException {
        int n = this.is.read();
        if (n < 128) {
            return n;
        }
        if ((n & 0xE0) == 192) {
            int n2 = this.is.read();
            if (n2 < 0) {
                throw new EOFException("unexpected end of file in utf8 character");
            }
            if ((n2 & 0xC0) != 128) {
                throw new CharConversionException("illegal utf8 encoding");
            }
            return ((n & 0x1F) << 6) + (n2 & 0x3F);
        }
        if ((n & 0xF0) == 224) {
            int n3 = this.is.read();
            int n4 = this.is.read();
            if (n3 < 0) {
                throw new EOFException("unexpected end of file in utf8 character");
            }
            if ((n3 & 0xC0) != 128) {
                throw new CharConversionException("illegal utf8 encoding");
            }
            if (n4 < 0) {
                throw new EOFException("unexpected end of file in utf8 character");
            }
            if ((n4 & 0xC0) != 128) {
                throw new CharConversionException("illegal utf8 encoding");
            }
            return ((n & 0x1F) << 12) + ((n3 & 0x3F) << 6) + (n4 & 0x3F);
        }
        throw new CharConversionException("illegal utf8 encoding at (" + n + ")");
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        n3 = 0;
        while (n3 < n2) {
            int n4 = this.read();
            if (n4 < 0) {
                return n3 == 0 ? -1 : n3;
            }
            cArray[n + n3] = (char)n4;
            ++n3;
        }
        return n3;
    }

    public void close() {
    }

    Utf8Reader(InputStream inputStream) {
        this.is = inputStream;
    }
}

