/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;

public class TempStream
extends StreamImpl {
    private TempBuffer head;
    private TempBuffer tail;
    private Path backingDir;
    private Path backingFile;
    private WriteStream backingStream;
    private boolean useBackingFile;

    public void openWrite() {
        TempBuffer tempBuffer = this.head;
        this.head = null;
        this.tail = null;
        while (tempBuffer != null) {
            TempBuffer tempBuffer2 = tempBuffer.next;
            TempBuffer.free(tempBuffer);
            tempBuffer = tempBuffer2;
        }
        this.useBackingFile = false;
        if (this.backingStream != null) {
            try {
                this.backingStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.backingStream = null;
        }
    }

    public void changeToBackingFile(int n) throws IOException {
        if (this.backingFile == null) {
            this.backingFile = this.backingDir.createTempFile("tmp", ".tmp");
        }
        this.backingStream = this.backingFile.openWrite();
        this.useBackingFile = true;
        while (this.head != null) {
            TempBuffer tempBuffer = this.head.next;
            this.backingStream.write(this.head.buf, 0, this.head.length);
            TempBuffer.free(this.head);
            this.head = tempBuffer;
        }
    }

    public boolean canWrite() {
        return true;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.backingStream != null) {
            this.backingStream.write(byArray, n, n2);
        } else {
            int n3 = 0;
            while (n3 < n2) {
                if (this.tail == null) {
                    this.addBuffer(TempBuffer.allocate());
                } else if (this.tail.length >= this.tail.buf.length) {
                    if (this.head.bufferCount < 8 || this.backingDir == null) {
                        this.addBuffer(TempBuffer.allocate());
                    } else {
                        this.changeToBackingFile(n3);
                        this.backingStream.write(byArray, n, n2);
                        return;
                    }
                }
                int n4 = this.tail.buf.length - this.tail.length;
                if (n4 > n2 - n3) {
                    n4 = n2 - n3;
                }
                System.arraycopy(byArray, n3 + n, this.tail.buf, this.tail.length, n4);
                n3 += n4;
                this.tail.length += n4;
            }
        }
    }

    private void addBuffer(TempBuffer tempBuffer) {
        tempBuffer.next = null;
        if (this.tail != null) {
            this.tail.next = tempBuffer;
            this.tail = tempBuffer;
        } else {
            this.tail = tempBuffer;
            this.head = tempBuffer;
        }
        ++this.head.bufferCount;
    }

    public void flush() throws IOException {
        if (this.backingStream != null) {
            this.backingStream.flush();
        }
    }

    public void close() throws IOException {
        if (this.backingStream != null) {
            this.backingStream.close();
            this.backingStream = null;
        }
        super.close();
    }

    public ReadStream openRead() throws IOException {
        return this.openRead(false);
    }

    public ReadStream openRead(boolean bl) throws IOException {
        this.close();
        if (this.useBackingFile) {
            return this.backingFile.openRead();
        }
        TempReadStream tempReadStream = new TempReadStream(this.head);
        tempReadStream.setFreeWhenDone(bl);
        if (bl) {
            this.head = null;
            this.tail = null;
        }
        tempReadStream.setPath(this.getPath());
        return new ReadStream(tempReadStream);
    }

    public ReadStream openRead(ReadStream readStream) throws IOException {
        this.close();
        if (this.useBackingFile) {
            return this.backingFile.openRead();
        }
        TempReadStream tempReadStream = new TempReadStream(this.head);
        tempReadStream.setFreeWhenDone(false);
        tempReadStream.setPath(this.getPath());
        readStream.init(tempReadStream, null);
        return readStream;
    }

    public void clearWrite() {
        TempBuffer tempBuffer = this.head;
        this.head = null;
        this.tail = null;
        while (tempBuffer != null) {
            TempBuffer tempBuffer2 = tempBuffer.next;
            TempBuffer.free(tempBuffer);
            tempBuffer = tempBuffer2;
        }
        if (this.backingStream != null) {
            try {
                this.backingStream.close();
                this.backingStream = this.backingFile.openWrite();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.useBackingFile = false;
    }

    public void discard() {
        this.head = null;
        this.tail = null;
        if (this.backingStream != null) {
            try {
                this.backingStream.close();
                this.backingStream = this.backingFile.openWrite();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.useBackingFile = false;
    }

    public void destroy() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.backingFile != null) {
                this.backingFile.remove();
            }
            this.backingFile = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        TempBuffer tempBuffer = this.head;
        this.head = null;
        this.tail = null;
        while (tempBuffer != null) {
            TempBuffer tempBuffer2 = tempBuffer.next;
            TempBuffer.free(tempBuffer);
            tempBuffer = tempBuffer2;
        }
    }

    public TempStream(Path path) {
        this.backingDir = path;
    }
}

