/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.FreeList;
import com.caucho.vfs.ReadStream;
import java.io.IOException;

public class TempBuffer {
    private static FreeList freeList = new FreeList(256);
    public static int SIZE = 8192;
    TempBuffer next;
    byte[] buf = new byte[SIZE];
    int offset;
    int length;
    int bufferCount;

    public static TempBuffer allocate() {
        TempBuffer tempBuffer = (TempBuffer)freeList.allocate();
        if (tempBuffer == null) {
            return new TempBuffer();
        }
        tempBuffer.next = null;
        tempBuffer.offset = 0;
        tempBuffer.length = 0;
        tempBuffer.bufferCount = 0;
        return tempBuffer;
    }

    public void clear() {
        this.next = null;
        this.offset = 0;
        this.length = 0;
        this.bufferCount = 0;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public int write(byte[] byArray, int n, int n2) {
        if (SIZE - this.length < n2) {
            n2 = SIZE - this.length;
        }
        System.arraycopy(byArray, n, this.buf, this.length, n2);
        this.length += n2;
        return n2;
    }

    public static TempBuffer copyFromStream(ReadStream readStream) throws IOException {
        TempBuffer tempBuffer;
        TempBuffer tempBuffer2;
        TempBuffer tempBuffer3 = tempBuffer2 = TempBuffer.allocate();
        int n = 0;
        while ((n = readStream.readAll(tempBuffer3.buf, 0, tempBuffer3.buf.length)) == tempBuffer3.buf.length) {
            tempBuffer = TempBuffer.allocate();
            tempBuffer3.length = n;
            tempBuffer3.next = tempBuffer;
            tempBuffer3 = tempBuffer;
        }
        if (n == 0 && tempBuffer2 == tempBuffer3) {
            return null;
        }
        if (n == 0) {
            tempBuffer = tempBuffer2;
            while (tempBuffer.getNext() != null) {
                if (tempBuffer.getNext().getNext() == null) {
                    TempBuffer.free(tempBuffer.getNext());
                    tempBuffer.next = null;
                }
                tempBuffer = tempBuffer.getNext();
            }
        } else {
            tempBuffer3.length = n;
        }
        return tempBuffer2;
    }

    public int getAvailable() {
        return this.buf.length - this.length;
    }

    public TempBuffer getNext() {
        return this.next;
    }

    public void setNext(TempBuffer tempBuffer) {
        this.next = tempBuffer;
    }

    public static void free(TempBuffer tempBuffer) {
        tempBuffer.next = null;
        freeList.free(tempBuffer);
    }

    public static void freeAll(TempBuffer tempBuffer) {
        while (tempBuffer != null) {
            TempBuffer tempBuffer2 = tempBuffer.next;
            TempBuffer.free(tempBuffer);
            tempBuffer = tempBuffer2;
        }
    }

    private TempBuffer() {
    }
}

