/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.Path;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TcpPath;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

class TcpStream
extends StreamImpl {
    private Socket s;
    private InputStream is;
    private OutputStream os;

    static TcpStream openRead(TcpPath tcpPath) throws IOException {
        Socket socket = new Socket(tcpPath.getHost(), tcpPath.getPort());
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        return new TcpStream(tcpPath, socket, inputStream, outputStream);
    }

    static TcpStream openReadWrite(TcpPath tcpPath) throws IOException {
        Socket socket = new Socket(tcpPath.getHost(), tcpPath.getPort());
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        return new TcpStream(tcpPath, socket, inputStream, outputStream);
    }

    public boolean canWrite() {
        return true;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.os.write(byArray, n, n2);
    }

    public boolean canRead() {
        return true;
    }

    public int getAvailable() throws IOException {
        return this.is.available();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.is.read(byArray, n, n2);
    }

    public void close() throws IOException {
        block5: {
            try {
                if (this.os != null) {
                    this.os.close();
                }
                if (this.is == null) break block5;
                this.is.close();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (this.s != null) {
                    this.s.close();
                }
                throw throwable;
            }
        }
        Object var2_1 = null;
        if (this.s != null) {
            this.s.close();
        }
    }

    private TcpStream(Path path, Socket socket, InputStream inputStream, OutputStream outputStream) {
        this.setPath(path);
        this.s = socket;
        this.is = inputStream;
        this.os = outputStream;
    }
}

