/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CharBuffer;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TcpStream;
import java.io.IOException;
import java.util.Map;

public class TcpPath
extends Path {
    protected String host;
    protected int port;

    protected Path schemeWalk(String string, Map map, String string2, int n) {
        int n2 = string2.length();
        if (n2 < 2 + n || string2.charAt(n) != '/' || string2.charAt(1 + n) != '/') {
            throw new RuntimeException("bad scheme");
        }
        CharBuffer charBuffer = new CharBuffer();
        int n3 = 2 + n;
        char c = '\u0000';
        while (n3 < n2 && (c = string2.charAt(n3)) != ':' && c != '/' && c != '?') {
            charBuffer.append(c);
            ++n3;
        }
        String string3 = charBuffer.toString();
        if (string3.length() == 0) {
            throw new RuntimeException("bad host");
        }
        int n4 = 0;
        if (c == ':') {
            ++n3;
            while (n3 < n2 && (c = string2.charAt(n3)) >= '0' && c <= '9') {
                n4 = 10 * n4 + string2.charAt(n3) - 48;
                ++n3;
            }
        }
        return new TcpPath(this, map, string3, n4);
    }

    public String getScheme() {
        return "tcp";
    }

    public String getURL() {
        int n = this.getPort();
        return this.getScheme() + "://" + this.getHost() + ":" + this.getPort();
    }

    public String getPath() {
        return "";
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public StreamImpl openReadImpl() throws IOException {
        return TcpStream.openRead(this);
    }

    public StreamImpl openReadWriteImpl() throws IOException {
        return TcpStream.openReadWrite(this);
    }

    TcpPath(TcpPath tcpPath, Map map, String string, int n) {
        super(tcpPath);
        this.host = string;
        this.port = n == 0 ? 80 : n;
    }
}

