/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class SocketStream
extends StreamImpl {
    private static byte[] unixNewline = new byte[]{10};
    private Socket s;
    private InputStream is;
    private OutputStream os;
    private byte[] newline = unixNewline;

    public void init(Socket socket) {
        this.s = socket;
        this.is = null;
        this.os = null;
    }

    public void setNewline(byte[] byArray) {
        this.newline = byArray;
    }

    public byte[] getNewline() {
        return this.newline;
    }

    public boolean canRead() {
        return true;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.s == null) {
            return -1;
        }
        if (this.is == null) {
            this.is = this.s.getInputStream();
        }
        try {
            return this.is.read(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw ClientDisconnectException.create(iOException);
        }
    }

    public int getAvailable() throws IOException {
        if (this.s == null) {
            return -1;
        }
        if (this.is == null) {
            this.is = this.s.getInputStream();
        }
        return this.is.available();
    }

    public boolean canWrite() {
        return true;
    }

    public void write(byte[] byArray, int n, int n2, boolean bl) throws IOException {
        if (this.s == null) {
            return;
        }
        if (this.os == null) {
            this.os = this.s.getOutputStream();
        }
        try {
            this.os.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            this.close();
            throw ClientDisconnectException.create(iOException);
        }
    }

    public void flush() throws IOException {
        if (this.os == null) {
            return;
        }
        try {
            this.os.flush();
        }
        catch (IOException iOException) {
            this.close();
            throw ClientDisconnectException.create(iOException);
        }
    }

    public void close() throws IOException {
        Socket socket = this.s;
        this.s = null;
        OutputStream outputStream = this.os;
        this.os = null;
        InputStream inputStream = this.is;
        this.is = null;
        if (outputStream != null) {
            outputStream.close();
        }
        if (socket != null) {
            socket.close();
        }
    }

    public SocketStream(Socket socket) {
        this.init(socket);
    }
}

