/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.NullIterator;
import com.caucho.util.Registry;
import com.caucho.util.StringCharCursor;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.MailtoPath;
import com.caucho.vfs.MemoryStream;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.VfsStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

class SmtpStream
extends MemoryStream {
    static WriteStream dbg = LogStream.open("/caucho.com/smtp.vfs");
    ArrayList to;
    ArrayList cc;
    ArrayList bcc;
    boolean isClosed;
    private HashMap attributes;

    public Object getAttribute(String string) throws IOException {
        if (this.attributes != null) {
            return this.attributes.get(string.toLowerCase());
        }
        return null;
    }

    public Iterator getAttributeNames() {
        if (this.attributes != null) {
            return this.attributes.keySet().iterator();
        }
        return new NullIterator();
    }

    public void setAttribute(String string, Object object) throws IOException {
        if ((string = string.toLowerCase()).equals("date") || string.equals("senter") || string.equals("received") || string.equals("return-path") || string.equals("message-id")) {
            throw new IOException("cannot set property `" + string + "'");
        }
        if (string.equals("to")) {
            this.addTo((String)object);
            return;
        }
        if (string.equals("cc")) {
            this.addCc((String)object);
            return;
        }
        if (string.equals("bcc")) {
            this.addBcc((String)object);
            return;
        }
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(string, object);
    }

    public void addTo(String string) throws IOException {
        StringCharCursor stringCharCursor = new StringCharCursor(string);
        ArrayList arrayList = MailtoPath.parseAddressList(stringCharCursor);
        int n = 0;
        while (n < arrayList.size()) {
            this.to.add(arrayList.get(n));
            ++n;
        }
    }

    public void addCc(String string) throws IOException {
        StringCharCursor stringCharCursor = new StringCharCursor(string);
        ArrayList arrayList = MailtoPath.parseAddressList(stringCharCursor);
        if (this.cc == null) {
            this.cc = arrayList;
        } else {
            int n = 0;
            while (n < arrayList.size()) {
                this.cc.add(arrayList.get(n));
                ++n;
            }
        }
    }

    public void addBcc(String string) throws IOException {
        StringCharCursor stringCharCursor = new StringCharCursor(string);
        ArrayList arrayList = MailtoPath.parseAddressList(stringCharCursor);
        if (this.bcc == null) {
            this.bcc = arrayList;
        } else {
            int n = 0;
            while (n < arrayList.size()) {
                this.bcc.add(arrayList.get(n));
                ++n;
            }
        }
    }

    private int readResponse(InputStream inputStream, CharBuffer charBuffer) throws IOException {
        int n;
        do {
            charBuffer.clear();
            n = 0;
            int n2 = inputStream.read();
            if (n2 >= 48 && n2 <= 57) {
                while (n2 >= 48 && n2 <= 57) {
                    charBuffer.append((char)n2);
                    n = 10 * n + n2 - 48;
                    n2 = inputStream.read();
                }
            }
            while (n2 != 13 && n2 != 10) {
                charBuffer.append((char)n2);
                n2 = inputStream.read();
            }
            if (n2 != 13) continue;
            n2 = inputStream.read();
        } while (n == 0);
        if (dbg.canWrite()) {
            dbg.println(charBuffer);
        }
        return n;
    }

    public void sendRecipients(ReadStream readStream, WriteStream writeStream, ArrayList arrayList, CharBuffer charBuffer) throws IOException {
        if (arrayList == null) {
            return;
        }
        int n = 0;
        while (n < arrayList.size()) {
            MailtoPath.Recipient recipient = (MailtoPath.Recipient)arrayList.get(n);
            writeStream.print("RCPT TO: ");
            writeStream.print(recipient.user);
            if (recipient.host != null) {
                writeStream.print("@");
                writeStream.print(recipient.host);
            }
            writeStream.println("\r");
            if (dbg.canWrite()) {
                dbg.log("RCPT TO: " + recipient.user + "@" + recipient.host);
            }
            if (this.readResponse(readStream, charBuffer) / 100 != 2) {
                throw new IOException("Expected '221' from SMTP: " + charBuffer);
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void writeMessageBody(WriteStream var1_1) throws IOException {
        var3_2 = this.openRead();
        var2_3 = var3_2.read();
        if (var2_3 >= 0) ** GOTO lbl19
        var1_1.println(".\r");
        return;
lbl-1000:
        // 1 sources

        {
            if (var2_3 == 10) {
                var2_3 = var3_2.read();
                if (var2_3 == 46) {
                    var1_1.print("\n..");
                } else {
                    if (var2_3 <= 0) {
                        var1_1.print("\n.\r\n");
                        return;
                    }
                    var1_1.write(10);
                    var1_1.write(var2_3);
                }
            } else {
                var1_1.write(var2_3);
            }
            var2_3 = var3_2.read();
lbl19:
            // 2 sources

            ** while (var2_3 >= 0)
        }
lbl20:
        // 1 sources

        var1_1.println("\r");
        var1_1.println("\n.\r");
    }

    private void writeMessageRecipients(WriteStream writeStream, ArrayList arrayList) throws IOException {
        int n = 0;
        while (n < arrayList.size()) {
            MailtoPath.Recipient recipient = (MailtoPath.Recipient)arrayList.get(n);
            if (n != 0) {
                writeStream.print(", ");
            }
            writeStream.print(recipient.user);
            if (recipient.host != null) {
                writeStream.print("@");
                writeStream.print(recipient.host);
            }
            ++n;
        }
        writeStream.println("\r");
    }

    private void writeMessage(WriteStream writeStream) throws IOException {
        writeStream.print("To: ");
        this.writeMessageRecipients(writeStream, this.to);
        if (this.cc != null && this.cc.size() > 0) {
            writeStream.print("Cc: ");
            this.writeMessageRecipients(writeStream, this.cc);
        }
        if (this.bcc != null && this.bcc.size() > 0) {
            writeStream.print("Bcc: ");
            this.writeMessageRecipients(writeStream, this.bcc);
        }
        Iterator iterator = this.getAttributeNames();
        while (iterator != null && iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = this.getAttribute(string);
            if (object == null) continue;
            writeStream.print(string);
            writeStream.print(": ");
            writeStream.print(String.valueOf(object));
            writeStream.println("\r");
        }
        if (this.getAttribute("from") != null) {
            writeStream.print("Sender: ");
            writeStream.print(CauchoSystem.getUserName());
            writeStream.print("@");
            writeStream.print(CauchoSystem.getLocalHost());
            writeStream.println("\r");
        }
        writeStream.println("\r");
        this.writeMessageBody(writeStream);
    }

    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        String string = Registry.getString("/caucho.com/smtp.vfs/host", "localhost");
        int n = Registry.getInt("/caucho.com/smtp.vfs/port", 25);
        Socket socket = new Socket(string, n);
        CharBuffer charBuffer = new CharBuffer();
        ReadStream readStream = null;
        WriteStream writeStream = null;
        try {
            ReadWritePair readWritePair = VfsStream.openReadWrite(socket.getInputStream(), socket.getOutputStream());
            readStream = readWritePair.getReadStream();
            writeStream = readWritePair.getWriteStream();
            if (this.readResponse(readStream, charBuffer) / 100 != 2) {
                throw new IOException("Expected '220' from SMTP");
            }
            writeStream.print("HELO ");
            writeStream.print(CauchoSystem.getLocalHost());
            writeStream.println("\r");
            if (this.readResponse(readStream, charBuffer) / 100 != 2) {
                throw new IOException("Expected '220' from SMTP");
            }
            writeStream.print("MAIL FROM: ");
            writeStream.print(CauchoSystem.getUserName());
            writeStream.print("@");
            writeStream.println(CauchoSystem.getLocalHost());
            if (this.readResponse(readStream, charBuffer) / 100 != 2) {
                throw new IOException("Expected '250' from SMTP: " + charBuffer);
            }
            this.sendRecipients(readStream, writeStream, this.to, charBuffer);
            if (this.cc != null) {
                this.sendRecipients(readStream, writeStream, this.cc, charBuffer);
            }
            if (this.bcc != null) {
                this.sendRecipients(readStream, writeStream, this.bcc, charBuffer);
            }
            writeStream.println("DATA\r");
            if (this.readResponse(readStream, charBuffer) / 100 != 3) {
                throw new IOException("Expected '354' from SMTP: " + charBuffer);
            }
            this.writeMessage(writeStream);
            if (this.readResponse(readStream, charBuffer) / 100 != 2) {
                throw new IOException("Expected '200' from SMTP: " + charBuffer);
            }
            writeStream.println("QUIT\r");
            if (this.readResponse(readStream, charBuffer) / 100 != 2) {
                throw new IOException("Expected '250' from SMTP: " + charBuffer);
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (readStream != null) {
                    readStream.close();
                }
                if (writeStream != null) {
                    writeStream.close();
                }
            }
            finally {
                Object v0 = null;
            }
        }
        try {
            if (readStream != null) {
                readStream.close();
            }
            if (writeStream != null) {
                writeStream.close();
            }
        }
        finally {
            Object v1 = null;
        }
    }

    SmtpStream(ArrayList arrayList, HashMap hashMap) throws IOException {
        if (arrayList.size() <= 0) {
            throw new IOException("No recipients in mailto");
        }
        this.to = new ArrayList();
        int n = 0;
        while (n < arrayList.size()) {
            this.to.add(arrayList.get(n));
            ++n;
        }
        if (hashMap != null) {
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                try {
                    this.setAttribute(string, hashMap.get(string));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

