/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CharBuffer;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamFilter;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.Utf16Reader;
import com.caucho.vfs.Utf8Reader;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;

public final class ReadStream
extends InputStream {
    private TempBuffer tempRead;
    private byte[] read_buffer;
    private int read_offset;
    private int read_length;
    private WriteStream sibling;
    private StreamImpl source;
    private Reader readEncoding;
    private String readEncodingName;
    private int specialEncoding;
    private boolean disableClose;
    private Reader reader;

    public void init(StreamImpl streamImpl, WriteStream writeStream) {
        this.disableClose = false;
        if (this.source != null) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (streamImpl == null) {
            throw new IllegalArgumentException();
        }
        this.source = streamImpl;
        this.sibling = writeStream;
        if (streamImpl.canRead()) {
            this.tempRead = TempBuffer.allocate();
            this.read_buffer = this.tempRead.buf;
        }
        this.read_offset = 0;
        this.read_length = 0;
        this.readEncoding = null;
        this.readEncodingName = "ISO-8859-1";
    }

    public void setSibling(WriteStream writeStream) {
        this.sibling = writeStream;
    }

    public WriteStream getSibling() {
        return this.sibling;
    }

    public StreamImpl getSource() {
        return this.source;
    }

    public void pushFilter(StreamFilter streamFilter) {
        streamFilter.init(this.source);
        this.source = streamFilter;
    }

    public byte[] getBuffer() {
        return this.read_buffer;
    }

    public int getOffset() {
        return this.read_offset;
    }

    public int getLength() {
        return this.read_length;
    }

    public void setOffset(int n) {
        this.read_offset = n;
    }

    public boolean canRead() {
        return this.source.canRead();
    }

    public void clearRead() {
        this.read_offset = 0;
        this.read_length = 0;
    }

    public int getAvailable() throws IOException {
        if (this.read_length > this.read_offset) {
            return this.read_length - this.read_offset;
        }
        if (this.sibling != null) {
            this.sibling.flush();
        }
        return this.source.getAvailable();
    }

    public int available() throws IOException {
        return this.getAvailable();
    }

    public int getPosition() {
        return -1;
    }

    public void setPosition(int n) {
    }

    public final int read() throws IOException {
        if (this.read_offset >= this.read_length && !this.readBuffer()) {
            return -1;
        }
        return this.read_buffer[this.read_offset++] & 0xFF;
    }

    public final void unread() {
        if (this.read_offset <= 0) {
            throw new RuntimeException();
        }
        --this.read_offset;
    }

    public long skip(long l) throws IOException {
        int n = 0;
        while ((long)this.read_offset + l - (long)n > (long)this.read_length) {
            n += this.read_length - this.read_offset;
            this.read_offset = 0;
            this.read_length = 0;
            if (this.readBuffer()) continue;
            return n;
        }
        this.read_offset = (int)((long)this.read_offset + (l - (long)n));
        return l;
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.read_offset >= this.read_length && !this.readBuffer()) {
            return -1;
        }
        int n3 = this.read_length - this.read_offset;
        if (n2 < n3) {
            n3 = n2;
        }
        System.arraycopy(this.read_buffer, this.read_offset, byArray, n, n3);
        this.read_offset += n3;
        return n3;
    }

    public int readAll(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n2 > 0) {
            int n4 = this.read(byArray, n, n2);
            if (n4 < 0) {
                return n3 == 0 ? -1 : n3;
            }
            n += n4;
            n3 += n4;
            n2 -= n4;
        }
        return n3;
    }

    public void setEncoding(String string) throws UnsupportedEncodingException {
        String string2 = Encoding.getJavaName(string);
        this.readEncoding = string2 == null || string2.equalsIgnoreCase("ISO8859_1") ? null : (string2.equals("UTF8") ? new Utf8Reader(this) : (string2.equals("UTF16") ? new Utf16Reader(this) : new InputStreamReader((InputStream)this, string2)));
        this.readEncodingName = Encoding.getMimeName(string);
    }

    public String getEncoding() {
        return this.readEncodingName;
    }

    public final int readChar() throws IOException {
        if (this.readEncoding != null) {
            return this.readEncoding.read();
        }
        if (this.read_offset >= this.read_length && !this.readBuffer()) {
            return -1;
        }
        return this.read_buffer[this.read_offset++] & 0xFF;
    }

    public final int read(char[] cArray, int n, int n2) throws IOException {
        if (this.readEncoding != null) {
            return this.readEncoding.read(cArray, n, n2);
        }
        byte[] byArray = this.read_buffer;
        if (byArray == null) {
            return -1;
        }
        int n3 = this.read_length;
        int n4 = this.read_offset;
        int n5 = n3 - n4;
        if (n5 <= 0) {
            if (!this.readBuffer()) {
                return -1;
            }
            n3 = this.read_length;
            n4 = this.read_offset;
            n5 = n3 - n4;
        }
        if (n2 < n5) {
            n5 = n2;
        }
        int n6 = 0;
        while (n6 < n5) {
            cArray[n + n6] = (char)(byArray[n4 + n6] & 0xFF);
            ++n6;
        }
        this.read_offset += n5;
        return n5;
    }

    public int readAll(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n2 > 0) {
            int n4 = this.read(cArray, n, n2);
            if (n4 <= 0) {
                return this.read_length;
            }
            n += n4;
            n3 += n4;
            n2 -= n4;
        }
        return n3;
    }

    public int read(CharBuffer charBuffer, int n) throws IOException {
        int n2 = charBuffer.getLength();
        charBuffer.setLength(n2 + n);
        int n3 = this.read(charBuffer.getBuffer(), n2, n);
        if (n3 < 0) {
            charBuffer.setLength(n2);
        } else if (n3 < n) {
            charBuffer.setLength(n2 + n3);
        }
        return n;
    }

    public int readAll(CharBuffer charBuffer, int n) throws IOException {
        int n2 = charBuffer.getLength();
        charBuffer.setLength(n2 + n);
        int n3 = this.readAll(charBuffer.getBuffer(), n2, n);
        if (n3 < 0) {
            charBuffer.setLength(n2);
        } else if (n3 < n) {
            charBuffer.setLength(n2 + n3);
        }
        return n;
    }

    public final boolean readln(CharBuffer charBuffer) throws IOException {
        return this.readLine(charBuffer);
    }

    public final boolean readLine(CharBuffer charBuffer) throws IOException {
        if (this.readEncoding != null) {
            return this.readlnEncoded(charBuffer);
        }
        int n = charBuffer.getCapacity();
        int n2 = charBuffer.getLength();
        char[] cArray = charBuffer.getBuffer();
        byte[] byArray = this.read_buffer;
        while (true) {
            int n3;
            if ((n3 = this.read_length - this.read_offset) > n - n2) {
                n3 = n - n2;
            }
            int n4 = this.read_offset;
            while (n3 > 0) {
                int n5;
                if ((n5 = byArray[n4++] & 0xFF) == 10) {
                    if (n2 > 0 && cArray[n2 - 1] == '\r') {
                        charBuffer.setLength(n2 - 1);
                    } else {
                        charBuffer.setLength(n2);
                    }
                    this.read_offset = n4;
                    return true;
                }
                cArray[n2++] = (char)n5;
                --n3;
            }
            this.read_offset = n4;
            if (n4 >= this.read_length && !this.readBuffer()) {
                charBuffer.setLength(n2);
                return n2 > 0;
            }
            if (n2 < n) continue;
            charBuffer.setLength(n2 + 1);
            n = charBuffer.getCapacity();
            cArray = charBuffer.getBuffer();
        }
    }

    public final int readLine(char[] cArray, int n) throws IOException {
        byte[] byArray = this.read_buffer;
        int n2 = 0;
        do {
            int n3;
            if ((n3 = this.read_length - this.read_offset) < n) {
                n3 = n;
            }
            int n4 = this.read_offset;
            while (n3 > 0) {
                int n5;
                if ((n5 = byArray[n4++] & 0xFF) == 10) {
                    this.read_offset = n4;
                    if (n2 > 0 && cArray[n2 - 1] == '\r') {
                        return n2 - 1;
                    }
                    return n2;
                }
                cArray[n2++] = (char)n5;
                --n3;
            }
            this.read_offset = n4;
            if (n4 < this.read_length || this.readBuffer()) continue;
            return n2;
        } while (n2 < n);
        return n + 1;
    }

    private boolean readlnEncoded(CharBuffer charBuffer) throws IOException {
        int n;
        while ((n = this.readChar()) >= 0) {
            if (n == 10) {
                if (charBuffer.length() > 0 && charBuffer.getLastChar() == '\r') {
                    charBuffer.setLength(charBuffer.getLength() - 1);
                }
                return true;
            }
            charBuffer.append((char)n);
        }
        return charBuffer.length() > 0;
    }

    public final String readln() throws IOException {
        return this.readLine();
    }

    public String readLine() throws IOException {
        CharBuffer charBuffer = new CharBuffer();
        if (this.readln(charBuffer)) {
            return charBuffer.toString();
        }
        if (charBuffer.length() == 0) {
            return null;
        }
        return charBuffer.toString();
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        if (this.read_offset >= this.read_length) {
            this.readBuffer();
        }
        while (this.read_offset < this.read_length) {
            outputStream.write(this.read_buffer, this.read_offset, this.read_length - this.read_offset);
            this.readBuffer();
        }
    }

    public void writeToStream(OutputStream outputStream, int n) throws IOException {
        while (n > 0) {
            if (this.read_offset >= this.read_length && !this.readBuffer()) {
                return;
            }
            int n2 = this.read_length - this.read_offset;
            if (n < n2) {
                n2 = n;
            }
            outputStream.write(this.read_buffer, this.read_offset, n2);
            this.read_offset += n2;
            n -= n2;
        }
    }

    public void writeToWriter(Writer writer) throws IOException {
        int n;
        while ((n = this.readChar()) >= 0) {
            writer.write((char)n);
        }
    }

    public int fillBuffer() throws IOException {
        if (!this.readBuffer()) {
            return -1;
        }
        return this.read_length;
    }

    private boolean readBuffer() throws IOException {
        if (this.read_buffer == null) {
            this.read_offset = 0;
            this.read_length = 0;
            return false;
        }
        if (this.sibling != null) {
            this.sibling.flush();
        }
        this.read_offset = 0;
        this.read_length = this.source.read(this.read_buffer, 0, this.read_buffer.length);
        return this.read_length > 0;
    }

    private boolean readBuffer(int n) throws IOException {
        if (this.read_buffer == null) {
            return false;
        }
        if (this.sibling != null) {
            this.sibling.flush();
        }
        this.read_offset = 0;
        this.read_length = this.source.read(this.read_buffer, n, this.read_buffer.length - n);
        return this.read_length > 0;
    }

    public void setDisableClose(boolean bl) {
        this.disableClose = bl;
    }

    public final void close() throws IOException {
        if (this.disableClose) {
            return;
        }
        if (this.tempRead != null) {
            TempBuffer.free(this.tempRead);
        }
        this.tempRead = null;
        this.read_buffer = null;
        if (this.source != null) {
            StreamImpl streamImpl = this.source;
            this.source = null;
            streamImpl.close();
        }
    }

    public Object getAttribute(String string) throws IOException {
        if (this.sibling != null) {
            this.sibling.flush();
        }
        return this.source.getAttribute(string);
    }

    public Iterator getAttributeNames() throws IOException {
        if (this.sibling != null) {
            this.sibling.flush();
        }
        return this.source.getAttributeNames();
    }

    public void setAttribute(String string, Object object) throws IOException {
        this.source.setAttribute(string, object);
    }

    public void removeAttribute(String string) throws IOException {
        this.source.removeAttribute(string);
    }

    public Path getPath() {
        return this.source.getPath();
    }

    public String getUserPath() {
        if (this.source == null || this.source.getPath() == null) {
            return "stream";
        }
        return this.source.getPath().getUserPath();
    }

    public void setPath(Path path) {
        this.source.setPath(path);
    }

    public Reader getReader() {
        if (this.reader == null) {
            ReadStream readStream = this;
            if (readStream == null) {
                throw null;
            }
            this.reader = readStream.new StreamReader();
        }
        return this.reader;
    }

    public ReadStream() {
    }

    public ReadStream(StreamImpl streamImpl) {
        this.init(streamImpl, null);
    }

    public ReadStream(StreamImpl streamImpl, WriteStream writeStream) {
        this.init(streamImpl, writeStream);
    }

    private class StreamReader
    extends Reader {
        public final int read(char[] cArray, int n, int n2) throws IOException {
            return ReadStream.this.read(cArray, n, n2);
        }

        public boolean ready() throws IOException {
            return ReadStream.this.available() > 0;
        }

        public final void close() throws IOException {
        }

        StreamReader() {
        }
    }
}

