/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import java.util.Iterator;

public class Tree {
    private Tree parent;
    private Tree next;
    private Tree previous;
    private Tree first;
    private Tree last;
    private Object data;

    public Object getData() {
        return this.data;
    }

    public Tree getParent() {
        return this.parent;
    }

    public Tree getNext() {
        return this.next;
    }

    public Tree getNextPreorder() {
        if (this.first != null) {
            return this.first;
        }
        Tree tree = this;
        while (tree != null) {
            if (tree.next != null) {
                return tree.next;
            }
            tree = tree.parent;
        }
        return null;
    }

    public Tree getPrevious() {
        return this.previous;
    }

    public Tree getFirst() {
        return this.first;
    }

    public Tree getLast() {
        return this.last;
    }

    public Tree append(Object object) {
        Tree tree = new Tree(object);
        tree.parent = this;
        tree.previous = this.last;
        if (this.last != null) {
            this.last.next = tree;
        } else {
            this.first = tree;
        }
        this.last = tree;
        return this.last;
    }

    public Iterator children() {
        return new ChildIterator(this.first);
    }

    public Iterator dfs() {
        return new DfsIterator(this.first);
    }

    public Iterator iterator() {
        return new ChildDataIterator(this.first);
    }

    public Tree(Object object) {
        this.data = object;
    }

    static class ChildIterator
    implements Iterator {
        private Tree node;

        public boolean hasNext() {
            return this.node != null;
        }

        public Object next() {
            Tree tree = this.node;
            if (this.node != null) {
                this.node = this.node.getNext();
            }
            return tree;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        ChildIterator(Tree tree) {
            this.node = tree;
        }
    }

    static class ChildDataIterator
    implements Iterator {
        private Tree node;

        public boolean hasNext() {
            return this.node != null;
        }

        public Object next() {
            Tree tree = this.node;
            if (this.node != null) {
                this.node = this.node.getNext();
            }
            return tree == null ? null : tree.data;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        ChildDataIterator(Tree tree) {
            this.node = tree;
        }
    }

    static class DfsIterator
    implements Iterator {
        private Tree top;
        private Tree node;

        public boolean hasNext() {
            return this.node != null;
        }

        public Object next() {
            Tree tree = this.node;
            if (this.node != null) {
                this.node = this.node.getNextPreorder();
            }
            return tree;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        DfsIterator(Tree tree) {
            this.top = tree;
            this.node = tree;
        }
    }
}

