/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.Alarm;
import com.caucho.util.LruCache;

public class TimedCache
extends LruCache {
    private long expireInterval;

    public Object put(Object object, Object object2) {
        return super.put(object, new Entry(this.expireInterval, object2));
    }

    public Object get(Object object) {
        Entry entry = (Entry)super.get(object);
        if (entry == null) {
            return null;
        }
        if (!entry.isValid()) {
            super.remove(object);
            return null;
        }
        return entry.getValue();
    }

    public TimedCache(int n, long l) {
        super(n);
        this.expireInterval = l;
    }

    static class Entry {
        long expireInterval;
        long checkTime;
        Object value;

        boolean isValid() {
            return Alarm.getCurrentTime() < this.checkTime + this.expireInterval;
        }

        Object getValue() {
            return this.value;
        }

        Entry(long l, Object object) {
            this.expireInterval = l;
            this.value = object;
            this.checkTime = Alarm.getCurrentTime();
        }
    }
}

