/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.DynamicClassLoader;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;

public class SimpleClassLoader
extends DynamicClassLoader {
    private static WriteStream dbg = LogStream.open("/caucho.com/util/loader");
    private Path path;
    private String prefix;
    private String pathPrefix;

    public static SimpleClassLoader create(ClassLoader classLoader, Path path, String string) {
        SimpleClassLoader simpleClassLoader;
        if (path == null) {
            throw new NullPointerException();
        }
        try {
            simpleClassLoader = new SimpleClassLoader(classLoader);
        }
        catch (Error error) {
            simpleClassLoader = new SimpleClassLoader();
            simpleClassLoader.setParent(classLoader);
        }
        simpleClassLoader.path = path;
        simpleClassLoader.prefix = string;
        return simpleClassLoader;
    }

    public Path getPath(String string) {
        if (this.prefix != null && this.pathPrefix == null) {
            this.pathPrefix = this.prefix.replace('.', '/');
        }
        if (this.pathPrefix != null && !string.startsWith(this.pathPrefix)) {
            return null;
        }
        return this.path.lookup(string);
    }

    protected String fillClassPath() {
        CharBuffer charBuffer = new CharBuffer();
        if (this.path instanceof JarPath) {
            charBuffer.append(((JarPath)this.path).getContainer().getNativePath());
        } else {
            charBuffer.append(this.path.getNativePath());
        }
        charBuffer.append(CauchoSystem.getPathSeparatorChar());
        charBuffer.append(super.fillClassPath());
        return charBuffer.toString();
    }

    protected SimpleClassLoader() {
    }

    protected SimpleClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }
}

