/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CharBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class QDate {
    public static final int YEAR = 0;
    public static final int MONTH = 1;
    public static final int DAY_OF_MONTH = 2;
    public static final int DAY = 3;
    public static final int DAY_OF_WEEK = 4;
    public static final int HOUR = 5;
    public static final int MINUTE = 6;
    public static final int SECOND = 7;
    public static final int MILLISECOND = 8;
    public static final int TIME = 9;
    public static final int TIME_ZONE = 10;
    static final long MS_PER_DAY = 86400000L;
    static final long MS_PER_EON = 12622780800000L;
    static final int[] DAYS_IN_MONTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    static String stdZoneName;
    static String dstZoneName;
    private static QDate globalDate;
    static String[] dayNames;
    static String[] monthNames;
    private static String[] shortWeekday;
    private static String[] longWeekday;
    private static String[] shortMonth;
    private static String[] longMonth;
    String zoneName;
    TimeZone localTimeZone;
    TimeZone utcTimeZone;
    DateFormat dateFormat;
    Date date;
    TimeZone zone;
    private long eonYear;
    private long time;
    private long days;
    private long year;
    private int dayOfYear;
    private long month;
    private long dayOfMonth;
    private long hour;
    private long minute;
    private long second;
    private long ms;
    private boolean isLeapYear;
    private long timeOfDay;
    private long zoneOffset;
    private long lastTime;
    private String lastDate;

    private boolean isLeapYear(long l) {
        return !(l % 4L != 0L || l % 100L == 0L && l % 400L != 0L);
    }

    private long divFloor(long l, long l2) {
        if (l > 0L) {
            return l / l2;
        }
        return (l - l2 + 1L) / l2;
    }

    private void calculateYear() {
        long l;
        long l2;
        long l3;
        long l4;
        long l5 = this.days;
        l5 += 134774L;
        if ((l4 = this.divFloor(l5 -= (l3 = this.divFloor(l5, 146097L)) * 146097L, 36524L)) == 4L) {
            l4 = 3L;
        }
        if ((l2 = this.divFloor(l5 -= l4 * 36524L, 1461L)) == 25L) {
            l2 = 24L;
        }
        if ((l = this.divFloor(l5 -= l2 * 1461L, 365L)) == 4L) {
            l = 3L;
        }
        this.year = 400L * l3 + 100L * l4 + 4L * l2 + l + 1601L;
        this.dayOfYear = (int)(l5 - 365L * l);
        this.isLeapYear = this.isLeapYear(this.year);
    }

    private void calculateMonth() {
        this.dayOfMonth = this.dayOfYear;
        this.month = 0L;
        while (this.month < 12L) {
            if (this.month == 1L && this.isLeapYear) {
                if (this.dayOfMonth < 29L) {
                    return;
                }
                this.dayOfMonth -= 29L;
            } else {
                if (this.dayOfMonth < (long)DAYS_IN_MONTH[(int)this.month]) {
                    return;
                }
                this.dayOfMonth -= (long)DAYS_IN_MONTH[(int)this.month];
            }
            ++this.month;
        }
    }

    private void calculateSplit(long l) {
        this.time = l;
        this.days = this.divFloor(l, 86400000L);
        this.timeOfDay = l - 86400000L * this.days;
        this.calculateYear();
        this.calculateMonth();
        this.hour = this.timeOfDay / 3600000L;
        this.minute = this.timeOfDay / 60000L % 60L;
        this.second = this.timeOfDay / 1000L % 60L;
        this.ms = this.timeOfDay % 1000L;
    }

    private long yearToDay(long l) {
        if (l > 0L) {
            return 365L * (l -= 1601L) + l / 4L - l / 100L + l / 400L - 134774L;
        }
        l = 2000L - l;
        return 10957L - (365L * l + l / 4L - l / 100L + l / 400L);
    }

    private long monthToDay(long l, boolean bl) {
        long l2 = 0L;
        int n = 0;
        while ((long)n < l && n < 12) {
            l2 += (long)DAYS_IN_MONTH[n];
            if (n == 1 && bl) {
                ++l2;
            }
            ++n;
        }
        return l2;
    }

    private long calculateJoin() {
        this.year += this.divFloor(this.month, 12L);
        this.month -= 12L * this.divFloor(this.month, 12L);
        this.time = 86400000L * (this.yearToDay(this.year) + this.monthToDay(this.month, this.isLeapYear(this.year)) + this.dayOfMonth);
        this.time += this.ms + 1000L * (this.second + 60L * (this.minute + 60L * this.hour));
        return this.time;
    }

    public long getZoneOffset() {
        long l = this.year % 400L + 1600L;
        long l2 = this.localTimeZone.getOffset(1, (int)l, (int)this.month, (int)this.dayOfMonth + 1, (int)(this.days % 7L + 11L) % 7 + 1, (int)this.timeOfDay);
        return l2;
    }

    public String printDate() {
        if (this.lastDate != null && this.lastTime == this.time) {
            return this.lastDate;
        }
        CharBuffer charBuffer = CharBuffer.allocate();
        charBuffer.append(dayNames[(int)(this.days % 7L + 11L) % 7]);
        charBuffer.append(", ");
        charBuffer.append((this.dayOfMonth + 1L) / 10L);
        charBuffer.append((this.dayOfMonth + 1L) % 10L);
        charBuffer.append(" ");
        charBuffer.append(monthNames[(int)this.month]);
        charBuffer.append(" ");
        charBuffer.append(this.year);
        charBuffer.append(" ");
        charBuffer.append(this.timeOfDay / 36000000L % 10L);
        charBuffer.append(this.timeOfDay / 3600000L % 10L);
        charBuffer.append(":");
        charBuffer.append(this.timeOfDay / 600000L % 6L);
        charBuffer.append(this.timeOfDay / 60000L % 10L);
        charBuffer.append(":");
        charBuffer.append(this.timeOfDay / 10000L % 6L);
        charBuffer.append(this.timeOfDay / 1000L % 10L);
        if (this.zoneName == null) {
            charBuffer.append(" GMT");
            this.lastDate = charBuffer.close();
            this.lastTime = this.time;
            return this.lastDate;
        }
        long l = this.zoneOffset;
        if (l < 0L) {
            charBuffer.append(" -");
            l = -l;
        } else {
            charBuffer.append(" +");
        }
        charBuffer.append(l / 36000000L % 10L);
        charBuffer.append(l / 3600000L % 10L);
        charBuffer.append(l / 600000L % 6L);
        charBuffer.append(l / 60000L % 10L);
        charBuffer.append(" (");
        charBuffer.append(this.zoneName);
        charBuffer.append(")");
        this.lastDate = charBuffer.close();
        this.lastTime = this.time;
        return this.lastDate;
    }

    public void printDate(WriteStream writeStream) throws IOException {
        writeStream.print(dayNames[(int)(this.days % 7L + 11L) % 7]);
        writeStream.write(44);
        writeStream.write(32);
        writeStream.print((this.dayOfMonth + 1L) / 10L);
        writeStream.print((this.dayOfMonth + 1L) % 10L);
        writeStream.write(32);
        writeStream.print(monthNames[(int)this.month]);
        writeStream.write(32);
        writeStream.print(this.year);
        writeStream.write(32);
        writeStream.print(this.timeOfDay / 36000000L % 10L);
        writeStream.print(this.timeOfDay / 3600000L % 10L);
        writeStream.write(58);
        writeStream.print(this.timeOfDay / 600000L % 6L);
        writeStream.print(this.timeOfDay / 60000L % 10L);
        writeStream.write(58);
        writeStream.print(this.timeOfDay / 10000L % 6L);
        writeStream.print(this.timeOfDay / 1000L % 10L);
        if (this.zoneName == null) {
            writeStream.print(" GMT");
            return;
        }
        long l = this.zoneOffset;
        if (l < 0L) {
            writeStream.write(32);
            writeStream.write(45);
            l = -l;
        } else {
            writeStream.write(32);
            writeStream.write(43);
        }
        writeStream.print(l / 36000000L % 10L);
        writeStream.print(l / 3600000L % 10L);
        writeStream.print(l / 600000L % 6L);
        writeStream.print(l / 60000L % 10L);
        writeStream.write(32);
        writeStream.write(40);
        writeStream.print(this.zoneName);
        writeStream.write(41);
    }

    public String printISO8601() {
        long l;
        CharBuffer charBuffer = new CharBuffer();
        if (this.year > 0L) {
            charBuffer.append(this.year / 1000L % 10L);
            charBuffer.append(this.year / 100L % 10L);
            charBuffer.append(this.year / 10L % 10L);
            charBuffer.append(this.year % 10L);
            charBuffer.append((this.month + 1L) / 10L % 10L);
            charBuffer.append((this.month + 1L) % 10L);
            charBuffer.append((this.dayOfMonth + 1L) / 10L % 10L);
            charBuffer.append((this.dayOfMonth + 1L) % 10L);
        }
        if ((l = this.timeOfDay / 1000L) != 0L || this.year <= 0L) {
            charBuffer.append("T");
            charBuffer.append(l / 36000L % 10L);
            charBuffer.append(l / 3600L % 10L);
            if (l % 3600L != 0L) {
                charBuffer.append(l / 600L % 6L);
                charBuffer.append(l / 60L % 10L);
                if (l % 60L != 0L) {
                    charBuffer.append(l / 10L % 6L);
                    charBuffer.append(l / 1L % 10L);
                }
            }
        }
        if (this.zoneName == null) {
            charBuffer.append("Z");
            return charBuffer.toString();
        }
        return charBuffer.toString();
    }

    public String printISO8601Date() {
        CharBuffer charBuffer = new CharBuffer();
        if (this.year > 0L) {
            charBuffer.append(this.year / 1000L % 10L);
            charBuffer.append(this.year / 100L % 10L);
            charBuffer.append(this.year / 10L % 10L);
            charBuffer.append(this.year % 10L);
            charBuffer.append('-');
            charBuffer.append((this.month + 1L) / 10L % 10L);
            charBuffer.append((this.month + 1L) % 10L);
            charBuffer.append('-');
            charBuffer.append((this.dayOfMonth + 1L) / 10L % 10L);
            charBuffer.append((this.dayOfMonth + 1L) % 10L);
        }
        return charBuffer.toString();
    }

    public static synchronized String format(long l, String string) {
        if (globalDate == null) {
            globalDate = new QDate();
        }
        globalDate.calculate(l, false);
        return globalDate.format(string);
    }

    public static synchronized String format(long l) {
        if (globalDate == null) {
            globalDate = new QDate();
        }
        globalDate.calculate(l, false);
        return globalDate.printDate();
    }

    public static synchronized String formatLocal(long l, String string) {
        if (globalDate == null) {
            globalDate = new QDate();
        }
        globalDate.calculate(l, true);
        return globalDate.format(string);
    }

    public static synchronized String formatLocal(long l) {
        if (globalDate == null) {
            globalDate = new QDate();
        }
        globalDate.calculate(l, true);
        return globalDate.printDate();
    }

    public String format(String string) {
        CharBuffer charBuffer = new CharBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c != '%') {
                charBuffer.append(c);
            } else {
                switch (string.charAt(++n2)) {
                    case 'a': {
                        charBuffer.append(shortWeekday[this.getDayOfWeek()]);
                        break;
                    }
                    case 'A': {
                        charBuffer.append(longWeekday[this.getDayOfWeek()]);
                        break;
                    }
                    case 'b': {
                        charBuffer.append(shortMonth[(int)this.month]);
                        break;
                    }
                    case 'B': {
                        charBuffer.append(longMonth[(int)this.month]);
                        break;
                    }
                    case 'c': {
                        charBuffer.append(this.printLocaleDate());
                        break;
                    }
                    case 'd': {
                        charBuffer.append((this.dayOfMonth + 1L) / 10L);
                        charBuffer.append((this.dayOfMonth + 1L) % 10L);
                        break;
                    }
                    case 'H': {
                        int n3 = (int)(this.timeOfDay / 3600000L) % 24;
                        charBuffer.append(n3 / 10);
                        charBuffer.append(n3 % 10);
                        break;
                    }
                    case 'I': {
                        int n3 = (int)(this.timeOfDay / 3600000L) % 12;
                        if (n3 == 0) {
                            n3 = 12;
                        }
                        charBuffer.append(n3 / 10);
                        charBuffer.append(n3 % 10);
                        break;
                    }
                    case 'j': {
                        charBuffer.append((this.dayOfYear + 1) / 100);
                        charBuffer.append((this.dayOfYear + 1) / 10 % 10);
                        charBuffer.append((this.dayOfYear + 1) % 10);
                        break;
                    }
                    case 'm': {
                        charBuffer.append((this.month + 1L) / 10L);
                        charBuffer.append((this.month + 1L) % 10L);
                        break;
                    }
                    case 'M': {
                        charBuffer.append(this.timeOfDay / 600000L % 6L);
                        charBuffer.append(this.timeOfDay / 60000L % 10L);
                        break;
                    }
                    case 'p': {
                        int n3 = (int)(this.timeOfDay / 3600000L) % 24;
                        if (n3 < 12) {
                            charBuffer.append("am");
                            break;
                        }
                        charBuffer.append("pm");
                        break;
                    }
                    case 'S': {
                        charBuffer.append(this.timeOfDay / 10000L % 6L);
                        charBuffer.append(this.timeOfDay / 1000L % 10L);
                        break;
                    }
                    case 's': {
                        charBuffer.append(this.timeOfDay / 100L % 10L);
                        charBuffer.append(this.timeOfDay / 10L % 10L);
                        charBuffer.append(this.timeOfDay % 10L);
                        break;
                    }
                    case 'W': {
                        int n4;
                        int n5 = (int)((this.days - (long)this.dayOfYear) % 7L + 11L) % 7;
                        int n6 = this.dayOfYear - (7 - n5) % 7;
                        int n7 = n4 = n6 < 0 ? -1 : n6 / 7;
                        if (n5 <= 3) {
                            ++n4;
                        }
                        charBuffer.append((n4 + 1) / 10);
                        charBuffer.append((n4 + 1) % 10);
                        break;
                    }
                    case 'w': {
                        charBuffer.append(this.getDayOfWeek());
                        break;
                    }
                    case 'y': {
                        charBuffer.append(this.year / 10L % 10L);
                        charBuffer.append(this.year % 10L);
                        break;
                    }
                    case 'Y': {
                        charBuffer.append(this.year / 1000L % 10L);
                        charBuffer.append(this.year / 100L % 10L);
                        charBuffer.append(this.year / 10L % 10L);
                        charBuffer.append(this.year % 10L);
                        break;
                    }
                    case 'Z': {
                        if (this.zoneName == null) {
                            charBuffer.append("GMT");
                            break;
                        }
                        charBuffer.append(this.zoneName);
                        break;
                    }
                    default: {
                        charBuffer.append(string.charAt(n2));
                    }
                }
            }
            ++n2;
        }
        return charBuffer.toString();
    }

    public String printLocaleDate() {
        if (this.date == null) {
            this.date = new Date();
        }
        this.date.setTime(this.time - this.zoneOffset);
        if (this.dateFormat == null) {
            this.dateFormat = DateFormat.getInstance();
        }
        return this.dateFormat.format(this.date);
    }

    public long parseDateToGMT(String string) throws Exception {
        long l = this.parseDate(string);
        return this.localToGMT(l);
    }

    public long parseDate(String string) throws Exception {
        try {
            int n = this.skipWhitespace(string, 0);
            char c = string.charAt(n);
            if (c >= '0' && c <= '9' || c == 'T' && string.charAt(n + 1) >= '0' && string.charAt(n + 1) <= '9') {
                return this.parseISO8601Date(string, n);
            }
            CharBuffer charBuffer = new CharBuffer();
            n = this.scan(string, 0, charBuffer, true);
            if (charBuffer.length() == 0 || !Character.isDigit(charBuffer.charAt(0))) {
                n = this.scan(string, n, charBuffer, true);
            }
            this.dayOfMonth = this.parseInt(charBuffer);
            n = this.scan(string, n, charBuffer, true);
            String string2 = charBuffer.toString();
            this.month = 0L;
            while (this.month < 12L) {
                if (monthNames[(int)this.month].equalsIgnoreCase(string2)) break;
                ++this.month;
            }
            if (this.month == 12L) {
                throw new Exception();
            }
            n = this.scan(string, n, charBuffer, true);
            this.year = this.parseInt(charBuffer);
            if (charBuffer.length() < 3 && this.year < 50L) {
                this.year += 2000L;
            } else if (charBuffer.length() < 3 && this.year < 100L) {
                this.year += 1900L;
            }
            n = this.scan(string, n, charBuffer, false);
            this.timeOfDay = this.parseInt(charBuffer) * 3600000;
            n = this.scan(string, n, charBuffer, false);
            this.timeOfDay += (long)(this.parseInt(charBuffer) * 60000);
            n = this.scan(string, n, charBuffer, false);
            this.timeOfDay += (long)(this.parseInt(charBuffer) * 1000);
            if (this.year <= 1600L) {
                --this.dayOfMonth;
            }
            long l = 86400000L * (this.yearToDay(this.year) + this.monthToDay(this.month, this.isLeapYear(this.year)) + this.dayOfMonth - 1L) + this.timeOfDay;
            try {
                int n2 = n = this.scan(string, n, charBuffer, false);
                while (n2 < charBuffer.length()) {
                    if (charBuffer.charAt(n2) == ';') {
                        charBuffer.setLength(n2);
                    }
                    ++n2;
                }
                c = charBuffer.charAt(0);
                if (c == '-' || c == '+' || c >= '0' && c <= '9') {
                    this.zoneOffset = this.parseInt(charBuffer);
                    this.zoneOffset = 60000L * (60L * (this.zoneOffset / 100L) + this.zoneOffset % 100L);
                    l -= this.zoneOffset;
                } else if (!charBuffer.equalsIgnoreCase("gmt") && !charBuffer.equalsIgnoreCase("utc")) {
                    l = this.localToGMT(l);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return l;
        }
        catch (Exception exception) {
            return Long.MAX_VALUE;
        }
    }

    private long parseISO8601Date(String string, int n) throws Exception {
        int n2 = string.length();
        int n3 = 0;
        char c = string.charAt(n);
        if ('0' <= c && c <= '9') {
            n3 = this.scanISOInt(string, n, n2, 4);
            n += 4;
        }
        if (n < n2 && string.charAt(n) == '-') {
            ++n;
        }
        int n4 = 0;
        if (n < n2 && '0' <= (c = string.charAt(n)) && c <= '9') {
            n4 = this.scanISOInt(string, n, n2, 2);
            --n4;
            n += 2;
        } else if (c == 'W') {
            return Long.MAX_VALUE;
        }
        if (n < n2 && string.charAt(n) == '-') {
            ++n;
        }
        int n5 = 0;
        if (n < n2 && '0' <= (c = string.charAt(n)) && c <= '9') {
            n5 = this.scanISOInt(string, n, n2, 2);
            --n5;
            n += 2;
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (n < n2 && string.charAt(n) == 'T') {
            if (++n < n2 && '0' <= (c = string.charAt(n)) && c <= '9') {
                n6 = this.scanISOInt(string, n, n2, 2);
                n += 2;
            }
            if (n < n2 && string.charAt(n) == ':') {
                ++n;
            }
            if (n < n2 && '0' <= (c = string.charAt(n)) && c <= '9') {
                n7 = this.scanISOInt(string, n, n2, 2);
                n += 2;
            }
            if (n < n2 && string.charAt(n) == ':') {
                ++n;
            }
            if (n < n2 && '0' <= (c = string.charAt(n)) && c <= '9') {
                n8 = this.scanISOInt(string, n, n2, 2);
                n += 2;
            }
        }
        long l = 1000 * (n8 + 60 * (n7 + 60 * n6));
        if (n3 <= 1600) {
            --n5;
        }
        long l2 = 86400000L * (this.yearToDay(n3) + this.monthToDay(n4, this.isLeapYear(n3)) + (long)n5) + l;
        if (n >= n2) {
            return this.localToGMT(l2);
        }
        if (string.charAt(n) == 'Z') {
            ++n;
        } else if (string.charAt(n) == '-' || string.charAt(n) == '+') {
            int n9 = 1;
            if (string.charAt(n) == '-') {
                n9 = -1;
            }
            int n10 = this.scanISOInt(string, ++n, n2, 2);
            int n11 = 0;
            if ((n += 2) < n2 && string.charAt(n) == ':') {
                ++n;
            }
            if (n < n2 && '0' <= (c = string.charAt(n)) && c <= '9') {
                n11 = this.scanISOInt(string, n, n2, 2);
                n += 2;
            }
            l2 += (long)(n9 * 1000 * (60 * (n11 + 60 * n10)));
        } else {
            l2 = this.localToGMT(l2);
        }
        n = this.skipWhitespace(string, n);
        if (n < n2) {
            throw new Exception("extra junk at end of ISO date");
        }
        return l2;
    }

    private int scanISOInt(String string, int n, int n2, int n3) throws Exception {
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            char c;
            if (n >= n2) {
                throw new Exception("expected ISO8601 digit");
            }
            if ('0' > (c = string.charAt(n++)) || c > '9') {
                throw new Exception("expected ISO8601 digit");
            }
            n4 = 10 * n4 + c - 48;
            ++n5;
        }
        return n4;
    }

    private int skipWhitespace(String string, int n) {
        char c;
        while (n < string.length() && ((c = string.charAt(n)) == ' ' || c == '\t' || c == '\n' || c == '\r')) {
            ++n;
        }
        return n;
    }

    private int scan(String string, int n, CharBuffer charBuffer, boolean bl) throws Exception {
        char c;
        charBuffer.setLength(0);
        while (n < string.length()) {
            c = string.charAt(n);
            if (!Character.isWhitespace(c) && c != ':' && (!bl || c != '-')) break;
            ++n;
        }
        while (n < string.length()) {
            c = string.charAt(n);
            if (Character.isWhitespace(c) || c == ':' || bl && c == '-') break;
            charBuffer.append(c);
            ++n;
        }
        if (charBuffer.length() == 0) {
            throw new Exception();
        }
        return n;
    }

    private int parseInt(CharBuffer charBuffer) throws Exception {
        int n = 0;
        int n2 = 1;
        int n3 = 0;
        while (n3 < charBuffer.length()) {
            char c = charBuffer.charAt(n3);
            if (n3 == 0 && c == '-') {
                n2 = -1;
            } else if (n3 != 0 || c != '+') {
                if (c >= '0' && c <= '9') {
                    n = 10 * n + c - 48;
                } else {
                    throw new Exception();
                }
            }
            ++n3;
        }
        return n2 * n;
    }

    private long localToGMT(long l) throws Exception {
        this.calculateSplit(l - (long)this.localTimeZone.getRawOffset());
        this.zoneOffset = this.getZoneOffset();
        this.calculateSplit(l - this.zoneOffset);
        return this.time;
    }

    private long GMTToLocal(long l) throws Exception {
        this.calculateSplit(l + (long)this.localTimeZone.getRawOffset());
        this.zoneOffset = this.getZoneOffset();
        return l + this.zoneOffset;
    }

    public long calculate(long l, boolean bl) {
        if (bl) {
            this.calculateSplit(l + (long)this.localTimeZone.getRawOffset());
            this.zoneOffset = this.getZoneOffset();
            this.calculateSplit(l + this.zoneOffset);
            this.zoneName = this.zoneOffset == (long)this.localTimeZone.getRawOffset() ? stdZoneName : dstZoneName;
        } else {
            this.zoneName = null;
            this.calculateSplit(l);
        }
        return this.time;
    }

    public long setTime(long l) {
        this.calculateSplit(l);
        return l;
    }

    public long setDate(long l, long l2, long l3) {
        this.calculateSplit(this.time);
        l += (long)Math.floor((double)l2 / 12.0);
        l2 = (long)((double)l2 - 12.0 * Math.floor((double)l2 / 12.0));
        this.year = l;
        this.month = l2;
        this.dayOfMonth = l3;
        this.calculateJoin();
        this.calculateSplit(this.time);
        return this.time;
    }

    public long setTime(long l, long l2, long l3, long l4) {
        this.calculateSplit(this.time);
        this.hour = l;
        this.minute = l2;
        this.second = l3;
        this.ms = l4;
        this.calculateJoin();
        this.calculateSplit(this.time);
        return this.time;
    }

    public long getTime() {
        return this.time;
    }

    public long getYear() {
        return this.year;
    }

    public int getMonth() {
        return (int)this.month;
    }

    public int getDayOfMonth() {
        return (int)this.dayOfMonth;
    }

    public int getDayOfWeek() {
        return (int)(this.days % 7L + 11L) % 7;
    }

    public long get(int n) {
        switch (n) {
            case 9: {
                return this.time;
            }
            case 0: {
                return this.year;
            }
            case 1: {
                return this.month;
            }
            case 2: {
                return this.dayOfMonth;
            }
            case 3: {
                return (this.days % 7L + 11L) % 7L;
            }
            case 4: {
                return (this.days % 7L + 11L) % 7L;
            }
            case 5: {
                return this.hour;
            }
            case 6: {
                return this.minute;
            }
            case 7: {
                return this.second;
            }
            case 8: {
                return this.ms;
            }
            case 10: {
                return this.getZoneOffset() / 1000L;
            }
        }
        return Long.MAX_VALUE;
    }

    public long set(int n, long l) {
        switch (n) {
            case 0: {
                this.year = l;
                break;
            }
            case 1: {
                this.month = l;
                break;
            }
            case 2: {
                this.dayOfMonth = l;
                break;
            }
            case 5: {
                this.hour = l;
                break;
            }
            case 6: {
                this.minute = l;
                break;
            }
            case 7: {
                this.second = l;
                break;
            }
            case 8: {
                this.ms = l;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        this.calculateJoin();
        this.calculateSplit(this.time);
        return this.time;
    }

    public Object clone() {
        QDate qDate = new QDate();
        qDate.localTimeZone = this.localTimeZone;
        qDate.utcTimeZone = this.utcTimeZone;
        return qDate;
    }

    public String toString() {
        return this.printDate();
    }

    public QDate() {
        if (stdZoneName == null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("z");
            GregorianCalendar gregorianCalendar = new GregorianCalendar(1970, 12, 23);
            stdZoneName = simpleDateFormat.format(gregorianCalendar.getTime());
            gregorianCalendar = new GregorianCalendar(1970, 6, 23);
            dstZoneName = simpleDateFormat.format(gregorianCalendar.getTime());
        }
        this.localTimeZone = TimeZone.getDefault();
        this.utcTimeZone = TimeZone.getTimeZone("UTC");
    }

    private QDate(boolean bl) {
    }

    static {
        dayNames = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        monthNames = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        shortWeekday = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        longWeekday = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
        shortMonth = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        longMonth = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    }
}

