/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CacheListener;
import java.util.Iterator;

public class LruCache {
    private static Integer NULL = new Integer(0);
    private CacheItem[] entries;
    private int capacity;
    private int size;
    private int mask;
    private CacheItem head;
    private CacheItem tail;

    public int getCapacity() {
        return this.capacity;
    }

    public void clear() {
        LruCache lruCache = this;
        synchronized (lruCache) {
            int n = 0;
            while (n < this.entries.length) {
                CacheItem cacheItem = this.entries[n];
                if (cacheItem != null && cacheItem.value instanceof CacheListener) {
                    ((CacheListener)cacheItem.value).removeEvent();
                }
                this.entries[n] = null;
                ++n;
            }
        }
        this.size = 0;
        this.head = null;
        this.tail = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object get(Object object) {
        if (object == null) {
            object = NULL;
        }
        int n = object.hashCode() & this.mask;
        int n2 = this.size + 1;
        LruCache lruCache = this;
        synchronized (lruCache) {
            while (n2 > 0) {
                CacheItem cacheItem = this.entries[n];
                if (cacheItem == null) {
                    return null;
                }
                if (cacheItem.key == object || cacheItem.key.equals(object)) {
                    this.updateLru(cacheItem);
                    return cacheItem.value;
                }
                n = n + 1 & this.mask;
                --n2;
            }
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object put(Object object, Object object2) {
        if (object == null) {
            object = NULL;
        }
        while (this.size >= this.capacity) {
            this.remove(this.tail.key);
        }
        LruCache lruCache = this;
        synchronized (lruCache) {
            int n = object.hashCode() & this.mask;
            int n2 = this.size + 1;
            while (n2 > 0) {
                CacheItem cacheItem = this.entries[n];
                if (cacheItem == null) {
                    this.entries[n] = cacheItem = new CacheItem(object, object2);
                    ++this.size;
                    cacheItem.next = this.head;
                    if (this.head != null) {
                        this.head.prev = cacheItem;
                    }
                    this.head = cacheItem;
                    if (this.tail != null) return null;
                    this.tail = cacheItem;
                    return null;
                }
                if (cacheItem.key == object || cacheItem.key.equals(object)) {
                    this.updateLru(cacheItem);
                    Object object3 = cacheItem.value;
                    cacheItem.value = object2;
                    return object3;
                }
                n = n + 1 & this.mask;
                --n2;
            }
            throw new RuntimeException();
        }
    }

    private void updateLru(CacheItem cacheItem) {
        CacheItem cacheItem2 = cacheItem.prev;
        CacheItem cacheItem3 = cacheItem.next;
        if (cacheItem2 != null) {
            cacheItem2.next = cacheItem3;
            cacheItem.prev = null;
            cacheItem.next = this.head;
            this.head.prev = cacheItem;
            this.head = cacheItem;
            if (cacheItem3 != null) {
                cacheItem3.prev = cacheItem2;
            } else {
                this.tail = cacheItem2;
            }
        }
    }

    public boolean removeTail() {
        CacheItem cacheItem = this.tail;
        if (cacheItem == null) {
            return false;
        }
        this.remove(cacheItem.key);
        return true;
    }

    public Object remove(Object object) {
        if (object == null) {
            object = NULL;
        }
        int n = object.hashCode() & this.mask;
        int n2 = this.size + 1;
        Object object2 = null;
        LruCache lruCache = this;
        synchronized (lruCache) {
            while (n2 > 0) {
                CacheItem cacheItem = this.entries[n];
                if (cacheItem == null) {
                    Object var7_7 = null;
                    Object var6_8 = null;
                    return var7_7;
                }
                if (cacheItem.key == object || cacheItem.key.equals(object)) {
                    this.entries[n] = null;
                    --this.size;
                    CacheItem cacheItem2 = cacheItem.prev;
                    CacheItem cacheItem3 = cacheItem.next;
                    if (cacheItem2 != null) {
                        cacheItem2.next = cacheItem3;
                    } else {
                        this.head = cacheItem3;
                    }
                    if (cacheItem3 != null) {
                        cacheItem3.prev = cacheItem2;
                    } else {
                        this.tail = cacheItem2;
                    }
                    int n3 = 1;
                    while (n3 <= n2) {
                        int n4 = n + n3 & this.mask;
                        CacheItem cacheItem4 = this.entries[n4];
                        if (cacheItem4 == null) break;
                        this.entries[n4] = null;
                        this.refillEntry(cacheItem4);
                        ++n3;
                    }
                    object2 = cacheItem.value;
                    break;
                }
                n = n + 1 & this.mask;
                --n2;
            }
        }
        if (n2 < 0) {
            throw new RuntimeException("internal cache error");
        }
        if (object2 instanceof CacheListener) {
            ((CacheListener)object2).removeEvent();
        }
        return object2;
    }

    private void refillEntry(CacheItem cacheItem) {
        int n = cacheItem.key.hashCode();
        int n2 = 0;
        while (n2 < this.size + 1) {
            int n3 = n + n2 & this.mask;
            if (this.entries[n3] == null) {
                this.entries[n3] = cacheItem;
                return;
            }
            ++n2;
        }
    }

    public Iterator keys() {
        KeyIterator keyIterator = new KeyIterator();
        keyIterator.init(this);
        return keyIterator;
    }

    public Iterator keys(Iterator iterator) {
        KeyIterator keyIterator = (KeyIterator)iterator;
        keyIterator.init(this);
        return keyIterator;
    }

    public Iterator values() {
        ValueIterator valueIterator = new ValueIterator();
        valueIterator.init(this);
        return valueIterator;
    }

    public Iterator values(Iterator iterator) {
        ValueIterator valueIterator = (ValueIterator)iterator;
        valueIterator.init(this);
        return valueIterator;
    }

    public LruCache(int n) {
        int n2 = 32;
        while (n2 < 2 * n) {
            n2 *= 2;
        }
        this.entries = new CacheItem[n2];
        this.mask = n2 - 1;
        this.capacity = n2 / 2;
    }

    static class CacheItem {
        CacheItem prev;
        CacheItem next;
        Object key;
        Object value;
        int index;

        CacheItem(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }
    }

    static class KeyIterator
    implements Iterator {
        CacheItem item;

        void init(LruCache lruCache) {
            this.item = lruCache.head;
        }

        public boolean hasNext() {
            return this.item != null;
        }

        public Object next() {
            Object object = this.item.key;
            this.item = this.item.next;
            return object;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        KeyIterator() {
        }
    }

    static class ValueIterator
    implements Iterator {
        CacheItem item;

        void init(LruCache lruCache) {
            this.item = lruCache.head;
        }

        public boolean hasNext() {
            return this.item != null;
        }

        public Object next() {
            Object object = this.item.value;
            this.item = this.item.next;
            return object;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        ValueIterator() {
        }
    }
}

