/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import java.util.Iterator;

public class IntMap {
    public static final int NULL = Integer.MIN_VALUE;
    private static int DELETED = 1;
    private Object[] keys = new Object[16];
    private int nullValue;
    private int[] values = new int[16];
    private byte[] flags = new byte[16];
    private int size = 0;
    private int mask = this.keys.length - 1;

    public void clear() {
        this.nullValue = Integer.MIN_VALUE;
        int n = 0;
        while (n < this.values.length) {
            this.keys[n] = null;
            this.flags[n] = 0;
            this.values[n] = 0;
            ++n;
        }
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public int get(Object object) {
        if (object == null) {
            return this.nullValue;
        }
        int n = object.hashCode() & this.mask;
        Object object2;
        while ((object2 = this.keys[n]) != object) {
            if (object2 == null) {
                if ((this.flags[n] & DELETED) == 0) {
                    return Integer.MIN_VALUE;
                }
            } else if (object2.equals(object)) {
                return this.values[n];
            }
            n = n + 1 & this.mask;
        }
        return this.values[n];
    }

    private void resize(int n) {
        Object[] objectArray = new Object[n];
        int[] nArray = new int[n];
        byte[] byArray = new byte[n];
        this.mask = objectArray.length - 1;
        int n2 = 0;
        while (n2 < this.keys.length) {
            if (this.keys[n2] != null && (this.flags[n2] & DELETED) == 0) {
                int n3 = this.keys[n2].hashCode() & this.mask;
                while (true) {
                    if (objectArray[n3] == null) {
                        objectArray[n3] = this.keys[n2];
                        nArray[n3] = this.values[n2];
                        byArray[n3] = this.flags[n2];
                        break;
                    }
                    n3 = n3 + 1 & this.mask;
                }
            }
            ++n2;
        }
        this.keys = objectArray;
        this.values = nArray;
        this.flags = byArray;
    }

    public int put(Object object, int n) {
        if (object == null) {
            int n2 = this.nullValue;
            this.nullValue = n;
            return n2;
        }
        int n3 = object.hashCode() & this.mask;
        while (true) {
            Object object2;
            if ((object2 = this.keys[n3]) == null || (this.flags[n3] & DELETED) != 0) {
                this.keys[n3] = object;
                this.values[n3] = n;
                this.flags[n3] = 0;
                ++this.size;
                if (this.keys.length <= 2 * this.size) {
                    this.resize(2 * this.keys.length);
                }
                return Integer.MIN_VALUE;
            }
            if (object == object2 || object2.equals(object)) break;
            n3 = n3 + 1 & this.mask;
        }
        int n4 = this.values[n3];
        this.values[n3] = n;
        return n4;
    }

    public int remove(Object object) {
        if (object == null) {
            int n = this.nullValue;
            this.nullValue = Integer.MIN_VALUE;
            return n;
        }
        int n = object.hashCode() & this.mask;
        Object object2;
        while ((object2 = this.keys[n]) != null) {
            if (object2.equals(object)) {
                int n2 = n;
                this.flags[n2] = (byte)(this.flags[n2] | DELETED);
                --this.size;
                this.keys[n] = null;
                return this.values[n];
            }
            n = n + 1 & this.mask;
        }
        return Integer.MIN_VALUE;
    }

    public Iterator iterator() {
        IntMap intMap = this;
        if (intMap == null) {
            throw null;
        }
        return intMap.new IntMapIterator();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IntMap[");
        boolean bl = true;
        int n = 0;
        while (n <= this.mask) {
            if ((this.flags[n] & DELETED) == 0 && this.keys[n] != null) {
                if (!bl) {
                    stringBuffer.append(", ");
                }
                bl = false;
                stringBuffer.append(this.keys[n]);
                stringBuffer.append(":");
                stringBuffer.append(this.values[n]);
            }
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public IntMap() {
        this.nullValue = Integer.MIN_VALUE;
    }

    class IntMapIterator
    implements Iterator {
        int index;

        public boolean hasNext() {
            while (this.index < IntMap.this.keys.length) {
                if (IntMap.this.keys[this.index] != null && (IntMap.this.flags[this.index] & DELETED) == 0) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        public Object next() {
            while (this.index < IntMap.this.keys.length) {
                if (IntMap.this.keys[this.index] != null && (IntMap.this.flags[this.index] & DELETED) == 0) {
                    return IntMap.this.keys[this.index++];
                }
                ++this.index;
            }
            return null;
        }

        public void remove() {
            throw new RuntimeException();
        }

        IntMapIterator() {
        }
    }
}

