/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

public class IntArray {
    private int[] data = new int[16];
    private int size = 0;

    public void clear() {
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public void add(int n) {
        if (this.size >= this.data.length) {
            this.expand(this.size + 1);
        }
        this.data[this.size++] = n;
    }

    public void add(IntArray intArray) {
        if (this.size >= this.data.length) {
            this.expand(this.size + intArray.size);
        }
        int n = 0;
        while (n < intArray.size) {
            this.data[this.size++] = intArray.data[n];
            ++n;
        }
    }

    public void add(int n, int n2) {
        this.expand(this.size + 1);
        System.arraycopy(this.data, n, this.data, n + 1, this.size - n);
        this.data[n] = n2;
        ++this.size;
    }

    public int pop() {
        return this.data[--this.size];
    }

    public void setLength(int n) {
        this.expand(n);
        int n2 = this.size;
        while (n2 < n) {
            this.data[n2] = 0;
            ++n2;
        }
        this.size = n;
    }

    private void expand(int n) {
        while (n > this.data.length) {
            int[] nArray = new int[this.data.length * 2];
            int n2 = 0;
            while (n2 < this.data.length) {
                nArray[n2] = this.data[n2];
                ++n2;
            }
            this.data = nArray;
        }
    }

    public int get(int n) {
        return this.data[n];
    }

    public int last() {
        return this.data[this.size - 1];
    }

    public void set(int n, int n2) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(n + " >= " + this.size);
        }
        this.data[n] = n2;
    }

    public boolean contains(int n) {
        int n2 = 0;
        while (n2 < this.size) {
            if (this.data[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isSubset(IntArray intArray) {
        int n = 0;
        while (n < intArray.size) {
            if (!this.contains(intArray.data[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void union(IntArray intArray) {
        int n = 0;
        while (n < intArray.size) {
            if (!this.contains(intArray.data[n])) {
                this.add(intArray.data[n]);
            }
            ++n;
        }
    }

    public int[] toArray() {
        int[] nArray = new int[this.size];
        System.arraycopy(this.data, 0, nArray, 0, this.size);
        return nArray;
    }
}

