/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.ByteBuffer;
import com.caucho.util.CauchoSystem;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class DynamicClassLoader
extends ClassLoader {
    private static WriteStream dbg = LogStream.open("/caucho.com/util/loader");
    private ClassLoader parent;
    private DynamicClassLoader next;
    private Hashtable cache;
    protected String classPath;
    private boolean isJdk12;

    public void setParent(ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = CauchoSystem.getContextClassLoader();
        }
        this.parent = classLoader;
    }

    public void setNext(DynamicClassLoader dynamicClassLoader) {
        this.next = dynamicClassLoader;
        this.classPath = null;
    }

    public ClassLoader getParentLoader() {
        if (this.next != null) {
            return this.next.getParentLoader();
        }
        return this.parent;
    }

    public String getClassPath() {
        return this.fillClassPath();
    }

    public synchronized boolean isModified() {
        if (this.next != null && this.next.isModified()) {
            return true;
        }
        if (this.cache == null) {
            return false;
        }
        Enumeration enumeration = this.cache.elements();
        while (enumeration.hasMoreElements()) {
            Entry entry = (Entry)enumeration.nextElement();
            if (!entry.isModified()) continue;
            return true;
        }
        return false;
    }

    public synchronized void makeAll() throws Exception {
        if (this.next != null) {
            this.next.makeAll();
        }
        if (this.parent instanceof DynamicClassLoader) {
            ((DynamicClassLoader)this.parent).makeAll();
        }
    }

    public synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = this.findClass(string);
        if (clazz == null) {
            throw new ClassNotFoundException(string);
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected synchronized Class findClass(String string) throws ClassNotFoundException {
        Entry entry;
        Class<?> clazz = null;
        if (this.cache == null) {
            this.cache = new Hashtable();
        }
        if ((entry = (Entry)this.cache.get(string)) != null) {
            return entry.getEntryClass();
        }
        entry = this.getClassEntry(string);
        if (entry != null) {
            ByteBuffer byteBuffer = new ByteBuffer();
            try {
                entry.load(byteBuffer);
            }
            catch (IOException iOException) {
                if (dbg.canWrite()) {
                    dbg.log(iOException);
                }
                throw new ClassNotFoundException(string + " [" + iOException + "]");
            }
            try {
                clazz = this.defineClass(string, byteBuffer.getBuffer(), 0, byteBuffer.length());
            }
            catch (Throwable throwable) {
                if (dbg.canWrite()) {
                    dbg.log(throwable);
                }
                throw new ClassNotFoundException(string + " [" + throwable + "]");
            }
            entry.setEntryClass(clazz);
            this.cache.put(string, entry);
            return clazz;
        }
        if (clazz == null && this.parent != null) {
            clazz = this.parent.loadClass(string);
        }
        if (clazz == null && this.isJdk12 && this.getParent() != null) {
            clazz = this.getParent().loadClass(string);
        }
        if (clazz == null) {
            return this.findSystemClass(string);
        }
        return clazz;
    }

    protected Entry getClassEntry(String string) throws ClassNotFoundException {
        String string2 = string.replace('.', '/') + ".class";
        Path path = this.getPath(string2);
        if (path != null && path.getLength() > 0L) {
            return new Entry(path, path);
        }
        if (this.next != null) {
            return this.next.getClassEntry(string);
        }
        return null;
    }

    public URL getResource(String string) {
        Path path = this.getPath("./" + string);
        if (path != null && path.canRead()) {
            try {
                return new URL("file:" + path.getNativePath());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.next != null) {
            return this.next.getResource(string);
        }
        if (this.parent != null) {
            return this.parent.getResource(string);
        }
        return ClassLoader.getSystemResource(string);
    }

    public InputStream getResourceAsStream(String string) {
        Path path = this.getPath("./" + string);
        if (path != null && path.canRead()) {
            try {
                return path.openRead();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        if (this.next != null) {
            return this.next.getResourceAsStream(string);
        }
        if (this.parent != null) {
            return this.parent.getResourceAsStream(string);
        }
        return ClassLoader.getSystemResourceAsStream(string);
    }

    public String findLibrary(String string) {
        try {
            String string2 = System.mapLibraryName(string);
            Path path = this.getPath(string2);
            if (path != null && path.canRead()) {
                return path.getNativePath();
            }
        }
        catch (Error error) {
            // empty catch block
        }
        if (this.next != null) {
            return this.next.findLibrary(string);
        }
        return super.findLibrary(string);
    }

    protected Path getPath(String string) {
        return null;
    }

    protected String fillClassPath() {
        if (this.next != null) {
            return this.next.getClassPath();
        }
        if (this.parent instanceof DynamicClassLoader) {
            return ((DynamicClassLoader)this.parent).getClassPath();
        }
        return System.getProperty("java.class.path");
    }

    protected DynamicClassLoader() {
    }

    protected DynamicClassLoader(ClassLoader classLoader) {
        super(classLoader);
        this.parent = classLoader;
        this.isJdk12 = true;
    }

    public static class Entry {
        private Path sourcePath;
        private Path classPath;
        private long lastModified;
        private Class cl;

        public boolean isModified() {
            return this.sourcePath.getLastModified() > this.lastModified || this.classPath.getLastModified() > this.lastModified;
        }

        public void load(ByteBuffer byteBuffer) throws IOException {
            byteBuffer.clear();
            long l = this.classPath.getLength();
            if (l < 0L) {
                throw new IOException("missing:");
            }
            ReadStream readStream = this.classPath.openRead();
            try {
                byteBuffer.setLength((int)l);
                if ((long)readStream.readAll(byteBuffer.getBuffer(), 0, (int)l) != l) {
                    throw new IOException("length mismatch");
                }
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                readStream.close();
                throw throwable;
            }
            readStream.close();
        }

        public void setEntryClass(Class clazz) {
            this.cl = clazz;
        }

        public Class getEntryClass() {
            return this.cl;
        }

        public Entry(Path path, Path path2) {
            this.sourcePath = path;
            this.classPath = path2;
            this.lastModified = path2.getLastModified();
        }
    }
}

