/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.Alarm;
import com.caucho.util.CauchoNative;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;

public class CpuUsage {
    private static WriteStream dbg = LogStream.open("/caucho.com/util/jni");
    private static CauchoNative jni;
    private static boolean triedLoading;
    private int pid;
    private long time;
    private long interval;
    private long userTime;
    private long systemTime;

    public static synchronized CpuUsage create() {
        block4: {
            if (jni == null && !triedLoading) {
                triedLoading = true;
                try {
                    jni = CauchoNative.create();
                }
                catch (Throwable throwable) {
                    if (!dbg.canWrite()) break block4;
                    dbg.log(throwable);
                }
            }
        }
        CpuUsage cpuUsage = new CpuUsage();
        if (jni == null) {
            return cpuUsage;
        }
        cpuUsage.update(Alarm.getCurrentTime());
        return cpuUsage;
    }

    public void update(long l) {
        this.time = l;
        if (jni == null) {
            return;
        }
        CauchoNative cauchoNative = jni;
        synchronized (cauchoNative) {
            jni.calculateUsage();
            this.pid = jni.getPid();
            this.userTime = (long)(jni.getUserTime() * 1000.0);
            this.systemTime = (long)(jni.getSystemTime() * 1000.0);
        }
    }

    public void copy(CpuUsage cpuUsage) {
        this.pid = cpuUsage.pid;
        this.time = cpuUsage.time;
        this.userTime = cpuUsage.userTime;
        this.systemTime = cpuUsage.systemTime;
    }

    public void clear() {
        this.pid = -1;
        this.time = 0L;
        this.interval = 0L;
        this.userTime = 0L;
        this.systemTime = 0L;
    }

    public void add(CpuUsage cpuUsage, CpuUsage cpuUsage2) {
        if (this.pid == -1) {
            this.pid = cpuUsage2.getPid();
            this.time = cpuUsage2.getTime();
            this.interval = this.time - cpuUsage.getTime();
        } else if (this.pid == cpuUsage2.getPid()) {
            return;
        }
        this.userTime += cpuUsage2.getUserTime() - cpuUsage.getUserTime();
        this.systemTime += cpuUsage2.getSystemTime() - cpuUsage.getSystemTime();
    }

    public int getPid() {
        return this.pid;
    }

    public long getTime() {
        return this.time;
    }

    public long getInterval() {
        return this.interval;
    }

    public long getUserTime() {
        return this.userTime;
    }

    public long getSystemTime() {
        return this.systemTime;
    }

    boolean setUser(String string, String string2) {
        if (jni == null) {
            throw new RuntimeException("can't set user because couldn't load libcaucho");
        }
        CauchoNative cauchoNative = jni;
        synchronized (cauchoNative) {
            boolean bl = jni.setUser(string, string2);
            Object var4_5 = null;
            return bl;
        }
    }

    private CpuUsage() {
    }
}

