/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

public final class CharSegment {
    private char[] buffer;
    private int offset;
    private int length;

    public int length() {
        return this.length;
    }

    public int getLength() {
        return this.length;
    }

    public char charAt(int n) {
        if (n < 0 || n >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[n + this.offset];
    }

    public char getLastChar() {
        if (this.length == 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[this.offset + this.length - 1];
    }

    public char[] getBuffer() {
        return this.buffer;
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        n += this.offset;
        n2 += this.offset;
        while (n < n2) {
            cArray[n3++] = this.buffer[n];
        }
    }

    public String substring(int n) {
        if (n > this.length || n < 0) {
            throw new StringIndexOutOfBoundsException();
        }
        return new String(this.buffer, this.offset + n, this.length - n);
    }

    public String substring(int n, int n2) {
        if (n > this.length || n < 0 || n > n2) {
            throw new StringIndexOutOfBoundsException();
        }
        return new String(this.buffer, this.offset + n, n2 - n);
    }

    public int indexOf(char c, int n) {
        if (n < 0) {
            n = 0;
        }
        while (n < this.length) {
            if (this.buffer[n + this.offset] == c) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int indexOf(char c) {
        return this.indexOf(c, 0);
    }

    public int lastIndexOf(char c, int n) {
        if (n >= this.length) {
            n = this.length - 1;
        }
        while (n >= 0) {
            if (this.buffer[n + this.offset] == c) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public int lastIndexOf(char c) {
        return this.lastIndexOf(c, this.length - 1);
    }

    public int hashCode() {
        int n = 1021;
        int n2 = 0;
        while (n2 < this.length) {
            n = 65521 * n + this.buffer[n2 + this.offset] * 251;
            ++n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CharSegment) {
            CharSegment charSegment = (CharSegment)object;
            if (this.length != charSegment.length) {
                return false;
            }
            int n = 0;
            while (n < this.length) {
                if (this.buffer[n + this.offset] != charSegment.buffer[n + charSegment.offset]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public boolean equalsIgnoreCase(String string) {
        return this.toString().equalsIgnoreCase(string);
    }

    public boolean equalsIgnoreCase(CharSegment charSegment) {
        if (this.length != charSegment.length) {
            return false;
        }
        int n = 0;
        while (n < this.length) {
            char c = this.buffer[this.offset + n];
            char c2 = charSegment.buffer[charSegment.offset + n];
            if (c != c2 && Character.toLowerCase(c) != Character.toLowerCase(c2)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void toLowerCase() {
        char[] cArray = this.buffer;
        int n = this.length;
        int n2 = 0;
        while (n2 < n) {
            cArray[n2 + this.offset] = Character.toLowerCase(cArray[n2 + this.offset]);
            ++n2;
        }
    }

    public boolean regionMatches(int n, CharSegment charSegment, int n2, int n3) {
        if (n + n3 > this.length || n2 + n3 > charSegment.length) {
            return false;
        }
        int n4 = 0;
        while (n4 < n3) {
            if (this.buffer[this.offset + n + n4] != charSegment.buffer[charSegment.offset + n2 + n4]) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public boolean regionMatches(int n, String string, int n2, int n3) {
        if (n + n3 > this.length || n2 + n3 > string.length()) {
            return false;
        }
        int n4 = 0;
        while (n4 < n3) {
            if (this.buffer[this.offset + n + n4] != string.charAt(n2 + n4)) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public boolean startsWith(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (this.length < n) {
            return false;
        }
        return this.regionMatches(0, string, 0, n);
    }

    public boolean endsWith(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (this.length < n) {
            return false;
        }
        return this.regionMatches(this.length - n, string, 0, n);
    }

    public String toString() {
        return new String(this.buffer, this.offset, this.length);
    }

    public CharSegment(char[] cArray, int n, int n2) {
        this.buffer = cArray;
        this.offset = n;
        this.length = n2;
    }
}

