/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.FreeList;
import java.io.InputStream;

public final class CharBuffer {
    private static FreeList freeList = new FreeList(128);
    private char[] buffer;
    private int capacity;
    private int length;

    public static CharBuffer allocate() {
        CharBuffer charBuffer = (CharBuffer)freeList.allocate();
        if (charBuffer != null) {
            charBuffer.length = 0;
            return charBuffer;
        }
        return new CharBuffer();
    }

    public void free() {
        if (this.capacity <= 256) {
            freeList.free(this);
        }
    }

    public int length() {
        return this.length;
    }

    public int getLength() {
        return this.length;
    }

    public int capacity() {
        return this.capacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    /*
     * Unable to fully structure code
     */
    public void ensureCapacity(int var1_1) {
        block2: {
            if (var1_1 <= this.capacity) {
                return;
            }
            var2_2 = this.capacity;
            if (var1_1 <= 4096) ** GOTO lbl8
            this.capacity = 4096 * ((var1_1 + 4095) / 4096);
            break block2;
lbl-1000:
            // 1 sources

            {
                this.capacity *= 2;
lbl8:
                // 2 sources

                ** while (this.capacity < var1_1)
            }
        }
        var3_3 = new char[this.capacity];
        System.arraycopy(this.buffer, 0, var3_3, 0, var2_2);
        this.buffer = var3_3;
    }

    public final void clear() {
        this.length = 0;
    }

    public final void setLength(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("illegal argument");
        }
        if (n > this.capacity) {
            this.ensureCapacity(n);
        }
        this.length = n;
    }

    public char charAt(int n) {
        if (n < 0 || n >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[n];
    }

    public char getLastChar() {
        if (this.length == 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[this.length - 1];
    }

    public final char[] getBuffer() {
        return this.buffer;
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        while (n < n2) {
            cArray[n3++] = this.buffer[n];
        }
    }

    public void setCharAt(int n, char c) {
        if (n < 0 || n >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        this.buffer[n] = c;
    }

    public CharBuffer append(Object object) {
        return this.append(String.valueOf(object));
    }

    public CharBuffer append(CharBuffer charBuffer) {
        return this.append(charBuffer.buffer, 0, charBuffer.length);
    }

    public CharBuffer append(String string) {
        int n;
        if (string == null) {
            string = "null";
        }
        if ((n = string.length()) + this.length >= this.capacity) {
            this.ensureCapacity(n + this.length);
        }
        string.getChars(0, n, this.buffer, this.length);
        this.length += n;
        return this;
    }

    public CharBuffer append(String string, int n, int n2) {
        if (n2 + this.length >= this.capacity) {
            this.ensureCapacity(n2 + this.length);
        }
        string.getChars(n, n + n2, this.buffer, this.length);
        this.length += n2;
        return this;
    }

    public CharBuffer append(char[] cArray) {
        return this.append(cArray, 0, cArray.length);
    }

    public CharBuffer append(char[] cArray, int n, int n2) {
        if (this.length + n2 > this.capacity) {
            this.ensureCapacity(this.length + n2);
        }
        System.arraycopy(cArray, n, this.buffer, this.length, n2);
        this.length += n2;
        return this;
    }

    public final CharBuffer append(boolean bl) {
        return this.append(String.valueOf(bl));
    }

    public final CharBuffer append(char c) {
        if (this.length >= this.capacity) {
            this.ensureCapacity(this.length + 1);
        }
        this.buffer[this.length++] = c;
        return this;
    }

    public CharBuffer append(int n) {
        if (this.length + 16 >= this.capacity) {
            this.ensureCapacity(this.length + 16);
        }
        if (n < 0) {
            this.buffer[this.length++] = 45;
            n = -n;
        } else if (n == 0) {
            this.buffer[this.length++] = 48;
            return this;
        }
        int n2 = this.length;
        while (n > 0) {
            this.buffer[this.length++] = (char)(n % 10 + 48);
            n /= 10;
        }
        int n3 = (this.length - n2) / 2;
        while (n3 > 0) {
            char c = this.buffer[this.length - n3];
            this.buffer[this.length - n3] = this.buffer[n2 + n3 - 1];
            this.buffer[n2 + n3 - 1] = c;
            --n3;
        }
        return this;
    }

    public CharBuffer append(long l) {
        if (this.length + 32 >= this.capacity) {
            this.ensureCapacity(this.length + 32);
        }
        if (l < 0L) {
            this.buffer[this.length++] = 45;
            l = -l;
        } else if (l == 0L) {
            this.buffer[this.length++] = 48;
            return this;
        }
        int n = this.length;
        while (l > 0L) {
            this.buffer[this.length++] = (char)(l % 10L + 48L);
            l /= 10L;
        }
        int n2 = (this.length - n) / 2;
        while (n2 > 0) {
            char c = this.buffer[this.length - n2];
            this.buffer[this.length - n2] = this.buffer[n + n2 - 1];
            this.buffer[n + n2 - 1] = c;
            --n2;
        }
        return this;
    }

    public CharBuffer append(float f) {
        return this.append(String.valueOf(f));
    }

    public CharBuffer append(double d) {
        return this.append(String.valueOf(d));
    }

    public final CharBuffer append(byte[] byArray, int n, int n2) {
        if (this.length + n2 >= this.capacity) {
            this.ensureCapacity(this.length + n2);
        }
        while (n2 > 0) {
            this.buffer[this.length++] = (char)byArray[n++];
            --n2;
        }
        return this;
    }

    public CharBuffer delete(int n, int n2) {
        if (n < 0 || n > n2 || n > this.length) {
            throw new StringIndexOutOfBoundsException();
        }
        if (n2 > this.length) {
            n2 = this.length;
        }
        int n3 = this.length - n2;
        int n4 = 0;
        while (n4 < n3) {
            this.buffer[n + n4] = this.buffer[n2 + n4];
            ++n4;
        }
        this.length -= n2 - n;
        return this;
    }

    public CharBuffer deleteCharAt(int n) {
        if (n < 0 || n > this.length) {
            throw new StringIndexOutOfBoundsException();
        }
        if (n == this.length) {
            return this;
        }
        int n2 = this.length - n + 1;
        int n3 = 0;
        while (n3 < n2) {
            this.buffer[n + n3] = this.buffer[n + n3 + 1];
            ++n3;
        }
        --this.length;
        return this;
    }

    public CharBuffer replace(int n, int n2, String string) {
        if (n < 0 || n > n2 || n > this.length) {
            throw new StringIndexOutOfBoundsException();
        }
        int n3 = string.length();
        if (n3 + this.length - (n2 - n) > this.capacity) {
            this.ensureCapacity(n3 + this.length - (n2 - n));
        }
        if (n3 < n2 - n) {
            int n4 = this.length - n2;
            int n5 = 0;
            while (n5 < n4) {
                this.buffer[n + n3 + n5] = this.buffer[n2 + n5];
                ++n5;
            }
        } else {
            int n6 = this.length - n2;
            int n7 = n6 - 1;
            while (n7 >= 0) {
                this.buffer[n2 + n7] = this.buffer[n + n3 + n7];
                --n7;
            }
        }
        string.getChars(0, n3, this.buffer, n);
        return this;
    }

    public CharBuffer replace(int n, int n2, char[] cArray, int n3, int n4) {
        if (n < 0 || n > n2 || n > this.length) {
            throw new StringIndexOutOfBoundsException();
        }
        if (n4 + this.length - (n2 - n) > this.capacity) {
            this.ensureCapacity(n4 + this.length - (n2 - n));
        }
        if (n4 < n2 - n) {
            int n5 = this.length - n2;
            int n6 = 0;
            while (n6 < n5) {
                this.buffer[n + n4 + n6] = this.buffer[n2 + n6];
                ++n6;
            }
        } else {
            int n7 = this.length - n2;
            int n8 = n7 - 1;
            while (n8 >= 0) {
                this.buffer[n2 + n8] = this.buffer[n + n4 + n8];
                --n8;
            }
        }
        System.arraycopy(cArray, n3, this.buffer, n, n4);
        return this;
    }

    public String substring(int n) {
        if (n > this.length || n < 0) {
            throw new StringIndexOutOfBoundsException();
        }
        return new String(this.buffer, n, this.length - n);
    }

    public String substring(int n, int n2) {
        if (n > this.length || n < 0 || n > n2) {
            throw new StringIndexOutOfBoundsException();
        }
        return new String(this.buffer, n, n2 - n);
    }

    public CharBuffer insert(int n, String string) {
        if (string == null) {
            string = "null";
        }
        if (n < 0 || n > this.length) {
            throw new StringIndexOutOfBoundsException();
        }
        int n2 = string.length();
        if (this.length + n2 > this.capacity) {
            this.ensureCapacity(n2 + this.length);
        }
        int n3 = this.length - n;
        int n4 = n3 - 1;
        while (n4 >= 0) {
            this.buffer[n + n2 + n4] = this.buffer[n + n4];
            --n4;
        }
        string.getChars(0, n2, this.buffer, n);
        this.length += n2;
        return this;
    }

    public CharBuffer insert(int n, char[] cArray, int n2, int n3) {
        if (n < 0 || n > this.length) {
            throw new StringIndexOutOfBoundsException();
        }
        if (n3 + this.length > this.capacity) {
            this.ensureCapacity(n3 + this.length);
        }
        int n4 = this.length - n;
        int n5 = n4 - 1;
        while (n5 >= 0) {
            this.buffer[n + n3 + n5] = this.buffer[n + n5];
            --n5;
        }
        System.arraycopy(cArray, n2, this.buffer, n, n3);
        this.length += n3;
        return this;
    }

    public CharBuffer insert(int n, Object object) {
        return this.insert(n, String.valueOf(object));
    }

    public CharBuffer insert(int n, char c) {
        return this.insert(n, String.valueOf(c));
    }

    public CharBuffer insert(int n, int n2) {
        return this.insert(n, String.valueOf(n2));
    }

    public CharBuffer insert(int n, long l) {
        return this.insert(n, String.valueOf(l));
    }

    public CharBuffer insert(int n, float f) {
        return this.insert(n, String.valueOf(f));
    }

    public CharBuffer insert(int n, double d) {
        return this.insert(n, String.valueOf(d));
    }

    public int indexOf(char c, int n) {
        if (n < 0) {
            n = 0;
        }
        while (n < this.length) {
            if (this.buffer[n] == c) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int indexOf(char c) {
        return this.indexOf(c, 0);
    }

    public int lastIndexOf(char c, int n) {
        if (n >= this.length) {
            n = this.length - 1;
        }
        while (n >= 0) {
            if (this.buffer[n] == c) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public int lastIndexOf(char c) {
        return this.lastIndexOf(c, this.length - 1);
    }

    public Object clone() {
        CharBuffer charBuffer = new CharBuffer();
        charBuffer.setLength(this.length);
        System.arraycopy(this.buffer, 0, charBuffer.buffer, 0, this.length);
        return charBuffer;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.length) {
            n = 65521 * n + this.buffer[n2] * 251 + 1021;
            ++n2;
        }
        return n;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CharBuffer) {
            CharBuffer charBuffer = (CharBuffer)object;
            if (this.length != charBuffer.length) {
                return false;
            }
            int n = 0;
            while (n < this.length) {
                if (this.buffer[n] != charBuffer.buffer[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public final boolean equals(CharBuffer charBuffer) {
        if (this.length != charBuffer.length) {
            return false;
        }
        int n = 0;
        while (n < this.length) {
            if (this.buffer[n] != charBuffer.buffer[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public final boolean equalsIgnoreCase(String string) {
        int n = string.length();
        if (this.length != n) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            char c = this.buffer[n2];
            char c2 = string.charAt(n2);
            if (c != c2 && Character.toLowerCase(c) != Character.toLowerCase(c2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public final boolean equalsIgnoreCase(CharBuffer charBuffer) {
        if (this.length != charBuffer.length) {
            return false;
        }
        int n = 0;
        while (n < this.length) {
            char c = this.buffer[n];
            char c2 = charBuffer.buffer[n];
            if (c != c2 && Character.toLowerCase(c) != Character.toLowerCase(c2)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean matches(Object object) {
        if (object instanceof CharBuffer) {
            CharBuffer charBuffer = (CharBuffer)object;
            if (this.length != charBuffer.length) {
                return false;
            }
            int n = 0;
            while (n < this.length) {
                if (this.buffer[n] != charBuffer.buffer[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (this.length != string.length()) {
                return false;
            }
            int n = 0;
            while (n < this.length) {
                if (this.buffer[n] != string.charAt(n)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public boolean matches(String string) {
        if (this.length != string.length()) {
            return false;
        }
        int n = 0;
        while (n < this.length) {
            if (this.buffer[n] != string.charAt(n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean matchesIgnoreCase(String string) {
        if (this.length != string.length()) {
            return false;
        }
        int n = 0;
        while (n < this.length) {
            char c = this.buffer[n];
            char c2 = string.charAt(n);
            if (c != c2 && Character.toLowerCase(c) != Character.toLowerCase(c2)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean regionMatches(int n, CharBuffer charBuffer, int n2, int n3) {
        if (n + n3 > this.length || n2 + n3 > charBuffer.length) {
            return false;
        }
        int n4 = 0;
        while (n4 < n3) {
            if (this.buffer[n + n4] != charBuffer.buffer[n2 + n4]) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public boolean regionMatches(int n, String string, int n2, int n3) {
        return this.regionMatches(n, new CharBuffer(string), n2, n3);
    }

    public CharBuffer toLowerCase() {
        char[] cArray = this.buffer;
        int n = this.length;
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = Character.toLowerCase(cArray[n2]);
            ++n2;
        }
        return this;
    }

    public boolean regionMatchesIgnoreCase(int n, CharBuffer charBuffer, int n2, int n3) {
        if (n + n3 > this.length || n2 + n3 > charBuffer.length) {
            return false;
        }
        int n4 = 0;
        while (n4 < n3) {
            if (Character.toLowerCase(this.buffer[n + n4]) != Character.toLowerCase(charBuffer.buffer[n2 + n4])) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public boolean startsWith(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (this.length < n) {
            return false;
        }
        return this.regionMatches(0, string, 0, n);
    }

    public boolean endsWith(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (this.length < n) {
            return false;
        }
        return this.regionMatches(this.length - n, string, 0, n);
    }

    public String toString() {
        return new String(this.buffer, 0, this.length);
    }

    public String close() {
        String string = new String(this.buffer, 0, this.length);
        this.free();
        return string;
    }

    public InputStream getInputStream() {
        CharBuffer charBuffer = this;
        if (charBuffer == null) {
            throw null;
        }
        return charBuffer.new CBInputStream();
    }

    public CharBuffer() {
        this.capacity = 16;
        this.buffer = new char[this.capacity];
        this.length = 0;
    }

    public CharBuffer(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n < 16) {
            n = 16;
        }
        this.capacity = n;
        this.buffer = new char[n];
        this.length = 0;
    }

    public CharBuffer(String string) {
        this.capacity = string.length();
        if (this.capacity < 16) {
            this.capacity = 16;
        }
        this.buffer = new char[this.capacity];
        this.length = string.length();
        string.getChars(0, this.length, this.buffer, 0);
    }

    public CharBuffer(String string, int n, int n2) {
        this.capacity = n2;
        if (this.capacity < 16) {
            this.capacity = 16;
        }
        this.buffer = new char[this.capacity];
        string.getChars(n, n2, this.buffer, 0);
    }

    class CBInputStream
    extends InputStream {
        int index = 0;

        public int read() {
            if (this.index >= CharBuffer.this.length) {
                return -1;
            }
            return CharBuffer.this.buffer[this.index++];
        }

        CBInputStream() {
        }
    }
}

