/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.Version;
import com.caucho.util.CpuUsage;
import com.caucho.util.Registry;
import com.caucho.vfs.Path;
import com.caucho.vfs.Pwd;
import com.caucho.vfs.Vfs;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;

public class CauchoSystem {
    static char separatorChar = File.separatorChar;
    static char pathSeparatorChar = File.pathSeparatorChar;
    static String localHost;
    static String userDir;
    static String userName;
    static Path resinHome;
    private static boolean oldJdk;
    private static int jdkVersion;
    static boolean isTesting;
    private static int isUnix;
    private static int version;
    private static String newline;
    static CpuUsage cpuUsage;
    private static ClassLoader staticClassLoader;

    public static boolean isTesting() {
        return isTesting;
    }

    public static void setIsTesting(boolean bl) {
        isTesting = bl;
    }

    public static void setResinHome(Path path) {
        resinHome = path;
    }

    public static Path getResinHome() {
        if (resinHome != null) {
            return resinHome;
        }
        String string = Registry.getString("/caucho.com/resin.home", null);
        if (string != null) {
            resinHome = Pwd.lookupNative(string);
            return resinHome;
        }
        string = System.getProperty("resin.home");
        if (string != null) {
            resinHome = Pwd.lookupNative(string);
            return resinHome;
        }
        String string2 = System.getProperty("java.class.path");
        int n = 0;
        char c = CauchoSystem.getFileSeparatorChar();
        int n2 = c == '/' ? 58 : 59;
        while (string == null) {
            int n3 = string2.indexOf(n2, n);
            String string3 = n3 < 0 ? string2.substring(n) : string2.substring(n, n3);
            if (string3.endsWith(c + "lib" + c + "resin.jar") || string3.equals("lib" + c + "resin.jar")) {
                string = string3.substring(0, string3.length() - ("lib" + c + "resin.jar").length());
            } else if (string3.endsWith(c + "classes") || string3.equals("classes")) {
                Path path = Pwd.lookupNative(string3);
                if ((path = path.lookup("com/caucho/es/Resin.class")).exists()) {
                    string = string3.substring(0, string3.length() - "classes".length());
                }
            }
            if (n3 < 0) break;
            n = n3 + 1;
        }
        if (string != null) {
            resinHome = Pwd.lookupNative(string);
        }
        if (resinHome != null && resinHome.isDirectory()) {
            return resinHome;
        }
        return Pwd.lookup();
    }

    public static int getVersionId() {
        if (version != 0) {
            return version;
        }
        String string = Version.VERSION;
        version = 1391;
        int n = 0;
        while (n < string.length()) {
            version = 65521 * version + string.charAt(n);
            ++n;
        }
        return version;
    }

    public static String getResinConfig() {
        return CauchoSystem.getResinHome() + "/conf/resin.conf";
    }

    public static Path getWorkPath() {
        String string = Registry.getString("/caucho.com/work-path", null);
        if (string == null) {
            string = Registry.getString("/caucho.com/java/work-path", null);
        }
        if (string == null) {
            string = Registry.getString("/caucho.com/java/work-dir", null);
        }
        if (string == null && CauchoSystem.isWindows()) {
            string = "/temp/caucho";
        } else if (string == null) {
            string = "/tmp/caucho";
        }
        Path path = string.charAt(0) == '/' ? Vfs.lookupNative(string) : CauchoSystem.getResinHome().lookupNative(string);
        try {
            path.mkdirs();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return path;
    }

    public static String getUserDir() {
        if (userDir == null) {
            userDir = Registry.getString("/caucho.com/user.dir", System.getProperty("user.dir"));
        }
        return userDir;
    }

    public static char getFileSeparatorChar() {
        return separatorChar;
    }

    public static char getPathSeparatorChar() {
        return pathSeparatorChar;
    }

    public static String getNewlineString() {
        if (newline == null && (newline = System.getProperty("line.separator")) == null) {
            newline = "\n";
        }
        return newline;
    }

    public static boolean isWindows() {
        return separatorChar == '\\';
    }

    public static boolean isUnix() {
        if (isUnix >= 0) {
            return isUnix == 1;
        }
        isUnix = 0;
        if (separatorChar == '/' && Vfs.lookup("/bin/sh").canRead()) {
            isUnix = 1;
        }
        return isUnix == 1;
    }

    public static void setWindowsTest(boolean bl) {
        isTesting = true;
        separatorChar = bl ? (char)92 : File.separatorChar;
    }

    public static String getLocalHost() {
        if (localHost != null) {
            return localHost;
        }
        localHost = Registry.getString("/caucho.com/local.host", null);
        if (localHost != null) {
            return localHost;
        }
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            localHost = inetAddress.getHostName();
        }
        catch (Exception exception) {
            localHost = "127.0.0.1";
        }
        return localHost;
    }

    public static String getUserName() {
        if (userName != null) {
            return userName;
        }
        userName = Registry.getString("/caucho.com/user.name", null);
        if (userName == null) {
            userName = System.getProperty("user.name");
        }
        return userName;
    }

    public static CpuUsage getCpuUsage() {
        return CpuUsage.create();
    }

    public static boolean isJdk12() {
        if (jdkVersion == 0) {
            try {
                Thread.currentThread().getContextClassLoader();
                jdkVersion = 66048;
            }
            catch (NoSuchMethodError noSuchMethodError) {
                jdkVersion = 65800;
            }
        }
        return jdkVersion >= 66048;
    }

    public static ClassLoader getContextClassLoader() {
        if (oldJdk) {
            return staticClassLoader;
        }
        try {
            return Thread.currentThread().getContextClassLoader();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            oldJdk = true;
            return staticClassLoader;
        }
    }

    public static void setContextClassLoader(ClassLoader classLoader) {
        if (oldJdk) {
            return;
        }
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            oldJdk = true;
        }
    }

    public static void setStaticClassLoader(ClassLoader classLoader) {
        staticClassLoader = classLoader;
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            oldJdk = true;
        }
    }

    public static ClassLoader getStaticClassLoader() {
        return staticClassLoader;
    }

    public static boolean setUser(String string, String string2) {
        return CpuUsage.create().setUser(string, string2);
    }

    private CauchoSystem() {
    }

    static {
        isUnix = -1;
        version = 0;
    }
}

