/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.vfs.ReadStream;
import com.caucho.vfs.VfsStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class ByteBuffer {
    byte[] buffer;
    int capacity;
    int length;

    public int capacity() {
        return this.capacity;
    }

    public int hashCode() {
        int n = 17;
        int n2 = this.length - 1;
        while (n2 >= 0) {
            n = 65537 * n + this.buffer[n2];
            --n2;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public void ensureCapacity(int var1_1) {
        block2: {
            if (var1_1 <= this.capacity) {
                return;
            }
            if (var1_1 <= 4096) ** GOTO lbl7
            this.capacity = var1_1 + 4095 & -4096;
            break block2;
lbl-1000:
            // 1 sources

            {
                this.capacity += this.capacity;
lbl7:
                // 2 sources

                ** while (this.capacity < var1_1)
            }
        }
        var2_2 = new byte[this.capacity];
        System.arraycopy(this.buffer, 0, var2_2, 0, this.length);
        this.buffer = var2_2;
    }

    public int length() {
        return this.length;
    }

    public int size() {
        return this.length;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int n) {
        if (n < 0) {
            throw new RuntimeException("illegal argument");
        }
        if (n > this.capacity) {
            this.ensureCapacity(n);
        }
        this.length = n;
    }

    public void clear() {
        this.length = 0;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public void append(int n) {
        if (this.length + 1 > this.capacity) {
            this.ensureCapacity(this.length + 1);
        }
        this.buffer[this.length++] = (byte)n;
    }

    public void add(int n, byte[] byArray, int n2, int n3) {
        if (this.length + n3 > this.capacity) {
            this.ensureCapacity(this.length + n3);
        }
        System.arraycopy(this.buffer, n, this.buffer, n + n3, this.length - n);
        System.arraycopy(byArray, n2, this.buffer, n, n3);
        this.length += n3;
    }

    public void add(byte[] byArray, int n, int n2) {
        if (this.length + n2 > this.capacity) {
            this.ensureCapacity(this.length + n2);
        }
        System.arraycopy(byArray, n, this.buffer, this.length, n2);
        this.length += n2;
    }

    public void add(int n, int n2) {
        if (this.length + 1 > this.capacity) {
            this.ensureCapacity(this.length + 1);
        }
        System.arraycopy(this.buffer, n, this.buffer, n + 1, this.length - n);
        this.buffer[n] = (byte)n2;
        ++this.length;
    }

    public void add(int n) {
        if (this.length + 1 > this.capacity) {
            this.ensureCapacity(this.length + 1);
        }
        this.buffer[this.length++] = (byte)n;
    }

    public void set(int n, byte[] byArray, int n2, int n3) {
        System.arraycopy(byArray, n2, this.buffer, n, n3);
    }

    public void set(int n, int n2) {
        this.buffer[n] = (byte)n2;
    }

    public void insert(int n, byte[] byArray, int n2, int n3) {
        if (this.length + n3 > this.capacity) {
            this.ensureCapacity(this.length + n3);
        }
        System.arraycopy(this.buffer, n, this.buffer, n + n3, this.length - n);
        System.arraycopy(byArray, n2, this.buffer, n, n3);
        this.length += n3;
    }

    public void replace(int n, byte[] byArray, int n2, int n3) {
        System.arraycopy(byArray, n2, this.buffer, n, n3);
    }

    public void append(byte[] byArray, int n, int n2) {
        if (this.length + n2 >= this.capacity) {
            this.ensureCapacity(this.length + n2);
        }
        System.arraycopy(byArray, n, this.buffer, this.length, n2);
        this.length += n2;
    }

    public void replaceShort(int n, int n2) {
        this.buffer[n] = (byte)(n2 >> 8);
        this.buffer[n + 1] = (byte)n2;
    }

    public void appendShort(int n) {
        if (this.length + 2 > this.capacity) {
            this.ensureCapacity(this.length + 2);
        }
        this.replaceShort(this.length, n);
        this.length += 2;
    }

    public void addShort(int n) {
        if (this.length + 2 > this.capacity) {
            this.ensureCapacity(this.length + 2);
        }
        this.buffer[this.length++] = (byte)(n >> 8);
        this.buffer[this.length++] = (byte)n;
    }

    public void addShort(int n, int n2) {
        this.add(n, (byte)(n2 >> 8));
        this.add(n + 1, (byte)n2);
    }

    public void setShort(int n, int n2) {
        this.buffer[n] = (byte)(n2 >> 8);
        this.buffer[n + 1] = (byte)n2;
    }

    public void replaceInt(int n, int n2) {
        this.buffer[n] = (byte)(n2 >> 24);
        this.buffer[n + 1] = (byte)(n2 >> 16);
        this.buffer[n + 2] = (byte)(n2 >> 8);
        this.buffer[n + 3] = (byte)n2;
    }

    public void appendInt(int n) {
        if (this.length + 4 > this.capacity) {
            this.ensureCapacity(this.length + 4);
        }
        this.replaceInt(this.length, n);
        this.length += 4;
    }

    public void addInt(int n) {
        if (this.length + 4 > this.capacity) {
            this.ensureCapacity(this.length + 4);
        }
        this.buffer[this.length++] = (byte)(n >> 24);
        this.buffer[this.length++] = (byte)(n >> 16);
        this.buffer[this.length++] = (byte)(n >> 8);
        this.buffer[this.length++] = (byte)n;
    }

    public void addInt(int n, int n2) {
        this.add(n, (byte)(n2 >> 24));
        this.add(n + 1, (byte)(n2 >> 16));
        this.add(n + 2, (byte)(n2 >> 8));
        this.add(n + 3, (byte)n2);
    }

    public void setInt(int n, int n2) {
        this.buffer[n] = (byte)(n2 >> 24);
        this.buffer[n + 1] = (byte)(n2 >> 16);
        this.buffer[n + 2] = (byte)(n2 >> 8);
        this.buffer[n + 3] = (byte)n2;
    }

    public void addDouble(double d) {
        if (this.length + 8 > this.capacity) {
            this.ensureCapacity(this.length + 8);
        }
        long l = Double.doubleToLongBits(d);
        this.buffer[this.length++] = (byte)(l >> 56);
        this.buffer[this.length++] = (byte)(l >> 48);
        this.buffer[this.length++] = (byte)(l >> 40);
        this.buffer[this.length++] = (byte)(l >> 32);
        this.buffer[this.length++] = (byte)(l >> 24);
        this.buffer[this.length++] = (byte)(l >> 16);
        this.buffer[this.length++] = (byte)(l >> 8);
        this.buffer[this.length++] = (byte)l;
    }

    public void addString(String string) {
        int n = string.length();
        if (n + this.length > this.capacity) {
            this.ensureCapacity(this.length + n);
        }
        int n2 = 0;
        while (n2 < n) {
            this.buffer[this.length++] = (byte)string.charAt(n2);
            ++n2;
        }
    }

    public void add(char[] cArray, int n, int n2) {
        if (n2 + this.length > this.capacity) {
            this.ensureCapacity(this.length + n2);
        }
        int n3 = 0;
        while (n3 < n2) {
            this.buffer[this.length++] = (byte)cArray[n + n3];
            ++n3;
        }
    }

    public void remove(int n, int n2) {
        System.arraycopy(this.buffer, n + n2, this.buffer, n, this.capacity - n2 - n);
        this.length -= n2;
    }

    public void append(String string) {
        int n = 0;
        while (n < string.length()) {
            this.append(string.charAt(n));
            ++n;
        }
    }

    public byte byteAt(int n) {
        if (n < 0 || n > this.length) {
            throw new RuntimeException();
        }
        return this.buffer[n];
    }

    public void setByteAt(int n, int n2) {
        this.buffer[n] = (byte)n2;
    }

    public byte get(int n) {
        if (n < 0 || n >= this.length) {
            throw new RuntimeException("out of bounds: " + n + " len: " + this.length);
        }
        return this.buffer[n];
    }

    public short getShort(int n) {
        if (n < 0 || n + 1 >= this.length) {
            throw new RuntimeException("out of bounds: " + n + " len: " + this.length);
        }
        return (short)(((this.buffer[n] & 0xFF) << 8) + (this.buffer[n + 1] & 0xFF));
    }

    public int getInt(int n) {
        if (n < 0 || n + 3 >= this.length) {
            throw new RuntimeException("out of bounds: " + n + " len: " + this.length);
        }
        return ((this.buffer[n] & 0xFF) << 24) + ((this.buffer[n + 1] & 0xFF) << 16) + ((this.buffer[n + 2] & 0xFF) << 8) + (this.buffer[n + 3] & 0xFF);
    }

    public Object clone() {
        ByteBuffer byteBuffer = new ByteBuffer(this.length);
        System.arraycopy(this.buffer, 0, byteBuffer.buffer, 0, this.length);
        return byteBuffer;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ByteBuffer)) {
            return false;
        }
        ByteBuffer byteBuffer = (ByteBuffer)object;
        if (byteBuffer.length != this.length) {
            return false;
        }
        int n = this.length - 1;
        while (n >= 0) {
            if (byteBuffer.buffer[n] != this.buffer[n]) {
                return false;
            }
            --n;
        }
        return true;
    }

    public InputStream createInputStream() {
        return new BBInputStream(this);
    }

    public OutputStream createOutputStream() {
        return new BBOutputStream(this);
    }

    public ReadStream createReadStream() {
        return VfsStream.openRead(new BBInputStream(this));
    }

    public String toString() {
        return new String(this.buffer, 0, this.length);
    }

    public String toString(String string) {
        try {
            return new String(this.buffer, 0, this.length, string);
        }
        catch (Exception exception) {
            return new String(this.buffer, 0, this.length);
        }
    }

    /*
     * Unable to fully structure code
     */
    public ByteBuffer(int var1_1) {
        block1: {
            super();
            this.capacity = 32;
            if (var1_1 <= 4096) ** GOTO lbl7
            this.capacity = var1_1 + 4095 & -4096;
            break block1;
lbl-1000:
            // 1 sources

            {
                this.capacity += this.capacity;
lbl7:
                // 2 sources

                ** while (this.capacity < var1_1)
            }
        }
        this.buffer = new byte[var1_1];
        this.length = 0;
    }

    public ByteBuffer() {
        this.buffer = new byte[32];
        this.capacity = this.buffer.length;
        this.length = 0;
    }

    static class BBInputStream
    extends InputStream {
        ByteBuffer buf;
        int index;

        public int available() {
            return this.buf.length - this.index;
        }

        public int read() throws IOException {
            if (this.index >= this.buf.length) {
                return -1;
            }
            return this.buf.buffer[this.index++] & 0xFF;
        }

        BBInputStream(ByteBuffer byteBuffer) {
            this.buf = byteBuffer;
        }
    }

    static class BBOutputStream
    extends OutputStream {
        ByteBuffer buf;

        public void write(int n) throws IOException {
            this.buf.append(n);
        }

        BBOutputStream(ByteBuffer byteBuffer) {
            this.buf = byteBuffer;
        }
    }
}

