/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.AlarmListener;
import com.caucho.util.Cron;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.util.AbstractCollection;
import java.util.ArrayList;

public class Alarm {
    private static WriteStream dbg = LogStream.open("/caucho.com/util/alarm");
    private static Integer timeLock = new Integer(0);
    private static long currentTime;
    private static int currentCount;
    private static AlarmThread alarmThread;
    private static ArrayList waiting;
    private static long testTime;
    private static long requests;
    private long wakeTime;
    private AlarmListener listener;
    private String name;

    public static long getCurrentTime() {
        long l;
        int n;
        do {
            n = currentCount;
            l = currentTime;
        } while (n != currentCount);
        return l;
    }

    public long getWakeTime() {
        return this.wakeTime;
    }

    public AlarmListener getListener() {
        return this.listener;
    }

    public void setListener(AlarmListener alarmListener) {
        this.listener = alarmListener;
    }

    public void queue(long l) {
        AlarmThread alarmThread = Alarm.alarmThread;
        synchronized (alarmThread) {
            ((AbstractCollection)waiting).remove(this);
            this.wakeTime = l + currentTime;
            int n = 0;
            n = 0;
            while (n < waiting.size()) {
                Alarm alarm = (Alarm)waiting.get(n);
                if (alarm.wakeTime > this.wakeTime) {
                    waiting.add(n, this);
                    Object var4_5 = null;
                    return;
                }
                ++n;
            }
            waiting.add(this);
        }
    }

    public void dequeue() {
        AlarmThread alarmThread = Alarm.alarmThread;
        synchronized (alarmThread) {
            ((AbstractCollection)waiting).remove(this);
        }
    }

    static void setTestTime(long l) {
        requests = 0L;
        testTime = l;
        currentTime = l;
        Thread.currentThread();
        Thread.yield();
        alarmThread.interrupt();
        Cron.setTestTime(l);
        Thread.currentThread();
        Thread.yield();
    }

    public String toString() {
        return "[Alarm " + this.name + "]";
    }

    static /* synthetic */ long access$5() {
        return requests;
    }

    public Alarm(AlarmListener alarmListener) {
        this.listener = alarmListener;
        this.name = "alarm";
    }

    public Alarm(String string, AlarmListener alarmListener, long l) {
        this(alarmListener);
        this.name = string;
        this.queue(l);
    }

    public Alarm(AlarmListener alarmListener, long l) {
        this(alarmListener);
        this.queue(l);
    }

    static {
        waiting = new ArrayList();
        currentTime = System.currentTimeMillis();
        alarmThread = new AlarmThread();
        alarmThread.start();
    }

    private static class AlarmThread
    extends Thread {
        public void run() {
            ArrayList<Alarm> arrayList = new ArrayList<Alarm>();
            while (true) {
                arrayList.clear();
                AlarmThread alarmThread = this;
                synchronized (alarmThread) {
                    currentCount = currentCount + 1;
                    if (testTime > 0L) {
                        currentTime = testTime;
                    } else {
                        currentTime = System.currentTimeMillis();
                    }
                    currentCount = currentCount + 1;
                    requests = 0L;
                    while (waiting.size() > 0) {
                        Alarm alarm = (Alarm)waiting.get(0);
                        if (alarm.wakeTime > currentTime) break;
                        waiting.remove(0);
                        arrayList.add(alarm);
                    }
                }
                int n = 0;
                while (n < arrayList.size()) {
                    block13: {
                        Alarm alarm = (Alarm)arrayList.get(n);
                        if (alarm.listener != null) {
                            try {
                                alarm.listener.handleAlarm(alarm);
                            }
                            catch (Throwable throwable) {
                                if (!dbg.canWrite()) break block13;
                                dbg.log(throwable);
                            }
                        }
                    }
                    ++n;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
        }

        AlarmThread() {
            super("resin-alarm");
            this.setDaemon(true);
        }
    }
}

