/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.sql.DBPool;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;

class QPooledConnection
implements Connection {
    private DBPool pool;
    private Connection conn;
    private boolean autoCommit = true;
    private boolean readOnly = false;
    private String catalog = null;
    private int isolation = -1;
    private Map typeMap;
    long poolWaitTime;
    private boolean isBad;
    private ArrayList statements = new ArrayList();

    long getPoolWaitTime() {
        return this.poolWaitTime;
    }

    void setPoolWaitTime(long l) {
        this.poolWaitTime = l;
    }

    Connection getConnection() {
        return this.conn;
    }

    public Statement createStatement() throws SQLException {
        try {
            Statement statement = this.conn.createStatement();
            if (this.statements.size() < 20) {
                this.statements.add(statement);
            }
            return statement;
        }
        catch (SQLException sQLException) {
            this.isBad = true;
            throw sQLException;
        }
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        try {
            Statement statement = this.conn.createStatement(n, n2);
            if (this.statements.size() < 20) {
                this.statements.add(statement);
            }
            return statement;
        }
        catch (SQLException sQLException) {
            this.isBad = true;
            throw sQLException;
        }
    }

    public String getCatalog() throws SQLException {
        return this.conn.getCatalog();
    }

    public void setCatalog(String string) throws SQLException {
        if (this.catalog == null) {
            this.catalog = this.conn.getCatalog();
        }
        this.conn.setCatalog(string);
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.conn.getMetaData();
    }

    public Map getTypeMap() throws SQLException {
        return this.conn.getTypeMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        if (this.typeMap == null) {
            this.typeMap = this.conn.getTypeMap();
        }
        this.conn.setTypeMap(map);
    }

    public String nativeSQL(String string) throws SQLException {
        return this.conn.nativeSQL(string);
    }

    public int getTransactionIsolation() throws SQLException {
        return this.conn.getTransactionIsolation();
    }

    public void setTransactionIsolation(int n) throws SQLException {
        if (n == -1) {
            n = this.conn.getTransactionIsolation();
        }
        this.conn.setTransactionIsolation(n);
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.conn.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.conn.clearWarnings();
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.readOnly = bl;
        this.conn.setReadOnly(bl);
    }

    public boolean isReadOnly() throws SQLException {
        return this.conn.isReadOnly();
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        try {
            CallableStatement callableStatement = this.conn.prepareCall(string, n, n2);
            this.statements.add(callableStatement);
            return callableStatement;
        }
        catch (SQLException sQLException) {
            this.isBad = true;
            throw sQLException;
        }
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        try {
            CallableStatement callableStatement = this.conn.prepareCall(string);
            if (this.statements.size() < 20) {
                this.statements.add(callableStatement);
            }
            return callableStatement;
        }
        catch (SQLException sQLException) {
            this.isBad = true;
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        try {
            PreparedStatement preparedStatement = this.conn.prepareStatement(string);
            this.statements.add(preparedStatement);
            return preparedStatement;
        }
        catch (SQLException sQLException) {
            this.isBad = true;
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        try {
            PreparedStatement preparedStatement = this.conn.prepareStatement(string, n, n2);
            this.statements.add(preparedStatement);
            return preparedStatement;
        }
        catch (SQLException sQLException) {
            this.isBad = true;
            throw sQLException;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        return this.conn.getAutoCommit();
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.autoCommit = bl;
        this.conn.setAutoCommit(bl);
    }

    public void commit() throws SQLException {
        this.conn.commit();
    }

    public void rollback() throws SQLException {
        this.conn.rollback();
    }

    public boolean isClosed() throws SQLException {
        return this.conn == null || this.conn.isClosed();
    }

    public void close() {
        if (this.conn != null) {
            Connection connection = this.conn;
            this.conn = null;
            if (this.isBad) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.pool.killConnection();
            } else {
                this.resetConnection(connection);
                this.pool.freeConnection(connection);
            }
        }
    }

    void kill() {
        if (this.conn != null) {
            Connection connection = this.conn;
            this.conn = null;
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void resetConnection(Connection connection) {
        if (connection == null) {
            return;
        }
        int n = 0;
        while (n < this.statements.size()) {
            try {
                Statement statement = (Statement)this.statements.get(n);
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ++n;
        }
        this.statements.clear();
        try {
            if (!this.autoCommit) {
                connection.rollback();
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.autoCommit = true;
        try {
            if (this.readOnly) {
                connection.setReadOnly(false);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.readOnly = false;
        try {
            if (this.catalog != null) {
                connection.setCatalog(this.catalog);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.catalog = null;
        try {
            if (this.isolation >= 0) {
                connection.setTransactionIsolation(this.isolation);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.isolation = -1;
        try {
            if (this.typeMap != null) {
                connection.setTypeMap(this.typeMap);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.typeMap = null;
        try {
            connection.clearWarnings();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void finalize() {
        this.close();
    }

    QPooledConnection(DBPool dBPool, Connection connection) {
        this.pool = dBPool;
        this.conn = connection;
    }
}

