/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.AbstractRequest;
import com.caucho.server.http.AccessLog;
import com.caucho.server.http.Application;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.Invocation;
import com.caucho.server.http.PageCache;
import com.caucho.server.http.Request;
import com.caucho.server.http.Response;
import com.caucho.server.http.ServletServer;
import com.caucho.server.http.UrlMap;
import com.caucho.util.Alarm;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.ExceptionWrapper;
import com.caucho.util.LruCache;
import com.caucho.util.QDate;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletException;

class VirtualHost {
    static WriteStream dbg = LogStream.open("/caucho.com/http/host");
    private ServletServer server;
    private String name;
    private String host;
    private RegistryNode registry;
    private Path hostRoot;
    private PageCache cache;
    private UrlMap appMap;
    private HashMap apps;
    private Application defaultApplication;
    private QDate calendar = new QDate();
    private WriteStream errorLog;
    private ArrayList accessLogs;
    private LruCache invocationCache;
    private long bogusDate;

    static VirtualHost create(ServletServer servletServer, String string, RegistryNode registryNode, Path path, Path path2, int n) throws Exception {
        String string2 = registryNode.getString("error-log", null);
        if (string2 == null && registryNode.getParent() != null) {
            string2 = registryNode.getParent().getString("error-log", null);
        }
        Path path3 = null;
        if (string2 != null) {
            path3 = servletServer.getHome().lookupNative(string2);
            path3.getParent().mkdirs();
        }
        try {
            return new VirtualHost(servletServer, string, registryNode, path, path2, n, path3);
        }
        catch (Exception exception) {
            if (path3 != null) {
                WriteStream writeStream = path3.openAppend();
                writeStream.log(exception);
                writeStream.close();
            }
            throw exception;
        }
    }

    void init() throws IOException {
        Iterator<Object> iterator = this.apps.values().iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            Application application = (Application)iterator.next();
            application.init();
        }
    }

    private void initApp(RegistryNode registryNode, String string) throws Exception {
        String string2 = registryNode.getString("app-dir", null);
        String string3 = registryNode.getString("url-regexp", null);
        if (string3 == null) {
            string3 = registryNode.getString("regexp", null);
        }
        if (string3 != null) {
            this.appMap.addRegexp(string3, null, null, string2, registryNode);
        } else if (string != null) {
            String string4 = Invocation.normalizeUri(string, true);
            if (string4.equals("/")) {
                string4 = "";
            }
            if (string2 == null) {
                string2 = "./" + string4;
            }
            Path path = this.hostRoot.lookupNative(string2);
            String string5 = string4;
            if (string5.length() != 0) {
                string5 = string5.charAt(string5.length() - 1) == '/' ? string5 + "*" : string5 + "/*";
            }
            Application application = new Application(this, string4, registryNode, path, "web-app");
            this.appMap.addMap(string5, null, null, string2, registryNode);
            this.apps.put(string4, application);
        } else {
            throw new ServletException(registryNode.getFilename() + ":" + registryNode.getLine() + " illegal web-app");
        }
    }

    ServletServer getServer() {
        return this.server;
    }

    String getName() {
        return this.name;
    }

    String getHost() {
        return this.host;
    }

    RegistryNode getRegistry() {
        return this.registry;
    }

    Iterator getApplications() {
        return this.apps.values().iterator();
    }

    Application getDefaultApplication() {
        HashMap hashMap = this.apps;
        synchronized (hashMap) {
            if (this.defaultApplication == null) {
                this.defaultApplication = (Application)this.apps.get("");
            }
            Application application = this.defaultApplication;
            Object var2_3 = null;
            return application;
        }
    }

    void logAccess(Request request, Response response) throws IOException {
        int n = 0;
        while (n < this.accessLogs.size()) {
            AccessLog accessLog = (AccessLog)this.accessLogs.get(n);
            accessLog.log(request, response);
            ++n;
        }
    }

    public void log(String string, Throwable throwable) throws IOException {
        this.log(this.errorLog, string, throwable);
        if (dbg.canWrite()) {
            this.log(dbg, string, throwable);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void log(WriteStream var1_1, String var2_2, Throwable var3_3) throws IOException {
        if (var1_1 != null) ** GOTO lbl4
        return;
lbl-1000:
        // 1 sources

        {
            var3_3 = ((ServletException)var3_3).getRootCause();
lbl4:
            // 2 sources

            ** while (var3_3 instanceof ServletException && ((ServletException)var3_3).getRootCause() != null)
        }
lbl5:
        // 2 sources

        while (var3_3 instanceof ExceptionWrapper && ((ExceptionWrapper)var3_3).getRootCause() != null) {
            var3_3 = ((ExceptionWrapper)var3_3).getRootCause();
        }
        var4_4 = var1_1;
        synchronized (var4_4) {
            var6_5 = this.bogusDate > 0L ? this.bogusDate : Alarm.getCurrentTime();
            var1_1.print("[");
            this.timestamp(var1_1, var6_5);
            var1_1.print("] ");
            var1_1.println(var2_2);
            if (var3_3 != null) {
                var8_6 = var1_1.getPrintWriter();
                var3_3.printStackTrace(var8_6);
                var8_6.flush();
            }
            var1_1.flush();
        }
    }

    private void timestamp(WriteStream writeStream, long l) throws IOException {
        this.calendar.calculate(l, true);
        writeStream.print(this.calendar.get(0));
        writeStream.print('/');
        long l2 = this.calendar.get(1) + 1L;
        writeStream.print(l2 / 10L);
        writeStream.print(l2 % 10L);
        writeStream.print('/');
        l2 = this.calendar.get(2) + 1L;
        writeStream.print(l2 / 10L);
        writeStream.print(l2 % 10L);
        writeStream.print(' ');
        l2 = this.calendar.get(5);
        writeStream.print(l2 / 10L);
        writeStream.print(l2 % 10L);
        writeStream.print(':');
        l2 = this.calendar.get(6);
        writeStream.print(l2 / 10L);
        writeStream.print(l2 % 10L);
        writeStream.print(':');
        l2 = this.calendar.get(7);
        writeStream.print(l2 / 10L);
        writeStream.print(l2 % 10L);
        l2 = this.calendar.get(8);
    }

    void service(AbstractRequest abstractRequest, Response response, boolean bl) throws IOException, ServletException {
        try {
            if (this.cache == null) {
                abstractRequest.service(this.getInvocation(abstractRequest.getPageUriBuffer(), bl), (CauchoResponse)response);
            } else {
                this.cache.service(abstractRequest, response, bl);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (ServletException servletException) {
            throw servletException;
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
    }

    synchronized Invocation getInvocation(CharBuffer charBuffer, boolean bl) throws Exception {
        Invocation invocation = (Invocation)this.invocationCache.get(charBuffer);
        if (invocation != null && !invocation.application.isModified()) {
            return invocation;
        }
        invocation = this.getInvocationInt(charBuffer.toString(), bl);
        this.invocationCache.put(charBuffer.clone(), invocation);
        return invocation;
    }

    Invocation updateInvocation(Invocation invocation) throws Exception {
        Application application = invocation.getApplication();
        if (application.isClosed()) {
            VirtualHost virtualHost = this;
            synchronized (virtualHost) {
                String string = invocation.getUri();
                invocation = this.getInvocationInt(string, false);
                this.invocationCache.put(new CharBuffer(string), invocation);
            }
            return invocation;
        }
        if (!application.isModified()) {
            return invocation;
        }
        application = this.restartApplication(application);
        VirtualHost virtualHost = this;
        synchronized (virtualHost) {
            String string = invocation.getUri();
            invocation = this.getInvocationInt(string, false);
            this.invocationCache.put(new CharBuffer(string), invocation);
        }
        return invocation;
    }

    private Invocation getInvocationInt(String string, boolean bl) throws Exception {
        Object object;
        Invocation invocation = new Invocation(this, string, bl);
        String string2 = invocation.getUri();
        Application application = null;
        UrlMap urlMap = this.appMap;
        synchronized (urlMap) {
            CharBuffer charBuffer = new CharBuffer();
            object = new CharBuffer();
            RegistryNode registryNode = (RegistryNode)this.appMap.map(string2, charBuffer, null, (CharBuffer)object);
            if (registryNode == null) {
                throw new RuntimeException("internal app error `" + string2 + "'");
            }
            invocation.contextPath = charBuffer.toString();
            application = (Application)this.apps.get(invocation.contextPath);
            if (application == null) {
                application = new Application(this, invocation.contextPath, registryNode, VirtualHost.getAppDir(this.hostRoot, ((CharBuffer)object).toString()), "web-app");
                this.apps.put(invocation.contextPath, application);
                application.init();
            } else if (application.isModified()) {
                application = this.restartApplication(application);
                this.apps.put(invocation.contextPath, application);
            }
        }
        int n = invocation.contextPath.length();
        invocation.application = application;
        object = null;
        int n2 = -1;
        if (application.enableSessionUrls()) {
            n2 = string2.indexOf(";jsessionid=");
        }
        if (n2 >= 0) {
            invocation.rawUri = invocation.rawUri.substring(0, n2);
            object = string2.substring(n2 + ";jsessionid=".length());
            int n3 = ((String)object).indexOf(59);
            invocation.sessionId = n3 >= 0 ? ((String)object).substring(0, n3) : object;
        }
        Object var12_13 = null;
        if (n >= 0 && n2 >= 0) {
            invocation.pathInfo = string2.substring(n, n2);
            invocation.uri = string2.substring(0, n2);
        } else if (n >= 0) {
            invocation.pathInfo = string2.substring(n);
        } else if (n2 >= 0) {
            invocation.uri = string2.substring(0, n2);
            invocation.pathInfo = string2;
        } else {
            invocation.pathInfo = string2;
        }
        invocation.security = application.getSecurity(invocation.pathInfo);
        application.getServlet(invocation);
        return invocation;
    }

    static Path getAppDir(Path path, String string) {
        Path path2;
        block7: {
            if (!string.endsWith(".war") && !string.endsWith(".jar")) {
                return path.lookupNative(string);
            }
            Path path3 = path.lookupNative(string);
            Path path4 = CauchoSystem.getWorkPath();
            path2 = path4.lookup("_war");
            path2 = path2.lookup(path3.getTail());
            if (dbg.canWrite()) {
                dbg.log("expanding war " + string + " to " + path2);
            }
            try {
                ZipEntry zipEntry;
                VirtualHost.removeAll(path2);
                path2.mkdirs();
                ReadStream readStream = path3.openRead();
                ZipInputStream zipInputStream = new ZipInputStream(readStream);
                byte[] byArray = new byte[1024];
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    int n;
                    String string2 = zipEntry.getName();
                    Path path5 = path2.lookup(string2);
                    if (zipEntry.isDirectory()) {
                        path5.mkdirs();
                        continue;
                    }
                    long l = zipEntry.getSize();
                    path5.getParent().mkdirs();
                    WriteStream writeStream = path5.openWrite();
                    while ((n = zipInputStream.read(byArray, 0, byArray.length)) > 0) {
                        writeStream.write(byArray, 0, n);
                    }
                    writeStream.close();
                }
                zipInputStream.close();
                readStream.close();
            }
            catch (IOException iOException) {
                if (!dbg.canWrite()) break block7;
                dbg.log(iOException);
            }
        }
        return path2;
    }

    private static void removeAll(Path path) {
        try {
            if (path.isDirectory()) {
                String[] stringArray = path.list();
                int n = 0;
                while (stringArray != null && n < stringArray.length) {
                    VirtualHost.removeAll(path.lookup(stringArray[n]));
                    ++n;
                }
                path.remove();
            } else if (path.isFile()) {
                path.remove();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Application restartApplication(Application application) {
        String string = application.getContextPath();
        String string2 = application.getCreateMode();
        RegistryNode registryNode = application.getRegistry();
        Path path = application.getAppDir();
        if (this.cache != null) {
            this.cache.clear();
        }
        HashMap hashMap = this.apps;
        synchronized (hashMap) {
            block7: {
                if (this.defaultApplication == application) {
                    this.defaultApplication = null;
                }
                this.apps.remove(string);
                application.close();
                try {
                    application = new Application(this, string, registryNode, path, string2);
                    this.apps.put(string, application);
                    application.init();
                }
                catch (Exception exception) {
                    if (!dbg.canWrite()) break block7;
                    dbg.log(exception);
                }
            }
        }
        return application;
    }

    void timeout(long l) {
        Object object;
        HashMap hashMap = this.apps;
        synchronized (hashMap) {
            Iterator iterator = this.apps.values().iterator();
            while (iterator.hasNext()) {
                object = (Application)iterator.next();
                ((Application)object).timeout(l);
            }
        }
        int n = 0;
        while (n < this.accessLogs.size()) {
            object = (AccessLog)this.accessLogs.get(n);
            try {
                ((AccessLog)object).flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n;
        }
    }

    void cron(long l) {
        Application application;
        ArrayList<Application> arrayList = new ArrayList<Application>();
        HashMap hashMap = this.apps;
        synchronized (hashMap) {
            Iterator iterator = this.apps.values().iterator();
            while (iterator.hasNext()) {
                application = (Application)iterator.next();
                arrayList.add(application);
            }
        }
        int n = 0;
        while (n < arrayList.size()) {
            application = (Application)arrayList.get(n);
            application.cron(l);
            ++n;
        }
    }

    void close() {
        Object object;
        int n = 0;
        while (n < this.accessLogs.size()) {
            object = (AccessLog)this.accessLogs.get(n);
            try {
                ((AccessLog)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n;
        }
        Iterator iterator = this.apps.values().iterator();
        while (iterator.hasNext()) {
            object = (Application)iterator.next();
            ((Application)object).close();
        }
    }

    public String toString() {
        return "[VirtualHost " + this.host + "]";
    }

    void setDate(long l) {
        this.bogusDate = l;
    }

    private VirtualHost(ServletServer servletServer, String string, RegistryNode registryNode, Path path, Path path2, int n, Path path3) throws Exception {
        Object object;
        Object object2;
        if (dbg.canWrite()) {
            dbg.println("virtual-host: " + string + " " + path);
        }
        if (path3 != null) {
            this.errorLog = path3.openAppend();
        }
        this.server = servletServer;
        this.hostRoot = path;
        if (path2 != null) {
            path2.mkdirs();
            this.cache = new PageCache(this, path2, n);
        }
        this.registry = registryNode;
        this.bogusDate = registryNode.getInt("bogus-date", 0);
        boolean bl = false;
        if (string == null) {
            bl = true;
            string = "";
        } else if (string.equals("*")) {
            string = "";
        }
        this.name = string;
        int n2 = string.indexOf(58);
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        this.host = string;
        this.invocationCache = new LruCache(1024);
        this.appMap = new UrlMap();
        this.apps = new HashMap();
        this.accessLogs = new ArrayList();
        boolean bl2 = false;
        Iterator iterator = registryNode.iterator();
        while (iterator.hasNext()) {
            object2 = (RegistryNode)iterator.next();
            if (((RegistryNode)object2).getName().equals("web-app")) {
                object = ((RegistryNode)object2).getValue();
                if ("".equals(((RegistryNode)object2).getValue()) || "/".equals(((RegistryNode)object2).getValue()) || "/*".equals(((RegistryNode)object2).getValue())) {
                    bl2 = true;
                    object = "";
                }
                this.initApp((RegistryNode)object2, (String)object);
                continue;
            }
            if (!((RegistryNode)object2).getName().equals("access-log")) continue;
            object = ((RegistryNode)object2).getValue();
            String string2 = ((RegistryNode)object2).getString("format", null);
            this.accessLogs.add(new AccessLog(servletServer.getHome().lookupNative((String)object), string2));
        }
        if (!bl2) {
            object2 = bl ? "http-server" : "host";
            object = new Application(this, "", registryNode, path, (String)object2);
            this.appMap.addMap("", null, null, ".", registryNode);
            this.apps.put("", object);
        }
    }
}

