/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.CauchoRequest;
import java.util.ArrayList;

class SecurityConstraint {
    ArrayList methods;
    String transport;
    ArrayList roles;

    void addMethod(String string) {
        if (this.methods == null) {
            this.methods = new ArrayList();
        }
        this.methods.add(string);
    }

    void setTransportGuarantee(String string) {
        this.transport = string;
    }

    void addRole(String string) {
        if (this.roles == null) {
            this.roles = new ArrayList();
        }
        this.roles.add(string);
    }

    boolean isAuthorized(CauchoRequest cauchoRequest) {
        if (this.methods != null) {
            String string = cauchoRequest.getMethod();
            int n = this.methods.size() - 1;
            while (n >= 0) {
                String string2 = (String)this.methods.get(n);
                if (string2.equals(string)) break;
                --n;
            }
            if (n < 0) {
                return true;
            }
        }
        if (this.transport != null && (this.transport.equalsIgnoreCase("integral") || this.transport.equalsIgnoreCase("confidential")) && !cauchoRequest.isSecure()) {
            return false;
        }
        if (this.roles == null || this.roles.size() == 0) {
            return true;
        }
        int n = 0;
        while (n < this.roles.size()) {
            String string = (String)this.roles.get(n);
            if (cauchoRequest.isUserInRole(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean needsAuthentication(CauchoRequest cauchoRequest) {
        if (this.roles == null || this.roles.size() == 0) {
            return false;
        }
        if (this.methods == null) {
            return true;
        }
        int n = 0;
        while (n < this.methods.size()) {
            String string = (String)this.methods.get(n);
            if (cauchoRequest.getMethod().equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    SecurityConstraint(ArrayList arrayList, String string) {
        this.roles = arrayList;
        this.transport = string;
    }
}

