/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.Version;
import com.caucho.server.RequestFactory;
import com.caucho.server.Server;
import com.caucho.server.ServerRequest;
import com.caucho.server.TcpServer;
import com.caucho.server.http.RunnerRequest;
import com.caucho.server.http.ServletServer;
import com.caucho.util.CauchoSystem;
import com.caucho.util.Registry;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Iterator;

public class RunnerServer
implements RequestFactory {
    static WriteStream dbg;
    static final String COPYRIGHT = "Copyright (c) 1998-2000 Caucho Technology.  All rights reserved.";

    public ServerRequest createRequest(Server server) {
        return new RunnerRequest((ServletServer)server);
    }

    public static void main(String[] stringArray) throws Exception {
        Closeable closeable;
        String string = CauchoSystem.getResinConfig();
        boolean bl = false;
        String string2 = null;
        InputStream inputStream = null;
        int n = 0;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (n3 + 1 < n2 && stringArray[n3].equals("-conf")) {
                string = stringArray[n3 + 1];
                n3 += 2;
                continue;
            }
            if (n3 + 1 < n2 && stringArray[n3].equals("-srun")) {
                string2 = stringArray[n3 + 1];
                n3 += 2;
                continue;
            }
            if (n3 + 1 < n2 && (stringArray[n3].equals("-port") || stringArray[n3].equals("-srun-port"))) {
                n = Integer.parseInt(stringArray[n3 + 1]);
                n3 += 2;
                continue;
            }
            if (stringArray[n3].equals("-version")) {
                System.out.println(Version.VERSION);
                System.exit(0);
                continue;
            }
            if (stringArray[n3].equals("-deadwait")) {
                bl = true;
                ++n3;
                continue;
            }
            if (stringArray[n3].equals("-socketwait")) {
                int n4 = Integer.parseInt(stringArray[n3 + 1]);
                closeable = new Socket("127.0.0.1", n4);
                inputStream = ((Socket)closeable).getInputStream();
                n3 += 2;
                continue;
            }
            System.out.println("unknown argument `" + stringArray[n3] + "'");
            System.out.println();
            RunnerServer.usage();
            System.exit(66);
        }
        try {
            Object object;
            ServerSocket serverSocket;
            Path path = CauchoSystem.getResinHome().lookupNative(string);
            closeable = path.openRead();
            Registry.setDefault(Registry.parse((ReadStream)closeable));
            ((ReadStream)closeable).close();
            dbg = LogStream.open("/caucho.com/httpd");
            if (dbg.canWrite()) {
                dbg.log("srun startup: " + Version.VERSION);
            }
            RegistryNode registryNode = Registry.lookup("/caucho.com/http-server");
            String string3 = registryNode.getString("srun-host", null);
            if (n <= 0) {
                n = registryNode.getInt("srun-port", 6802);
            }
            Iterator iterator = registryNode.select("srun");
            int n5 = 1;
            while (iterator.hasNext()) {
                RegistryNode registryNode2 = (RegistryNode)iterator.next();
                String string4 = registryNode2.getValue();
                if (string4 == null || string4.equals("")) {
                    string4 = String.valueOf(n5);
                }
                if (string2 == null || string2.equals("") || string2.equals(string4)) {
                    string3 = registryNode2.getString("host", string3);
                    n = registryNode2.getInt("port", n);
                    break;
                }
                ++n5;
            }
            int n6 = registryNode.getInt("thread-min", 5);
            int n7 = registryNode.getInt("thread-max", 20);
            int n8 = registryNode.getInt("thread-keepalive", -1);
            long l = registryNode.getPeriod("request-timeout", -1L);
            long l2 = registryNode.getPeriod("timeout-interval", 15000L);
            int n9 = registryNode.getInt("listen", 10);
            System.err.println(Version.VERSION);
            if (string3 == null) {
                serverSocket = new ServerSocket(n, n9);
                System.err.println("listening to *:" + n);
            } else {
                object = InetAddress.getByName(string3);
                serverSocket = new ServerSocket(n, n9, (InetAddress)object);
                System.err.println("listening to " + string3 + ":" + n);
            }
            object = registryNode.getString("user-name", null);
            String string5 = registryNode.getString("group-name", null);
            if (object != null && !CauchoSystem.setUser((String)object, string5)) {
                throw new Exception("Can't set user `" + (String)object + "'");
            }
            ServletServer servletServer = new ServletServer(path, registryNode, CauchoSystem.getResinHome());
            RunnerServer runnerServer = new RunnerServer();
            TcpServer tcpServer = new TcpServer(runnerServer, serverSocket, n6, n7, n8, l, l2);
            tcpServer.init(servletServer);
            if (inputStream != null) {
                try {
                    while (inputStream.read() >= 0) {
                    }
                }
                catch (Exception exception) {
                    if (dbg.canWrite()) {
                        dbg.log(exception);
                    }
                }
            } else if (bl) {
                try {
                    while (System.in.read() >= 0) {
                    }
                }
                catch (Exception exception) {
                    if (dbg.canWrite()) {
                        exception.printStackTrace(dbg.getPrintWriter());
                        dbg.flush();
                    }
                }
            } else {
                while (true) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(10000L);
                        if (!tcpServer.isDead()) continue;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            }
            if (dbg.canWrite()) {
                dbg.log("closing server");
            }
            tcpServer.close();
            servletServer.close();
            if (dbg.canWrite()) {
                dbg.log("srun shutdown");
            }
            System.exit(0);
        }
        catch (BindException bindException) {
            System.err.println("Can't bind to server port.  Check for conflicting servers.");
            System.exit(67);
        }
        catch (Throwable throwable) {
            try {
                throwable.printStackTrace(System.err);
            }
            finally {
                Object var10_15 = null;
                System.exit(66);
            }
        }
    }

    private static void usage() {
        System.err.println("usage: RunnerServer [-conf resin.conf]");
    }
}

