/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.Version;
import com.caucho.java.LineMap;
import com.caucho.java.LineMapException;
import com.caucho.server.Connection;
import com.caucho.server.ServerRequest;
import com.caucho.server.http.AbstractRequest;
import com.caucho.server.http.Application;
import com.caucho.server.http.ChunkedInputStream;
import com.caucho.server.http.Form;
import com.caucho.server.http.Invocation;
import com.caucho.server.http.QRequestDispatcher;
import com.caucho.server.http.QServletConfig;
import com.caucho.server.http.QServletInputStream;
import com.caucho.server.http.QSession;
import com.caucho.server.http.Response;
import com.caucho.server.http.ServletServer;
import com.caucho.server.http.VirtualHost;
import com.caucho.util.Alarm;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.CompileException;
import com.caucho.util.ExceptionWrapper;
import com.caucho.util.FreeList;
import com.caucho.util.NullEnumeration;
import com.caucho.util.StringCharCursor;
import com.caucho.vfs.BufferedReaderAdapter;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;

abstract class Request
extends AbstractRequest
implements ServerRequest {
    private static final String CHAR_ENCODING = "resin.form.character.encoding";
    private static final String CAUCHO_CHAR_ENCODING = "caucho.form.character.encoding";
    private static final String FORM_LOCALE = "resin.form.locale";
    static WriteStream dbg = LogStream.open("/caucho.com/http/connection");
    static final int HTTP_0_9 = 9;
    static final int HTTP_1_0 = 256;
    static final int HTTP_1_1 = 257;
    static CharBuffer getCb = new CharBuffer("GET");
    static CharBuffer headCb = new CharBuffer("HEAD");
    static CharBuffer postCb = new CharBuffer("POST");
    static CharBuffer contentLengthCb = new CharBuffer("Content-Length");
    static FreeList freeCharBuffers = new FreeList(128);
    static FreeList freeArrayLists = new FreeList(128);
    protected ServletServer server;
    protected Connection conn;
    private long date;
    protected int version;
    private Cookie[] cookiesIn;
    private ArrayList cookies = new ArrayList();
    private CharBuffer cbName = new CharBuffer();
    private CharBuffer cbValue = new CharBuffer();
    private ArrayList arrayList = new ArrayList();
    protected int sessionGroup;
    private QSession session;
    protected ReadStream rawStream;
    protected ReadStream filterStream;
    private boolean hasInputStream;
    private ContentLengthStream contentLengthStream;
    private ChunkedInputStream chunkedInputStream;
    private QServletInputStream is;
    private BufferedReaderAdapter bufferedReader;
    private String method;
    private Hashtable form = new Hashtable();
    private Hashtable filledForm;
    private Hashtable attributes;
    private ArrayList locales;
    protected Response response;
    protected CharBuffer cb;
    private byte[] byteBuffer;
    protected boolean isSecure;
    private long bogusDate;
    protected boolean bogusSecure;

    protected void start(ReadStream readStream) throws IOException {
        super.start();
        this.rawStream = readStream;
        this.date = Alarm.getCurrentTime();
        this.bogusDate = this.server.bogusDate;
        this.cookiesIn = null;
        this.cookies.clear();
        this.invocation = null;
        this.hasInputStream = false;
        this.version = -1;
        this.isSecure = this.bogusSecure;
        this.sessionGroup = -1;
        this.session = null;
        this.method = null;
        if (this.attributes.size() > 0) {
            this.attributes.clear();
        }
        if (this.form.size() > 0) {
            this.form.clear();
        }
        this.filledForm = null;
        if (this.locales.size() > 0) {
            this.locales.clear();
        }
        this.response.start();
    }

    void setConnection(Connection connection) {
        this.conn = connection;
    }

    protected void dispatch(CharBuffer charBuffer, CharBuffer charBuffer2, boolean bl) {
        block4: {
            try {
                VirtualHost virtualHost = this.server.getHost(charBuffer);
                virtualHost.service(this, this.response, bl);
            }
            catch (Throwable throwable) {
                try {
                    this.sendServletError(throwable);
                }
                catch (Exception exception) {
                    if (!dbg.canWrite()) break block4;
                    dbg.log(exception);
                }
            }
        }
    }

    public String getFilter(String string) {
        QServletConfig qServletConfig = this.getServletConfig();
        if (qServletConfig == null) {
            return null;
        }
        return qServletConfig.getFilter(string);
    }

    public abstract void setHeader(String var1, String var2);

    private void sendServletError(Throwable throwable) throws IOException {
        String string;
        Object object;
        LineMap lineMap = null;
        this.response.killChaining();
        try {
            this.response.reset(true);
        }
        catch (IllegalStateException illegalStateException) {}
        while (true) {
            if (throwable instanceof LineMapException) {
                lineMap = ((LineMapException)((Object)throwable)).getLineMap();
            }
            object = null;
            if (throwable instanceof ServletException) {
                object = ((ServletException)throwable).getRootCause();
            } else if (throwable instanceof ExceptionWrapper) {
                object = ((ExceptionWrapper)((Object)throwable)).getRootCause();
            }
            if (object == null) break;
            throwable = object;
        }
        object = this.getApplication();
        String string2 = string = object != null ? ((Application)object).getErrorPage(throwable) : null;
        if (string != null) {
            this.setAttribute("javax.servlet.jsp.jspException", throwable);
            this.setAttribute("javax.servlet.error.exception_type", throwable);
            this.response.setStatus(500);
            try {
                QRequestDispatcher qRequestDispatcher = (QRequestDispatcher)((Application)object).getRequestDispatcher(string);
                qRequestDispatcher.forward(this, this.response, "GET");
                return;
            }
            catch (Throwable throwable2) {
                if (dbg.canWrite()) {
                    dbg.log(throwable);
                }
                throwable = throwable2;
            }
        }
        this.response.setStatus(500);
        this.response.setContentType("text/html");
        PrintWriter printWriter = this.response.getWriter();
        String string3 = "500 Servlet Exception";
        printWriter.println("<title>" + string3 + "</title>");
        printWriter.println("<h1>" + string3 + "</h1>");
        printWriter.println("<code><pre>");
        if (dbg.canWrite()) {
            dbg.log(throwable);
        }
        boolean bl = true;
        if (throwable instanceof CompileException) {
            bl = false;
            printWriter.println(this.escapeHtml(throwable.getMessage()));
        } else if (!bl) {
            printWriter.println(this.escapeHtml(throwable.toString()));
        }
        if (object != null) {
            if (bl) {
                ((Application)object).log(throwable.getMessage(), throwable);
            } else {
                ((Application)object).log(throwable.getMessage(), null);
            }
        }
        if (bl || dbg.canWrite()) {
            this.printStackTrace(printWriter, throwable, lineMap);
        }
        printWriter.println("</pre></code>");
        if (!CauchoSystem.isTesting()) {
            printWriter.println("<hr><small>");
            printWriter.println(Version.VERSION);
            printWriter.println("</small>");
        }
        printWriter.close();
    }

    private void printStackTrace(PrintWriter printWriter, Throwable throwable, LineMap lineMap) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        PrintWriter printWriter2 = new PrintWriter(charArrayWriter);
        if (lineMap != null) {
            lineMap.printStackTrace(throwable, printWriter2);
        } else {
            throwable.printStackTrace(printWriter2);
        }
        printWriter2.close();
        char[] cArray = charArrayWriter.toCharArray();
        printWriter.print(this.escapeHtml(new String(cArray)));
    }

    private String escapeHtml(String string) {
        if (string == null) {
            return null;
        }
        CharBuffer charBuffer = new CharBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '<') {
                charBuffer.append("&lt;");
            } else if (c == '&') {
                charBuffer.append("&amp;");
            } else {
                charBuffer.append(c);
            }
            ++n;
        }
        return charBuffer.toString();
    }

    private void handleError(Throwable throwable) {
        if (throwable instanceof InterruptedException || throwable instanceof InterruptedIOException) {
            this.response.closeConnection();
        }
    }

    protected void finish() throws IOException {
        if (this.session != null) {
            this.session.finish();
        }
        this.response.finish(false);
        if (this.response.allowKeepalive() && !this.conn.isInterrupted() && !this.getMethodBuffer().matches("GET")) {
            ServletInputStream servletInputStream = this.getInputStream();
            while (servletInputStream.skip(65536L) > 0L) {
            }
        }
    }

    public ServletInputStream getInputStream() throws IOException {
        String string;
        if (this.hasInputStream) {
            return this.is;
        }
        this.hasInputStream = true;
        int n = this.getContentLength();
        if (n < 0 && this.getVersion() >= 257 && (string = this.getHeader("Transfer-Encoding")) != null) {
            this.chunkedInputStream.init(this, this.rawStream);
            this.filterStream.init(this.chunkedInputStream, null);
            this.is.init(this.filterStream);
        } else {
            this.contentLengthStream.init(this, this.rawStream, n);
            this.filterStream.init(this.contentLengthStream, null);
            this.is.init(this.filterStream);
        }
        String string2 = this.getCharacterEncoding();
        String string3 = Encoding.getJavaName(string2);
        this.filterStream.setEncoding(string3);
        return this.is;
    }

    public ReadStream getStream() throws IOException {
        this.getInputStream();
        return this.filterStream;
    }

    public int getRequestDepth() {
        return 0;
    }

    public BufferedReader getReader() throws IOException {
        this.getInputStream();
        this.bufferedReader.init(this.filterStream);
        return this.bufferedReader;
    }

    public abstract String getServerName();

    public abstract int getServerPort();

    public abstract String getRemoteAddr();

    void getRemoteAddr(CharBuffer charBuffer) {
        charBuffer.append(this.getRemoteAddr());
    }

    public abstract String getRemoteHost();

    public abstract String getScheme();

    public abstract CharBuffer getMethodBuffer();

    public String getMethod() {
        if (this.method == null) {
            CharBuffer charBuffer = this.getMethodBuffer();
            if (charBuffer.length() == 0) {
                this.method = "GET";
                return this.method;
            }
            switch (charBuffer.charAt(0)) {
                case 'G': {
                    this.method = charBuffer.equals(getCb) ? "GET" : charBuffer.toString();
                    break;
                }
                case 'H': {
                    this.method = charBuffer.equals(headCb) ? "HEAD" : charBuffer.toString();
                    break;
                }
                case 'P': {
                    this.method = charBuffer.equals(postCb) ? "POST" : charBuffer.toString();
                    break;
                }
                default: {
                    this.method = charBuffer.toString();
                }
            }
        }
        return this.method;
    }

    void setMethod(String string) {
        this.method = string;
    }

    public String getProtocol() {
        return this.getProtocolBuffer().toString();
    }

    abstract CharBuffer getProtocolBuffer();

    int getVersion() {
        int n;
        if (this.version > 0) {
            return this.version;
        }
        CharBuffer charBuffer = this.getProtocolBuffer();
        if (charBuffer.length() < 8) {
            this.version = 9;
            return this.version;
        }
        if (charBuffer.equals("HTTP/1.0")) {
            this.version = 256;
            return this.version;
        }
        if (charBuffer.equals("HTTP/1.1")) {
            this.version = 257;
            return 257;
        }
        if (charBuffer.equals("HTTP/0.9")) {
            this.version = 9;
            return 9;
        }
        int n2 = charBuffer.indexOf('/');
        int n3 = charBuffer.length();
        int n4 = 0;
        ++n2;
        while (n2 < n3) {
            n = charBuffer.charAt(n2);
            if (n < 48 || n > 57) {
                if (n == 46) break;
                this.version = 256;
                return this.version;
            }
            n4 = 10 * n4 + n - 48;
            ++n2;
        }
        n = 0;
        ++n2;
        while (n2 < n3) {
            char c = charBuffer.charAt(n2);
            if (c < '0' || c > '9') break;
            n = 10 * n + c - 48;
            ++n2;
        }
        this.version = 256 * n4 + n;
        return this.version;
    }

    public String getRequestURI() {
        return this.invocation.getRawUri();
    }

    public String getPageURI() {
        return this.invocation.getRawUri();
    }

    public String getContextPath() {
        return this.invocation.getContextPath();
    }

    public String getPageContextPath() {
        return this.invocation.getContextPath();
    }

    public String getServletPath() {
        return this.invocation.getServletPath();
    }

    public String getPageServletPath() {
        return this.invocation.getServletPath();
    }

    public String getPathInfo() {
        return this.invocation.getPathInfo();
    }

    public String getPagePathInfo() {
        return this.invocation.getPathInfo();
    }

    public String getRealPath(String string) {
        int n;
        if (string == null) {
            return null;
        }
        if (string.length() > 0 && string.charAt(0) == '/') {
            return this.invocation.getApplication().getRealPath(string);
        }
        String string2 = this.getPageURI();
        String string3 = this.getPageContextPath();
        if (string3 != null) {
            string2 = string2.substring(string3.length());
        }
        if ((n = string2.lastIndexOf(47)) >= 0) {
            string = string2.substring(0, n + 1) + string;
        }
        return this.invocation.getApplication().getRealPath(string);
    }

    public String getPathTranslated() {
        String string = this.getPathInfo();
        if (string == null) {
            return null;
        }
        return this.getRealPath(string);
    }

    public String getPageQueryString() {
        return this.getQueryString();
    }

    public String getHeader(String string) {
        CharBuffer charBuffer = this.getHeaderBuffer(string);
        if (charBuffer != null) {
            return charBuffer.toString();
        }
        return null;
    }

    public abstract CharBuffer getHeaderBuffer(String var1);

    public abstract CharBuffer getHeaderBuffer(CharBuffer var1);

    public abstract void getHeaderBuffers(ArrayList var1, String var2);

    public abstract Enumeration getHeaderNames();

    public int getContentLength() {
        char c;
        CharBuffer charBuffer = this.getHeaderBuffer(contentLengthCb);
        if (charBuffer == null) {
            return -1;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < charBuffer.length() && (c = charBuffer.charAt(n2)) >= '0' && c <= '9') {
            n = 10 * n + c - 48;
            ++n2;
        }
        return n2 == 0 ? -1 : n;
    }

    public String getContentType() {
        return this.getHeader("content-type");
    }

    public String getCharacterEncoding() {
        String string = this.getHeader("content-type");
        if (string == null) {
            return null;
        }
        int n = string.indexOf("charset");
        if (n < 0) {
            return null;
        }
        int n2 = string.length();
        n += 7;
        while (n < n2 && Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        if (n >= n2 || string.charAt(n) != '=') {
            return null;
        }
        ++n;
        while (n < n2 && Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        int n3 = n;
        while (n3 < n2) {
            if (Character.isWhitespace(string.charAt(n3)) || string.charAt(n3) == ';') break;
            ++n3;
        }
        return Encoding.getMimeName(string.substring(n, n3));
    }

    public Cookie[] getCookies() {
        this.setVaryCookies();
        if (this.cookiesIn == null) {
            this.fillCookies();
        }
        if (this.cookiesIn != null && this.cookiesIn.length > 0) {
            this.setUsesCookies();
        }
        return this.cookiesIn;
    }

    public Cookie getCookie(String string) {
        Cookie[] cookieArray = this.getCookies();
        int n = 0;
        while (cookieArray != null && n < cookieArray.length) {
            if (cookieArray[n].getName().equals(string)) {
                return cookieArray[n];
            }
            ++n;
        }
        return null;
    }

    private void fillCookies() {
        this.arrayList.clear();
        this.getHeaderBuffers(this.arrayList, "cookie");
        int n = 0;
        while (n < this.arrayList.size()) {
            CharBuffer charBuffer = (CharBuffer)this.arrayList.get(n);
            this.fillCookie(this.cookies, charBuffer);
            ++n;
        }
        this.cookiesIn = new Cookie[this.cookies.size()];
        this.cookies.toArray(this.cookiesIn);
    }

    private void fillCookie(ArrayList arrayList, CharBuffer charBuffer) {
        int n = 0;
        int n2 = charBuffer.length();
        int n3 = 0;
        Cookie cookie = null;
        while (n < n2) {
            char c = '\u0000';
            this.cbName.clear();
            this.cbValue.clear();
            while (n < n2 && ((c = charBuffer.charAt(n)) == ' ' || c == ';' || c == ',')) {
                ++n;
            }
            boolean bl = false;
            if (n < n2 && charBuffer.charAt(n) == '$') {
                bl = true;
                ++n;
            }
            while (n < n2) {
                c = charBuffer.charAt(n);
                if (c == ' ' || c == '=' || c == ';' || c == ',') break;
                this.cbName.append(c);
                ++n;
            }
            while (n < n2 && (c = charBuffer.charAt(n)) == ' ') {
                ++n;
            }
            if (n >= n2) break;
            if (c == ';' || c == ',') {
                try {
                    cookie = new Cookie(this.cbName.toString(), "");
                    cookie.setVersion(n3);
                    arrayList.add(cookie);
                }
                catch (Exception exception) {
                    if (!dbg.canWrite()) continue;
                    dbg.log(exception);
                }
                continue;
            }
            if (c != '=') {
                while (n < n2 && (c = charBuffer.charAt(n)) != ';') {
                    ++n;
                }
                continue;
            }
            ++n;
            while (n < n2 && (c = charBuffer.charAt(n)) == ' ') {
                ++n;
            }
            while (n < n2) {
                c = charBuffer.charAt(n);
                if (c == ' ' || c == ';' || c == ',') break;
                this.cbValue.append(c);
                ++n;
            }
            if (!bl) {
                cookie = new Cookie(this.cbName.toString(), this.cbValue.toString());
                cookie.setVersion(n3);
                arrayList.add(cookie);
                continue;
            }
            if (cookie == null) {
                if (!this.cbName.matchesIgnoreCase("Version")) continue;
                n3 = this.cbValue.charAt(0) - 48;
                continue;
            }
            if (this.cbName.matchesIgnoreCase("Version")) {
                cookie.setVersion(this.cbValue.charAt(0) - 48);
                continue;
            }
            if (this.cbName.matchesIgnoreCase("Domain")) {
                cookie.setDomain(this.cbValue.toString());
                continue;
            }
            if (!this.cbName.matchesIgnoreCase("Path")) continue;
            cookie.setPath(this.cbValue.toString());
        }
    }

    protected void setVaryCookies() {
        super.setVaryCookies();
        this.response.setPrivateCache(true);
    }

    public HttpSession getSession(boolean bl) {
        if (this.session != null && this.session.isValid()) {
            return this.session;
        }
        boolean bl2 = this.session != null;
        this.session = null;
        if (this.invocation == null) {
            return null;
        }
        Application application = this.invocation.getApplication();
        String string = this.findSessionIdFromCookie();
        if (string != null) {
            this.session = this.invocation.getApplication().getSession(string);
            if (this.session != null && this.session.isValid()) {
                this.session.setAccess(this.getDate());
                return this.session;
            }
        } else {
            string = this.findSessionIdFromUrl();
            if (string != null) {
                this.session = this.invocation.getApplication().getSession(string);
                if (this.session != null && this.session.isValid()) {
                    this.session.setAccess(this.getDate());
                    return this.session;
                }
            }
        }
        if (!bl) {
            return null;
        }
        this.setUsesCookies();
        if (string != null) {
            this.session = this.invocation.getApplication().getSession(string);
            if (this.session != null && !this.session.isValid()) {
                string = null;
            }
        }
        if (bl2) {
            string = null;
        }
        String string2 = string;
        string = this.createSessionId(string);
        this.session = new QSession(application, string, this.date);
        application.addSession(this.session);
        if (string.equals(string2)) {
            return this.session;
        }
        if (application.enableSessionCookies()) {
            this.response.setSessionId(this.session.getId());
        }
        return this.session;
    }

    private String findSessionIdFromCookie() {
        Application application = this.invocation.getApplication();
        if (!application.enableSessionCookies()) {
            return null;
        }
        this.setVaryCookies();
        Cookie cookie = this.getCookie("JSESSIONID");
        if (cookie != null) {
            return cookie.getValue();
        }
        return null;
    }

    private String findSessionIdFromUrl() {
        this.setVaryCookies();
        String string = this.invocation.getSessionId();
        if (string != null) {
            this.setUsesCookies();
        }
        return string;
    }

    String createSessionId(String string) {
        CharBuffer charBuffer;
        String string2;
        long l = this.date;
        boolean bl = true;
        if (this.bogusDate > 0L) {
            l = this.bogusDate;
            bl = false;
        }
        Application application = this.invocation.getApplication();
        block0: do {
            int n = this.server.incrSession();
            charBuffer = new CharBuffer();
            int n2 = 0;
            if (this.sessionGroup >= 0) {
                n2 = this.sessionGroup;
            } else {
                if (bl) {
                    n2 = (int)(Math.random() * 262144.0);
                }
                n2 += (int)((long)n + l + (l >> 1000));
            }
            charBuffer.append(this.convert(n2));
            charBuffer.append(this.convert(n2 >> 6));
            charBuffer.append(this.convert(n2 >> 12));
            if (string != null && (this.sessionGroup < 0 || string.startsWith(charBuffer.toString()))) {
                return string;
            }
            String string3 = bl ? ("" + Math.random()).substring(2) + n + l : "" + n + l;
            int n3 = 1021;
            int n4 = 0;
            while (n4 < string3.length()) {
                if (n4 + 1 == string3.length()) {
                    n3 = 65521 * n3 + 251 * (string3.charAt(n4) + '\u0001');
                    charBuffer.append(this.convert(n3));
                    continue block0;
                }
                n3 = 65521 * n3 + 251 * (string3.charAt(n4) + '\u0001');
                n3 = 65521 * n3 + 251 * (string3.charAt(n4 + 1) + '\u0001');
                charBuffer.append(this.convert(n3));
                n4 += 2;
            }
        } while (application.getSession(string2 = charBuffer.toString()) != null);
        return string2;
    }

    private char convert(int n) {
        if ((n &= 0x3F) < 26) {
            return (char)(97 + n);
        }
        if (n < 52) {
            return (char)(65 + n - 26);
        }
        if (n < 62) {
            return (char)(48 + n - 52);
        }
        switch (n) {
            case 62: {
                return '_';
            }
            case 63: {
                return '-';
            }
        }
        throw new RuntimeException();
    }

    public String getRequestedSessionId() {
        this.setVaryCookies();
        String string = this.findSessionIdFromCookie();
        if (string != null) {
            this.setUsesCookies();
            return string;
        }
        return this.findSessionIdFromUrl();
    }

    public boolean isRequestedSessionIdValid() {
        this.setVaryCookies();
        String string = this.getRequestedSessionId();
        if (string == null) {
            return false;
        }
        QSession qSession = (QSession)this.getSession(false);
        return qSession != null && qSession.isValid && qSession.getId().equals(string);
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.findSessionIdFromCookie() != null;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.findSessionIdFromUrl() != null;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    private Hashtable parseQuery() {
        try {
            Object object;
            String string = this.getQueryString();
            String string2 = this.getContentType();
            if (string == null && (string2 == null || this.getContentLength() == 0)) {
                return this.form;
            }
            String string3 = this.getCharacterEncoding();
            if (string3 == null) {
                string3 = (String)this.getAttribute(CAUCHO_CHAR_ENCODING);
            }
            if (string3 == null) {
                string3 = (String)this.getAttribute(CHAR_ENCODING);
            }
            if (string3 == null && (object = (Locale)this.getAttribute(FORM_LOCALE)) != null) {
                string3 = Encoding.getMimeName((Locale)object);
            }
            if (string3 == null) {
                string3 = this.invocation.getApplication().getCharEncoding();
            }
            if (string3 == null) {
                string3 = this.response.getRealCharacterEncoding();
            }
            object = Encoding.getJavaName(string3);
            if (string != null) {
                Form.parseQueryString(this.form, string, (String)object);
            }
            if (string2 != null && string2.startsWith("application/x-www-form-urlencoded") && this.getContentLength() >= 0) {
                Form.parsePostData(this.form, (InputStream)this.getInputStream(), (String)object);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.form;
    }

    public Enumeration getParameterNames() {
        if (this.filledForm == null) {
            this.filledForm = this.parseQuery();
        }
        if (this.filledForm.size() == 0) {
            return NullEnumeration.create();
        }
        return this.filledForm.keys();
    }

    public String[] getParameterValues(String string) {
        if (this.filledForm == null) {
            this.filledForm = this.parseQuery();
        }
        return (String[])this.filledForm.get(string);
    }

    public String getParameter(String string) {
        String[] stringArray = this.getParameterValues(string);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return stringArray[0];
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public void setAttribute(String string, Object object) {
        if (object != null) {
            this.attributes.put(string, object);
        }
    }

    public void removeAttribute(String string) {
        this.attributes.remove(string);
    }

    public Enumeration getHeaders(String string) {
        String string2 = this.getHeader(string);
        if (string2 == null) {
            return NullEnumeration.create();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        return Collections.enumeration(arrayList);
    }

    public Locale getLocale() {
        Enumeration enumeration = this.getLocales();
        if (!enumeration.hasMoreElements()) {
            return Locale.getDefault();
        }
        return (Locale)enumeration.nextElement();
    }

    public Enumeration getLocales() {
        if (this.locales.size() == 0) {
            this.fillLocales();
        }
        return Collections.enumeration(this.locales);
    }

    /*
     * Unable to fully structure code
     */
    private void fillLocales() {
        var1_1 = this.getHeaders("Accept-Language");
        if (var1_1 != null) ** GOTO lbl42
        return;
lbl-1000:
        // 1 sources

        {
            var2_2 = (String)var1_1.nextElement();
            var3_3 = new StringCharCursor(var2_2);
            ** GOTO lbl41
            {
                var3_3.next();
                do {
                    if (Character.isWhitespace(var3_3.current())) continue block1;
                    this.cb.clear();
                    while ((var4_4 = var3_3.current()) >= 'a' && var4_4 <= 'z' || var4_4 >= 'A' && var4_4 <= 'Z' || var4_4 >= '0' && var4_4 <= '0') {
                        this.cb.append(var3_3.current());
                        var3_3.next();
                    }
                    var5_5 = this.cb.toString();
                    var6_6 = "";
                    if (var3_3.current() == '-' || var3_3.current() == '_') {
                        this.cb.clear();
                        var3_3.next();
                        while ((var4_4 = var3_3.current()) >= 'a' && var4_4 <= 'z' || var4_4 >= 'A' && var4_4 <= 'Z' || var4_4 >= '0' && var4_4 <= '0') {
                            this.cb.append(var3_3.current());
                            var3_3.next();
                        }
                        var6_6 = this.cb.toString();
                    }
                    if (var5_5.length() > 0) {
                        var7_7 = new Locale(var5_5, var6_6);
                        this.locales.add(var7_7);
                    }
                    while (var3_3.current() != '\uffff' && var3_3.current() != ',') {
                        var3_3.next();
                    }
                    var3_3.next();
lbl41:
                    // 2 sources

                } while (var3_3.current() != '\uffff');
            }
lbl42:
            // 2 sources

            ** while (var1_1.hasMoreElements())
        }
lbl43:
        // 1 sources

    }

    public boolean isSecure() {
        return this.isSecure;
    }

    Invocation getInvocation() {
        return this.invocation;
    }

    public Application getApplication() {
        if (this.invocation == null) {
            return this.server.getDefaultApplication();
        }
        return this.invocation.getApplication();
    }

    public void resetTimeout() {
        if (this.conn != null) {
            this.conn.resetTimeout();
        }
    }

    Servlet getServlet() throws Exception {
        return this.invocation.getServlet();
    }

    QServletConfig getServletConfig() {
        return this.invocation == null ? null : this.invocation.getServletConfig();
    }

    public long getDate() {
        return this.bogusDate > 0L ? this.bogusDate : this.date;
    }

    void setDate(long l) {
        this.bogusDate = l;
    }

    void addDate(long l) {
        this.bogusDate += l;
    }

    public abstract void handleConnection(Connection var1) throws IOException;

    protected Request(ServletServer servletServer) {
        this.server = servletServer;
        this.contentLengthStream = new ContentLengthStream();
        this.chunkedInputStream = new ChunkedInputStream();
        this.filterStream = new ReadStream();
        this.is = new QServletInputStream();
        this.bufferedReader = new BufferedReaderAdapter(this.filterStream);
        this.attributes = new Hashtable();
        this.locales = new ArrayList();
        this.cb = new CharBuffer();
        this.byteBuffer = new byte[256];
    }

    static class ContentLengthStream
    extends StreamImpl {
        private Request request;
        private ReadStream next;
        private int length;

        void init(Request request, ReadStream readStream, int n) {
            this.request = request;
            this.next = readStream;
            this.length = n;
        }

        public boolean canRead() {
            return true;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (n2 > this.length) {
                n2 = this.length;
            }
            if (n2 <= 0) {
                return -1;
            }
            this.request.resetTimeout();
            int n3 = this.next.read(byArray, n, n2);
            if (this.request.conn.isInterrupted()) {
                throw new InterruptedIOException("interrupt during read");
            }
            this.length = n3 > 0 ? (this.length -= n3) : -1;
            return n3;
        }

        public int getAvailable() {
            return this.length;
        }

        ContentLengthStream() {
        }
    }
}

