/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.Application;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.CauchoRequestDispatcher;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.ChainRequest;
import com.caucho.server.http.Invocation;
import com.caucho.server.http.QServletConfig;
import com.caucho.server.http.Request;
import com.caucho.server.http.Response;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServletRequest;

class QNamedDispatcher
implements CauchoRequestDispatcher {
    private QServletConfig config;
    private String queryString;

    public void forward(CauchoRequest cauchoRequest, CauchoResponse cauchoResponse, String string) throws ServletException, IOException {
        this.forward((ServletRequest)cauchoRequest, (ServletResponse)cauchoResponse);
    }

    public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        Response response = (Response)servletResponse;
        response.clearBuffer();
        this.service(servletRequest, (ServletResponse)response);
        response.finish(true);
    }

    public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        this.service(servletRequest, servletResponse);
    }

    public void chain(Invocation invocation, ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        ChainRequest chainRequest = new ChainRequest();
        chainRequest.init(invocation, (CauchoRequest)servletRequest);
        chainRequest.startChaining((CauchoResponse)servletResponse);
        try {
            this.service((ServletRequest)chainRequest, servletResponse);
        }
        finally {
            Object var6_5 = null;
            chainRequest.close();
        }
    }

    public void include(ServletRequest servletRequest, ServletResponse servletResponse, String string) throws ServletException, IOException {
        String string2 = ((HttpServletRequest)servletRequest).getMethod();
        if (servletRequest instanceof Request) {
            Request request = (Request)servletRequest;
            request.setMethod(string);
            try {
                this.service(servletRequest, servletResponse);
            }
            finally {
                Object var7_6 = null;
                request.setMethod(string2);
            }
        } else {
            this.service(servletRequest, servletResponse);
        }
    }

    void service(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        Application application = (Application)this.config.getServletContext();
        if (this.config.getJspFile() != null) {
            servletRequest.setAttribute("caucho.jsp.servlet-config", (Object)this.config);
            String string = this.config.getJspFile();
            if (string.length() == 0 || string.charAt(0) != '/') {
                string = "/" + string;
            }
            RequestDispatcher requestDispatcher = application.getRequestDispatcher(string);
            requestDispatcher.include(servletRequest, servletResponse);
            return;
        }
        Servlet servlet = null;
        try {
            servlet = application.updateServlet(this.config, null, 0);
            if (servlet == null) {
                servlet = application.loadServlet(this.config);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ServletException((Throwable)classNotFoundException);
        }
        if (servlet instanceof SingleThreadModel) {
            Servlet servlet2 = servlet;
            synchronized (servlet2) {
                servlet.service(servletRequest, servletResponse);
            }
        } else {
            servlet.service(servletRequest, servletResponse);
        }
    }

    QNamedDispatcher(QServletConfig qServletConfig, String string) {
        this.config = qServletConfig;
        this.queryString = string;
    }
}

