/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.AbstractRequest;
import com.caucho.server.http.Application;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.Invocation;
import com.caucho.server.http.Response;
import com.caucho.server.http.VirtualHost;
import com.caucho.util.Alarm;
import com.caucho.util.CacheListener;
import com.caucho.util.CharBuffer;
import com.caucho.util.LruCache;
import com.caucho.util.QDate;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.ServletException;

class PageCache {
    static WriteStream dbg = LogStream.open("/caucho.com/http/cache");
    static final long DEFAULT_EXPIRES = 5000L;
    VirtualHost host;
    Path cacheRoot;
    LruCache cache;
    Key key;
    QDate calendar = new QDate();

    synchronized void clear() {
        this.cache.clear();
    }

    void service(AbstractRequest abstractRequest, Response response, boolean bl) throws Exception {
        Entry entry = this.getEntry(abstractRequest.getPageUriBuffer(), abstractRequest.getPageQueryBuffer(), bl);
        entry.service(abstractRequest, response);
    }

    Invocation getInvocation(CharBuffer charBuffer, CharBuffer charBuffer2, boolean bl) throws Exception {
        Entry entry = this.getEntry(charBuffer, charBuffer2, bl);
        return entry.invocation;
    }

    private Entry getEntry(CharBuffer charBuffer, CharBuffer charBuffer2, boolean bl) throws Exception {
        Entry entry = null;
        PageCache pageCache = this;
        synchronized (pageCache) {
            this.key.init(charBuffer, charBuffer2);
            entry = (Entry)this.cache.get(this.key);
        }
        if (entry != null) {
            return entry;
        }
        Invocation invocation = this.host.getInvocation(charBuffer, bl);
        PageCache pageCache2 = this;
        if (pageCache2 == null) {
            throw null;
        }
        entry = pageCache2.new Entry(this.cacheRoot, invocation, charBuffer2.toString());
        pageCache = this;
        synchronized (pageCache) {
            Key key = new Key(charBuffer, charBuffer2);
            this.cache.put(key, entry);
        }
        return entry;
    }

    PageCache(VirtualHost virtualHost, Path path, int n) {
        this.host = virtualHost;
        this.cacheRoot = path;
        this.cache = new LruCache(n);
        this.key = new Key();
        try {
            Iterator iterator = path.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                try {
                    Path path2 = path.lookup(string);
                    path2.remove();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    class Entry
    implements CacheListener {
        String url;
        String queryString;
        private Invocation invocation;
        Path cacheRoot;
        Path cache;
        WriteStream cacheStream;
        ArrayList headerKeys;
        ArrayList headerValues;
        String contentType;
        boolean isCacheable = true;
        long lastCacheCheck;
        boolean hasCache = false;
        boolean isFillingCache = false;
        long expiresTime = -1L;
        long expireDate = -1L;
        String etag;
        String lastModified;
        long lastModifiedDate = -1L;
        boolean varyCookies = false;
        boolean canCache = false;

        Invocation getInvocation() throws ServletException {
            try {
                VirtualHost virtualHost = this.invocation.getHost();
                this.invocation = virtualHost.updateInvocation(this.invocation);
                return this.invocation;
            }
            catch (ServletException servletException) {
                throw servletException;
            }
            catch (Exception exception) {
                throw new ServletException((Throwable)exception);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void service(AbstractRequest abstractRequest, Response response) throws IOException, ServletException {
            Entry entry;
            boolean bl;
            block27: {
                bl = this.hasCache && this.cache != null;
                entry = this;
                synchronized (entry) {
                    if (bl) {
                        if (this.varyCookies && abstractRequest.getHeader("Cookie") != null) {
                            bl = false;
                        } else if (!this.invocation.getApplication().isModified() && this.expireDate >= abstractRequest.getDate() && this.fillFromCache(abstractRequest, response, true)) {
                            return;
                        }
                    }
                    String string = null;
                    if (bl && this.etag != null) {
                        int n;
                        string = abstractRequest.getHeader("If-None-Match");
                        abstractRequest.setHeader("If-None-Match", this.etag);
                        if (string != null && (n = string.indexOf(59)) > 0) {
                            string = string.substring(0, n);
                        }
                    }
                    String string2 = null;
                    if (bl && this.lastModified != null) {
                        int n;
                        string2 = abstractRequest.getHeader("If-Modified-Since");
                        abstractRequest.setHeader("If-Modified-Since", this.lastModified);
                        if (string2 != null && (n = string2.indexOf(59)) > 0) {
                            string2 = string2.substring(0, n);
                        }
                    }
                    if (bl) {
                        if (abstractRequest.getRequestDepth(0) > 1) {
                            response.setPageCache(this);
                        } else if (string == null && string2 == null) {
                            response.setPageCache(this);
                        } else if (string != null && !string.equals(this.etag)) {
                            response.setPageCache(this);
                        } else if (string2 != null && !string2.equals(this.lastModified)) {
                            response.setPageCache(this);
                        }
                    }
                }
                try {
                    try {
                        abstractRequest.service(this, (CauchoResponse)response);
                    }
                    catch (ServletException servletException) {
                        if (this.cacheStream == null) throw servletException;
                        this.finishCaching(false);
                        throw servletException;
                    }
                    catch (IOException iOException) {
                        if (this.cacheStream == null) throw iOException;
                        this.finishCaching(false);
                        throw iOException;
                    }
                    Object var5_7 = null;
                    if (this.cacheStream == null) break block27;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    if (this.cacheStream == null) throw throwable;
                    response.finish(true);
                    throw throwable;
                }
                response.finish(true);
            }
            entry = this;
            synchronized (entry) {
                if (!bl) return;
                if (this.expiresTime <= 0L) return;
                if (this.expireDate >= abstractRequest.getDate()) return;
                this.expireDate = abstractRequest.getDate() + 5000L;
                return;
            }
        }

        synchronized boolean fillFromCache(AbstractRequest abstractRequest, Response response, boolean bl) throws IOException {
            if (!this.hasCache || this.cache == null) {
                return false;
            }
            response.reset();
            response.disableCaching(true);
            boolean bl2 = false;
            if (bl) {
                int n;
                String string;
                if (this.etag != null) {
                    string = abstractRequest.getHeader("if-none-match");
                    int n2 = n = string != null ? string.indexOf(59) : -1;
                    if (n >= 0) {
                        string = string.substring(0, n);
                    }
                    if (string != null && string.equals(this.etag)) {
                        response.setStatus(304);
                        bl2 = true;
                    }
                }
                if (!bl2 && this.lastModified != null) {
                    string = abstractRequest.getHeader("if-modified-since");
                    int n3 = n = string != null ? string.indexOf(59) : 0;
                    if (n > 0) {
                        string = string.substring(0, n);
                    }
                    if (string != null && string.equals(this.lastModified)) {
                        response.setStatus(304);
                        bl2 = true;
                    }
                }
            }
            if (dbg.canWrite()) {
                if (bl2) {
                    dbg.log("not-modified: " + this.url + "?" + this.queryString);
                } else {
                    dbg.log("using cache: " + this.url + "?" + this.queryString);
                }
            }
            if (bl2) {
                return true;
            }
            if (this.contentType != null) {
                response.setContentType(this.contentType);
            }
            int n = 0;
            while (this.headerKeys != null && n < this.headerKeys.size()) {
                response.addHeader((String)this.headerKeys.get(n), (String)this.headerValues.get(n));
                ++n;
            }
            if (this.varyCookies) {
                response.setNoCache(true);
            } else if (this.expiresTime > 0L) {
                response.setDateHeader("Expires", abstractRequest.getDate() + this.expiresTime);
            } else if (this.expireDate > 0L) {
                response.setDateHeader("Expires", this.expireDate);
            }
            CharBuffer charBuffer = abstractRequest.getMethodBuffer();
            if (charBuffer != null && charBuffer.matches("HEAD")) {
                return true;
            }
            try {
                this.cache.writeToStream(response.getStream());
            }
            catch (IOException iOException) {
                this.cache = null;
                response.reset();
                return false;
            }
            return true;
        }

        boolean isCacheable() {
            return this.isCacheable && this.canCache;
        }

        synchronized WriteStream startCaching(AbstractRequest abstractRequest, Response response, ArrayList arrayList, ArrayList arrayList2, String string, String string2) {
            Object object;
            String string3;
            Path path = null;
            long l = abstractRequest.getDate();
            if (!this.isCacheable && this.lastCacheCheck + 60000L < l || this.isFillingCache) {
                return null;
            }
            this.isCacheable = false;
            this.isFillingCache = true;
            boolean bl = this.hasCache;
            this.hasCache = false;
            path = this.cache;
            this.cache = null;
            boolean bl2 = false;
            if (!"GET".equals(abstractRequest.getMethod()) && !"HEAD".equals(abstractRequest.getMethod())) {
                bl2 = true;
            } else if (response.getHeader("Vary") != null) {
                bl2 = true;
            }
            String string4 = response.getHeader("Cache-Control");
            boolean bl3 = false;
            int n = 0;
            while (n < arrayList.size()) {
                String string5 = (String)arrayList.get(n);
                String string6 = (String)arrayList2.get(n);
                if (string5.equalsIgnoreCase("cache-control") && !string6.equals("public")) {
                    if (string6.equals("x-anonymous")) {
                        bl3 = true;
                        arrayList.remove(n);
                        arrayList2.remove(n);
                        --n;
                    } else {
                        bl2 = true;
                    }
                }
                ++n;
            }
            boolean bl4 = this.canCache = !bl2;
            if (bl2) {
                try {
                    if (path != null) {
                        path.remove();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
            this.varyCookies = bl3 && abstractRequest.getVaryCookies();
            n = !bl3 || !abstractRequest.getUsesCookies() ? 0 : 1;
            long l2 = -1L;
            if (n == 0) {
                this.expireDate = l2;
            }
            if ((string3 = response.getHeader("Expires")) != null) {
                QDate qDate = PageCache.this.calendar;
                synchronized (qDate) {
                    try {
                        l2 = PageCache.this.calendar.parseDate(string3);
                        if (n == 0) {
                            this.expireDate = l2;
                        }
                        if (l2 < abstractRequest.getDate()) {
                            this.canCache = false;
                            WriteStream writeStream = null;
                            Object var19_23 = null;
                            return writeStream;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            long l3 = -1L;
            String string7 = response.getHeader("Last-Modified");
            if (string7 != null) {
                object = PageCache.this.calendar;
                synchronized (object) {
                    block55: {
                        try {
                            l3 = PageCache.this.calendar.parseDate(string7);
                        }
                        catch (Exception exception) {
                            if (!dbg.canWrite()) break block55;
                            dbg.log(exception);
                        }
                    }
                }
            }
            if (n == 0) {
                this.lastModifiedDate = l3;
                this.lastModified = string7;
            }
            object = response.getHeader("ETag");
            if (n == 0) {
                this.etag = object;
            }
            if (n == 0 && l2 == -1L && (object != null || l3 > 0L)) {
                if (this.expiresTime < 0L) {
                    Application application = abstractRequest.getApplication();
                    if (application != null && this.url != null) {
                        this.expiresTime = application.getCacheTime(this.url);
                    }
                    if (this.expiresTime < 5000L) {
                        this.expiresTime = 5000L;
                    }
                }
                if (this.expiresTime > 0L && !this.varyCookies) {
                    response.setDateHeader("Expires", abstractRequest.getDate() + this.expiresTime);
                }
                this.expireDate = abstractRequest.getDate() + 5000L;
            } else if (l2 - 1000L < abstractRequest.getDate() && l3 < 0L && object == null) {
                this.canCache = false;
                return null;
            }
            if (n != 0) {
                response.setPrivateCache(true);
                this.isCacheable = true;
                this.isFillingCache = false;
                this.cache = path;
                this.hasCache = bl;
                return null;
            }
            if (this.varyCookies) {
                response.setNoCache(true);
            }
            if (path != null) {
                try {
                    path.remove();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.headerKeys == null) {
                this.headerKeys = new ArrayList();
            } else {
                this.headerKeys.clear();
            }
            if (this.headerValues == null) {
                this.headerValues = new ArrayList();
            } else {
                this.headerValues.clear();
            }
            int n2 = 0;
            while (n2 < arrayList.size()) {
                String string8 = (String)arrayList.get(n2);
                String string9 = (String)arrayList2.get(n2);
                if (!string8.equalsIgnoreCase("expires")) {
                    this.headerKeys.add(string8);
                    this.headerValues.add(arrayList2.get(n2));
                }
                ++n2;
            }
            if (string != null && string2 != null) {
                this.contentType = string + "; charset=" + string2;
            } else if (string != null) {
                this.contentType = string;
            } else if (string2 != null) {
                this.contentType = "text/html; charset=" + string2;
            }
            try {
                this.cache = this.cacheRoot.createTempFile("res", "");
                this.cacheStream = this.cache.openWrite();
                this.isCacheable = true;
                return this.cacheStream;
            }
            catch (IOException iOException) {
                if (dbg.canWrite()) {
                    dbg.log(iOException);
                }
                return null;
            }
        }

        void finishCaching(boolean bl) {
            block8: {
                Object object;
                try {
                    object = this.cacheStream;
                    this.cacheStream = null;
                    if (object != null) {
                        ((WriteStream)object).close();
                    }
                }
                catch (IOException iOException) {
                    if (dbg.canWrite()) {
                        dbg.log(iOException);
                    }
                    bl = false;
                }
                if (dbg.canWrite()) {
                    this.logCache();
                }
                try {
                    if (!bl && this.cache != null) {
                        object = this.cache;
                        this.cache = null;
                        ((Path)object).remove();
                    }
                }
                catch (IOException iOException) {
                    if (!dbg.canWrite()) break block8;
                    dbg.log(iOException);
                }
            }
            this.hasCache = bl;
            this.isFillingCache = false;
        }

        public void removeEvent() {
            if (this.cache != null) {
                try {
                    this.cache.remove();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (dbg.canWrite()) {
                    dbg.log("lru removing cache: " + this.url + "?" + this.queryString);
                }
            }
        }

        private void logCache() {
            CharBuffer charBuffer = CharBuffer.allocate();
            if (this.varyCookies) {
                charBuffer.append(" anonymous");
            }
            if (this.etag != null) {
                charBuffer.append(" etag=");
                charBuffer.append(this.etag);
            } else if (this.lastModified != null) {
                charBuffer.append(" last-modified=");
                charBuffer.append(this.lastModified);
            } else if (this.expireDate > Alarm.getCurrentTime()) {
                charBuffer.append(" expires=");
                charBuffer.append(QDate.format(this.expireDate));
            }
            if (this.hasCache) {
                dbg.log("caching: " + this.url + "?" + this.queryString + charBuffer.close());
            } else if (this.cache != null) {
                dbg.log("removing cache: " + this.url + "?" + this.queryString + charBuffer.close());
            }
        }

        Entry(Path path, Invocation invocation, String string) {
            this.cacheRoot = path;
            this.invocation = invocation;
            this.url = invocation.uri;
            this.queryString = string;
        }
    }

    static class Key {
        CharBuffer url;
        CharBuffer queryString;

        void init(CharBuffer charBuffer, CharBuffer charBuffer2) {
            this.url = charBuffer;
            this.queryString = charBuffer2;
        }

        public int hashCode() {
            if (this.queryString != null) {
                return this.url.hashCode() * 65521 + this.queryString.hashCode();
            }
            return this.url.hashCode() * 65521;
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                Key key = (Key)object;
                return this.url.equals(key.url) && this.queryString.equals(key.queryString);
            }
            return false;
        }

        Key() {
        }

        Key(CharBuffer charBuffer, CharBuffer charBuffer2) {
            this.url = (CharBuffer)charBuffer.clone();
            this.queryString = charBuffer2 != null ? (CharBuffer)charBuffer2.clone() : new CharBuffer();
        }
    }
}

