/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.Application;
import com.caucho.server.http.QServletConfig;
import com.caucho.server.http.SecurityConstraint;
import com.caucho.server.http.VirtualHost;
import com.caucho.util.ByteBuffer;
import com.caucho.util.QDate;
import javax.servlet.Servlet;
import javax.servlet.ServletException;

class Invocation {
    private static QDate date = new QDate();
    private VirtualHost host;
    Application application;
    String rawUri;
    String uri;
    String contextPath;
    String servletPath;
    String pathInfo;
    String sessionId;
    QServletConfig servletConfig;
    Servlet servlet;
    int loaderCount;
    SecurityConstraint security;

    static String normalizeUri(String string, boolean bl) {
        if (bl) {
            string = Invocation.normalizeUriEscape(string);
        }
        ByteBuffer byteBuffer = new ByteBuffer();
        int n = string.length();
        if (n == 0 || string.charAt(0) != '/') {
            byteBuffer.append(47);
        }
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '/') {
                while (n2 + 1 < n) {
                    c = string.charAt(n2 + 1);
                    if (c == '/') {
                        ++n2;
                        continue;
                    }
                    if (c != '.') break;
                    if (n2 + 2 >= n || (c = string.charAt(n2 + 2)) == '/') {
                        n2 += 2;
                        continue;
                    }
                    if (c != '.' || n2 + 3 < n && string.charAt(n2 + 3) != '/') break;
                    int n3 = byteBuffer.size() - 1;
                    while (n3 >= 0) {
                        if (byteBuffer.get(n3) == 47) break;
                        --n3;
                    }
                    if (n3 > 0) {
                        byteBuffer.setLength(n3);
                    } else {
                        byteBuffer.setLength(0);
                    }
                    n2 += 3;
                }
                byteBuffer.append(47);
            } else {
                byteBuffer.append(c);
            }
            ++n2;
        }
        return byteBuffer.toString();
    }

    private static String normalizeUriEscape(String string) {
        ByteBuffer byteBuffer = new ByteBuffer();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (c == '%') {
                n = Invocation.scanUriEscape(byteBuffer, string, n + 1, n2);
                continue;
            }
            byteBuffer.add(string.charAt(n));
            ++n;
        }
        return byteBuffer.toString();
    }

    private static int scanUriEscape(ByteBuffer byteBuffer, String string, int n, int n2) {
        if (n >= n2) {
            byteBuffer.add(37);
            return n;
        }
        char c = string.charAt(n);
        if (c == 'u') {
            byteBuffer.add(37);
            return n;
        }
        if (n + 2 > n2) {
            byteBuffer.add(37);
            return n;
        }
        int n3 = Invocation.toHex(c);
        if (n3 < 0) {
            byteBuffer.add(37);
            return n;
        }
        char c2 = string.charAt(n + 1);
        int n4 = Invocation.toHex(c2);
        if (n4 < 0) {
            byteBuffer.add(37);
            return n;
        }
        byteBuffer.append((byte)((n3 << 4) + n4));
        return n + 2;
    }

    private static int toHex(int n) {
        if (n >= 48 && n <= 57) {
            return n - 48;
        }
        if (n >= 97 && n <= 102) {
            return n - 97 + 10;
        }
        if (n >= 65 && n <= 70) {
            return n - 65 + 10;
        }
        return -1;
    }

    VirtualHost getHost() {
        return this.host;
    }

    String getRawUri() {
        return this.rawUri;
    }

    String getUri() {
        return this.uri;
    }

    String getContextPath() {
        return this.contextPath;
    }

    String getServletPath() {
        return this.servletPath;
    }

    String getPathInfo() {
        return this.pathInfo;
    }

    String getSessionId() {
        return this.sessionId;
    }

    Application getApplication() {
        return this.application;
    }

    QServletConfig getServletConfig() {
        return this.servletConfig;
    }

    String getServletName() {
        return this.servletConfig.getServletName();
    }

    Servlet getServlet() throws Exception, ServletException {
        this.servlet = this.application.updateServlet(this.servletConfig, this.servlet, this.loaderCount);
        if (this.servlet == null) {
            this.servlet = this.application.loadServlet(this.servletConfig);
        }
        this.loaderCount = this.application.getClassUpdateCount();
        return this.servlet;
    }

    Invocation(VirtualHost virtualHost, String string, boolean bl) {
        this.host = virtualHost;
        this.rawUri = string;
        this.uri = Invocation.normalizeUri(string, bl);
    }
}

