/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.Version;
import com.caucho.server.RequestFactory;
import com.caucho.server.Server;
import com.caucho.server.ServerRequest;
import com.caucho.server.StreamConnection;
import com.caucho.server.TcpServer;
import com.caucho.server.http.HttpRequest;
import com.caucho.server.http.Request;
import com.caucho.server.http.ServletServer;
import com.caucho.util.CauchoSystem;
import com.caucho.util.Registry;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class HttpServer
implements RequestFactory {
    static final String COPYRIGHT = "Copyright (c) 1998-2000 Caucho Technology.  All rights reserved.";
    static WriteStream dbg;

    public ServerRequest createRequest(Server server) {
        return new HttpRequest((ServletServer)server);
    }

    public static void main(String[] stringArray) throws Exception {
        Closeable closeable;
        String string = CauchoSystem.getResinConfig();
        boolean bl = false;
        InputStream inputStream = null;
        int n = 0;
        String string2 = null;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (n3 + 1 < n2 && stringArray[n3].equals("-conf")) {
                string = stringArray[n3 + 1];
                n3 += 2;
                continue;
            }
            if (n3 + 1 < n2 && (stringArray[n3].equals("-port") || stringArray[n3].equals("-http-port"))) {
                n = Integer.parseInt(stringArray[n3 + 1]);
                n3 += 2;
                continue;
            }
            if (stringArray[n3].equals("-version")) {
                System.out.println(Version.VERSION);
                System.exit(0);
                continue;
            }
            if (stringArray[n3].equals("-deadwait")) {
                bl = true;
                ++n3;
                continue;
            }
            if (n3 + 1 < n2 && stringArray[n3].equals("-e")) {
                string2 = stringArray[n3 + 1];
                n3 += 2;
                continue;
            }
            if (stringArray[n3].equals("-socketwait")) {
                int n4 = Integer.parseInt(stringArray[n3 + 1]);
                closeable = new Socket("127.0.0.1", n4);
                inputStream = ((Socket)closeable).getInputStream();
                n3 += 2;
                continue;
            }
            System.out.println("unknown argument `" + stringArray[n3] + "'");
            System.out.println();
            HttpServer.usage();
            System.exit(66);
        }
        try {
            Object object;
            ServerSocket serverSocket;
            Object object2;
            Path path = CauchoSystem.getResinHome().lookupNative(string);
            closeable = path.openRead();
            Registry.setDefault(Registry.parse((ReadStream)closeable));
            ((ReadStream)closeable).close();
            dbg = LogStream.open("/caucho.com/httpd");
            if (dbg.canWrite()) {
                dbg.log("httpd startup: " + Version.VERSION);
            }
            RegistryNode registryNode = Registry.lookup("/caucho.com/http-server");
            ServletServer servletServer = new ServletServer(path, registryNode, CauchoSystem.getResinHome());
            if (string2 != null) {
                object2 = new HttpServer();
                HttpServer.doStandalone((HttpServer)object2, servletServer, string2);
                System.exit(0);
            }
            if ((object2 = registryNode.getString("httpd-host", null)) == null) {
                object2 = registryNode.getString("http-host", null);
            }
            if (n <= 0) {
                n = registryNode.getInt("httpd-port", 0);
            }
            if (n <= 0) {
                n = registryNode.getInt("port", 0);
            }
            int n5 = registryNode.getInt("thread-min", 5);
            int n6 = registryNode.getInt("thread-max", 20);
            int n7 = registryNode.getInt("thread-keepalive", -1);
            long l = registryNode.getPeriod("request-timeout", -1L);
            long l2 = registryNode.getPeriod("timeout-interval", 15000L);
            int n8 = registryNode.getInt("listen", 10);
            System.err.println(Version.VERSION);
            if (object2 == null) {
                serverSocket = new ServerSocket(n, n8);
                System.err.println("listening to *:" + n);
            } else {
                object = InetAddress.getByName((String)object2);
                serverSocket = new ServerSocket(n, n8, (InetAddress)object);
                System.err.println("listening to " + (String)object2 + ":" + n);
            }
            object = registryNode.getString("user-name", null);
            String string3 = registryNode.getString("group-name", null);
            if (object != null && !CauchoSystem.setUser((String)object, string3)) {
                throw new Exception("Can't set user `" + (String)object + "'");
            }
            HttpServer httpServer = new HttpServer();
            TcpServer tcpServer = new TcpServer(httpServer, serverSocket, n5, n6, n7, l, l2);
            tcpServer.init(servletServer);
            if (inputStream != null) {
                try {
                    while (inputStream.read() >= 0) {
                    }
                }
                catch (Exception exception) {
                    if (dbg.canWrite()) {
                        dbg.log(exception);
                    }
                }
            } else if (bl) {
                try {
                    while (System.in.read() >= 0) {
                    }
                }
                catch (Exception exception) {
                    if (dbg.canWrite()) {
                        dbg.log(exception);
                    }
                }
            } else {
                while (true) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(10000L);
                        if (!tcpServer.isDead()) continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            System.err.println("closing server");
            tcpServer.close();
            servletServer.close();
            if (dbg.canWrite()) {
                dbg.log("httpd shutdown");
            }
            System.exit(0);
        }
        catch (BindException bindException) {
            System.err.println("Can't bind to server port.  Check for conflicting servers.");
            System.exit(67);
        }
        catch (Throwable throwable) {
            try {
                throwable.printStackTrace(System.err);
            }
            finally {
                Object var10_15 = null;
                System.exit(66);
            }
        }
    }

    private static void doStandalone(HttpServer httpServer, ServletServer servletServer, String string) throws Exception {
        String string2;
        HttpRequest httpRequest = new HttpRequest(servletServer);
        ReadStream readStream = Vfs.openRead("GET " + string + " HTTP/1.0");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        WriteStream writeStream = Vfs.openWrite(byteArrayOutputStream);
        StreamConnection streamConnection = new StreamConnection(readStream, writeStream);
        streamConnection.setLocalAddress(InetAddress.getByName("127.0.0.1"));
        streamConnection.setRemoteAddress(InetAddress.getByName("127.0.0.1"));
        streamConnection.setLocalPort(8080);
        streamConnection.setRemotePort(32732);
        readStream.setDisableClose(true);
        writeStream.setDisableClose(true);
        ((Request)httpRequest).handleConnection(streamConnection);
        servletServer.close();
        readStream.setDisableClose(false);
        writeStream.setDisableClose(false);
        writeStream.close();
        readStream.close();
        readStream = Vfs.openRead(byteArrayOutputStream.toString());
        String string3 = readStream.readLine();
        while ((string2 = readStream.readLine()) != null && string2.length() > 0) {
        }
        readStream.writeToStream(System.out);
        if (string3.startsWith("HTTP/1.0 200")) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    private static void usage() {
        System.err.println("usage: HttpServer [-conf resin.conf]");
    }
}

