/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.HttpRequest;
import com.caucho.server.http.Request;
import com.caucho.server.http.Response;
import com.caucho.util.ByteBuffer;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import javax.servlet.http.Cookie;

class HttpResponse
extends Response {
    static byte[] http10ok = "HTTP/1.0 200 OK".getBytes();
    static byte[] http11ok = "HTTP/1.1 200 OK".getBytes();
    static byte[] resinServerBytes = "\r\nServer: Resin/1.1".getBytes();
    static byte[] contentLengthBytes = "\r\nContent-Length: ".getBytes();
    static byte[] contentTypeBytes = "\r\nContent-Type: ".getBytes();
    static CharBuffer connectionCb = new CharBuffer("Connection");
    static CharBuffer closeCb = new CharBuffer("Close");
    HttpRequest req;
    private ByteBuffer dateBuffer = new ByteBuffer();
    private long lastDate;

    boolean writeHeadersInt(WriteStream writeStream, int n) throws IOException {
        Object object;
        boolean bl = false;
        int n2 = this.req.getVersion();
        if (n2 < 256) {
            this.allowKeepalive = false;
            return false;
        }
        if (this.statusCode == 200) {
            if (n2 >= 257) {
                writeStream.write(http11ok, 0, http11ok.length);
            } else {
                writeStream.write(http10ok, 0, http10ok.length);
            }
        } else {
            if (n2 >= 257) {
                writeStream.print("HTTP/1.1 ");
            } else {
                writeStream.print("HTTP/1.0 ");
            }
            writeStream.write(this.statusCode / 100 % 10 + 48);
            writeStream.write(this.statusCode / 10 % 10 + 48);
            writeStream.write(this.statusCode % 10 + 48);
            writeStream.write(32);
            writeStream.print(this.statusMessage);
        }
        if (!this.containsHeader("Server")) {
            writeStream.write(resinServerBytes, 0, resinServerBytes.length);
        }
        if (this.isNoCache) {
            this.setHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
        } else if (this.isPrivateCache && n2 == 257) {
            writeStream.print("\r\nCache-Control: private");
        }
        int n3 = 0;
        while (n3 < this.headerKeys.size()) {
            String string = (String)this.headerKeys.get(n3);
            writeStream.write(13);
            writeStream.write(10);
            writeStream.print(string);
            writeStream.write(58);
            writeStream.write(32);
            writeStream.print((String)this.headerValues.get(n3));
            if (Response.dbg.canWrite()) {
                Response.dbg.log(string + ": " + this.headerValues.get(n3));
            }
            ++n3;
        }
        long l = this.request.getDate();
        int n4 = 0;
        while (n4 < this.cookiesOut.size()) {
            object = (Cookie)this.cookiesOut.get(n4);
            this.fillCookie(this.cb, (Cookie)object, l);
            writeStream.print("\r\nSet-Cookie: ");
            writeStream.print(this.cb.getBuffer(), 0, this.cb.getLength());
            if (Response.dbg.canWrite()) {
                Response.dbg.log("Set-Cookie: " + this.cb);
            }
            ++n4;
        }
        if (this.contentType != null) {
            writeStream.write(contentTypeBytes, 0, contentTypeBytes.length);
            writeStream.print(this.contentType);
            if (this.charEncoding != null) {
                writeStream.print("; charset=");
                writeStream.print(this.charEncoding);
            }
            if (Response.dbg.canWrite()) {
                Response.dbg.log("\r\nContent-Type: " + this.contentType + "; charset=" + this.charEncoding);
            }
        }
        n4 = 0;
        if (this.contentLength >= 0L) {
            writeStream.write(contentLengthBytes, 0, contentLengthBytes.length);
            writeStream.print(this.contentLength);
            n4 = 1;
        } else if (n >= 0) {
            writeStream.write(contentLengthBytes, 0, contentLengthBytes.length);
            writeStream.print(n);
            n4 = 1;
        }
        if (n2 < 257) {
            this.allowKeepalive = false;
        } else if (this.allowKeepalive && n2 >= 257) {
            object = this.req.getHeaderBuffer(connectionCb);
            if (object != null && ((CharBuffer)object).equalsIgnoreCase(closeCb)) {
                this.allowKeepalive = false;
            } else if (!this.req.conn.allocateKeepalive()) {
                writeStream.print("\r\nConnection: close");
                this.allowKeepalive = false;
            }
        } else {
            this.allowKeepalive = false;
        }
        if (n2 >= 257 && n4 == 0) {
            writeStream.print("\r\nTransfer-Encoding: chunked");
            bl = true;
        }
        if (this.lastDate != l) {
            this.lastDate = l;
            this.calendar.calculate(l, false);
            this.dateBuffer.clear();
            this.dateBuffer.addString("\r\nDate: ");
            this.dateBuffer.addString(this.calendar.printDate());
            this.dateBuffer.addString("\r\n\r\n");
        }
        writeStream.write(this.dateBuffer.getBuffer(), 0, this.dateBuffer.length());
        return bl;
    }

    HttpResponse(Request request) {
        super(request);
        this.req = (HttpRequest)request;
    }
}

