/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.Connection;
import com.caucho.server.http.Application;
import com.caucho.server.http.BadRequestException;
import com.caucho.server.http.BrowserConfig;
import com.caucho.server.http.HttpResponse;
import com.caucho.server.http.Request;
import com.caucho.server.http.ServletServer;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

class HttpRequest
extends Request {
    static WriteStream dbg = LogStream.open("/caucho.com/http/connection");
    static CharBuffer hostCb = new CharBuffer("Host");
    static CharBuffer userAgentCb = new CharBuffer("User-Agent");
    private CharBuffer method;
    private CharBuffer scheme;
    private CharBuffer host;
    private CharBuffer uri;
    private CharBuffer queryString;
    private CharBuffer protocol;
    private CharBuffer[] headerKeys;
    private CharBuffer[] headerValues;
    private int headerSize;
    private int headerCapacity;
    private CharBuffer cb;
    private char[] charBuf;
    private String cacheQuery;

    public void handleConnection(Connection connection) throws IOException {
        ReadStream readStream;
        this.setConnection(connection);
        this.rawStream = readStream = connection.getReadStream();
        WriteStream writeStream = connection.getWriteStream();
        this.response.init(writeStream);
        if (!this.handleRequest(true)) {
            return;
        }
        while (!connection.isInterrupted() && this.handleRequest(false)) {
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleRequest(boolean bl) throws IOException {
        block19: {
            boolean bl2;
            block18: {
                try {
                    try {
                        Object object;
                        this.start(this.rawStream);
                        if (!bl) {
                            this.conn.setIdle();
                        }
                        boolean bl3 = false;
                        try {
                            bl3 = this.readRequest(this.rawStream);
                        }
                        catch (InterruptedIOException interruptedIOException) {
                            // empty catch block
                        }
                        if (!bl3) {
                            bl2 = false;
                            Object var3_10 = null;
                            break block18;
                        }
                        if (this.protocol.length() == 0) {
                            this.protocol.append("HTTP/0.9");
                        }
                        if (dbg.canWrite()) {
                            dbg.log("[" + this.conn.getId() + "] " + this.method + " " + this.uri + "?" + this.queryString + " " + this.protocol);
                        }
                        this.parseHeaders(this.rawStream);
                        if (this.getVersion() >= 257 && (object = this.getApplication()) != null && ((Application)object).hasBrowserMap()) {
                            CharBuffer charBuffer = this.getHeaderBuffer(userAgentCb);
                            BrowserConfig browserConfig = null;
                            if (charBuffer != null && object != null) {
                                browserConfig = ((Application)object).getBrowser(charBuffer);
                            }
                            if (browserConfig != null && browserConfig.isForce10()) {
                                this.protocol.clear();
                                this.protocol.append("HTTP/1.0");
                                this.version = 256;
                            }
                        }
                        if ((object = this.getHost()) == null && this.getVersion() >= 257) {
                            this.response.closeConnection();
                            this.response.sendError(400, "HTTP/1.1 requires host");
                            break block19;
                        } else {
                            this.dispatch((CharBuffer)object, this.uri, true);
                        }
                        break block19;
                    }
                    catch (BadRequestException badRequestException) {
                        if (dbg.canWrite()) {
                            dbg.log(badRequestException);
                        }
                        this.response.sendError(400);
                        boolean bl4 = false;
                        Object var3_12 = null;
                        this.finish();
                        return bl4;
                    }
                    catch (SocketException socketException) {
                        boolean bl5 = false;
                        Object var3_13 = null;
                        this.finish();
                        return bl5;
                    }
                }
                catch (Throwable throwable) {
                    Object var3_14 = null;
                    this.finish();
                    throw throwable;
                }
            }
            this.finish();
            return bl2;
        }
        Object var3_11 = null;
        this.finish();
        if (dbg.canWrite()) {
            dbg.log("[" + this.conn.getId() + "] " + (this.response.allowKeepalive() ? "keepalive" : "done"));
        }
        return this.response.allowKeepalive();
    }

    protected void start(ReadStream readStream) throws IOException {
        super.start(readStream);
        this.method.clear();
        this.protocol.clear();
        this.uri.clear();
        this.queryString.clear();
        this.cacheQuery = null;
        this.host.clear();
        this.headerSize = 0;
    }

    /*
     * Unable to fully structure code
     */
    private boolean readRequest(ReadStream var1_1) throws IOException {
        var2_2 = false;
        var3_3 = var1_1.getBuffer();
        var4_4 = var1_1.getOffset();
        if (var4_4 >= (var5_5 = var1_1.getLength())) {
            var5_5 = var1_1.fillBuffer();
            if (var5_5 < 0) {
                return false;
            }
            var4_4 = 0;
        }
        var6_6 = (char)(var3_3[var4_4++] & 255);
        this.conn.setActive();
        this.conn.setAccessTime(this.getDate());
        while (var6_6 == ' ' || var6_6 == '\t' || var6_6 == '\r' || var6_6 == '\n') {
            if (var4_4 >= var5_5) {
                var5_5 = var1_1.fillBuffer();
                if (var5_5 < 0) {
                    return false;
                }
                var4_4 = 0;
            }
            var6_6 = (char)(var3_3[var4_4++] & 255);
        }
        while (var6_6 != ' ' && var6_6 != '\t') {
            if (var6_6 >= 'a' && var6_6 <= 'z') {
                this.method.append((char)(var6_6 + 65 - 97));
            } else {
                this.method.append(var6_6);
            }
            if (var4_4 >= var5_5) {
                var5_5 = var1_1.fillBuffer();
                if (var5_5 < 0) {
                    return false;
                }
                var4_4 = 0;
            }
            var6_6 = (char)(var3_3[var4_4++] & 255);
        }
        while (var6_6 == ' ' || var6_6 == '\t') {
            if (var4_4 >= var5_5) {
                var5_5 = var1_1.fillBuffer();
                if (var5_5 < 0) {
                    return false;
                }
                var4_4 = 0;
            }
            var6_6 = (char)(var3_3[var4_4++] & 255);
        }
        while (var6_6 != '/') {
            if (var4_4 >= var5_5) {
                var5_5 = var1_1.fillBuffer();
                if (var5_5 < 0) {
                    return false;
                }
                var4_4 = 0;
            }
            var6_6 = (char)(var3_3[var4_4++] & 255);
        }
        if (var4_4 >= var5_5) {
            var5_5 = var1_1.fillBuffer();
            if (var5_5 < 0) {
                return true;
            }
            var4_4 = 0;
        }
        var7_7 = this.uri.getBuffer();
        var8_8 = 0;
        if ((var9_9 = (char)(var3_3[var4_4++] & 255)) != '/') {
            var7_7[var8_8++] = var6_6;
            var6_6 = var9_9;
        } else {
            block15: while (true) {
                if (var4_4 >= var5_5) {
                    var5_5 = var1_1.fillBuffer();
                    if (var5_5 < 0) {
                        return true;
                    }
                    var4_4 = 0;
                }
                var6_6 = (char)(var3_3[var4_4++] & 255);
                switch (var6_6) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        throw new BadRequestException("bad url");
                    }
                    case '?': {
                        break block15;
                    }
                    case '/': {
                        break block15;
                    }
                    default: {
                        this.host.append(var6_6);
                        break;
                    }
                }
            }
        }
        block16: while (true) {
            switch (var6_6) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '?': {
                    break block16;
                }
                default: {
                    var7_7[var8_8++] = var6_6;
                    if (var4_4 >= var5_5) {
                        var5_5 = var1_1.fillBuffer();
                        if (var5_5 < 0) {
                            this.uri.setLength(var8_8);
                            return true;
                        }
                        var4_4 = 0;
                    }
                    var6_6 = (char)(var3_3[var4_4++] & 255);
                }
            }
        }
        this.uri.setLength(var8_8);
        if (var6_6 != '?') ** GOTO lbl118
        while (true) {
            if (var4_4 >= var5_5) {
                var5_5 = var1_1.fillBuffer();
                if (var5_5 < 0) {
                    return true;
                }
                var4_4 = 0;
            }
            var6_6 = (char)(var3_3[var4_4++] & 255);
            switch (var6_6) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (true) ** GOTO lbl118
                }
                default: {
                    this.queryString.append(var6_6);
                    break;
                }
            }
        }
        do {
            if (var4_4 >= var5_5) {
                var5_5 = var1_1.fillBuffer();
                if (var5_5 < 0) {
                    return true;
                }
                var4_4 = 0;
            }
            var6_6 = (char)(var3_3[var4_4++] & 255);
lbl118:
            // 3 sources

        } while (var6_6 == ' ' || var6_6 == '\t');
        while (var6_6 != ' ' && var6_6 != '\t' && var6_6 != '\r' && var6_6 != '\n') {
            if (var6_6 >= 'a' && var6_6 <= 'z') {
                this.protocol.append((char)(var6_6 + 65 - 97));
            } else {
                this.protocol.append(var6_6);
            }
            if (var4_4 >= var5_5) {
                var5_5 = var1_1.fillBuffer();
                if (var5_5 < 0) {
                    return true;
                }
                var4_4 = 0;
            }
            var6_6 = (char)(var3_3[var4_4++] & 255);
        }
        while (var6_6 != '\n') {
            if (var4_4 >= var5_5) {
                var5_5 = var1_1.fillBuffer();
                if (var5_5 < 0) {
                    return true;
                }
                var4_4 = 0;
            }
            var6_6 = (char)(var3_3[var4_4++] & 255);
        }
        var1_1.setOffset(var4_4);
        return true;
    }

    private void parseHeaders(ReadStream readStream) throws IOException {
        int n = this.getVersion();
        if (n < 256) {
            return;
        }
        if (n < 257) {
            this.response.closeConnection();
        }
        byte[] byArray = readStream.getBuffer();
        int n2 = readStream.getOffset();
        int n3 = readStream.getLength();
        while (true) {
            char c;
            CharBuffer charBuffer = this.headerKeys[this.headerSize];
            char[] cArray = charBuffer.getBuffer();
            int n4 = 0;
            block11: while (true) {
                if (n2 >= n3) {
                    n3 = readStream.fillBuffer();
                    if (n3 < 0) {
                        return;
                    }
                    n2 = 0;
                }
                c = (char)(byArray[n2++] & 0xFF);
                switch (c) {
                    case '\r': {
                        if (n2 >= n3) {
                            n3 = readStream.fillBuffer();
                            if (n3 < 0) {
                                return;
                            }
                            n2 = 0;
                        }
                        c = (char)(byArray[n2++] & 0xFF);
                    }
                    case '\n': {
                        readStream.setOffset(n2);
                        return;
                    }
                    case '\t': 
                    case ' ': 
                    case ':': {
                        break block11;
                    }
                    default: {
                        cArray[n4++] = c;
                        break;
                    }
                }
            }
            charBuffer.setLength(n4);
            boolean bl = false;
            while (c == ' ' || c == '\t' || c == ':' && !bl) {
                if (c == ':') {
                    bl = true;
                }
                if (n2 >= n3) {
                    n3 = readStream.fillBuffer();
                    if (n3 < 0) {
                        return;
                    }
                    n2 = 0;
                }
                c = (char)(byArray[n2++] & 0xFF);
            }
            CharBuffer charBuffer2 = this.headerValues[this.headerSize];
            cArray = charBuffer2.getBuffer();
            n4 = 0;
            int n5 = 0;
            block13: while (true) {
                switch (c) {
                    case '\r': {
                        if (n2 >= n3) {
                            n3 = readStream.fillBuffer();
                            if (n3 < 0) {
                                return;
                            }
                            n2 = 0;
                        }
                        c = (char)(byArray[n2++] & 0xFF);
                    }
                    case '\n': {
                        readStream.setOffset(n3);
                        break block13;
                    }
                    case '\t': 
                    case ' ': {
                        cArray[n4++] = c;
                        if (n4 < cArray.length) break;
                        charBuffer2.setLength(n4);
                        charBuffer2.ensureCapacity(cArray.length + 1);
                        cArray = charBuffer2.getBuffer();
                        break;
                    }
                    default: {
                        cArray[n4++] = c;
                        n5 = n4;
                        if (n4 < cArray.length) break;
                        charBuffer2.setLength(n4);
                        charBuffer2.ensureCapacity(cArray.length + 1);
                        cArray = charBuffer2.getBuffer();
                        break;
                    }
                }
                if (n2 >= n3) {
                    n2 = 0;
                    n3 = readStream.fillBuffer();
                    if (n3 < 0) break;
                }
                c = (char)(byArray[n2++] & 0xFF);
            }
            charBuffer2.setLength(n5);
            ++this.headerSize;
            if (!dbg.canWrite()) continue;
            dbg.println(charBuffer + ": " + charBuffer2);
        }
    }

    private void resizeHeaders() {
        int n = this.headerCapacity * 2;
        CharBuffer[] charBufferArray = new CharBuffer[n];
        CharBuffer[] charBufferArray2 = new CharBuffer[n];
        int n2 = 0;
        while (n2 < this.headerCapacity) {
            charBufferArray[n2] = this.headerKeys[n2];
            charBufferArray2[n2] = this.headerValues[n2];
            ++n2;
        }
        n2 = this.headerCapacity;
        while (n2 < n) {
            charBufferArray[n2] = new CharBuffer();
            charBufferArray2[n2] = new CharBuffer();
            ++n2;
        }
        this.headerKeys = charBufferArray;
        this.headerValues = charBufferArray2;
        this.headerCapacity = n;
    }

    private boolean isWhitespace(int n) {
        return n == 32 || n == 9 || n == 10 || n == 13;
    }

    public String getScheme() {
        return this.scheme.toString();
    }

    public CharBuffer getMethodBuffer() {
        return this.method;
    }

    CharBuffer getHost() {
        if (this.host.length() != 0) {
            return this.host;
        }
        CharBuffer charBuffer = this.getHeaderBuffer(hostCb);
        if (charBuffer == null) {
            return null;
        }
        this.host.clear();
        this.host.append(charBuffer);
        return this.host;
    }

    public CharBuffer getPageUriBuffer() {
        return this.uri;
    }

    public CharBuffer getPageQueryBuffer() {
        return this.queryString;
    }

    public String getQueryString() {
        if (this.queryString.length() == 0) {
            return null;
        }
        return this.queryString.toString();
    }

    public CharBuffer getProtocolBuffer() {
        return this.protocol;
    }

    public void setHeader(String string, String string2) {
        this.headerKeys[this.headerSize].clear();
        this.headerKeys[this.headerSize].append(string);
        this.headerValues[this.headerSize].clear();
        this.headerValues[this.headerSize].append(string2);
        ++this.headerSize;
    }

    public CharBuffer getHeaderBuffer(String string) {
        int n = this.headerSize;
        int n2 = 0;
        while (n2 < n) {
            CharBuffer charBuffer = this.headerKeys[n2];
            if (charBuffer.equalsIgnoreCase(string)) {
                return this.headerValues[n2];
            }
            ++n2;
        }
        return null;
    }

    public CharBuffer getHeaderBuffer(CharBuffer charBuffer) {
        int n = this.headerSize;
        int n2 = 0;
        while (n2 < n) {
            CharBuffer charBuffer2 = this.headerKeys[n2];
            if (charBuffer2.equalsIgnoreCase(charBuffer)) {
                return this.headerValues[n2];
            }
            ++n2;
        }
        return null;
    }

    public void getHeaderBuffers(ArrayList arrayList, String string) {
        this.cb.clear();
        this.cb.append(string);
        int n = this.headerSize;
        int n2 = 0;
        while (n2 < n) {
            CharBuffer charBuffer = this.headerKeys[n2];
            if (charBuffer.equalsIgnoreCase(this.cb)) {
                arrayList.add(this.headerValues[n2]);
            }
            ++n2;
        }
    }

    public Enumeration getHeaders(String string) {
        this.cb.clear();
        this.cb.append(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.headerSize;
        int n2 = 0;
        while (n2 < n) {
            CharBuffer charBuffer = this.headerKeys[n2];
            if (charBuffer.equalsIgnoreCase(this.cb)) {
                CharBuffer charBuffer2 = this.headerValues[n2];
                String string2 = charBuffer2.toString();
                arrayList.add(string2);
            }
            ++n2;
        }
        return Collections.enumeration(arrayList);
    }

    public Enumeration getHeaderNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.headerSize) {
            String string = this.headerKeys[n].toString();
            int n2 = 0;
            while (n2 < arrayList.size()) {
                String string2 = (String)arrayList.get(n2);
                if (string.equals(string2)) break;
                ++n2;
            }
            if (n2 == arrayList.size()) {
                arrayList.add(n2, string);
            }
            ++n;
        }
        return Collections.enumeration(arrayList);
    }

    public String getServerName() {
        CharBuffer charBuffer = this.getHost();
        if (charBuffer == null) {
            InetAddress inetAddress = this.conn.getRemoteAddress();
            return inetAddress.getHostName();
        }
        int n = charBuffer.indexOf(':');
        if (n >= 0) {
            return charBuffer.substring(0, n);
        }
        return charBuffer.toString();
    }

    public int getServerPort() {
        CharBuffer charBuffer = this.getHost();
        if (charBuffer == null) {
            return this.conn.getLocalPort();
        }
        int n = charBuffer.indexOf(':');
        if (n >= 0) {
            return Integer.parseInt(charBuffer.substring(n + 1));
        }
        return this.conn.getLocalPort();
    }

    public String getRemoteAddr() {
        InetAddress inetAddress = this.conn.getRemoteAddress();
        return inetAddress.getHostAddress();
    }

    public void getRemoteAddr(CharBuffer charBuffer) {
        InetAddress inetAddress = this.conn.getRemoteAddress();
        byte[] byArray = inetAddress.getAddress();
        int n = 0;
        while (n < byArray.length) {
            if (n != 0) {
                charBuffer.append('.');
            }
            charBuffer.append(byArray[n] & 0xFF);
            ++n;
        }
    }

    public String getRemoteHost() {
        InetAddress inetAddress = this.conn.getRemoteAddress();
        return inetAddress.getHostName();
    }

    void setSecure(boolean bl) {
        this.bogusSecure = bl;
    }

    HttpRequest(ServletServer servletServer) {
        super(servletServer);
        this.response = new HttpResponse(this);
        this.charBuf = new char[1024];
        this.uri = new CharBuffer();
        this.uri.ensureCapacity(1024);
        this.cb = new CharBuffer();
        this.method = new CharBuffer();
        this.host = new CharBuffer();
        this.protocol = new CharBuffer();
        this.scheme = new CharBuffer("http");
        this.queryString = new CharBuffer();
        this.queryString.ensureCapacity(1024);
        this.headerCapacity = 32;
        this.headerSize = 0;
        this.headerKeys = new CharBuffer[this.headerCapacity];
        this.headerValues = new CharBuffer[this.headerCapacity];
        int n = 0;
        while (n < this.headerCapacity) {
            this.headerKeys[n] = new CharBuffer();
            this.headerKeys[n].ensureCapacity(128);
            this.headerValues[n] = new CharBuffer();
            this.headerValues[n].ensureCapacity(256);
            ++n;
        }
    }
}

