/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.Application;
import com.caucho.server.http.Authenticator;
import com.caucho.server.http.CauchoApplication;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.Invocation;
import com.caucho.server.http.PageCache;
import com.caucho.server.http.QNamedDispatcher;
import com.caucho.server.http.QRequestDispatcher;
import com.caucho.server.http.QServletConfig;
import com.caucho.server.http.Response;
import com.caucho.util.Base64;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.QDate;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;

abstract class AbstractRequest
implements CauchoRequest {
    static WriteStream dbg = LogStream.open("/caucho.com/http/invocation");
    static WriteStream dbgAuth = LogStream.open("/caucho.com/http/auth");
    private static String REQUEST_URI = "javax.servlet.include.request_uri";
    private static String CONTEXT_PATH = "javax.servlet.include.context_path";
    private static String SERVLET_PATH = "javax.servlet.include.servlet_path";
    private static String PATH_INFO = "javax.servlet.include.path_info";
    private static String QUERY_STRING = "javax.servlet.include.query_string";
    static String LOGIN_NAME = "com.caucho.servlet.login.name";
    static String LOGIN_SAVED_PATH = "com.caucho.servlet.login.path";
    static String LOGIN_SAVED_QUERY = "com.caucho.servlet.login.query";
    protected QDate calendar;
    protected Invocation invocation;
    protected PageCache.Entry cache;
    private boolean varyCookies;
    private boolean usesCookies;
    private boolean isCaching;
    private Principal userPrincipal;

    void start() {
        this.invocation = null;
        this.cache = null;
        this.varyCookies = false;
        this.usesCookies = false;
        this.isCaching = false;
        this.userPrincipal = null;
    }

    public abstract ReadStream getStream() throws IOException;

    public int getRequestDepth(int n) {
        return n + 1;
    }

    public abstract long getDate();

    public abstract ServletInputStream getInputStream() throws IOException;

    public abstract BufferedReader getReader() throws IOException;

    public abstract String getServerName();

    public abstract int getServerPort();

    public abstract String getRemoteAddr();

    public abstract String getRemoteHost();

    public abstract String getScheme();

    public CharBuffer getMethodBuffer() {
        return null;
    }

    public abstract String getMethod();

    public abstract String getProtocol();

    abstract CharBuffer getPageUriBuffer();

    public abstract String getRequestURI();

    public String getPageURI() {
        String string = (String)this.getAttribute(REQUEST_URI);
        if (string != null) {
            return string;
        }
        return this.getRequestURI();
    }

    public abstract String getContextPath();

    public String getPageContextPath() {
        String string = (String)this.getAttribute(REQUEST_URI);
        if (string != null) {
            return (String)this.getAttribute(CONTEXT_PATH);
        }
        return this.getContextPath();
    }

    public abstract String getServletPath();

    public String getPageServletPath() {
        String string = (String)this.getAttribute(REQUEST_URI);
        if (string != null) {
            return (String)this.getAttribute(SERVLET_PATH);
        }
        return this.getServletPath();
    }

    public abstract String getPathInfo();

    public String getPagePathInfo() {
        String string = (String)this.getAttribute(REQUEST_URI);
        if (string != null) {
            return (String)this.getAttribute(PATH_INFO);
        }
        return this.getPathInfo();
    }

    public abstract CharBuffer getPageQueryBuffer();

    public abstract String getQueryString();

    public String getPageQueryString() {
        String string = (String)this.getAttribute(REQUEST_URI);
        if (string != null) {
            return (String)this.getAttribute(QUERY_STRING);
        }
        return this.getQueryString();
    }

    public abstract int getContentLength();

    public abstract String getContentType();

    public abstract String getCharacterEncoding();

    public abstract String getHeader(String var1);

    public void setHeader(String string, String string2) {
    }

    Application getApplication() {
        return null;
    }

    public CauchoApplication getCauchoApplication() {
        return this.getApplication();
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getIntHeader(String string) {
        String string2 = this.getHeader(string);
        int n = string2.length();
        if (n == 0) {
            throw new IllegalArgumentException(string2);
        }
        int n2 = 0;
        int n3 = 0;
        char c = string2.charAt(n3);
        int n4 = 1;
        if (c == '+') {
            if (n3 + 1 >= n) {
                throw new IllegalArgumentException(string2);
            }
            c = string2.charAt(++n3);
        } else if (c == '-') {
            n4 = -1;
            if (n3 + 1 >= n) {
                throw new IllegalArgumentException(string2);
            }
            c = string2.charAt(++n3);
        }
        while (n3 < n && (c = string2.charAt(n3)) >= '0' && c <= '9') {
            n2 = 10 * n2 + c - 48;
            ++n3;
        }
        if (n3 < n) {
            throw new IllegalArgumentException(string2);
        }
        return n4 * n2;
    }

    public long getDateHeader(String string) {
        String string2 = this.getHeader(string);
        if (string2 == null) {
            return -1L;
        }
        long l = -1L;
        try {
            if (this.calendar == null) {
                this.calendar = new QDate();
            }
            l = this.calendar.parseDate(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (l == Long.MAX_VALUE) {
            throw new IllegalArgumentException(string2);
        }
        return l;
    }

    protected void setVaryCookies() {
        this.varyCookies = true;
    }

    protected void setUsesCookies() {
        this.usesCookies = true;
    }

    boolean getVaryCookies() {
        return this.varyCookies;
    }

    boolean getUsesCookies() {
        return this.usesCookies;
    }

    public abstract HttpSession getSession(boolean var1);

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public abstract String getRequestedSessionId();

    public abstract boolean isRequestedSessionIdValid();

    public abstract boolean isRequestedSessionIdFromCookie();

    public abstract boolean isRequestedSessionIdFromURL();

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public abstract Enumeration getHeaderNames();

    public abstract Enumeration getAttributeNames();

    public abstract Object getAttribute(String var1);

    public abstract void setAttribute(String var1, Object var2);

    public abstract void removeAttribute(String var1);

    public abstract Enumeration getParameterNames();

    public abstract String[] getParameterValues(String var1);

    public abstract String getParameter(String var1);

    public abstract Cookie[] getCookies();

    public abstract Cookie getCookie(String var1);

    public abstract String getRealPath(String var1);

    public abstract String getPathTranslated();

    public abstract Enumeration getHeaders(String var1);

    public abstract Locale getLocale();

    public abstract Enumeration getLocales();

    public abstract boolean isSecure();

    public RequestDispatcher getRequestDispatcher(String string) {
        int n;
        String string2;
        String string3;
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.charAt(0) == '/') {
            return this.getCauchoApplication().getRequestDispatcher(string);
        }
        CharBuffer charBuffer = CharBuffer.allocate();
        Application application = this.getApplication();
        if (application != null) {
            charBuffer.append(application.getContextPath());
        }
        if ((string3 = this.getPageServletPath()) != null) {
            charBuffer.append(string3);
        }
        if ((string2 = this.getPagePathInfo()) != null) {
            charBuffer.append(string2);
        }
        if ((n = charBuffer.lastIndexOf('/')) >= 0) {
            charBuffer.setLength(n);
        }
        charBuffer.append('/');
        charBuffer.append(string);
        if (application == null) {
            return this.getCauchoApplication().getRequestDispatcher(charBuffer.close());
        }
        n = charBuffer.indexOf('?');
        String string4 = null;
        if (n > 0) {
            string4 = charBuffer.substring(n + 1);
            charBuffer.setLength(n);
        }
        RequestDispatcher requestDispatcher = application.getRequestDispatcher(charBuffer, string4);
        charBuffer.free();
        return requestDispatcher;
    }

    void service(PageCache.Entry entry, CauchoResponse cauchoResponse) throws IOException, ServletException {
        this.cache = entry;
        this.service(entry.getInvocation(), cauchoResponse);
    }

    void service(Invocation invocation, CauchoResponse cauchoResponse) throws IOException, ServletException {
        RequestDispatcher requestDispatcher;
        Object object;
        Servlet servlet;
        this.invocation = invocation;
        QServletConfig qServletConfig = invocation.getServletConfig();
        Application application = invocation.getApplication();
        if (!this.authenticate(qServletConfig, cauchoResponse)) {
            return;
        }
        try {
            servlet = invocation.getServlet();
        }
        catch (ServletException servletException) {
            throw servletException;
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
        if (dbg.canWrite()) {
            dbg.log("invocation:" + invocation.getUri() + " -> (host:" + invocation.getHost().getName() + ", context:" + invocation.getContextPath() + ", servletPath:" + invocation.getServletPath() + ", pathInfo:" + invocation.getPathInfo() + ", servlet:" + (qServletConfig == null ? "null" : qServletConfig.getServletName()) + ")");
        }
        ClassLoader classLoader = CauchoSystem.getContextClassLoader();
        try {
            CauchoSystem.setContextClassLoader(application.getClassLoader());
            if (servlet == null && qServletConfig.getJspFile() != null) {
                this.setAttribute("caucho.jsp.servlet-config", qServletConfig);
                object = qServletConfig.getJspFile();
                if (((String)object).length() == 0 || ((String)object).charAt(0) != '/') {
                    object = "/" + (String)object;
                }
                this.setAttribute("caucho.jsp.jsp-file", object);
                requestDispatcher = application.getNamedDispatcher("com.caucho.jsp.JspServlet");
                requestDispatcher.forward((ServletRequest)this, (ServletResponse)cauchoResponse);
            } else if (servlet instanceof SingleThreadModel) {
                object = servlet;
                synchronized (object) {
                    servlet.service((ServletRequest)this, (ServletResponse)cauchoResponse);
                }
            } else if (servlet != null) {
                servlet.service((ServletRequest)this, (ServletResponse)cauchoResponse);
            } else {
                throw new ServletException("can't find servlet");
            }
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            CauchoSystem.setContextClassLoader(classLoader);
            throw throwable;
        }
        CauchoSystem.setContextClassLoader(classLoader);
        object = cauchoResponse.getFilter();
        if (object != null) {
            if (dbg.canWrite()) {
                dbg.log("filter: url:" + invocation.getUri() + " -> " + (String)object);
            }
            if ((requestDispatcher = (QNamedDispatcher)application.getNamedDispatcher((String)object)) == null) {
                throw new ServletException("unknown servlet filter `" + (String)object + "'");
            }
            requestDispatcher.chain(invocation, (ServletRequest)this, (ServletResponse)cauchoResponse);
        }
    }

    boolean isCacheable() {
        return this.cache != null && this.cache.isCacheable();
    }

    WriteStream allowCaching(Response response, ArrayList arrayList, ArrayList arrayList2, String string, String string2) {
        if (this.cache == null) {
            return null;
        }
        WriteStream writeStream = this.cache.startCaching(this, response, arrayList, arrayList2, string, string2);
        if (writeStream != null) {
            this.isCaching = true;
        }
        return writeStream;
    }

    void finishCaching(boolean bl) {
        if (this.isCaching) {
            this.cache.finishCaching(bl);
        }
    }

    public String getFilter(String string) {
        return this.getApplication().getFilter(string);
    }

    public String getMedia() {
        Application application = this.getApplication();
        if (application == null) {
            return null;
        }
        return application.getMedia(this);
    }

    private boolean authenticate(QServletConfig qServletConfig, CauchoResponse cauchoResponse) throws ServletException, IOException {
        Principal principal;
        if (this.invocation == null || this.invocation.security == null) {
            return true;
        }
        if (!this.invocation.security.needsAuthentication(this)) {
            return this.authorize(cauchoResponse);
        }
        if (cauchoResponse instanceof Response) {
            ((Response)cauchoResponse).setPrivateCache(true);
        }
        Application application = this.getApplication();
        HttpSession httpSession = this.getSession(false);
        if (httpSession != null && (principal = (Principal)httpSession.getValue(LOGIN_NAME)) != null) {
            return this.authorize(cauchoResponse);
        }
        if (this.getAttribute(LOGIN_NAME) != null) {
            return true;
        }
        principal = this.getCookiePrincipal();
        if (principal != null) {
            this.setAttribute(LOGIN_NAME, principal);
            return this.authorize(cauchoResponse);
        }
        this.setAttribute(LOGIN_NAME, "ok");
        String string = application.getLoginMethod();
        if (string.equals("form")) {
            if (this.invocation.getUri().endsWith("/j_security_check")) {
                return true;
            }
            String string2 = this.getServletPath();
            if (string2 == null) {
                string2 = this.getPathInfo();
            } else if (this.getPathInfo() != null) {
                string2 = string2 + this.getPathInfo();
            }
            if (string2.equals("")) {
                cauchoResponse.sendRedirect(this.getContextPath() + "/");
                return true;
            }
            if (httpSession == null) {
                httpSession = this.getSession();
            }
            httpSession.putValue(LOGIN_SAVED_PATH, (Object)string2);
            httpSession.putValue(LOGIN_SAVED_QUERY, (Object)this.getQueryString());
            RequestDispatcher requestDispatcher = application.getRequestDispatcher(application.getLoginForm());
            ((QRequestDispatcher)requestDispatcher).forwardInternal(this, cauchoResponse);
            return false;
        }
        if (string.equals("basic") && !this.authenticateBasic(cauchoResponse)) {
            return false;
        }
        return this.authorize(cauchoResponse);
    }

    private boolean authorize(CauchoResponse cauchoResponse) throws ServletException, IOException {
        if (!this.invocation.security.isAuthorized(this)) {
            cauchoResponse.sendError(403);
            return false;
        }
        return true;
    }

    public boolean authenticateBasic(CauchoResponse cauchoResponse) {
        Principal principal = this.getBasicPrincipal();
        if (principal == null) {
            return this.sendBasicChallenge(cauchoResponse);
        }
        HttpSession httpSession = this.getSession(false);
        if (httpSession != null) {
            httpSession.putValue(LOGIN_NAME, (Object)principal);
        } else {
            this.setAttribute(LOGIN_NAME, principal);
        }
        return true;
    }

    private Principal getCookiePrincipal() {
        Cookie cookie = this.getCookie("resinauthid");
        if (cookie != null) {
            String string = cookie.getValue();
            Authenticator authenticator = this.getApplication().getAuthenticator();
            Principal principal = authenticator.authenticateCookie(this, string);
            if (dbgAuth.canWrite()) {
                dbgAuth.log("cookie-auth: " + string + " -> " + principal);
            }
            if (principal != null) {
                HttpSession httpSession = this.getSession();
                httpSession.putValue(LOGIN_NAME, (Object)principal);
            }
            return principal;
        }
        return null;
    }

    private Principal getBasicPrincipal() {
        String string = this.getHeader("authorization");
        if (string == null) {
            return null;
        }
        int n = string.indexOf(32);
        if (n <= 0) {
            return null;
        }
        String string2 = Base64.decode(string.substring(n + 1));
        int n2 = string2.indexOf(58);
        if (n2 < 0) {
            return null;
        }
        String string3 = string2.substring(0, n2);
        String string4 = string2.substring(n2 + 1);
        Authenticator authenticator = this.getApplication().getAuthenticator();
        Principal principal = authenticator.authenticate(this, string3, string4);
        if (dbgAuth.canWrite()) {
            dbgAuth.log("basic: " + string3 + " -> " + principal);
        }
        return principal;
    }

    private boolean sendBasicChallenge(CauchoResponse cauchoResponse) {
        String string = this.getApplication().getLoginRealm();
        if (string == null) {
            string = "resin";
        }
        cauchoResponse.setStatus(401);
        cauchoResponse.setHeader("WWW-Authenticate", "Basic realm=\"" + string + "\"");
        return false;
    }

    public String getAuthType() {
        String string = this.getHeader("authorization");
        if (string == null) {
            return null;
        }
        int n = string.indexOf(32);
        if (n <= 0) {
            return null;
        }
        return string.substring(0, n).toLowerCase();
    }

    String getRemoteUser(boolean bl) {
        if (this.userPrincipal == null) {
            if (!bl) {
                return null;
            }
            this.getUserPrincipal();
        }
        if (this.userPrincipal != null) {
            return this.userPrincipal.getName();
        }
        return null;
    }

    public String getRemoteUser() {
        Principal principal = this.getUserPrincipal();
        if (principal != null) {
            return principal.getName();
        }
        return null;
    }

    public Principal getUserPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        Object object = this.getAttribute(LOGIN_NAME);
        if (object instanceof Principal) {
            this.userPrincipal = (Principal)object;
            return this.userPrincipal;
        }
        HttpSession httpSession = this.getSession(false);
        Principal principal = null;
        if (httpSession != null) {
            principal = (Principal)httpSession.getValue(LOGIN_NAME);
        }
        if (principal != null) {
            this.userPrincipal = principal;
            return principal;
        }
        principal = this.getCookiePrincipal();
        if (principal != null) {
            this.userPrincipal = principal;
            return principal;
        }
        principal = this.getCookiePrincipal();
        Application application = this.getApplication();
        if (application == null) {
            return null;
        }
        String string = application.getLoginMethod();
        if (string == null || string.equals("basic")) {
            this.userPrincipal = this.getBasicPrincipal();
            return this.userPrincipal;
        }
        return null;
    }

    public boolean isUserInRole(String string) {
        Authenticator authenticator;
        Application application = this.getApplication();
        Authenticator authenticator2 = authenticator = application == null ? null : application.getAuthenticator();
        if (authenticator != null) {
            Principal principal = this.getUserPrincipal();
            boolean bl = authenticator.isUserInRole(this, principal, string);
            if (dbgAuth.canWrite()) {
                if (bl) {
                    dbgAuth.log(principal + " is in role: " + string);
                } else {
                    dbgAuth.log("failed " + principal + " in role: " + string);
                }
            }
            return bl;
        }
        return false;
    }

    public abstract void resetTimeout();

    AbstractRequest() {
    }
}

