/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server;

import com.caucho.server.Connection;
import com.caucho.server.ServerRequest;
import com.caucho.server.TcpServer;
import com.caucho.util.Alarm;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CpuUsage;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.SocketStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

public class TcpConnection
extends Connection
implements Runnable {
    private static WriteStream dbg = LogStream.open("/caucho.com/tcp-server");
    public static int connOpened;
    public static int connClosed;
    private Thread thread;
    private TcpServer server;
    private ServerRequest request;
    private Socket socket;
    private SocketStream streamImpl;
    private ReadStream readStream;
    private WriteStream writeStream;
    private int interruptCount;
    private boolean isListening;
    private boolean isClosed;
    private boolean isKeepalive;
    private CpuUsage cpuUsage;
    private CpuUsage baseUsage;
    private long lastUsageTime;

    void setThread(Thread thread) {
        this.thread = thread;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.thread = Thread.currentThread();
        this.isClosed = false;
        this.isKeepalive = false;
        long l = this.server.getConnectionTimeout();
        try {
            try {
                while (!this.isClosed && (this.socket = this.accept()) != null) {
                    Object var6_2;
                    ++connOpened;
                    try {
                        try {
                            if (l > 0L) {
                                this.socket.setSoTimeout((int)l);
                            }
                            try {
                                this.streamImpl.init(this.socket);
                                this.writeStream.init(this.streamImpl);
                                this.readStream.init(this.streamImpl, this.writeStream);
                                ClassLoader classLoader = CauchoSystem.getStaticClassLoader();
                                CauchoSystem.setContextClassLoader(classLoader);
                                this.request.handleConnection(this);
                            }
                            finally {
                                Object var8_7 = null;
                                this.writeStream.setDisableClose(false);
                                this.writeStream.close();
                                this.readStream.setDisableClose(false);
                                this.readStream.close();
                            }
                            var6_2 = null;
                        }
                        catch (ClientDisconnectException clientDisconnectException) {
                            this.isClosed = true;
                            if (dbg.canWrite()) {
                                dbg.log("[" + this.getId() + "] " + clientDisconnectException);
                            }
                            var6_2 = null;
                            this.socket.close();
                            ++connClosed;
                            continue;
                        }
                        catch (IOException iOException) {
                            this.isClosed = true;
                            if (dbg.canWrite()) {
                                dbg.log("[" + this.getId() + "] " + iOException);
                                dbg.log(iOException);
                            }
                            var6_2 = null;
                            this.socket.close();
                            ++connClosed;
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        var6_2 = null;
                        this.socket.close();
                        ++connClosed;
                        throw throwable;
                    }
                    this.socket.close();
                    ++connClosed;
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (dbg.canWrite()) {
                    dbg.log(outOfMemoryError);
                }
                this.server.close();
                Object var4_13 = null;
                this.thread = null;
                if (this.isKeepalive) {
                    this.isKeepalive = false;
                    this.server.freeKeepalive();
                }
                this.server.stopConnection(this);
                return;
            }
            catch (Throwable throwable) {
                if (dbg.canWrite()) {
                    dbg.log(throwable);
                }
                this.isClosed = true;
                return;
            }
            Object var4_12 = null;
            this.thread = null;
            if (this.isKeepalive) {
                this.isKeepalive = false;
                this.server.freeKeepalive();
            }
            this.server.stopConnection(this);
            return;
        }
        finally {
            Object var4_14 = null;
            this.thread = null;
            if (this.isKeepalive) {
                this.isKeepalive = false;
                this.server.freeKeepalive();
            }
            this.server.stopConnection(this);
        }
    }

    private Socket accept() {
        super.setIdle();
        if (this.isKeepalive) {
            this.isKeepalive = false;
            this.server.freeKeepalive();
        }
        this.interruptCount = 0;
        this.isListening = true;
        this.socket = null;
        this.setAccessTime(-1L);
        long l = Alarm.getCurrentTime();
        if (this.lastUsageTime + 5000L < l) {
            this.lastUsageTime = l;
        }
        Socket socket = this.server.accept(this);
        l = Alarm.getCurrentTime();
        this.isListening = false;
        this.setAccessTime(l);
        return socket;
    }

    public boolean isBusy() {
        return this.server.isBusy();
    }

    public boolean allocateKeepalive() {
        if (this.isKeepalive) {
            return true;
        }
        this.isKeepalive = this.interruptCount == 0 && this.server.allocateKeepalive();
        return this.isKeepalive;
    }

    public void setActive() {
        super.setActive();
        if (this.isKeepalive) {
            this.isKeepalive = false;
            this.server.freeKeepalive();
        }
    }

    void setSocket(Socket socket) throws IOException {
        this.socket = socket;
    }

    Socket getSocket() {
        return this.socket;
    }

    boolean isListening() {
        return this.isListening;
    }

    void updateUsage(CpuUsage cpuUsage) {
        cpuUsage.add(this.baseUsage, this.cpuUsage);
    }

    void interrupt() {
    }

    int getInterrupts() {
        return this.interruptCount;
    }

    void setClosed() {
    }

    boolean isClosed() {
        return this.isClosed;
    }

    public boolean isInterrupted() {
        return this.interruptCount > 0;
    }

    public ReadStream getReadStream() throws IOException {
        return this.readStream;
    }

    public WriteStream getWriteStream() throws IOException {
        return this.writeStream;
    }

    public InetAddress getLocalAddress() {
        try {
            return this.socket.getLocalAddress();
        }
        catch (Exception exception) {
            try {
                return InetAddress.getLocalHost();
            }
            catch (Exception exception2) {
                try {
                    return InetAddress.getByName("127.0.0.1");
                }
                catch (Exception exception3) {
                    return null;
                }
            }
        }
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public InetAddress getRemoteAddress() {
        return this.socket.getInetAddress();
    }

    public int getRemotePort() {
        return this.socket.getPort();
    }

    Thread getThread() {
        return this.thread;
    }

    TcpConnection(TcpServer tcpServer, ServerRequest serverRequest) {
        this.server = tcpServer;
        this.request = serverRequest;
        this.readStream = new ReadStream();
        this.writeStream = new WriteStream();
        this.streamImpl = new SocketStream(null);
        this.cpuUsage = CpuUsage.create();
        this.baseUsage = CpuUsage.create();
    }
}

