/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.regexp;

import com.caucho.regexp.IllegalRegexpException;
import com.caucho.regexp.Node;
import com.caucho.regexp.PeekString;
import com.caucho.regexp.RegOptim;
import com.caucho.regexp.Regcomp;
import com.caucho.regexp.RegexpSet;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharCursor;
import com.caucho.util.IntArray;
import com.caucho.util.StringCharCursor;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.util.ArrayList;

public class Regexp {
    static WriteStream dbg = LogStream.open("/caucho.com/regexp");
    public static final int FAIL = -1;
    String pattern;
    Node prog;
    boolean ignoreCase;
    boolean isGlobal;
    int first;
    int start;
    StringCharCursor stringCursor;
    int nLoop;
    int[] loopCount;
    int[] loopTail;
    int nGroup;
    int[] groupStart;
    IntArray group;
    int match;
    int lexeme;
    CharBuffer cb;
    CharBuffer prefix;
    int minLength;
    CharCursor lastCursor;
    int lastIndex;

    public String getPattern() {
        return this.pattern;
    }

    private void compile(Node node, Regcomp regcomp) {
        this.ignoreCase = (regcomp.flags & 4) != 0;
        boolean bl = this.isGlobal = (regcomp.flags & 0x10) != 0;
        if (this.ignoreCase) {
            RegOptim.ignoreCase(node);
        }
        if (!this.ignoreCase) {
            RegOptim.eliminateBacktrack(node, null);
        }
        this.minLength = RegOptim.minLength(node);
        this.prefix = RegOptim.prefix(node);
        this.prog = RegOptim.linkLoops(node);
        this.nGroup = regcomp.maxGroup;
        this.nLoop = regcomp.nLoop;
        this.groupStart = new int[this.nGroup + 1];
        this.loopCount = new int[this.nLoop];
        this.loopTail = new int[this.nLoop];
        this.cb = new CharBuffer();
        this.stringCursor = new StringCharCursor("");
        this.group = new IntArray();
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public boolean ignoreCase() {
        return this.ignoreCase;
    }

    public int exec(CharCursor charCursor, int n, int n2) {
        int n3;
        this.start = n;
        this.first = n2;
        charCursor.setIndex(n2);
        int n4 = charCursor.getIndex();
        int n5 = -1;
        if (n4 >= n2) {
            do {
                this.group.setLength(0);
                n5 = this.match(this.prog, charCursor);
                if (n5 != -1) break;
                charCursor.setIndex(n4 + 1);
                n4 = charCursor.getIndex();
            } while (charCursor.current() != '\uffff');
        }
        if ((n3 = charCursor.getIndex()) < n4) {
            n4 = n3;
        }
        if (this.group.size() < 2) {
            this.group.setLength(2);
        }
        this.group.set(0, n4);
        this.group.set(1, n3);
        return n5;
    }

    public int exec(String string, int n) {
        this.stringCursor.init(string);
        return this.exec(this.stringCursor, 0, n);
    }

    public int exec(CharBuffer charBuffer, int n) {
        this.stringCursor.init(charBuffer.toString());
        return this.exec(this.stringCursor, 0, n);
    }

    public int exec(CharCursor charCursor) {
        int n = 0;
        if (charCursor == this.lastCursor) {
            n = this.lastIndex;
        }
        this.lastCursor = charCursor;
        int n2 = this.exec(charCursor, 0, n);
        this.lastIndex = n2 == -1 ? 0 : (this.getBegin(0) == this.getEnd(0) ? this.getEnd(0) + 1 : this.getEnd(0));
        return n2;
    }

    private int match(Node node, CharCursor charCursor) {
        while (node != null) {
            switch (node.code) {
                case 1: {
                    node = node.rest;
                    break;
                }
                case 0: 
                case 28: {
                    this.lexeme = node.index;
                    return node.index;
                }
                case 2: {
                    int n2 = node.string.length();
                    if (charCursor.regionMatches(node.string.getBuffer(), 0, n2)) {
                        node = node.rest;
                        break;
                    }
                    return -1;
                }
                case 24: {
                    int n2 = node.string.length();
                    if (charCursor.regionMatchesIgnoreCase(node.string.getBuffer(), 0, n2)) {
                        node = node.rest;
                        break;
                    }
                    return -1;
                }
                case 3: {
                    char c = charCursor.read();
                    if (c != '\uffff' && node.set.match(c)) {
                        node = node.rest;
                        break;
                    }
                    return -1;
                }
                case 25: {
                    char c = charCursor.read();
                    if (c == '\uffff') {
                        return -1;
                    }
                    char c2 = Character.toLowerCase(c);
                    char c3 = Character.toUpperCase(c2);
                    if (node.set.match(c2) || node.set.match(c3)) {
                        node = node.rest;
                        break;
                    }
                    return -1;
                }
                case 4: {
                    char c = charCursor.read();
                    if (c != '\uffff' && !node.set.match(c)) {
                        node = node.rest;
                        break;
                    }
                    return -1;
                }
                case 26: {
                    char c = charCursor.read();
                    if (c == '\uffff') {
                        return -1;
                    }
                    char c2 = Character.toLowerCase(c);
                    char c3 = Character.toUpperCase(c2);
                    if (!node.set.match(c2) && !node.set.match(c3)) {
                        node = node.rest;
                        break;
                    }
                    return -1;
                }
                case 5: {
                    this.groupStart[node.index] = charCursor.getIndex();
                    node = node.rest;
                    break;
                }
                case 6: {
                    int n = 2 * node.index;
                    if (this.group.size() <= n + 1) {
                        this.group.setLength(n + 2);
                    }
                    this.group.set(2 * node.index, this.groupStart[node.index]);
                    this.group.set(2 * node.index + 1, charCursor.getIndex());
                    node = node.rest;
                    break;
                }
                case 7: {
                    int n = this.group.get(2 * node.index);
                    int n2 = this.group.get(2 * node.index + 1) - this.group.get(2 * node.index);
                    this.cb.setLength(0);
                    charCursor.subseq(this.cb, n, n + n2);
                    if (charCursor.regionMatches(this.cb.getBuffer(), 0, n2)) {
                        node = node.rest;
                        break;
                    }
                    return -1;
                }
                case 27: {
                    int n = this.group.get(2 * node.index);
                    int n2 = this.group.get(2 * node.index + 1) - this.group.get(2 * node.index);
                    this.cb.setLength(0);
                    charCursor.subseq(this.cb, n, n + n2);
                    if (charCursor.regionMatchesIgnoreCase(this.cb.getBuffer(), 0, n2)) {
                        charCursor.skip(n2);
                        node = node.rest;
                        break;
                    }
                    return -1;
                }
                case 9: {
                    this.loopCount[node.rest.index] = 0;
                    this.loopTail[node.rest.index] = -1;
                    node = node.rest;
                    break;
                }
                case 8: {
                    int n = charCursor.getIndex();
                    int n3 = node.index;
                    int n4 = this.loopCount[n3];
                    this.loopCount[n3] = n4 + 1;
                    if (n4 < node.min) {
                        node = node.branch;
                        break;
                    }
                    if (this.loopCount[node.index] > node.max) {
                        node = node.rest;
                        break;
                    }
                    if (this.loopTail[node.index] == n) {
                        return -1;
                    }
                    this.loopTail[node.index] = n;
                    int n5 = this.group.size();
                    char c = charCursor.current();
                    if (c == '\uffff') {
                        node = node.rest;
                        break;
                    }
                    if (node.set != null && node.set.match(c)) {
                        node = node.branch;
                        break;
                    }
                    int n6 = this.match(node.branch, charCursor);
                    if (n6 != -1) {
                        return n6;
                    }
                    charCursor.setIndex(n);
                    this.group.setLength(n5);
                    node = node.rest;
                    break;
                }
                case 10: {
                    int n = charCursor.getIndex();
                    int n7 = node.index;
                    int n8 = this.loopCount[n7];
                    this.loopCount[n7] = n8 + 1;
                    if (n8 < node.min) {
                        node = node.branch;
                        break;
                    }
                    if (this.loopCount[node.index] > node.max) {
                        node = node.rest;
                        break;
                    }
                    int n6 = this.match(node.rest, charCursor);
                    if (n6 != -1) {
                        return n6;
                    }
                    if (this.loopTail[node.index] == n) {
                        return -1;
                    }
                    this.loopTail[node.index] = n;
                    charCursor.setIndex(n);
                    node = node.branch;
                    break;
                }
                case 11: {
                    int n = node.index;
                    int n9 = this.loopCount[n];
                    this.loopCount[n] = n9 + 1;
                    if (n9 < node.min) {
                        node = node.branch;
                        break;
                    }
                    if (this.loopCount[node.index] > node.max) {
                        node = node.rest;
                        break;
                    }
                    char c = charCursor.current();
                    if (c == '\uffff') {
                        node = node.rest;
                        break;
                    }
                    if (node.set.match(c)) {
                        node = node.branch;
                        break;
                    }
                    node = node.rest;
                    break;
                }
                case 13: {
                    this.match = this.group.size();
                    int n = charCursor.getIndex();
                    int n6 = this.match(node.branch, charCursor);
                    if (n6 != -1) {
                        return n6;
                    }
                    charCursor.setIndex(n);
                    this.group.setLength(this.match);
                    node = node.rest;
                    break;
                }
                case 14: {
                    char c = charCursor.current();
                    if (c == '\uffff') {
                        node = node.rest;
                        break;
                    }
                    if (node.set.match(c)) {
                        node = node.branch;
                        break;
                    }
                    node = node.rest;
                    break;
                }
                case 15: {
                    int n = charCursor.getIndex();
                    if (this.match(node.branch, charCursor) == -1) {
                        return -1;
                    }
                    charCursor.setIndex(n);
                    node = node.rest;
                    break;
                }
                case 16: {
                    int n = charCursor.getIndex();
                    if (this.match(node.branch, charCursor) != -1) {
                        return -1;
                    }
                    charCursor.setIndex(n);
                    node = node.rest;
                    break;
                }
                case 19: {
                    if (charCursor.getIndex() == this.start) {
                        node = node.rest;
                        break;
                    }
                    if (charCursor.previous() == '\n') {
                        charCursor.next();
                        node = node.rest;
                        break;
                    }
                    charCursor.next();
                    return -1;
                }
                case 20: {
                    if (charCursor.current() == '\uffff' || charCursor.current() == '\n') {
                        node = node.rest;
                        break;
                    }
                    return -1;
                }
                case 23: {
                    if (charCursor.getIndex() == this.first) {
                        node = node.rest;
                        break;
                    }
                    return -1;
                }
                case 21: {
                    if (charCursor.getIndex() == this.start) {
                        node = node.rest;
                        break;
                    }
                    return -1;
                }
                case 22: {
                    if (charCursor.current() == '\uffff') {
                        node = node.rest;
                        break;
                    }
                    return -1;
                }
                case 17: {
                    int n = charCursor.getIndex();
                    if ((n != this.start && RegexpSet.WORD.match(charCursor.prev())) != (charCursor.current() != '\uffff' && RegexpSet.WORD.match(charCursor.current()))) {
                        node = node.rest;
                        break;
                    }
                    return -1;
                }
                case 18: {
                    int n = charCursor.getIndex();
                    if ((n != this.start && RegexpSet.WORD.match(charCursor.prev())) == (charCursor.current() != '\uffff' && RegexpSet.WORD.match(charCursor.current()))) {
                        node = node.rest;
                        break;
                    }
                    return -1;
                }
                default: {
                    throw new RuntimeException("Internal error");
                }
            }
        }
        return 0;
    }

    public int getBegin(int n) {
        if (this.group.size() < 2 * n) {
            return 0;
        }
        return this.group.get(2 * n);
    }

    public int getEnd(int n) {
        if (this.group.size() < 2 * n + 1) {
            return 0;
        }
        return this.group.get(2 * n + 1);
    }

    public int length() {
        return this.group.size() / 2;
    }

    public boolean match(String string) {
        return this.exec(string, 0) != -1;
    }

    public ArrayList split(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            if (this.exec(string, n) == -1) {
                arrayList.add(string.substring(n));
                break;
            }
            arrayList.add(string.substring(n, this.getBegin(0)));
            n = this.getBegin(0) != this.getEnd(0) ? this.getEnd(0) : this.getEnd(0) + 1;
        }
        return arrayList;
    }

    public CharBuffer replace(String string, String string2, CharBuffer charBuffer) {
        charBuffer.clear();
        int n = 0;
        while (n < string2.length()) {
            char c = string2.charAt(n);
            if (c != '$' || n == string2.length() - 1) {
                charBuffer.append(c);
            } else {
                c = string2.charAt(n + 1);
                if (c >= '0' && c <= '9') {
                    int n2 = c - 48;
                    if (n2 < this.length()) {
                        charBuffer.append(string.substring(this.getBegin(n2), this.getEnd(n2)));
                    }
                    ++n;
                } else if (c == '$') {
                    charBuffer.append('$');
                    ++n;
                } else {
                    charBuffer.append('$');
                }
            }
            ++n;
        }
        return charBuffer;
    }

    public String replace(String string, String string2) {
        return this.replace(string, string2, this.cb).toString();
    }

    public CharBuffer fill(String string, String string2, CharBuffer charBuffer) {
        charBuffer.clear();
        int n = 0;
        while (n < string2.length()) {
            char c = string2.charAt(n);
            if (c != '$' || n == string2.length() - 1) {
                charBuffer.append(c);
            } else {
                c = string2.charAt(n + 1);
                if (c >= '0' && c <= '9') {
                    int n2 = c - 48;
                    if (n2 < this.length()) {
                        charBuffer.append(string.substring(this.getBegin(n2), this.getEnd(n2)));
                    }
                    ++n;
                } else if (c == '$') {
                    charBuffer.append('$');
                    ++n;
                } else {
                    charBuffer.append('$');
                }
            }
            ++n;
        }
        return charBuffer;
    }

    public String fill(String string, String string2) {
        return this.replace(string, string2, this.cb).toString();
    }

    public String toString() {
        return "[Regexp " + this.pattern + "]";
    }

    public Regexp(String string, String string2) throws IllegalRegexpException {
        this.pattern = string;
        int n = 0;
        int n2 = 0;
        while (string2 != null && n2 < string2.length()) {
            switch (string2.charAt(n2)) {
                case 'm': {
                    n |= 1;
                    break;
                }
                case 's': {
                    n |= 2;
                    break;
                }
                case 'i': {
                    n |= 4;
                    break;
                }
                case 'x': {
                    n |= 8;
                    break;
                }
                case 'g': {
                    n |= 0x10;
                    break;
                }
            }
            ++n2;
        }
        Regcomp regcomp = new Regcomp(n);
        this.prog = regcomp.parse(new PeekString(string));
        this.compile(this.prog, regcomp);
    }

    public Regexp(String string) throws IllegalRegexpException {
        this(string, null);
    }

    public Regexp(Node node, Regcomp regcomp) {
        this.compile(node, regcomp);
    }
}

