/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.jsp.QJspFactory;
import com.caucho.jsp.XslManager;
import com.caucho.server.http.CauchoApplication;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.Http;
import com.caucho.util.CauchoSystem;
import com.caucho.util.Registry;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.Pwd;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.Html;
import com.caucho.xml.Xml;
import com.caucho.xml.XmlParser;
import com.caucho.xml.XmlUtil;
import com.caucho.xpath.XPath;
import com.caucho.xpath.XPathParseException;
import com.caucho.xsl.CacheableDocument;
import com.caucho.xsl.Stylesheet;
import java.io.IOException;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.PageContext;
import org.w3c.dom.Document;
import org.w3c.dom.ProcessingInstruction;

public class XslFilter
extends GenericServlet {
    private static WriteStream dbg = LogStream.open("/caucho.com/xtp/filter");
    static final String COPYRIGHT = "Copyright (c)(c) 1998-1999 Caucho Technology.  All rights reserved.";
    private CauchoApplication application;
    private XslManager xslManager;
    private boolean isStrictXsl;
    private boolean isStrictXml;

    public void init(ServletConfig servletConfig) throws ServletException {
        String string;
        Object object;
        Object object2;
        super.init(servletConfig);
        if (Registry.getRegistry() == null) {
            try {
                object2 = servletConfig.getInitParameter("resin.conf");
                if (object2 == null) {
                    object2 = CauchoSystem.getResinConfig();
                }
                object = Registry.parse(Pwd.lookupNative((String)object2));
                Registry.setDefault((RegistryNode)object);
                dbg = LogStream.open("/caucho.com/xtp/filter");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.application = (object2 = servletConfig.getServletContext()) instanceof CauchoApplication ? (CauchoApplication)object2 : Http.createApplicationAdapter(object2);
        this.xslManager = new XslManager();
        object = servletConfig.getInitParameter("strict-xsl");
        if (object != null && !((String)object).equals("false") && !((String)object).equals("no")) {
            this.isStrictXsl = true;
        }
        if ((string = servletConfig.getInitParameter("strict-xml")) == null || string.equals("true") || string.equals("yes")) {
            this.isStrictXml = true;
        }
        this.xslManager.setStrictXsl(this.isStrictXsl);
        JspFactory.setDefaultFactory(QJspFactory.create());
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        long l;
        CacheableDocument cacheableDocument;
        Stylesheet stylesheet;
        CauchoResponse cauchoResponse;
        CauchoRequest cauchoRequest;
        block19: {
            Object object;
            cauchoRequest = (CauchoRequest)servletRequest;
            cauchoResponse = (CauchoResponse)servletResponse;
            Document document = null;
            ReadStream readStream = cauchoRequest.getStream();
            try {
                if (this.isStrictXml) {
                    document = new Xml().parse(readStream);
                } else {
                    object = new Html();
                    ((XmlParser)object).setEntitiesAsText(true);
                    ((XmlParser)object).setAutodetectXml(true);
                    document = ((XmlParser)object).parse(readStream);
                }
            }
            catch (Exception exception) {
                throw new ServletException((Throwable)exception);
            }
            object = (String)servletRequest.getAttribute("caucho.xsl.stylesheet");
            if (object == null) {
                object = this.getStylesheetHref(document);
            }
            if (object == null) {
                object = "default.xsl";
            }
            if (dbg.canWrite()) {
                dbg.log("formatting with " + (String)object);
            }
            try {
                stylesheet = this.xslManager.get((String)object, cauchoRequest);
            }
            catch (Exception exception) {
                throw new ServletException((Throwable)exception);
            }
            JspFactory jspFactory = JspFactory.getDefaultFactory();
            PageContext pageContext = jspFactory.getPageContext((Servlet)this, (ServletRequest)cauchoRequest, (ServletResponse)cauchoResponse, stylesheet.getErrorPage(), false, 0, false);
            Path path = this.application.getAppDir();
            String string6 = this.application.getRealPath(cauchoRequest.getPageServletPath());
            path = path.lookupNative(string6);
            try {
                cacheableDocument = stylesheet.transformCacheable(document, null, path.getParent(), pageContext);
            }
            catch (Exception exception) {
                throw new ServletException((Throwable)exception);
            }
            cauchoResponse.setContentType(stylesheet.getContentType());
            l = -1L;
            string5 = cauchoRequest.getHeader("ETag");
            string4 = cauchoRequest.getHeader("Last-Modified");
            string3 = cauchoRequest.getHeader("Cache-Control");
            string2 = cauchoRequest.getHeader("Pragma");
            try {
                l = cauchoRequest.getDateHeader("Expires");
            }
            catch (Exception exception) {
                if (!dbg.canWrite()) break block19;
                dbg.log(exception);
            }
        }
        if (l > cauchoRequest.getDate()) {
            cauchoResponse.setDateHeader("Expires", l);
        }
        if (string5 != null) {
            cauchoResponse.setHeader("ETag", string5);
        }
        if (string4 != null) {
            cauchoResponse.setHeader("Last-Modified", string4);
        }
        if (string3 != null) {
            cauchoResponse.setHeader("Cache-Control", string3);
        }
        if (string2 != null) {
            cauchoResponse.setHeader("Pragma", string2);
        }
        if ((string = stylesheet.getOutputAttribute("encoding")) != null) {
            cauchoResponse.getStream().setEncoding(string);
        }
        stylesheet.print(cauchoResponse.getStream(), cacheableDocument.getDocument());
    }

    private String getStylesheetHref(Document document) throws XPathParseException {
        ProcessingInstruction processingInstruction = null;
        processingInstruction = (ProcessingInstruction)XPath.find("//processing-instruction('xml-stylesheet')", document);
        if (processingInstruction == null) {
            return null;
        }
        String string = processingInstruction.getNodeValue();
        return XmlUtil.getPIAttribute(string, "href");
    }

    public String getServletInfo() {
        return "XSL Filter";
    }
}

