/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java;

import com.caucho.java.ErrorParser;
import com.caucho.java.JavaCompileException;
import com.caucho.java.JavacErrorParser;
import com.caucho.java.LineMap;
import com.caucho.regexp.Regexp;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.DynamicClassLoader;
import com.caucho.util.Registry;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.MemoryStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.Pwd;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import sun.tools.javac.Main;

public class JavaCompiler {
    static Integer LOCK = new Integer(0);
    static WriteStream dbg = LogStream.open("/caucho.com/java");
    private ClassLoader loader;
    private String classPath;
    private String charEncoding;
    private String compiler;
    private String srcDirName;
    private String classDirName;
    private Path srcDir;
    private Path classDir;
    private ArrayList args;

    public static JavaCompiler create(ClassLoader classLoader) {
        return new JavaCompiler(classLoader);
    }

    public static String mangleName(String string) {
        CharBuffer charBuffer = new CharBuffer();
        charBuffer.append("_");
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '/' || c == CauchoSystem.getPathSeparatorChar()) {
                if (n != 0 && charBuffer.charAt(charBuffer.length() - 1) != '.') {
                    charBuffer.append("._");
                }
            } else if (c == '.') {
                charBuffer.append("__");
            } else if (c == '_') {
                charBuffer.append("_0");
            } else if (Character.isJavaIdentifierPart(c)) {
                charBuffer.append(c);
            } else if (c <= '\u0100') {
                charBuffer.append("_2" + JavaCompiler.encodeHex(c >> 4) + JavaCompiler.encodeHex(c));
            } else {
                charBuffer.append("_4" + JavaCompiler.encodeHex(c >> 12) + JavaCompiler.encodeHex(c >> 8) + JavaCompiler.encodeHex(c >> 4) + JavaCompiler.encodeHex(c));
            }
            ++n;
        }
        if (charBuffer.length() == 0) {
            charBuffer.append("_z");
        }
        return charBuffer.toString();
    }

    private static char encodeHex(int n) {
        if ((n &= 0xF) < 10) {
            return (char)(n + 48);
        }
        return (char)(n - 10 + 97);
    }

    public void setEncoding(String string) {
        this.charEncoding = Encoding.getJavaName(string);
    }

    public void setArgs(ArrayList arrayList) {
        if (arrayList == null) {
            return;
        }
        if (this.args == null) {
            this.args = new ArrayList();
        }
        int n = 0;
        while (n < arrayList.size()) {
            this.args.add(arrayList.get(n));
            ++n;
        }
    }

    public void compile(String string, LineMap lineMap) throws Exception {
        ClassLoader classLoader;
        if (this.loader instanceof DynamicClassLoader && (classLoader = ((DynamicClassLoader)this.loader).getParentLoader()) instanceof DynamicClassLoader) {
            ((DynamicClassLoader)classLoader).makeAll();
        }
        int n = string.lastIndexOf(46);
        String string2 = string.substring(0, n);
        String string3 = string2 + ".java";
        Path path = this.srcDir.lookup(string3);
        String string4 = string2 + ".class";
        Path path2 = this.classDir.lookup(string4);
        Integer n2 = LOCK;
        synchronized (n2) {
            if (path.canRead() && path2.exists()) {
                path2.remove();
            }
            if (this.compiler == null || this.compiler.equals("internal")) {
                this.compileInternal(string, lineMap);
            } else {
                this.compileExternal(this.compiler, string, lineMap);
            }
        }
        Thread.currentThread();
        if (Thread.interrupted()) {
            throw new InterruptedException("timeout during compilation");
        }
    }

    private void compileInternal(String string, LineMap lineMap) throws Exception {
        MemoryStream memoryStream = new MemoryStream();
        WriteStream writeStream = new WriteStream(memoryStream);
        try {
            String[] stringArray;
            Main main = new Main((OutputStream)writeStream, "javac");
            Path path = this.srcDir.lookup(string);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("-d");
            arrayList.add(this.classDirName);
            if (this.charEncoding != null) {
                arrayList.add("-encoding");
                arrayList.add(this.charEncoding);
            }
            arrayList.add("-classpath");
            arrayList.add(this.classPath);
            int n = 0;
            while (this.args != null && n < this.args.size()) {
                arrayList.add((String)this.args.get(n));
                ++n;
            }
            arrayList.add(path.getNativePath());
            if (dbg.canWrite()) {
                dbg.print("javac(int)");
                n = 0;
                while (n < arrayList.size()) {
                    dbg.print(" ");
                    dbg.print(arrayList.get(n));
                    ++n;
                }
                dbg.println();
            }
            if (!main.compile(stringArray = arrayList.toArray(new String[arrayList.size()]))) {
                ReadStream readStream;
                writeStream.close();
                memoryStream.close();
                if (dbg.canWrite()) {
                    readStream = memoryStream.openRead();
                    dbg.writeStream(readStream);
                    readStream.close();
                    dbg.flush();
                }
                readStream = memoryStream.openRead();
                JavacErrorParser javacErrorParser = new JavacErrorParser();
                String string2 = javacErrorParser.parseErrors(readStream, lineMap);
                readStream.close();
                throw new JavaCompileException(string2);
            }
            Object var7_13 = null;
            memoryStream.destroy();
        }
        catch (Throwable throwable) {
            Object var7_14 = null;
            memoryStream.destroy();
            throw throwable;
        }
    }

    private void compileExternal(String string, String string2, LineMap lineMap) throws Exception {
        InputStream inputStream;
        MemoryStream memoryStream;
        block17: {
            memoryStream = new MemoryStream();
            WriteStream writeStream = new WriteStream(memoryStream);
            InputStream inputStream2 = null;
            inputStream = null;
            boolean bl = CauchoSystem.isUnix();
            try {
                Path path = this.srcDir.lookup(string2);
                String string3 = Pwd.lookupNative(string2).getParent().getNativePath();
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string);
                int n = 0;
                while (this.args != null && n < this.args.size()) {
                    arrayList.add((String)this.args.get(n));
                    ++n;
                }
                if (string.endsWith("jikes") || string.endsWith("jikes.exe")) {
                    arrayList.add("+E");
                    bl = false;
                    if (this.charEncoding != null) {
                        arrayList.add("-encoding=" + this.charEncoding);
                    }
                } else if (this.charEncoding != null) {
                    arrayList.add("-encoding");
                    arrayList.add(this.charEncoding);
                }
                arrayList.add("-classpath");
                arrayList.add(this.classPath);
                arrayList.add("-d");
                arrayList.add(this.classDirName);
                if (bl) {
                    arrayList.add(string2);
                } else {
                    arrayList.add(path.getNativePath());
                }
                Process process = this.executeCompiler(arrayList, bl);
                inputStream2 = process.getInputStream();
                inputStream = process.getErrorStream();
                writeStream.writeStream(inputStream);
                writeStream.writeStream(inputStream2);
                int n2 = process.waitFor();
                if (n2 != 0) {
                    ReadStream readStream;
                    writeStream.close();
                    memoryStream.close();
                    if (dbg.canWrite()) {
                        readStream = memoryStream.openRead();
                        dbg.writeStream(readStream);
                        readStream.close();
                        dbg.flush();
                    }
                    readStream = memoryStream.openRead();
                    JavacErrorParser javacErrorParser = new JavacErrorParser();
                    String string4 = ((ErrorParser)javacErrorParser).parseErrors(readStream, lineMap);
                    readStream.close();
                    if (string4 == null | string4.equals("")) {
                        CharBuffer charBuffer = new CharBuffer();
                        charBuffer.append("unknown compiler error executing:\n");
                        int n3 = 0;
                        while (n3 < arrayList.size()) {
                            charBuffer.append(" " + arrayList.get(n3) + "\n");
                            ++n3;
                        }
                        readStream = memoryStream.openRead();
                        while ((n3 = readStream.read()) >= 0) {
                            charBuffer.append((char)n3);
                        }
                        readStream.close();
                        string4 = charBuffer.toString();
                    }
                    throw new JavaCompileException(string4);
                }
                Object var10_20 = null;
                if (inputStream2 == null) break block17;
            }
            catch (Throwable throwable) {
                Object var10_21 = null;
                if (inputStream2 != null) {
                    inputStream2.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                memoryStream.destroy();
                throw throwable;
            }
            inputStream2.close();
        }
        if (inputStream != null) {
            inputStream.close();
        }
        memoryStream.destroy();
    }

    private Process executeCompiler(ArrayList arrayList, boolean bl) throws IOException {
        String[] stringArray;
        Object object;
        if (bl) {
            object = new CharBuffer();
            ((CharBuffer)object).append("cd ");
            ((CharBuffer)object).append(this.srcDirName);
            ((CharBuffer)object).append(";");
            int n = 0;
            while (n < arrayList.size()) {
                ((CharBuffer)object).append(" ");
                ((CharBuffer)object).append(arrayList.get(n));
                ++n;
            }
            stringArray = new String[]{"/bin/sh", "-c", ((CharBuffer)object).toString()};
        } else {
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
        }
        if (dbg.canWrite()) {
            int n = 0;
            while (n < stringArray.length) {
                if (n != 0) {
                    dbg.print(" ");
                }
                dbg.print(stringArray[n]);
                ++n;
            }
            dbg.println();
        }
        object = Runtime.getRuntime();
        return ((Runtime)object).exec(stringArray);
    }

    public JavaCompiler(ClassLoader classLoader, String string, String string2, Path path) {
        block10: {
            block9: {
                this.loader = classLoader;
                if (string == null && classLoader instanceof DynamicClassLoader) {
                    string = ((DynamicClassLoader)classLoader).getClassPath();
                } else if (string == null) {
                    string = System.getProperty("java.class.path");
                }
                this.compiler = Registry.getString("/caucho.com/java/compiler", "internal");
                String string3 = Registry.getString("/caucho.com/java/args", null);
                try {
                    if (string3 != null) {
                        this.args = new Regexp("[\\s,]+").split(string3);
                    }
                }
                catch (Exception exception) {
                    if (!dbg.canWrite()) break block9;
                    dbg.log(exception);
                }
            }
            this.classDir = path != null ? path : CauchoSystem.getWorkPath();
            this.srcDir = string2 != null ? Pwd.lookupNative(string2) : this.classDir;
            this.srcDirName = this.srcDir.getNativePath();
            this.classDirName = this.classDir.getNativePath();
            char c = CauchoSystem.getPathSeparatorChar();
            if (!this.srcDirName.equals(this.classDirName)) {
                string = this.srcDirName + c + string;
            }
            this.classPath = string = this.classDirName + c + string;
            try {
                this.classDir.mkdirs();
            }
            catch (IOException iOException) {
                if (!dbg.canWrite()) break block10;
                dbg.log(iOException);
            }
        }
    }

    public JavaCompiler(ClassLoader classLoader, String string) {
        this(classLoader, string, null, null);
    }

    public JavaCompiler(ClassLoader classLoader) {
        this(classLoader, null, null, null);
    }
}

