/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.parser;

import com.caucho.es.ESId;
import com.caucho.es.parser.Block;
import com.caucho.es.parser.Function;

class Variable {
    private Function function;
    private ESId id;
    private boolean isLocal;
    private boolean isScope;
    private boolean isInitialized;
    private boolean isUsed;
    private boolean isClosureVar;
    int type;

    void setType(int n) {
        if (n == 0) {
            this.isInitialized = true;
        }
        this.type = n;
    }

    boolean isLocal() {
        return this.isLocal;
    }

    boolean isJavaLocal() {
        return this.isLocal && !this.isClosureVar;
    }

    int getType() {
        if (this.type == 0) {
            this.type = 1;
            this.isInitialized = false;
        }
        return this.type;
    }

    boolean hasInit() {
        return this.type != 0 && this.isLocal && this.isInitialized;
    }

    boolean isScope() {
        return this.isScope;
    }

    void setUsed() {
        this.isUsed = true;
        if (this.type == 0) {
            this.type = 1;
        }
    }

    void setUsedByClosure() {
        this.isClosureVar = true;
        this.setUsed();
    }

    boolean isUsed() {
        return this.isUsed;
    }

    void setLocal() {
        this.isLocal = true;
    }

    ESId getId() {
        return this.id;
    }

    Variable(Block block, ESId eSId, boolean bl) {
        this.function = block.function;
        this.id = eSId;
        this.isLocal = bl;
        this.isScope = block.getDepth() > 0 || !this.function.isGlobalScope();
        this.type = 0;
    }
}

