/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.parser;

import com.caucho.es.ESBase;
import com.caucho.es.ESException;
import com.caucho.es.ESGlobal;
import com.caucho.es.ESId;
import com.caucho.es.ESParseException;
import com.caucho.es.Global;
import com.caucho.es.Script;
import com.caucho.es.parser.Block;
import com.caucho.es.parser.CallExpr;
import com.caucho.es.parser.Expr;
import com.caucho.es.parser.Function;
import com.caucho.es.parser.IdExpr;
import com.caucho.es.parser.Lexer;
import com.caucho.es.parser.LiteralExpr;
import com.caucho.es.parser.ParseClass;
import com.caucho.java.JavaCompiler;
import com.caucho.java.LineMap;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntArray;
import com.caucho.util.SimpleClassLoader;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;

public class Parser {
    private static WriteStream dbg = LogStream.open("/caucho.com/es/parser");
    private static Integer LOCK = new Integer(0);
    static ESId CLINIT = ESId.intern("__clinit__");
    static ESId PROTOTYPE = ESId.intern("prototype");
    static ESId FINALLY = ESId.intern("finally");
    static ESId ANONYMOUS = ESId.intern("anonymous");
    static ESId OBJECT = ESId.intern("Object");
    static ESId REGEXP = ESId.intern("RegExp");
    static ESId ARRAY = ESId.intern("Array");
    static ESId LENGTH = ESId.intern("length");
    static final int PREC_DOT = 1;
    static final int PREC_POST = 1;
    static final int PREC_FUN = 2;
    static final int PREC_UMINUS = 3;
    static final int PREC_TIMES = 4;
    static final int PREC_PLUS = 5;
    static final int PREC_SHIFT = 6;
    static final int PREC_CMP = 7;
    static final int PREC_EQ = 8;
    static final int PREC_BITAND = 9;
    static final int PREC_BITXOR = 10;
    static final int PREC_BITOR = 11;
    static final int PREC_AND = 12;
    static final int PREC_OR = 13;
    static final int PREC_COND = 14;
    static final int PREC_ASSIGN = 15;
    static final int PREC_COMMA = 16;
    static final int PREC_MAX = 17;
    static ESId BOGUS = ESId.intern("return ");
    ClassLoader loader;
    Path[] scriptPath;
    boolean isEval;
    Lexer lexer;
    IntArray hashes = new IntArray();
    ParseClass parseClass;
    Function globalFunction;
    Function staticFunction;
    Function function;
    Block block;
    Path workPath;
    JavaCompiler compiler;
    String className;

    public void setClassLoader(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    public void setScriptPath(Path[] pathArray) {
        this.scriptPath = pathArray;
    }

    public void setFast(boolean bl) {
    }

    public static Script parse(ClassLoader classLoader, Path[] pathArray, ReadStream readStream, String string, int n) throws ESException, IOException {
        Parser parser = new Parser(classLoader, pathArray, readStream, string, n);
        Script script = parser.parse(false);
        script.setScriptPath(pathArray);
        script.setClassDir(parser.workPath);
        return script;
    }

    public static Script parse(ClassLoader classLoader, Path[] pathArray, ReadStream readStream, LineMap lineMap, long l) throws ESException, IOException {
        Object object;
        String string = "_js." + JavaCompiler.mangleName(readStream.getPath().getPath());
        if (l > 0L && (object = Parser.loadScript(string, classLoader)) != null && ((Script)object).getLastModified() >= l) {
            ((Script)object).setScriptPath(pathArray);
            ((Script)object).setClassDir(CauchoSystem.getWorkPath());
            return object;
        }
        object = new Parser(classLoader, pathArray, readStream, lineMap);
        Script script = super.parse(false);
        script.setScriptPath(pathArray);
        script.setClassDir(((Parser)object).workPath);
        return script;
    }

    public static Script parse(String string, Path[] pathArray, ClassLoader classLoader) throws ESException, IOException {
        Path path = null;
        int n = 0;
        while (n < pathArray.length) {
            path = pathArray[n].lookup(string);
            if (path != null && path.canRead()) break;
            path = null;
            ++n;
        }
        if (path == null) {
            throw new IOException("can't find " + string);
        }
        Script script = null;
        ReadStream readStream = path.openRead();
        Parser parser = new Parser(classLoader, pathArray, readStream, string, 1);
        Path path2 = parser.workPath;
        if ((path2 = path2.lookup(parser.className.replace('.', '/') + ".class")).getLastModified() > path.getLastModified()) {
            try {
                script = (Script)classLoader.loadClass(parser.className).newInstance();
                script.setScriptPath(pathArray);
                script.setClassDir(parser.workPath);
                return script;
            }
            catch (Exception exception) {
                throw new ESParseException(exception);
            }
        }
        try {
            script = parser.parse(false);
        }
        finally {
            Object var9_11 = null;
            readStream.close();
        }
        script.setScriptPath(pathArray);
        return script;
    }

    public static Script loadScript(String string, ClassLoader classLoader) {
        try {
            Path path = CauchoSystem.getWorkPath();
            SimpleClassLoader simpleClassLoader = SimpleClassLoader.create(classLoader, path, string);
            return (Script)simpleClassLoader.loadClass(string).newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Script parseFunction(Global global, ESGlobal eSGlobal, ReadStream readStream, String string, int n) throws ESException, IOException {
        Parser parser = new Parser(null, null, readStream, string, n);
        return parser.parse(false);
    }

    public static Script parseEval(Global global, ESBase eSBase, ESGlobal eSGlobal, String string) throws ESException, IOException {
        ReadStream readStream = Vfs.openRead(string);
        Parser parser = new Parser(null, null, readStream, "eval", 1);
        return parser.parse(true);
    }

    public Script parse(ReadStream readStream, String string, int n) throws ESException, IOException {
        if (string == null) {
            string = readStream.getUserPath();
        }
        this.lexer = new Lexer(readStream, string, n);
        this.className = "_js." + JavaCompiler.mangleName(string);
        Script script = this.parse(false);
        script.setScriptPath(this.scriptPath);
        script.setClassDir(this.workPath);
        return script;
    }

    private Script parse(boolean bl) throws ESException, IOException {
        this.compiler = new JavaCompiler(this.loader, null, null, this.workPath);
        this.block = null;
        String string = this.lexer.getFilename();
        this.parseClass = new ParseClass(string, this.className);
        this.parseClass.setLastModified(this.lexer.getLastModified());
        this.globalFunction = this.parseClass.newFunction(null, ESId.intern("global"), false);
        this.staticFunction = this.parseClass.newFunction(null, ESId.intern("$static"), false);
        this.parseClass.setGlobal(this.globalFunction);
        if (bl) {
            this.block = Block.create(this, this.globalFunction);
            this.block.finish();
            this.function = this.parseClass.newFunction(this.globalFunction, ESId.intern("eval"), false);
            this.function.setEval();
        } else {
            this.function = this.globalFunction;
        }
        this.block = Block.create(this, this.function);
        this.parseBlock(true);
        this.block.finish();
        if (this.lexer.peek() != -1) {
            throw this.expect("end of file");
        }
        this.block = Block.create(this, this.staticFunction);
        this.block.finish();
        Integer n = LOCK;
        synchronized (n) {
            Path path = this.workPath.lookup(this.className.replace('.', '/') + ".java");
            path.getParent().mkdirs();
            WriteStream writeStream = path.openWrite();
            this.parseClass.writeCode(writeStream);
            writeStream.close();
            SimpleClassLoader simpleClassLoader = SimpleClassLoader.create(this.loader, this.workPath, this.className);
            Script script = null;
            try {
                this.compiler.compile(this.className.replace('.', '/') + ".java", null);
                Class<?> clazz = simpleClassLoader.loadClass(this.className);
                script = (Script)clazz.newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new ESParseException(exception);
            }
            Script script2 = script;
            Object var4_11 = null;
            return script2;
        }
    }

    private Function parseFunction() throws ESException {
        this.function.setNeedsScope();
        ESId eSId = null;
        if (this.lexer.peek() == 259) {
            this.lexer.next();
            eSId = this.lexer.getId();
        }
        if (this.lexer.next() != 40) {
            throw this.expect("`('");
        }
        if (eSId != null) {
            this.function.addVariable(this.block, eSId);
            this.block.newVar(eSId).getVar().setType(1);
        }
        Block block = this.block;
        Function function = this.function;
        this.function = this.parseClass.newFunction(function, eSId, false);
        function.addFunction(this.function);
        this.block = Block.create(this, this.function);
        boolean bl = true;
        while (this.lexer.peek() != 41) {
            if (!bl && this.lexer.next() != 44) {
                throw this.expect("`,'");
            }
            bl = false;
            if (this.lexer.next() != 259) {
                throw this.expect("formal argument");
            }
            this.function.addFormal(this.block, this.lexer.getId());
        }
        this.lexer.next();
        if (this.lexer.next() != 123) {
            throw this.expect("`{'");
        }
        this.parseBlock(false);
        if (this.lexer.next() != 125) {
            throw this.expect("`}'");
        }
        this.block.finish();
        Function function2 = this.function;
        this.function = function;
        this.block = block;
        return function2;
    }

    private void parseBlock(boolean bl) throws ESException {
        block10: while (true) {
            switch (this.lexer.peek()) {
                case 40: 
                case 91: 
                case 257: 
                case 258: 
                case 259: 
                case 260: 
                case 261: 
                case 262: 
                case 264: 
                case 265: 
                case 281: 
                case 282: 
                case 283: 
                case 284: 
                case 296: 
                case 298: 
                case 305: {
                    this.parseStatement();
                    continue block10;
                }
                case 59: 
                case 285: 
                case 287: 
                case 290: 
                case 291: 
                case 292: 
                case 294: 
                case 295: 
                case 297: 
                case 299: 
                case 300: 
                case 308: 
                case 309: 
                case 312: {
                    this.parseStatement();
                    continue block10;
                }
                case 123: {
                    this.block = this.block.startBlock();
                    this.parseStatement();
                    this.block = this.block.finishBlock();
                    continue block10;
                }
                case 310: {
                    this.block.doTry();
                    this.parseCatch();
                    continue block10;
                }
                case 311: {
                    this.block.doTry();
                    this.parseFinally();
                    continue block10;
                }
                case 306: {
                    this.parseClass();
                    continue block10;
                }
                case 313: {
                    this.parseImport();
                    continue block10;
                }
                case 314: {
                    throw new ESException("nostatus");
                }
            }
            break;
        }
    }

    private void parseStatement() throws ESException {
        int n = this.lexer.peek();
        this.hashes.clear();
        int n2 = this.lexer.getLine();
        Object var3_3 = null;
        this.block.setLine(n2);
        if (this.block.isDead) {
            switch (n) {
                case 59: 
                case 296: 
                case 299: 
                case 310: 
                case 311: {
                    break;
                }
                default: {
                    throw this.error("can't reach statement");
                }
            }
        }
        switch (n) {
            case 259: {
                this.parseIdentifierStatement();
                break;
            }
            case 40: 
            case 91: 
            case 257: 
            case 258: 
            case 260: 
            case 261: 
            case 262: 
            case 264: 
            case 265: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 298: 
            case 305: {
                this.block.addExpr(this.parseExpression(17, true));
                this.parseStatementEnd();
                break;
            }
            case 296: {
                this.lexer.next();
                Function function = this.parseFunction();
                break;
            }
            case 299: {
                this.parseVar(false);
                this.parseStatementEnd();
                break;
            }
            case 294: {
                this.lexer.next();
                if (this.lexer.peek() == 259 && !this.lexer.seenLineFeed()) {
                    this.block.doBreak(this.lexer.getId());
                    this.lexer.next();
                } else {
                    this.block.doBreak();
                }
                this.parseStatementEnd();
                break;
            }
            case 295: {
                this.lexer.next();
                if (this.lexer.peek() == 259 && !this.lexer.seenLineFeed()) {
                    this.block.doContinue(this.lexer.getId());
                    this.lexer.next();
                } else {
                    this.block.doContinue();
                }
                this.parseStatementEnd();
                break;
            }
            case 297: {
                this.lexer.next();
                if (this.lexer.peek() == 59 || this.lexer.peek() == 125 || this.lexer.seenLineFeed()) {
                    this.block.doReturn();
                } else {
                    this.block.doReturn(this.parseExpression(17, true));
                }
                this.parseStatementEnd();
                break;
            }
            case 285: {
                this.parseIf();
                break;
            }
            case 287: {
                this.parseSwitch();
                break;
            }
            case 290: {
                this.parseWhile(null);
                break;
            }
            case 291: {
                this.parseDo(null);
                break;
            }
            case 292: {
                this.parseFor(null);
                break;
            }
            case 300: {
                this.parseWith();
                break;
            }
            case 308: {
                this.parseSynchronized();
                break;
            }
            case 309: {
                this.parseTry();
                break;
            }
            case 312: {
                this.lexer.next();
                this.block.doThrow(this.parseExpression(17));
                break;
            }
            case 59: {
                this.lexer.next();
                break;
            }
            case 123: {
                this.lexer.next();
                this.parseBlock(false);
                if (this.lexer.next() == 125) break;
                throw this.expect("`}'");
            }
            default: {
                throw this.expect("statement");
            }
        }
    }

    private void parseStatementEnd() throws ESException {
        if (this.lexer.peek() == 59) {
            this.lexer.next();
        } else if (this.lexer.peek() != 125 && this.lexer.peek() != -1 && !this.lexer.seenLineFeed()) {
            throw this.expect("`;'");
        }
    }

    private void parseIdentifierStatement() throws ESException {
        ESId eSId = this.lexer.getId();
        int n = this.lexer.getLine();
        this.lexer.next();
        if (this.lexer.peek() != 58) {
            IdExpr idExpr = this.block.newVar(eSId);
            Expr expr = this.parseExprRec(this.parseTermTail(idExpr, false, true), 17, false, true);
            this.block.addExpr(expr);
            this.parseStatementEnd();
            return;
        }
        this.lexer.next();
        switch (this.lexer.peek()) {
            case 290: {
                this.parseWhile(eSId);
                break;
            }
            case 291: {
                this.parseDo(eSId);
                break;
            }
            case 292: {
                this.parseFor(eSId);
                break;
            }
            default: {
                this.block = this.block.startBlock(eSId);
                this.parseStatement();
                this.block = this.block.finishBlock();
                break;
            }
        }
    }

    private Expr parseVar(boolean bl) throws ESException {
        boolean bl2 = true;
        IdExpr idExpr = null;
        do {
            this.lexer.next();
            if (this.lexer.next() != 259) {
                throw this.expect("identifier");
            }
            ESId eSId = this.lexer.getId();
            this.block.defVar(eSId);
            if (this.lexer.peek() == 61) {
                this.lexer.next();
                IdExpr idExpr2 = this.block.newVar(eSId);
                Expr expr = this.parseExpression(16, true);
                this.block.evalExpr();
                ((Expr)idExpr2).assign(expr).exprStatement(this.block.function);
            } else if (bl) {
                idExpr = this.block.newVar(eSId);
            }
            bl2 = false;
        } while (this.lexer.peek() == 44);
        return idExpr;
    }

    private void parseIf() throws ESException {
        boolean bl = true;
        boolean bl2 = true;
        this.block = this.block.create();
        while (this.lexer.peek() == 285) {
            this.lexer.next();
            if (this.lexer.next() != 40) {
                throw this.expect("`('");
            }
            this.block.startIf(this.parseBooleanExpression(17), !bl);
            bl = false;
            if (this.lexer.next() != 41) {
                throw this.expect("`)'");
            }
            this.parseStatement();
            this.block.endBlock();
            if (!this.block.isDead) {
                bl2 = false;
            }
            this.block.isDead = false;
            if (this.lexer.peek() != 286) {
                this.block = this.block.pop();
                return;
            }
            this.lexer.next();
        }
        this.block.startElse();
        this.parseStatement();
        this.block.endBlock();
        if (!this.block.isDead) {
            bl2 = false;
        }
        this.block = this.block.pop();
        this.block.isDead = bl2;
    }

    private void parseSwitch() throws ESException {
        int n;
        this.lexer.next();
        if (this.lexer.next() != 40) {
            throw this.expect("`)'");
        }
        Expr expr = this.parseExpression(17);
        if (this.lexer.next() != 41) {
            throw this.expect("`)'");
        }
        if (this.lexer.next() != 123) {
            throw this.expect("`{'");
        }
        ArrayList<Expr> arrayList = new ArrayList<Expr>();
        this.block = this.block.startSwitch(expr);
        block4: while ((n = this.lexer.peek()) != -1 && n != 125) {
            switch (n) {
                case 288: {
                    this.lexer.next();
                    this.block.doCase(arrayList.size());
                    arrayList.add(this.parseExpression(17));
                    if (this.lexer.next() == 58) continue block4;
                    throw this.expect("`:'");
                }
                case 289: {
                    this.lexer.next();
                    if (this.lexer.next() != 58) {
                        throw this.expect("`:'");
                    }
                    this.block.doDefault();
                    break;
                }
                default: {
                    this.parseStatement();
                }
            }
        }
        if (this.lexer.next() != 125) {
            throw this.expect("`}'");
        }
        this.block = this.block.fillSwitch(arrayList);
    }

    private void parseWhile(ESId eSId) throws ESException {
        this.lexer.next();
        if (this.lexer.next() != 40) {
            throw this.expect("`('");
        }
        Expr expr = this.parseBooleanExpression(17);
        if (expr instanceof LiteralExpr && !((LiteralExpr)expr).getLiteral().toBoolean()) {
            throw this.error("while (false) is never executed.");
        }
        this.block = this.block.startWhile(eSId, expr);
        if (this.lexer.next() != 41) {
            throw this.expect("`)'");
        }
        this.parseStatement();
        this.block = this.block.endLoop();
    }

    private void parseFor(ESId eSId) throws ESException {
        this.lexer.next();
        if (this.lexer.next() != 40) {
            throw this.expect("`('");
        }
        boolean bl = false;
        Expr expr = null;
        if (this.lexer.peek() == 299) {
            expr = this.parseVar(true);
        } else if (this.lexer.peek() != 59) {
            expr = this.parseExpression(17);
        } else if (this.lexer.peek() == 293) {
            throw this.expect("expression");
        }
        if (this.lexer.peek() == 293) {
            this.parseForIn(eSId, expr);
            return;
        }
        if (expr != null) {
            expr.exprStatement(this.block.function);
        }
        if (this.lexer.next() != 59) {
            throw this.expect("`;'");
        }
        Expr expr2 = null;
        if (this.lexer.peek() != 59) {
            expr2 = this.parseExpression(17);
        }
        if (this.lexer.next() != 59) {
            throw this.expect("`;'");
        }
        Expr expr3 = null;
        if (this.lexer.peek() != 41) {
            expr3 = this.parseExpression(17);
            expr3.killValue();
        }
        if (this.lexer.next() != 41) {
            throw this.expect("`)'");
        }
        if (expr2 instanceof LiteralExpr && !((LiteralExpr)expr2).getLiteral().toBoolean()) {
            throw this.error("for (;false;) is never executed.");
        }
        this.block = this.block.startFor(eSId, expr2, expr3);
        this.parseStatement();
        this.block = this.block.endLoop();
    }

    private void parseForIn(ESId eSId, Expr expr) throws ESException {
        this.lexer.next();
        String string = this.block.newIterator(eSId, this.parseExpression(17));
        if (this.lexer.next() != 41) {
            throw this.expect("`)'");
        }
        this.block = this.block.startWhile(eSId, this.block.hasNext(string));
        this.block.addExpr(expr.next(string, expr));
        this.parseStatement();
        this.block = this.block.endLoop();
    }

    private void parseDo(ESId eSId) throws ESException {
        this.lexer.next();
        this.block = this.block.startDo(eSId);
        this.parseStatement();
        if (this.lexer.next() != 290) {
            throw this.expect("`while'");
        }
        if (this.lexer.next() != 40) {
            throw this.expect("`('");
        }
        this.block = this.block.endDo(this.parseBooleanExpression(17));
        if (this.lexer.next() != 41) {
            throw this.expect("`)'");
        }
        this.parseStatementEnd();
    }

    private void parseWith() throws ESException {
        this.lexer.next();
        if (this.lexer.next() != 40) {
            throw this.expect("`('");
        }
        this.block = this.block.startWith(this.parseExpression(17));
        if (this.lexer.next() != 41) {
            throw this.expect("`)'");
        }
        this.parseStatement();
        this.block = this.block.endWith();
    }

    private void parseSynchronized() throws ESException {
        this.lexer.next();
        if (this.lexer.next() != 40) {
            throw this.expect("`('");
        }
        this.block = this.block.startSynchronized(this.parseExpression(17));
        if (this.lexer.next() != 41) {
            throw this.expect("`)'");
        }
        this.parseStatement();
        this.block = this.block.endSynchronized();
    }

    private void parseTry() throws ESException {
        this.lexer.next();
        this.block = this.block.startTry();
        this.parseStatement();
        this.block = this.block.endTry();
        if (this.lexer.peek() == 310) {
            this.parseCatch();
        } else if (this.lexer.peek() == 311) {
            this.parseFinally();
        } else {
            throw this.error("expected `catch' or `finally' at " + this.getToken());
        }
    }

    private void parseCatch() throws ESException {
        this.block.function.disallowJavaLocal();
        boolean bl = this.block.isDead;
        boolean bl2 = false;
        while (this.lexer.peek() == 310) {
            this.block.isDead = false;
            if (bl2) {
                throw this.error("catch () must be last catch clause");
            }
            this.lexer.next();
            if (this.lexer.next() != 40) {
                throw this.expect("`('");
            }
            String string = "";
            while (this.lexer.peek() == 259) {
                this.lexer.next();
                string = string + this.lexer.getText();
                if (this.lexer.peek() != 46) break;
                this.lexer.next();
                string = string + ".";
                if (this.lexer.peek() == 259) continue;
                throw this.expect("identifier");
            }
            ESId eSId = null;
            if (this.lexer.peek() == 259) {
                eSId = this.lexer.getId();
                this.lexer.next();
            }
            if (this.lexer.next() != 41) {
                if (string.equals("")) {
                    throw this.expect("identifier");
                }
                throw this.expect("`)'");
            }
            if (eSId == null) {
                eSId = ESId.intern(string);
                string = "java.lang.Exception";
            }
            IdExpr idExpr = null;
            if (eSId != null) {
                idExpr = this.block.newVar(eSId);
            }
            this.block = this.block.startCatch(string, idExpr);
            this.parseStatement();
            if (!this.block.isDead) {
                bl = false;
            }
            this.block = this.block.endCatch();
        }
        this.block.isDead = bl;
        if (this.lexer.peek() == 311) {
            this.parseFinally();
        }
    }

    private void parseFinally() throws ESException {
        boolean bl = this.block.isDead;
        this.block.isDead = false;
        this.lexer.next();
        this.block = this.block.startFinally();
        this.parseStatement();
        this.block = this.block.endFinally();
        this.block.isDead = bl;
    }

    private void parseClass() throws ESException {
        if (this.function.getParent() != null) {
            throw this.error("`class' only allowed at top level");
        }
        this.lexer.next();
        if (this.lexer.next() != 259) {
            throw this.expect("class name");
        }
        ESId eSId = this.lexer.getId();
        ESId eSId2 = this.parseExtends();
        if (this.lexer.next() != 123) {
            throw this.expect("`{'");
        }
        ParseClass parseClass = this.parseClass;
        Function function = this.globalFunction;
        Function function2 = this.staticFunction;
        Function function3 = this.function;
        Block block = this.block;
        this.parseClass = parseClass.newClass(eSId);
        this.parseClass.setProto(eSId2);
        this.globalFunction = this.parseClass.newFunction(null, ESId.intern("global"), true);
        this.staticFunction = this.parseClass.newFunction(null, ESId.intern("$static"), true);
        this.parseClass.setGlobal(this.globalFunction);
        this.function = this.globalFunction;
        this.block = Block.create(this, this.function);
        this.parseBlock(true);
        this.block.finish();
        this.block = Block.create(this, this.staticFunction);
        this.block.finish();
        if (this.parseClass.getFunction(eSId) == null) {
            this.function = this.parseClass.newFunction(null, eSId, false);
            this.block = Block.create(this, this.function);
            this.block.finish();
        }
        this.block = block;
        this.function = function3;
        this.globalFunction = function;
        this.staticFunction = function2;
        this.parseClass = parseClass;
        if (this.lexer.next() != 125) {
            throw this.expect("`}'");
        }
    }

    private ESId parseExtends() throws ESException {
        if (this.lexer.peek() != 307) {
            return null;
        }
        this.lexer.next();
        if (this.lexer.next() != 259) {
            throw this.expect("parent class name");
        }
        return this.lexer.getId();
    }

    private void parseImport() throws ESException {
        CharBuffer charBuffer = new CharBuffer();
        this.lexer.next();
        while (true) {
            if (this.lexer.peek() != 259) {
                throw this.expect("identifier");
            }
            charBuffer.append(this.lexer.getText());
            this.lexer.next();
            if (this.lexer.peek() != 46) break;
            this.lexer.next();
            charBuffer.append('/');
        }
        if (this.scriptPath == null) {
            throw this.error("anonymous functions can't import");
        }
        int n = 0;
        while (n < this.scriptPath.length) {
            Path path = this.scriptPath[n].lookup(charBuffer.toString() + ".js");
            if (path.exists()) {
                this.function.cl.addImport(charBuffer.toString());
                return;
            }
            ++n;
        }
        throw this.error("can't open import `" + charBuffer + ".js'");
    }

    private Expr parseExpression(int n, boolean bl) throws ESException {
        Expr expr = this.parseExprRec(this.parseTerm(bl), n, false, bl);
        expr.getType();
        return expr;
    }

    private Expr parseBooleanExpression(int n) throws ESException {
        Expr expr = this.parseExprRec(this.parseTerm(false), n, true, false);
        expr.getType();
        return expr;
    }

    private Expr parseExpression(int n) throws ESException {
        Expr expr = this.parseExprRec(this.parseTerm(false), n, false, false);
        expr.getType();
        return expr;
    }

    private Expr parseExpression() throws ESException {
        Expr expr = this.parseExprRec(this.parseTerm(false), 17, false, false);
        expr.getType();
        return expr;
    }

    private Expr parseExprRec(Expr expr, int n, boolean bl, boolean bl2) throws ESException {
        Expr expr2 = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            switch (this.lexer.peek()) {
                case 61: {
                    if (n2 != 0 && n3 != 44) {
                        throw this.error("illegal left hand side of assignment");
                    }
                    if (bl) {
                        throw this.error("assignment used as boolean needs parentheses");
                    }
                }
                case 263: {
                    if (this.lexer.getOp() == 277 || this.lexer.getOp() == 278) {
                        this.function.setVars();
                    }
                }
                case 44: 
                case 63: 
                case 265: {
                    n7 = this.lexer.peek();
                    n6 = this.lexer.getOp();
                    n5 = this.lexer.getPrecedence();
                    bl5 = this.lexer.isRightAssoc();
                    bl3 = true;
                    break;
                }
                default: {
                    return n2 != 0 ? expr.binaryOp(n3, n2, expr2) : expr;
                }
            }
            if (n5 >= n) {
                return n2 != 0 ? expr.binaryOp(n3, n2, expr2) : expr;
            }
            if (n4 != 0) {
                if (n5 < n4) {
                    expr2 = this.parseExprRec(expr2, n4, bl, bl2);
                    continue;
                }
                expr = n2 != 0 ? expr.binaryOp(n3, n2, expr2) : expr;
            }
            n4 = n5;
            n3 = n7;
            n2 = n6;
            if (bl3) {
                this.lexer.next();
            }
            if (bl5) {
                expr2 = this.parseExpression(n4 + 1, bl2);
                continue;
            }
            if (n2 == 63) {
                this.function.setVars();
                Expr expr3 = this.parseExpression(16);
                if (this.lexer.peek() != 58) {
                    throw this.expect("`:'");
                }
                this.lexer.next();
                expr2 = this.parseExpression(16, bl2);
                expr = expr.conditional(expr3, expr2);
                n2 = 0;
                continue;
            }
            expr2 = this.parseTerm(bl2);
        }
    }

    private Expr parseTerm(boolean bl) throws ESException {
        switch (this.lexer.peek()) {
            case 264: 
            case 265: {
                this.lexer.next();
                int n = this.lexer.getOp();
                return this.parseTerm(bl).unaryOp(n);
            }
            case 283: {
                this.lexer.next();
                return this.parseTerm(bl).doVoid();
            }
            case 284: {
                this.lexer.next();
                return this.parseTerm(bl).typeof();
            }
            case 282: {
                this.lexer.next();
                return this.parseTerm(bl).delete();
            }
            case 281: {
                this.lexer.next();
                int n = this.lexer.getOp();
                return this.parseTerm(bl).prefix(n);
            }
            case 40: 
            case 91: 
            case 123: 
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 261: 
            case 262: 
            case 296: 
            case 298: 
            case 305: {
                return this.parseLhs(false, bl);
            }
        }
        throw this.expect("expression");
    }

    private Expr parseLhs(boolean bl, boolean bl2) throws ESException {
        Expr expr = null;
        switch (this.lexer.next()) {
            case 298: {
                return this.parseTermTail(this.parseLhs(true, bl2), bl, bl2);
            }
            case 257: {
                return this.parseTermTail(this.block.newLiteral(this.lexer.getLiteral()), bl, bl2);
            }
            case 258: {
                return this.parseTermTail(this.block.newRegexp(this.lexer.getLiteral(), this.lexer.getFlags()), bl, bl2);
            }
            case 259: {
                return this.parseTermTail(this.block.newVar(this.lexer.getId()), bl, bl2);
            }
            case 260: {
                return this.parseTermTail(this.block.newThis(), bl, bl2);
            }
            case 305: {
                if (this.lexer.peek() != 40) {
                    throw this.expect("`('");
                }
                this.function.setArguments();
                return this.parseTermTail(this.block.newVar(ESId.intern("eval")), bl, false);
            }
            case 40: {
                expr = this.parseExpression(17);
                if (this.lexer.next() != 41) {
                    throw this.expect("`)'");
                }
                return this.parseTermTail(expr, bl, bl2);
            }
            case 123: {
                expr = this.parseObjectLiteral(-1);
                if (this.lexer.next() != 125) {
                    throw this.expect("`}'");
                }
                return this.parseTermTail(expr, bl, bl2);
            }
            case 91: {
                expr = this.parseArrayLiteral(-1);
                if (this.lexer.next() != 93) {
                    throw this.expect("`]'");
                }
                return this.parseTermTail(expr, bl, bl2);
            }
            case 296: {
                Function function = this.parseFunction();
                this.function.addVariable(this.block, function.id);
                this.block.newVar(function.id).getVar().setType(1);
                expr = this.block.newVar(function.id);
                return this.parseTermTail(expr, bl, bl2);
            }
            case 261: {
                switch (this.lexer.peek()) {
                    case 123: {
                        this.lexer.next();
                        expr = this.parseObjectLiteral(this.lexer.intValue);
                        if (this.lexer.next() != 125) {
                            throw this.expect("`}'");
                        }
                        return this.parseTermTail(expr, bl, bl2);
                    }
                    case 91: {
                        this.lexer.next();
                        expr = this.parseArrayLiteral(this.lexer.intValue);
                        if (this.lexer.next() != 93) {
                            throw this.expect("`]'");
                        }
                        return this.parseTermTail(expr, bl, bl2);
                    }
                }
                return expr;
            }
        }
        throw this.expect("term");
    }

    private Expr parseTermTail(Expr expr, boolean bl, boolean bl2) throws ESException {
        block6: while (true) {
            switch (this.lexer.peek()) {
                case 46: {
                    this.lexer.next();
                    if (this.lexer.next() != 259) {
                        throw this.expect("property name");
                    }
                    expr = expr.fieldReference(this.lexer.getId());
                    break;
                }
                case 40: {
                    if (bl2 && this.lexer.seenLineFeed()) {
                        return expr;
                    }
                    this.lexer.next();
                    int n = 0;
                    CallExpr callExpr = bl ? expr.startNew() : expr.startCall();
                    while (this.lexer.peek() != 41) {
                        if (n != 0 && this.lexer.peek() != 44) {
                            throw this.expect("`,'");
                        }
                        if (n != 0) {
                            this.lexer.next();
                        }
                        callExpr.addCallParam(this.parseExpression(16));
                        ++n;
                    }
                    this.lexer.next();
                    if (bl) {
                        return callExpr;
                    }
                    expr = callExpr;
                    break;
                }
                case 91: {
                    if (bl2 && this.lexer.seenLineFeed()) {
                        return expr;
                    }
                    this.lexer.next();
                    expr = expr.fieldReference(this.parseExpression(17));
                    if (this.lexer.next() == 93) continue block6;
                    throw this.expect("`]'");
                }
                case 281: {
                    if (bl) {
                        return expr.startNew();
                    }
                    if (this.lexer.seenLineFeed()) {
                        return expr;
                    }
                    expr = expr.postfix(this.lexer.getOp());
                    this.lexer.next();
                    break;
                }
                default: {
                    if (bl) {
                        return expr.startNew();
                    }
                    return expr;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private Expr parseObjectLiteral(int var1_1) throws ESException {
        var2_2 = this.block.newVar(ESId.intern("Object"));
        var3_3 = var2_2.startCall();
        if (this.lexer.peek() != 44) ** GOTO lbl15
        this.lexer.next();
        return var3_3;
lbl-1000:
        // 1 sources

        {
            var4_4 = this.lexer.next() == 257 ? ESId.intern(this.lexer.literal.toString()) : this.lexer.getId();
            if (this.lexer.next() != 58) {
                throw this.expect("`:'");
            }
            var3_3.addCallParam(this.block.newLiteral(var4_4));
            var3_3.addCallParam(this.parseExpression(16));
            if (this.lexer.peek() != 44) break;
            this.lexer.next();
lbl15:
            // 2 sources

            ** while (this.lexer.peek() == 257 || this.lexer.peek() == 259)
        }
lbl16:
        // 2 sources

        return var3_3;
    }

    private Expr parseArrayLiteral(int n) throws ESException {
        IdExpr idExpr = this.block.newVar(ESId.intern("Array"));
        CallExpr callExpr = ((Expr)idExpr).startCall();
        boolean bl = true;
        while (this.lexer.peek() != 93) {
            if (this.lexer.peek() == 44) {
                this.lexer.next();
                callExpr.addCallParam(this.block.newLiteral(ESBase.esUndefined));
                bl = false;
                continue;
            }
            Expr expr = this.parseExpression(16);
            if (bl && this.lexer.peek() == 93) {
                return this.block.newArray(expr);
            }
            if (this.lexer.peek() != 44) {
                callExpr.addCallParam(expr);
                break;
            }
            this.lexer.next();
            if (bl && this.lexer.peek() == 93) {
                return this.block.newArray(expr);
            }
            bl = false;
            callExpr.addCallParam(expr);
        }
        return callExpr;
    }

    public String getFilename() {
        return this.lexer.getFilename();
    }

    ESException error(String string) {
        return this.lexer.error(string);
    }

    int getFormalsSize() {
        return this.function.getFormalsSize();
    }

    private String getToken() {
        if (this.lexer.isEof()) {
            return "end of file";
        }
        return "`" + this.lexer.getToken() + "'";
    }

    private ESException expect(String string) {
        return this.lexer.error("expected " + string + " at " + this.getToken());
    }

    public Parser() {
        this.workPath = CauchoSystem.getWorkPath();
    }

    private Parser(ClassLoader classLoader, Path[] pathArray, ReadStream readStream, String string, int n) throws ESException, IOException {
        this.loader = classLoader;
        this.scriptPath = pathArray;
        this.lexer = new Lexer(readStream, string, n);
        this.workPath = CauchoSystem.getWorkPath();
        this.className = "_js." + JavaCompiler.mangleName(readStream.getPath().getPath());
    }

    private Parser(ClassLoader classLoader, Path[] pathArray, ReadStream readStream, LineMap lineMap) throws ESException, IOException {
        this.loader = classLoader;
        this.scriptPath = pathArray;
        this.lexer = new Lexer(readStream, lineMap);
        this.workPath = CauchoSystem.getWorkPath();
        this.className = "_js." + JavaCompiler.mangleName(readStream.getPath().getPath());
    }
}

