/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.parser;

import com.caucho.es.ESBase;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESId;
import com.caucho.es.ESNull;
import com.caucho.es.ESNumber;
import com.caucho.es.ESString;
import com.caucho.es.ESUndefined;
import com.caucho.es.parser.Function;
import com.caucho.es.parser.Variable;
import com.caucho.java.LineMap;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntMap;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

class ParseClass {
    private String srcFilename;
    private LineMap lineMap;
    private String pkg;
    private String name;
    private ESId proto;
    private ParseClass root;
    private ArrayList classes = new ArrayList();
    private ArrayList functions = new ArrayList();
    private IntMap funMap = new IntMap();
    private HashMap names = new HashMap();
    private HashMap literals = new HashMap();
    private HashMap mangledSet = new HashMap();
    private Function global;
    private int unique;
    private int callDepth;
    private ArrayList imports = new ArrayList();
    private WriteStream os;
    private int printDepth;
    private int destLine;
    private long lastModified;

    void setLastModified(long l) {
        this.lastModified = l;
    }

    void setWriteStream(WriteStream writeStream) {
        this.os = writeStream;
    }

    ParseClass newClass(ESId eSId) {
        ParseClass parseClass = new ParseClass(this.srcFilename, eSId.toString());
        this.classes.add(parseClass);
        parseClass.root = this.root;
        return parseClass;
    }

    Function newFunction(Function function, ESId eSId, boolean bl) {
        if (eSId == null) {
            eSId = ESId.intern("$lambda" + this.unique++);
        }
        String string = "_f_" + eSId.toString();
        while (this.names.get(string) != null) {
            string = string + this.unique++;
        }
        this.names.put(string, string);
        Function function2 = new Function(this, function, string, eSId, bl);
        this.setFunction(function2);
        return function2;
    }

    void setFunction(Function function) {
        int n = this.funMap.get(function.name);
        if (n >= 0) {
            function.num = n;
            this.functions.set(n, function);
        } else {
            function.num = this.functions.size();
            this.funMap.put(function.name, this.functions.size());
            this.functions.add(function);
        }
    }

    void addImport(String string) {
        this.imports.add(string);
    }

    void setGlobal(Function function) {
        this.global = function;
    }

    void setProto(ESId eSId) {
        this.proto = eSId;
    }

    void addFunction(Function function) {
        this.setFunction(function);
    }

    void writeCode(WriteStream writeStream) throws IOException {
        this.os = writeStream;
        this.println("package " + this.pkg + ";");
        this.println("import java.io.*;");
        this.println("import com.caucho.es.*;");
        this.println("import com.caucho.util.*;");
        this.println("public class " + this.name + " extends Script {");
        this.writeClassContents();
        this.println("}");
    }

    void writeClassContents() throws IOException {
        Object object;
        if (this.os == null) {
            this.os = this.root.os;
        }
        int n = 0;
        while (n < this.functions.size()) {
            object = (Function)this.functions.get(n);
            ((Function)object).writeCode(this);
            ++n;
        }
        this.writeMap();
        this.writeInit();
        this.writeLastModified();
        this.writeExport();
        this.writeStaticInit();
        this.printLineMap();
        n = 0;
        while (n < this.classes.size()) {
            object = (ParseClass)this.classes.get(n);
            String string = ((ParseClass)object).name;
            this.println();
            this.println("public static class " + string + " extends Script {");
            ((ParseClass)object).setWriteStream(this.os);
            ((ParseClass)object).writeClassContents();
            this.println("}");
            ++n;
        }
    }

    void printId(ESId eSId) throws IOException {
        String string = (String)this.literals.get(eSId);
        if (string == null) {
            string = this.mangleLiteral(eSId);
            this.literals.put(eSId, string);
        }
        this.print(string);
    }

    void pushCall() {
        ++this.callDepth;
    }

    void popCall(int n) {
        this.callDepth -= n;
    }

    int getCallDepth() {
        return this.callDepth;
    }

    void printLiteral(ESBase eSBase) throws IOException {
        if (eSBase == null) {
            this.print("ESBase.esNull");
        } else if (eSBase instanceof ESNull) {
            this.print("ESBase.esNull");
        } else if (eSBase instanceof ESUndefined) {
            this.print("ESBase.esUndefined");
        } else if (eSBase == ESBoolean.TRUE) {
            this.print("ESBoolean.TRUE");
        } else if (eSBase == ESBoolean.FALSE) {
            this.print("ESBoolean.FALSE");
        } else {
            String string = (String)this.literals.get(eSBase);
            if (string == null) {
                try {
                    if (eSBase instanceof ESNumber && Double.isNaN(eSBase.toNum())) {
                        this.print("ESNumber.NaN");
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                string = this.mangleLiteral(eSBase);
                this.literals.put(eSBase, string);
            }
            this.print(string);
        }
    }

    private String mangleLiteral(Object object) {
        String string = object.toString();
        CharBuffer charBuffer = new CharBuffer("_l_");
        int n = 0;
        while (n < string.length() && n < 32) {
            char c = string.charAt(n);
            if (Character.isJavaIdentifierPart(c) && c >= ' ' && c < '\u007f') {
                charBuffer.append(c);
            } else if (charBuffer.getLastChar() != '_') {
                charBuffer.append("_");
            }
            ++n;
        }
        if (this.mangledSet.get(charBuffer) != null) {
            charBuffer.append("_" + this.unique++);
        }
        this.mangledSet.put(charBuffer, charBuffer);
        return charBuffer.toString();
    }

    void writeMap() throws IOException {
        this.println("public ESBase call(int n, Call call, int length)");
        this.println("  throws Exception");
        this.println("{");
        this.println("  switch(n) {");
        int n = 0;
        while (n < this.functions.size()) {
            Function function = (Function)this.functions.get(n);
            this.println("  case " + n + ":");
            this.println("    return " + function.name + "(call, length);");
            ++n;
        }
        this.println("  default:");
        this.println("    throw new RuntimeException();");
        this.println("  }");
        this.println("}");
    }

    void writeInit() throws IOException {
        Object object;
        this.println("public void _init(Global resin, ESObject global) throws Exception");
        this.println("{");
        int n = 0;
        while (n < this.imports.size()) {
            object = (String)this.imports.get(n);
            this.print("  resin.importScript(global, \"");
            this.printString((String)object);
            this.println(".js\");");
            ++n;
        }
        this.println("  ESClosure fun;");
        n = 0;
        while (this.global.functions != null && n < this.global.functions.size()) {
            object = (Function)this.global.functions.get(n);
            this.print("  fun = new ESClosure(");
            this.printLiteral(((Function)object).id);
            this.print(", this, null, " + ((Function)object).num + ", ");
            if (((Function)object).getFormalSize() == 0) {
                this.print("_a_null");
            } else {
                this.print("_a_" + ((Function)object).num);
            }
            this.println(", global);");
            this.println("  global.put(\"" + ((Function)object).id + "\", fun, ESBase.DONT_ENUM);");
            ++n;
        }
        this.println("  Script cl;");
        this.println("  ESObject protoProto;");
        this.println("  ESObject proto;");
        n = 0;
        while (n < this.classes.size()) {
            object = (ParseClass)this.classes.get(n);
            Function function = ((ParseClass)object).getFunction(ESId.intern(((ParseClass)object).name));
            this.println("  cl = new " + ((ParseClass)object).name + "();");
            if (((ParseClass)object).proto != null) {
                this.print("  proto = new ESObject(\"Object\", global.getProperty(");
                this.printLiteral(((ParseClass)object).proto);
                this.println(").getProperty(");
                this.printLiteral(ESId.intern("prototype"));
                this.println("));");
            } else {
                this.println("  proto = resin.createObject();");
            }
            this.println("  cl._init(resin, proto);");
            this.print("  fun = new ESClosure(");
            this.printLiteral(ESId.intern(((ParseClass)object).name));
            this.print(", cl, proto, " + function.num + ", ");
            if (function.getFormalSize() == 0) {
                this.print("_a_null");
            } else {
                this.print("_a_" + (n + this.functions.size()));
            }
            this.println(", null);");
            this.println("  global.setProperty(\"" + ((ParseClass)object).name + "\", fun);");
            ++n;
        }
        this.println("}");
    }

    void writeLastModified() throws IOException {
        this.println("public long getLastModified()");
        this.println("{");
        this.println("  return " + this.lastModified + "L;");
        this.println("}");
    }

    void writeExport() throws IOException {
        Object object;
        this.println("public void export(ESObject dst, ESObject src) throws Exception");
        this.println("{");
        this.println("  ESBase tmp;");
        int n = 0;
        while (this.global.functions != null && n < this.global.functions.size()) {
            object = (Function)this.global.functions.get(n);
            this.println("  tmp = src.getProperty(\"" + ((Function)object).id + "\");");
            this.println("  dst.put(\"" + ((Function)object).id + "\", tmp, ESBase.DONT_ENUM);");
            ++n;
        }
        n = 0;
        while (n < this.classes.size()) {
            object = (ParseClass)this.classes.get(n);
            Function function = ((ParseClass)object).getFunction(ESId.intern(((ParseClass)object).name));
            this.println("  tmp = src.getProperty(\"" + ((ParseClass)object).name + "\");");
            this.println("  dst.put(\"" + ((ParseClass)object).name + "\", tmp, ESBase.DONT_ENUM);");
            ++n;
        }
        this.println("}");
    }

    Function getFunction(ESId eSId) {
        int n = 0;
        while (n < this.functions.size()) {
            Function function = (Function)this.functions.get(n);
            if (function.id == eSId) {
                return function;
            }
            ++n;
        }
        return null;
    }

    boolean hasFunction(ArrayList arrayList, ESId eSId) {
        int n = 2;
        while (n < arrayList.size()) {
            Function function = (Function)arrayList.get(n);
            if (function.id == eSId) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void writeStaticInit() throws IOException {
        Object object;
        Iterator iterator = this.literals.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            object = (String)this.literals.get(k);
            if (k instanceof ESId) {
                this.print("  private static ESId " + (String)object);
                this.print(" = ESId.intern(\"");
                this.printString(String.valueOf(k));
                this.println("\");");
                continue;
            }
            if (k instanceof ESString) {
                this.print("  private static ESString " + (String)object);
                this.print(" = ESString.create(\"");
                this.printString(String.valueOf(k));
                this.println("\");");
                continue;
            }
            if (k instanceof ESNumber) {
                this.print("  private static ESNumber " + (String)object);
                double d = ((ESNumber)k).toNum();
                if (Double.isInfinite(d)) {
                    this.println(" = ESNumber.create(Double.POSITIVE_INFINITY);");
                    continue;
                }
                if (Double.isInfinite(-d)) {
                    this.println(" = ESNumber.create(Double.NEGATIVE_INFINITY);");
                    continue;
                }
                if (Double.isNaN(d)) {
                    throw new RuntimeException();
                }
                this.println(" = ESNumber.create(" + k + "D);");
                continue;
            }
            throw new RuntimeException();
        }
        this.println("  private static ESId[] _a_null = new ESId[0];");
        int n = 0;
        while (n < this.functions.size()) {
            object = (Function)this.functions.get(n);
            this.printFormals((Function)object, n);
            ++n;
        }
        n = 0;
        while (n < this.classes.size()) {
            object = (ParseClass)this.classes.get(n);
            Function function = ((ParseClass)object).getFunction(ESId.intern(((ParseClass)object).name));
            this.printFormals(function, n + this.functions.size());
            ++n;
        }
    }

    void setLine(String string, int n) {
        this.lineMap.add(string, n, this.destLine);
    }

    void printLineMap() throws IOException {
        String string = "foo.java";
        String string2 = this.srcFilename;
        String string3 = this.srcFilename;
        int n = string3.lastIndexOf(47);
        if (n >= 0) {
            string3 = string3.substring(n + 1);
        }
        if ((n = string3.lastIndexOf(92)) >= 0) {
            string3 = string3.substring(n + 1);
        }
        this.println();
        this.println("public com.caucho.java.LineMap getLineMap()");
        this.println("{");
        this.pushDepth();
        this.print("com.caucho.java.LineMap lineMap = new com.caucho.java.LineMap(\"");
        this.printString(string);
        this.print("\", \"");
        this.printString(string3);
        this.println("\");");
        this.println("lineMap.add(1, 1);");
        Iterator iterator = this.lineMap.iterator();
        while (iterator.hasNext()) {
            LineMap.Line line = (LineMap.Line)iterator.next();
            if (line.getSourceFilename() == string2) {
                this.println("lineMap.add(" + line.getSourceLine() + ", " + line.getDestLine() + ");");
                continue;
            }
            string2 = line.getSourceFilename();
            string3 = string2;
            n = string3.lastIndexOf(47);
            if (n >= 0) {
                string3 = string3.substring(n + 1);
            }
            if ((n = string3.lastIndexOf(92)) >= 0) {
                string3 = string3.substring(n + 1);
            }
            this.print("lineMap.add(\"");
            this.printString(string3);
            this.println("\", " + line.getSourceLine() + ", " + line.getDestLine() + ");");
        }
        this.println("return lineMap;");
        this.popDepth();
        this.println("}");
    }

    private void printFormals(Function function, int n) throws IOException {
        if (function.getFormalSize() > 0) {
            this.print("  private static ESId[] _a_" + n + " = new ESId[] {");
            int n2 = 0;
            while (function.formals != null && n2 < function.formals.size()) {
                if (n2 != 0) {
                    this.print(",");
                }
                Variable variable = (Variable)function.formals.get(n2);
                this.print(" ESId.intern(\"" + variable.getId() + "\")");
                ++n2;
            }
            this.println("};");
        }
    }

    void printString(String string) throws IOException {
        int n = 0;
        while (n < string.length()) {
            if (n > 0 && n % 16384 == 0) {
                this.os.print("\" + \"");
            }
            char c = string.charAt(n);
            switch (c) {
                case '\\': {
                    this.os.print("\\\\");
                    break;
                }
                case '\n': {
                    this.os.print("\\n");
                    break;
                }
                case '\r': {
                    this.os.print("\\r");
                    break;
                }
                case '\t': {
                    this.os.print("\\t");
                    break;
                }
                case '\"': {
                    this.os.print("\\\"");
                    break;
                }
                default: {
                    if (c >= ' ' && c < '\u007f') {
                        this.os.print(c);
                        break;
                    }
                    this.os.print("\\u");
                    this.printHex(c >> 12);
                    this.printHex(c >> 8);
                    this.printHex(c >> 4);
                    this.printHex(c);
                    break;
                }
            }
            ++n;
        }
    }

    void printHex(int n) throws IOException {
        if ((n &= 0xF) < 10) {
            this.os.print(n);
        } else {
            this.os.print((char)(97 + n - 10));
        }
    }

    void pushDepth() {
        this.printDepth += 2;
    }

    void popDepth() {
        this.printDepth -= 2;
    }

    void print(boolean bl) throws IOException {
        this.root.os.print(bl);
    }

    void print(int n) throws IOException {
        this.root.os.print(n);
    }

    void print(char c) throws IOException {
        this.root.os.print(c);
    }

    void print(String string) throws IOException {
        if (string == null) {
            string = "null";
        }
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '\n') {
                ++this.destLine;
            }
            ++n;
        }
        this.root.os.print(string);
    }

    void print(Object object) throws IOException {
        this.print(String.valueOf(object));
    }

    void println() throws IOException {
        this.root.os.println();
        ++this.destLine;
    }

    void println(String string) throws IOException {
        this.print(string);
        this.println();
    }

    void println(Object object) throws IOException {
        this.print(String.valueOf(object));
        this.println();
    }

    ParseClass(String string, String string2) {
        this.srcFilename = string;
        this.root = this;
        int n = string2.lastIndexOf(46);
        if (n >= 0) {
            this.pkg = string2.substring(0, n);
            this.name = string2.substring(n + 1);
        } else {
            this.name = string2;
        }
        this.lineMap = new LineMap(string2, string);
        this.lineMap.add(1, 1);
        this.destLine = 1;
    }

    static class Location {
        String filename;
        int line;

        Location(String string, int n) {
            this.filename = string;
            this.line = n;
        }
    }
}

