/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.parser;

import com.caucho.es.ESBase;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESException;
import com.caucho.es.ESNumber;
import com.caucho.es.ESString;
import com.caucho.es.parser.Block;
import com.caucho.es.parser.Expr;
import java.io.IOException;

class LiteralExpr
extends Expr {
    private ESBase value;

    ESBase getLiteral() {
        return this.value;
    }

    boolean isSimple() {
        return true;
    }

    void printInt32() throws IOException {
        try {
            this.cl.print(this.value.toInt32());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void printNum() throws IOException {
        try {
            double d = this.value.toNum();
            if (Double.isInfinite(d)) {
                this.cl.print("Double.POSITIVE_INFINITY");
            } else if (Double.isInfinite(-d)) {
                this.cl.print("Double.NEGATIVE_INFINITY");
            } else if (Double.isNaN(d)) {
                this.cl.print("Double.NaN");
            } else {
                this.cl.print("(" + d + "D)");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void printBoolean() throws IOException {
        this.cl.print(this.value.toBoolean());
    }

    void printString() throws IOException {
        try {
            this.cl.print("\"");
            String string = this.value.toStr().toString();
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                switch (c) {
                    case '\"': {
                        this.cl.print("\\\"");
                        break;
                    }
                    case '\\': {
                        this.cl.print("\\\\");
                        break;
                    }
                    case '\n': {
                        this.cl.print("\\n");
                        break;
                    }
                    case '\r': {
                        this.cl.print("\\r");
                        break;
                    }
                    default: {
                        this.cl.print(c);
                        break;
                    }
                }
                ++n;
            }
            this.cl.print("\"");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void printStr() throws IOException {
        try {
            this.printLiteral(this.value.toStr());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void print() throws IOException {
        this.printLiteral(this.value);
    }

    LiteralExpr(Block block, ESBase eSBase) throws ESException {
        super(block);
        if (eSBase == null) {
            eSBase = ESBase.esNull;
        }
        this.value = eSBase;
        this.type = eSBase instanceof ESNumber ? 3 : (eSBase instanceof ESBoolean ? 5 : (eSBase instanceof ESString ? 2 : 1));
        if (this.value == null) {
            throw new RuntimeException();
        }
    }
}

