/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.parser;

import com.caucho.es.ESBase;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESId;
import com.caucho.es.ESNumber;
import com.caucho.es.ESParseException;
import com.caucho.es.ESString;
import com.caucho.es.Global;
import com.caucho.java.LineMap;
import com.caucho.regexp.Regexp;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.ReadStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

class Lexer {
    static final int ERROR = -3;
    static final int START = -2;
    static final int EOF = -1;
    static final int RESERVED = 256;
    static final int LITERAL = 257;
    static final int REGEXP = 258;
    static final int IDENTIFIER = 259;
    static final int THIS = 260;
    static final int HASH_DEF = 261;
    static final int HASH_REF = 262;
    static final int BIN_OP = 263;
    static final int UNARY_OP = 264;
    static final int BANDU_OP = 265;
    static final int RSHIFT = 266;
    static final int URSHIFT = 267;
    static final int LSHIFT = 268;
    static final int BITAND = 269;
    static final int BITOR = 270;
    static final int GEQ = 271;
    static final int LEQ = 272;
    static final int EQ = 273;
    static final int NEQ = 274;
    static final int STRICT_EQ = 275;
    static final int STRICT_NEQ = 276;
    static final int AND = 277;
    static final int OR = 278;
    static final int ASSIGN_OP = 279;
    static final int PREFIX = 280;
    static final int POSTFIX = 281;
    static final int DELETE = 282;
    static final int VOID = 283;
    static final int TYPEOF = 284;
    static final int IF = 285;
    static final int ELSE = 286;
    static final int SWITCH = 287;
    static final int CASE = 288;
    static final int DEFAULT = 289;
    static final int WHILE = 290;
    static final int DO = 291;
    static final int FOR = 292;
    static final int IN = 293;
    static final int BREAK = 294;
    static final int CONTINUE = 295;
    static final int FUNCTION = 296;
    static final int RETURN = 297;
    static final int NEW = 298;
    static final int VAR = 299;
    static final int WITH = 300;
    static final int NULL = 301;
    static final int UNDEFINED = 302;
    static final int TRUE = 303;
    static final int FALSE = 304;
    static final int EVAL = 305;
    static final int CLASS = 306;
    static final int EXTENDS = 307;
    static final int SYNCHRONIZED = 308;
    static final int TRY = 309;
    static final int CATCH = 310;
    static final int FINALLY = 311;
    static final int THROW = 312;
    static final int IMPORT = 313;
    static final int STATIC = 314;
    static final int LAST_LEXEME = 314;
    static HashMap ops;
    static HashMap reserved;
    Global resin;
    ReadStream is;
    int peek;
    ArrayList macros = new ArrayList();
    CharBuffer macroText;
    int macroIndex;
    int macroOldLine;
    CharBuffer flags;
    int state;
    int lbrace;
    int stringClose;
    boolean isRegexp;
    LineMap lineMap;
    String filename;
    String lastFilename;
    String beginFilename;
    int lastLine;
    int beginLine;
    int beginLineCh;
    int line;
    int lineCh;
    Op op;
    int lexeme;
    int lastLexeme;
    CharBuffer text;
    CharBuffer lineText = new CharBuffer();
    boolean isEof = false;
    ESId id;
    ESBase literal;
    int intValue;
    boolean hasLf;
    boolean regexpOk;
    String writeln;
    CharBuffer temp = new CharBuffer();

    private void opsPut(String string, int n, int n2, int n3, boolean bl) {
        ops.put(new CharBuffer(string), new Op(n, n2, n3, bl));
    }

    private void resPut(String string, int n) {
        reserved.put(new CharBuffer(string), new Integer(n));
    }

    int peek() throws ESParseException {
        try {
            if (this.lexeme == -2) {
                this.lexeme = this.lex();
            }
            this.lastLexeme = this.lexeme;
            return this.lexeme;
        }
        catch (ESParseException eSParseException) {
            throw eSParseException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw this.error(exception.toString());
        }
    }

    int next() throws ESParseException {
        try {
            int n = this.lexeme;
            if (n == -2) {
                n = this.lex();
            }
            this.lastLexeme = n;
            this.lexeme = -2;
            this.lastFilename = this.beginFilename;
            this.lastLine = this.beginLine;
            return n;
        }
        catch (ESParseException eSParseException) {
            throw eSParseException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw this.error(exception == null ? "" : exception.toString());
        }
    }

    int prev() {
        if (this.lastLexeme == -2) {
            throw new RuntimeException();
        }
        this.lexeme = this.lastLexeme;
        this.lastLexeme = -2;
        return this.lexeme;
    }

    int last() {
        if (this.lastLexeme == -2) {
            throw new RuntimeException();
        }
        return this.lastLexeme;
    }

    private int peekCh() throws ESParseException {
        try {
            int n = this.read();
            this.ungetc(n);
            return n;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    /*
     * Unable to fully structure code
     */
    private int lex() throws ESParseException {
        this.lastFilename = this.beginFilename;
        this.lastLine = this.beginLine;
        this.hasLf = false;
        block31: while (true) {
            this.beginFilename = this.filename;
            this.beginLine = this.line;
            this.beginLineCh = this.lineCh;
            var1_1 = this.read();
            block1 : switch (var1_1) {
                case -1: {
                    this.isEof = true;
                    return -1;
                }
                case 9: 
                case 11: 
                case 12: 
                case 32: {
                    break;
                }
                case 10: {
                    this.newline();
                }
                case 13: {
                    this.hasLf = true;
                    break;
                }
                case 33: 
                case 38: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 94: 
                case 124: 
                case 126: {
                    this.regexpOk = true;
                    return this.lexOp(var1_1);
                }
                case 41: 
                case 93: {
                    this.regexpOk = false;
                    return var1_1;
                }
                case 40: 
                case 58: 
                case 59: 
                case 91: 
                case 123: 
                case 125: {
                    this.regexpOk = true;
                    return var1_1;
                }
                case 46: {
                    var2_2 = this.read();
                    if (var2_2 >= 48 && var2_2 <= 57) {
                        this.regexpOk = false;
                        return this.lexFloat(0.0, var2_2);
                    }
                    this.regexpOk = true;
                    this.ungetc(var2_2);
                    return this.lexOp(var1_1);
                }
                case 47: {
                    var2_2 = this.read();
                    if (var2_2 == 47) {
                        var2_2 = this.read();
                        while (var2_2 > 0 && var2_2 != 10 && var2_2 != 13) {
                            var2_2 = this.read();
                        }
                        this.ungetc(var2_2);
                        break;
                    }
                    if (var2_2 != 42) ** GOTO lbl62
                    var3_3 = false;
                    var2_2 = this.read();
                    if (true) ** GOTO lbl59
                    do {
                        if (var2_2 == 47 && (var2_2 = this.read()) == 42) {
                            throw this.error("comments cannot nest");
                        }
                        v0 = var3_3 = var2_2 == 42;
                        if (var2_2 == 10) {
                            this.newline();
                        }
                        if (var2_2 == 10 || var2_2 == 13) {
                            this.hasLf = true;
                        }
                        var2_2 = this.read();
lbl59:
                        // 2 sources

                        if (var2_2 <= 0) continue block31;
                    } while (!var3_3 || var2_2 != 47);
                    break;
lbl62:
                    // 1 sources

                    if (this.regexpOk) {
                        this.regexpOk = false;
                        this.ungetc(var2_2);
                        this.lexString('/', null, true, false);
                        this.readRegexpFlags();
                        try {
                            var3_4 = new Regexp(this.literal.toString(), this.flags.toString());
                        }
                        catch (Exception var3_5) {
                            throw this.error(String.valueOf(var3_5));
                        }
                        return 258;
                    }
                    this.ungetc(var2_2);
                    return this.lexOp(var1_1);
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.regexpOk = false;
                    return this.lexNumber(var1_1);
                }
                case 34: 
                case 39: {
                    this.regexpOk = false;
                    return this.lexString((char)var1_1, null, false, false);
                }
                case 64: {
                    var2_2 = this.read();
                    switch (var2_2) {
                        case 34: {
                            var3_6 = new CharBuffer();
                            var3_6.append('(');
                            this.interpolate(var3_6, 34, null, "\"", "\"", false, false);
                            var3_6.append(')');
                            this.pushMacro(var3_6);
                            break block1;
                        }
                        case 39: {
                            var3_7 = new CharBuffer();
                            var3_7.append('(');
                            this.interpolate(var3_7, 39, null, "'", "'", false, false);
                            var3_7.append(')');
                            this.pushMacro(var3_7);
                            break block1;
                        }
                        case 114: {
                            var2_2 = this.read();
                            if (var2_2 < 0) {
                                throw this.error("unexpected end of file");
                            }
                            switch (var2_2) {
                                case 123: {
                                    var2_2 = 125;
                                    break;
                                }
                                case 60: {
                                    var2_2 = 62;
                                    break;
                                }
                                case 40: {
                                    var2_2 = 41;
                                    break;
                                }
                                case 91: {
                                    var2_2 = 93;
                                    break;
                                }
                            }
                            return this.lexString((char)var2_2, null, true, false);
                        }
                        case 60: {
                            var2_2 = this.read();
                            if (var2_2 != 60) {
                                throw this.error("illegal character at `@'");
                            }
                            if (!this.scanMultiline()) continue block31;
                            return 257;
                        }
                        case 47: {
                            var3_8 = new CharBuffer();
                            var3_8.append("new RegExp(");
                            this.interpolate(var3_8, 47, null, "@r/", "/", true, false);
                            var3_8.append(",\"");
                            var3_8.append(this.readRegexpFlags());
                            var3_8.append("\")");
                            var3_8.append((char)this.read());
                            this.pushMacro(var3_8);
                            break block1;
                        }
                        default: {
                            this.ungetc(var2_2);
                            throw this.error("illegal character at `@'");
                        }
                    }
                }
                case 37: {
                    var2_2 = this.read();
                    this.regexpOk = true;
                    this.ungetc(var2_2);
                    return this.lexOp(var1_1);
                }
                case 35: {
                    var2_2 = this.read();
                    if (this.line == 1 && this.lineCh == 2 && var2_2 == 33) {
                        while (var2_2 > 0 && var2_2 != 10 && var2_2 != 13) {
                            var2_2 = this.read();
                        }
                        this.ungetc(var2_2);
                        break;
                    }
                    if (var2_2 >= 97 && var2_2 <= 122 || var2_2 >= 65 && var2_2 <= 90) {
                        this.temp.clear();
                        while (var2_2 >= 97 && var2_2 <= 122 || var2_2 >= 65 && var2_2 <= 90) {
                            this.temp.append((char)var2_2);
                            var2_2 = this.read();
                        }
                        if (this.temp.toString().equals("line")) {
                            this.scanLine(var2_2);
                            break;
                        }
                        if (this.temp.toString().equals("file")) {
                            this.scanFile(var2_2);
                            break;
                        }
                        throw this.error("expected pragma at `" + this.temp + "'");
                    }
                    if (var2_2 < 48 || var2_2 > 57) {
                        throw this.error("expected digit at " + this.badChar(var2_2));
                    }
                    this.intValue = 0;
                    while (var2_2 >= 48 && var2_2 <= 57) {
                        this.intValue = 10 * this.intValue + var2_2 - 48;
                        var2_2 = this.read();
                    }
                    if (var2_2 == 61) {
                        return 261;
                    }
                    if (var2_2 == 35) {
                        return 262;
                    }
                    throw this.error("expected sharp variable at " + this.badChar(var1_1));
                }
                default: {
                    if (var1_1 >= 97 && var1_1 <= 122 || var1_1 >= 65 && var1_1 <= 90 || var1_1 == 95 || var1_1 == 36) {
                        this.regexpOk = false;
                        return this.lexId(var1_1);
                    }
                    throw this.error("illegal character at " + this.badChar(var1_1));
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private int read() throws ESParseException {
        ++this.lineCh;
        if (this.peek < 0) ** GOTO lbl19
        var1_1 = this.peek;
        this.peek = -1;
        return var1_1;
lbl-1000:
        // 1 sources

        {
            if (this.macroIndex < this.macroText.length()) {
                var1_3 = this.macroText.charAt(this.macroIndex++);
                this.lineText.append(var1_3);
                return var1_3;
            }
            this.line = this.macroOldLine;
            if (this.macros.size() == 0) {
                this.macroText = null;
                continue;
            }
            var1_2 = (Macro)this.macros.remove(this.macros.size() - 1);
            this.macroText = var1_2.text;
            this.macroIndex = var1_2.index;
            this.macroOldLine = var1_2.oldLine;
lbl19:
            // 3 sources

            ** while (this.macroText != null)
        }
lbl20:
        // 1 sources

        try {
            var1_4 = this.is.readChar();
            this.lineText.append((char)var1_4);
            return var1_4;
        }
        catch (CharConversionException var1_5) {
            throw this.error("expected " + this.is.getEncoding() + " encoded character");
        }
        catch (IOException var1_6) {
            throw new ESParseException(var1_6);
        }
    }

    private void ungetc(int n) {
        this.peek = n;
        if (this.lineCh > 0) {
            --this.lineCh;
        }
    }

    CharBuffer getText() {
        return this.text;
    }

    boolean isEof() {
        return this.isEof;
    }

    String getToken() {
        return this.lineText.substring(this.beginLineCh, this.lineCh);
    }

    ESId getId() {
        return this.id;
    }

    boolean seenLineFeed() {
        return this.hasLf;
    }

    ESParseException error(String string) {
        return new ESParseException(this.filename, this.beginLine, this.beginLineCh, this.line, this.lineCh, string);
    }

    private String hex(int n) {
        CharBuffer charBuffer = new CharBuffer();
        int n2 = 3;
        while (n2 >= 0) {
            int n3 = n >> 4 * n2 & 0xF;
            if (n3 < 10) {
                charBuffer.append((char)(n3 + 48));
            } else {
                charBuffer.append((char)(n3 - 10 + 97));
            }
            --n2;
        }
        return charBuffer.toString();
    }

    private String badChar(int n) {
        if (n >= 32 && n <= 127) {
            return "`" + (char)n + "'";
        }
        if (n == 13 || n == 10) {
            return "end of line";
        }
        if (n == -1) {
            return "end of file";
        }
        return "`" + (char)n + "' (\\u" + this.hex(n) + ")";
    }

    String getFilename() {
        LineMap.Line line;
        if (this.lineMap != null && (line = this.lineMap.getLine(this.line)) != null) {
            return line.getSourceFilename();
        }
        return this.filename;
    }

    long getLastModified() {
        if (this.is.getPath() == null) {
            return 0L;
        }
        return this.is.getPath().getLastModified();
    }

    int getLine() {
        LineMap.Line line;
        if (this.lineMap != null && (line = this.lineMap.getLine(this.line)) != null) {
            return line.getSourceLine(this.line);
        }
        return this.line;
    }

    String getLastFilename() {
        LineMap.Line line;
        if (this.lineMap != null && (line = this.lineMap.getLine(this.lastLine)) != null) {
            return line.getSourceFilename();
        }
        return this.lastFilename;
    }

    int getLastLine() {
        LineMap.Line line;
        if (this.lineMap != null && (line = this.lineMap.getLine(this.lastLine)) != null) {
            return line.getSourceLine(this.lastLine);
        }
        return this.lastLine;
    }

    private void pushMacro(CharBuffer charBuffer) {
        if (this.macroText != null) {
            Lexer lexer = this;
            if (lexer == null) {
                throw null;
            }
            this.macros.add(lexer.new Macro(this.macroText, this.macroIndex, this.macroOldLine));
        }
        this.macroText = charBuffer;
        this.macroIndex = 0;
        this.macroOldLine = this.line;
    }

    private void newline() {
        ++this.line;
        this.lineCh = 0;
        this.lineText.clear();
    }

    private int lexFloat(double d, int n) throws ESParseException {
        int n2 = 0;
        while (n >= 48 && n <= 57) {
            d = 10.0 * d + (double)n - 48.0;
            --n2;
            n = this.read();
        }
        if (n == 101 || n == 69) {
            n = this.read();
            int n3 = 1;
            if (n == 45) {
                n3 = -1;
                n = this.read();
            } else if (n == 43) {
                n = this.read();
            }
            if (n < 48 || n > 57) {
                throw this.error("expected exponent at " + this.badChar(n));
            }
            int n4 = 0;
            while (n >= 48 && n <= 57) {
                n4 = 10 * n4 + n - 48;
                n = this.read();
            }
            n2 += n3 * n4;
        }
        this.ungetc(n);
        this.literal = n2 >= 0 ? ESNumber.create(d * Math.pow(10.0, n2)) : ESNumber.create(d / Math.pow(10.0, -n2));
        return 257;
    }

    private int lexNumber(int n) throws ESParseException {
        int n2 = 10;
        double d = 0.0;
        boolean bl = true;
        if (n == 48) {
            n = this.read();
            if (n >= 48 && n <= 57) {
                n2 = 8;
            } else if (n == 120 || n == 88) {
                bl = false;
                n2 = 16;
                n = this.read();
            }
        }
        while (n >= 0) {
            if (n >= 48 && n <= 57) {
                d = (double)n2 * d + (double)n - 48.0;
                bl = true;
                if (n2 == 8 && n >= 56) {
                    throw this.error("expected octal digit at " + this.badChar(n));
                }
            } else if (n2 == 16 && n >= 97 && n <= 102) {
                bl = true;
                d = (double)n2 * d + (double)n - 97.0 + 10.0;
            } else {
                if (n2 != 16 || n < 65 || n > 70) break;
                bl = true;
                d = (double)n2 * d + (double)n - 65.0 + 10.0;
            }
            n = this.read();
        }
        if (!bl) {
            throw this.error("expected hex digit at " + this.badChar(n));
        }
        if (n2 == 10 && n == 46) {
            n = this.read();
            if (n >= 48 && n <= 57) {
                return this.lexFloat(d, n);
            }
            this.ungetc(n);
            this.literal = ESNumber.create(d);
            return 257;
        }
        if (n2 == 10 && (n == 101 || n == 69)) {
            return this.lexFloat(d, n);
        }
        this.ungetc(n);
        this.literal = ESNumber.create(d);
        return 257;
    }

    private int hexDigit(int n) throws ESParseException {
        if (n >= 48 && n <= 57) {
            return n - 48;
        }
        if (n >= 97 && n <= 102) {
            return n - 97 + 10;
        }
        if (n >= 65 && n <= 70) {
            return n - 65 + 10;
        }
        throw this.error("expected hex digit at " + this.badChar(n));
    }

    private int lexString(char c, String string, boolean bl, boolean bl2) throws ESParseException {
        this.text.setLength(0);
        int n = this.read();
        while (n >= 0) {
            int n2;
            if (n == 10 || n == 13) {
                if (!bl2) {
                    throw this.error("unexpected end of line in " + (bl ? "regular expression" : "string"));
                }
                if (n == 13) {
                    this.text.append('\r');
                    n = this.read();
                }
                this.newline();
            }
            if (n == c) {
                if (string == null) {
                    this.literal = ESString.create(this.text.toString());
                    return 257;
                }
                if (this.text.endsWith(string)) {
                    if (this.text.length() == string.length()) {
                        this.literal = ESString.create("");
                        return 257;
                    }
                    n2 = this.text.charAt(this.text.length() - string.length() - 1);
                    if (n2 == 10) {
                        this.text.setLength(this.text.length() - string.length() - 1);
                        this.literal = ESString.create(this.text.toString());
                        return 257;
                    }
                }
            }
            if (n == 92) {
                n = this.read();
                switch (n) {
                    case -1: {
                        throw this.error("unexpected end of file in " + (bl ? "regular expression" : "string"));
                    }
                    case 10: 
                    case 13: {
                        throw this.error("unexpected end of line in " + (bl ? "regular expression" : "string"));
                    }
                    case 98: {
                        if (bl) {
                            this.text.append("\\b");
                            break;
                        }
                        this.text.append('\b');
                        break;
                    }
                    case 101: {
                        this.text.append('\u001b');
                        break;
                    }
                    case 102: {
                        this.text.append('\f');
                        break;
                    }
                    case 110: {
                        this.text.append('\n');
                        break;
                    }
                    case 114: {
                        this.text.append('\r');
                        break;
                    }
                    case 116: {
                        this.text.append('\t');
                        break;
                    }
                    case 118: {
                        this.text.append('\u000b');
                        break;
                    }
                    case 99: {
                        n = this.read();
                        if (n >= 97 && n <= 122) {
                            this.text.append((char)(n - 97 + 1));
                            break;
                        }
                        if (n >= 65 && n <= 90) {
                            this.text.append((char)(n - 65 + 1));
                            break;
                        }
                        if (n - 64 >= 0 && n - 64 < 32) {
                            this.text.append((char)(n - 64));
                            break;
                        }
                        throw this.error("expected control character at " + this.badChar(n));
                    }
                    case 111: {
                        n2 = 0;
                        while ((n = this.read()) >= 48 && n <= 56) {
                            n2 = 8 * n2 + n - 48;
                        }
                        this.ungetc(n);
                        this.text.append((char)n2);
                        break;
                    }
                    case 120: {
                        n2 = 16 * this.hexDigit(this.read());
                        this.text.append((char)(n2 += this.hexDigit(this.read())));
                        break;
                    }
                    case 117: {
                        n2 = 4096 * this.hexDigit(this.read());
                        n2 += 256 * this.hexDigit(this.read());
                        n2 += 16 * this.hexDigit(this.read());
                        this.text.append((char)(n2 += this.hexDigit(this.read())));
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: {
                        n2 = n - 48;
                        if (n != 48 && bl) {
                            this.text.append('\\');
                            this.text.append((char)n);
                            break;
                        }
                        n = this.read();
                        if (n >= 48 && n <= 55) {
                            if ((n2 = 8 * n2 + n - 48) < 32) {
                                n = this.read();
                                if (n >= 48 && n <= 55) {
                                    n2 = 8 * n2 + n - 48;
                                } else {
                                    this.ungetc(n);
                                }
                            }
                        } else {
                            this.ungetc(n);
                        }
                        this.text.append((char)n2);
                        break;
                    }
                    default: {
                        if (bl) {
                            this.text.append('\\');
                        }
                        this.text.append((char)n);
                        break;
                    }
                }
            } else {
                this.text.append((char)n);
            }
            n = this.read();
        }
        if (n == -1) {
            throw this.error("unexpected end of file in " + (bl ? "regular expression" : "string"));
        }
        this.literal = ESString.create(this.text.toString());
        return 257;
    }

    private void scanMacroStatement(CharBuffer charBuffer, int n, boolean bl, boolean bl2) throws ESParseException {
        int n2;
        block7: while ((n2 = this.read()) >= 0 && n2 != n) {
            charBuffer.append((char)n2);
            block0 : switch (n2) {
                case 92: {
                    n2 = this.read();
                    charBuffer.append((char)n2);
                    break;
                }
                case 34: 
                case 39: {
                    int n3 = n2;
                    while ((n2 = this.read()) >= 0) {
                        if (n2 == 92) {
                            charBuffer.append((char)n2);
                            n2 = this.read();
                        } else {
                            if (n2 == n3) {
                                charBuffer.append((char)n2);
                                break block0;
                            }
                            if (n2 == 10 || n2 == 13) {
                                if (!bl2) {
                                    throw this.error("unexpected end of line in " + (bl ? "regular expression" : "string"));
                                }
                                this.newline();
                            }
                        }
                        charBuffer.append((char)n2);
                    }
                    continue block7;
                }
                case 40: {
                    this.scanMacroStatement(charBuffer, 41, bl, bl2);
                    charBuffer.append(')');
                    break;
                }
                case 123: {
                    this.scanMacroStatement(charBuffer, 125, bl, bl2);
                    charBuffer.append('}');
                    break;
                }
                case 10: 
                case 13: {
                    if (!bl2) {
                        throw this.error("unexpected end of line in " + (bl ? "regular expression" : "string"));
                    }
                    this.newline();
                    break;
                }
            }
        }
    }

    private void interpolate(CharBuffer charBuffer, int n, String string, String string2, String string3, boolean bl, boolean bl2) throws ESParseException {
        int n2 = this.read();
        charBuffer.append(string2);
        int n3 = charBuffer.length();
        block4: while (n2 >= 0) {
            switch (n2) {
                case 92: {
                    charBuffer.append((char)n2);
                    n2 = this.read();
                    if (n2 == -1) break;
                    charBuffer.append((char)n2);
                    break;
                }
                case 36: {
                    n2 = this.read();
                    if (n2 == -1) break;
                    if (n2 >= 97 && n2 <= 122 || n2 >= 65 && n2 <= 90 || n2 == 95 || n2 == 36) {
                        charBuffer.append(string3);
                        charBuffer.append("+(");
                        charBuffer.append((char)n2);
                        while ((n2 = this.read()) >= 0 && n2 >= 97 && n2 <= 122 || n2 >= 65 && n2 <= 90 || n2 >= 48 && n2 <= 57 || n2 == 95 || n2 == 36) {
                            charBuffer.append((char)n2);
                        }
                        this.ungetc(n2);
                        charBuffer.append(")+");
                        charBuffer.append(string2);
                        break;
                    }
                    if (n2 == 123) {
                        charBuffer.append(string3);
                        charBuffer.append("+(");
                        this.scanMacroStatement(charBuffer, 125, bl, bl2);
                        charBuffer.append(")+");
                        charBuffer.append(string2);
                        break;
                    }
                    if (n2 == 40) {
                        charBuffer.append(string3);
                        charBuffer.append("+(");
                        this.scanMacroStatement(charBuffer, 41, bl, bl2);
                        charBuffer.append(")+");
                        charBuffer.append(string2);
                        break;
                    }
                    this.ungetc(n2);
                    charBuffer.append('$');
                    break;
                }
                default: {
                    boolean bl3 = false;
                    if (n2 == 13 || n2 == 10) {
                        if (n2 == 13) {
                            bl3 = true;
                            n2 = this.read();
                        }
                        this.newline();
                        if (!bl2) {
                            throw this.error("unexpected end of line in " + (bl ? "regular expression" : "string"));
                        }
                    }
                    if (n2 == n) {
                        if (string == null) break block4;
                        if (charBuffer.endsWith(string)) {
                            if (charBuffer.length() - n3 == string.length()) {
                                charBuffer.setLength(n3);
                                break block4;
                            }
                            if (charBuffer.charAt(charBuffer.length() - string.length() - 1) == '\n') {
                                charBuffer.setLength(charBuffer.length() - string.length() - 1);
                                if (charBuffer.length() <= 0 || charBuffer.charAt(charBuffer.length() - 1) != '\r') break block4;
                                charBuffer.setLength(charBuffer.length() - 1);
                                break block4;
                            }
                        }
                    }
                    if (bl3) {
                        charBuffer.append('\r');
                    }
                    charBuffer.append((char)n2);
                    break;
                }
            }
            n2 = this.read();
        }
        charBuffer.append(string3);
    }

    private boolean scanMultiline() throws ESParseException {
        CharBuffer charBuffer = new CharBuffer();
        boolean bl = true;
        boolean bl2 = true;
        int n = this.read();
        if (n >= 97 && n <= 122 || n >= 65 && n <= 90 || n == 95 || n == 36) {
            while (n >= 0 && n >= 97 && n <= 122 || n >= 65 && n <= 90 || n == 95 || n == 36 || n >= 48 && n <= 57) {
                charBuffer.append((char)n);
                n = this.read();
            }
        } else if (n == 39) {
            bl = false;
            n = this.read();
            while (n >= 0 && n != 39 && n != 10) {
                charBuffer.append((char)n);
                n = this.read();
            }
            if (n != 39) {
                throw this.error("multiline escape bogus: " + this.badChar(n));
            }
            n = this.read();
        } else if (n == 96) {
            bl = false;
            n = this.read();
            while (n >= 0 && n != 96 && n != 10 && n != 13) {
                charBuffer.append((char)n);
                n = this.read();
            }
            if (n != 96) {
                throw this.error("multiline escape bogus: " + this.badChar(n));
            }
            bl2 = false;
        } else if (n == 34) {
            n = this.read();
            while (n >= 0 && n != 34 && n != 10 && n != 13) {
                charBuffer.append((char)n);
                n = this.read();
            }
            if (n != 34) {
                throw this.error("multiline escape bogus: " + this.badChar(n));
            }
            n = this.read();
        }
        int n2 = this.line;
        CharBuffer charBuffer2 = null;
        if (bl2) {
            charBuffer2 = new CharBuffer();
            while (n >= 0 && n != 10 && n != 13) {
                charBuffer2.append((char)n);
                n = this.read();
            }
            if (n == 13) {
                charBuffer2.append((char)n);
                n = this.read();
            }
            if (n == 10) {
                this.newline();
                charBuffer2.append((char)n);
            }
        }
        CharBuffer charBuffer3 = null;
        String string = charBuffer.toString();
        if (bl) {
            charBuffer3 = new CharBuffer();
            charBuffer3.append('(');
            this.interpolate(charBuffer3, 10, string, "@<<`" + string + "`", "\n" + string + "\n", false, true);
            charBuffer3.append("+'\\n')");
        } else if (bl2) {
            this.lexString('\n', string, false, true);
            this.text.append('\n');
            this.literal = ESString.create(this.text);
        } else {
            this.lexString('\n', string, false, true);
            this.line -= 2;
        }
        if (bl2) {
            this.pushMacro(charBuffer2);
            this.line = n2;
        }
        if (bl) {
            this.pushMacro(charBuffer3);
            ++this.line;
            return false;
        }
        return true;
    }

    private CharBuffer readRegexpFlags() throws ESParseException {
        int n;
        this.flags.setLength(0);
        block3: while (true) {
            n = this.read();
            switch (n) {
                case 103: 
                case 105: 
                case 109: 
                case 115: 
                case 120: {
                    this.flags.append((char)n);
                    continue block3;
                }
            }
            break;
        }
        this.ungetc(n);
        return this.flags;
    }

    private int lexId(int n) throws ESParseException {
        this.text.setLength(0);
        this.text.append((char)n);
        while ((n = this.read()) >= 97 && n <= 122 || n >= 65 && n <= 90 || n == 95 || n == 36 || n >= 48 && n <= 57) {
            this.text.append((char)n);
        }
        this.ungetc(n);
        Integer n2 = (Integer)reserved.get(this.text);
        if (n2 == null) {
            this.id = ESId.intern(this.text.toString());
            return 259;
        }
        int n3 = n2;
        switch (n3) {
            case 301: {
                this.literal = ESBase.esNull;
                return 257;
            }
            case 302: {
                this.literal = ESBase.esUndefined;
                return 257;
            }
            case 304: {
                this.literal = ESBoolean.create(false);
                return 257;
            }
            case 303: {
                this.literal = ESBoolean.create(true);
                return 257;
            }
        }
        return n2;
    }

    private int lexOp(int n) throws ESParseException {
        this.text.setLength(0);
        this.text.append((char)n);
        block3: while ((n = this.read()) >= 0) {
            switch (n) {
                case 33: 
                case 37: 
                case 38: 
                case 42: 
                case 43: 
                case 45: 
                case 46: 
                case 47: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 94: 
                case 124: {
                    this.text.append((char)n);
                    this.op = (Op)ops.get(this.text);
                    if (this.op != null) continue block3;
                    this.text.setLength(this.text.length() - 1);
                    this.ungetc(n);
                    break block3;
                }
                default: {
                    this.ungetc(n);
                    break block3;
                }
            }
        }
        this.op = (Op)ops.get(this.text);
        if (this.op == null) {
            throw this.error("expected operator at `" + this.text.toString() + "'");
        }
        return this.op.lexeme;
    }

    int getOp() {
        return this.op.op;
    }

    int getPrecedence() {
        return this.op.precedence;
    }

    boolean isRightAssoc() {
        return this.op.isRightAssoc;
    }

    ESBase getLiteral() {
        return this.literal;
    }

    String getFlags() {
        return this.flags.toString();
    }

    private void scanLine(int n) throws ESParseException {
        while (n == 32 || n == 9) {
            n = this.read();
        }
        if (n < 48 || n > 57) {
            throw this.error("expected digit at " + this.badChar(n));
        }
        this.line = 0;
        while (n >= 48 && n <= 57) {
            this.line = 10 * this.line + n - 48;
            n = this.read();
        }
        while (n == 32 || n == 9) {
            n = this.read();
        }
        if (n != 35) {
            throw this.error("expected `#' at " + this.badChar(n));
        }
    }

    private void scanFile(int n) throws ESParseException {
        while (n == 32 || n == 9) {
            n = this.read();
        }
        this.temp.clear();
        while (n >= 0 && n != 32 && n != 9 && n != 35) {
            this.temp.append((char)n);
            n = this.read();
        }
        if (this.temp.length() == 0) {
            throw this.error("expected filename at " + this.badChar(n));
        }
        this.filename = this.temp.toString();
        while (n == 32 || n == 9) {
            n = this.read();
        }
        this.line = 0;
        while (n >= 48 && n <= 57) {
            this.line = 10 * this.line + n - 48;
            n = this.read();
        }
        if (this.line == 0) {
            this.line = 1;
        }
        while (n == 32 || n == 9) {
            n = this.read();
        }
        if (n != 35) {
            throw this.error("expected `#' at " + this.badChar(n));
        }
    }

    Lexer(ReadStream readStream, String string, int n, LineMap lineMap) {
        this.filename = string;
        this.line = n;
        this.lastFilename = string;
        this.lastLine = n;
        this.lineMap = lineMap;
        this.is = readStream;
        this.peek = -1;
        this.text = new CharBuffer();
        this.lexeme = -2;
        this.lastLexeme = -2;
        this.regexpOk = true;
        this.macroText = null;
        this.macroIndex = 0;
        this.flags = new CharBuffer();
        if (ops == null) {
            ops = new HashMap();
            this.opsPut(".", 46, 46, 1, false);
            this.opsPut("++", 43, 281, 1, false);
            this.opsPut("--", 45, 281, 1, false);
            this.opsPut("~", 126, 264, 3, false);
            this.opsPut("!", 33, 264, 3, false);
            this.opsPut("*", 42, 263, 4, false);
            this.opsPut("/", 47, 263, 4, false);
            this.opsPut("%", 37, 263, 4, false);
            this.opsPut("+", 43, 265, 5, false);
            this.opsPut("-", 45, 265, 5, false);
            this.opsPut(">>", 266, 263, 6, false);
            this.opsPut(">>>", 267, 263, 6, false);
            this.opsPut("<<", 268, 263, 6, false);
            this.opsPut(">", 62, 263, 7, false);
            this.opsPut(">=", 271, 263, 7, false);
            this.opsPut("<", 60, 263, 7, false);
            this.opsPut("<=", 272, 263, 7, false);
            this.opsPut("==", 273, 263, 7, false);
            this.opsPut("!=", 274, 263, 7, false);
            this.opsPut("===", 275, 263, 7, false);
            this.opsPut("!==", 276, 263, 7, false);
            this.opsPut("&", 38, 263, 9, false);
            this.opsPut("^", 94, 263, 10, false);
            this.opsPut("|", 124, 263, 11, false);
            this.opsPut("&&", 277, 263, 12, false);
            this.opsPut("||", 278, 263, 13, false);
            this.opsPut("?", 63, 63, 14, false);
            this.opsPut("=", 61, 61, 15, true);
            this.opsPut("*=", 42, 61, 15, true);
            this.opsPut("/=", 47, 61, 15, true);
            this.opsPut("%=", 37, 61, 15, true);
            this.opsPut("+=", 43, 61, 15, true);
            this.opsPut("-=", 45, 61, 15, true);
            this.opsPut(">>=", 266, 61, 15, true);
            this.opsPut(">>>=", 267, 61, 15, true);
            this.opsPut("<<=", 268, 61, 15, true);
            this.opsPut("&=", 38, 61, 15, true);
            this.opsPut("^=", 94, 61, 15, true);
            this.opsPut("|=", 124, 61, 15, true);
            this.opsPut(",", 44, 44, 16, false);
            reserved = new HashMap();
            this.resPut("new", 298);
            this.resPut("var", 299);
            this.resPut("delete", 282);
            this.resPut("void", 283);
            this.resPut("typeof", 284);
            this.resPut("if", 285);
            this.resPut("else", 286);
            this.resPut("switch", 287);
            this.resPut("case", 288);
            this.resPut("default", 289);
            this.resPut("while", 290);
            this.resPut("do", 291);
            this.resPut("for", 292);
            this.resPut("in", 293);
            this.resPut("break", 294);
            this.resPut("continue", 295);
            this.resPut("null", 301);
            this.resPut("undefined", 302);
            this.resPut("true", 303);
            this.resPut("false", 304);
            this.resPut("this", 260);
            this.resPut("eval", 305);
            this.resPut("function", 296);
            this.resPut("return", 297);
            this.resPut("with", 300);
            this.resPut("class", 306);
            this.resPut("extends", 307);
            this.resPut("synchronized", 308);
            this.resPut("try", 309);
            this.resPut("catch", 310);
            this.resPut("finally", 311);
            this.resPut("throw", 312);
            this.resPut("import", 313);
            this.resPut("static", 314);
            this.resPut("const", 256);
            this.resPut("debugger", 256);
            this.resPut("enum", 256);
            this.resPut("export", 256);
            this.resPut("super", 256);
            this.resPut("boolean", 256);
            this.resPut("byte", 256);
            this.resPut("char", 256);
            this.resPut("double", 256);
            this.resPut("float", 256);
            this.resPut("int", 256);
            this.resPut("long", 256);
            this.resPut("short", 256);
            this.resPut("public", 256);
            this.resPut("private", 256);
            this.resPut("protected", 256);
            this.resPut("throws", 256);
        }
    }

    Lexer(ReadStream readStream, String string, int n) {
        this(readStream, string, n, null);
    }

    Lexer(ReadStream readStream, LineMap lineMap) {
        this(readStream, null, 1, lineMap);
    }

    static class Op {
        int op;
        int lexeme;
        int precedence;
        boolean isRightAssoc;

        Op(int n, int n2, int n3, boolean bl) {
            this.op = n;
            this.lexeme = n2;
            this.precedence = n3;
            this.isRightAssoc = bl;
        }
    }

    class Macro {
        CharBuffer text;
        int index;
        int oldLine;

        void clear() {
            this.text.clear();
            this.index = 0;
        }

        Macro(CharBuffer charBuffer, int n, int n2) {
            this.text = charBuffer;
            this.index = n;
            this.oldLine = n2;
        }
    }
}

