/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.parser;

import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.parser.AssignExpr;
import com.caucho.es.parser.Block;
import com.caucho.es.parser.CallExpr;
import com.caucho.es.parser.DeleteExpr;
import com.caucho.es.parser.Expr;
import com.caucho.es.parser.Function;
import com.caucho.es.parser.PostfixExpr;
import com.caucho.es.parser.Variable;
import java.io.IOException;

class IdExpr
extends Expr {
    private static ESId ARGUMENTS = ESId.intern("arguments");
    private Variable var;

    void setType(int n) {
        this.var.setType(n);
    }

    boolean isLocal() {
        return this.var.isLocal() && this.function.allowLocals();
    }

    boolean isJavaLocal() {
        return this.var.isJavaLocal() && this.function.allowLocals();
    }

    void setUsed() {
        this.var.setUsed();
    }

    int getType() {
        if (!this.isLocal()) {
            return 1;
        }
        return this.var.getType();
    }

    boolean isSimple() {
        return this.isJavaLocal();
    }

    boolean isGlobalScope() {
        return this.function.isGlobalScope() && !this.var.isScope();
    }

    Variable getVar() {
        return this.var;
    }

    boolean isUsed() {
        return this.var.isUsed() || this.function.useAllVariables();
    }

    void setLocal() {
        this.var.setLocal();
    }

    ESId getId() {
        return this.var.getId();
    }

    Expr delete() {
        return new DeleteExpr(this.block, this);
    }

    Expr postfix(int n) {
        if (n == 43) {
            return new PostfixExpr(this.block, 73, this);
        }
        return new PostfixExpr(this.block, 68, this);
    }

    Expr prefix(int n) {
        if (n == 43) {
            return new PostfixExpr(this.block, 105, this);
        }
        return new PostfixExpr(this.block, 100, this);
    }

    Expr assign(Expr expr) throws ESException {
        int n = expr.getType();
        int n2 = this.var.type;
        if (this.isLocal()) {
            if (n == 0 || n2 == 2) {
                n = 1;
            }
            if (n2 == 0) {
                this.var.setType(n);
            } else if (n2 != n) {
                if (!(n2 != 4 && n2 != 3 || n != 4 && n != 3)) {
                    this.var.setType(3);
                } else {
                    this.var.setType(1);
                }
            }
        }
        return new AssignExpr(this.block, this, expr);
    }

    CallExpr startCall() throws ESException {
        this.var.setUsed();
        return new CallExpr(this.block, this, null, false);
    }

    CallExpr startNew() throws ESException {
        this.var.setUsed();
        return new CallExpr(this.block, this, null, true);
    }

    void exprStatement(Function function) throws ESException {
        this.doVoid().exprStatement(function);
    }

    void printNumImpl() throws IOException {
        this.cl.print(this.getId());
    }

    void printBooleanImpl() throws IOException {
        this.cl.print(this.getId());
    }

    void printInt32Impl() throws IOException {
        this.cl.print(this.getId());
    }

    void printStringImpl() throws IOException {
        this.cl.print("CharBuffer.allocate()");
        this.cl.print(".append(");
        this.cl.print(this.getId());
        this.cl.print(")");
    }

    void printImpl() throws IOException {
        this.cl.setLine(this.getFilename(), this.getLine());
        if (this.isJavaLocal()) {
            this.cl.print(this.getId());
        } else if (this.isGlobalScope()) {
            this.cl.print("_env.getGlobalVariable(");
            this.printLiteral(this.getId());
            this.cl.print(")");
        } else {
            this.cl.print("_env.getScopeProperty(");
            this.printLiteral(this.getId());
            this.cl.print(")");
        }
    }

    IdExpr(Block block, Variable variable) {
        super(block);
        this.var = variable;
        if (variable.getId() == ARGUMENTS) {
            this.function.setArguments();
            this.function.setUseAllVariables();
        }
        if (!variable.isLocal() && !this.function.isGlobalScope()) {
            this.function.setNeedsScope();
        }
    }
}

