/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.parser;

import com.caucho.es.ESId;
import com.caucho.es.parser.Block;
import com.caucho.es.parser.Expr;
import com.caucho.es.parser.IdExpr;
import com.caucho.es.parser.ParseClass;
import com.caucho.es.parser.Variable;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

class Function {
    static ESId PROTOTYPE = ESId.intern("prototype");
    ParseClass cl;
    private Function parent;
    int funDepth;
    private int lambdaCount = 0;
    ArrayList formals;
    ArrayList variables = new ArrayList();
    ArrayList functions;
    private IntMap funMap;
    boolean isClass;
    ESId classProto;
    Function constructor;
    String name;
    ESId id;
    int num;
    boolean isSilent;
    boolean hasCall;
    boolean hasThis;
    boolean allowLocals;
    boolean allowJavaLocals;
    boolean needsScope;
    ArrayList data = new ArrayList();
    private HashMap vars = new HashMap();
    CharBuffer tail;
    private int iterCount;
    private int tempCount;
    private int stmtCount;
    private int stmtTop;
    private HashMap usedVars;
    private boolean isGlobal;
    private boolean needsArguments;
    private boolean needsStatementResults;
    private boolean useAllVariables;
    private boolean isEval;
    private boolean hasSwitch;

    Function getParent() {
        return this.parent;
    }

    boolean isGlobalScope() {
        return !this.needsScope && (this.getFunctionDepth() == 0 || this.getFunctionDepth() == 1 && !this.needsArguments());
    }

    boolean needsStatementResults() {
        return this.needsStatementResults;
    }

    void setNeedsResults() {
        this.needsStatementResults = true;
    }

    void setEval() {
        this.setArguments();
        this.needsStatementResults = true;
        this.isEval = true;
    }

    boolean useAllVariables() {
        return this.isEval || this.useAllVariables;
    }

    void setUseAllVariables() {
        this.useAllVariables = true;
    }

    String getStatementVar() {
        if (!this.needsStatementResults()) {
            return null;
        }
        return "_val" + this.stmtCount;
    }

    void pushStatementLoop() {
        if (!this.needsStatementResults()) {
            return;
        }
        ++this.stmtCount;
        if (this.stmtCount > this.stmtTop) {
            this.stmtTop = this.stmtCount;
        }
    }

    void popStatementLoop() {
        if (!this.needsStatementResults()) {
            return;
        }
        --this.stmtCount;
    }

    void setCall() {
        this.hasCall = true;
    }

    void setThis() {
        this.hasThis = true;
    }

    void setVars() {
        Iterator iterator = this.vars.values().iterator();
        while (iterator.hasNext()) {
            Variable variable = (Variable)iterator.next();
            variable.getType();
        }
    }

    boolean isGlobal() {
        return this.isGlobal;
    }

    int getFunctionDepth() {
        return this.funDepth;
    }

    void disableGlobal() {
        this.isGlobal = false;
    }

    void disallowLocal() {
        if (this.parent != null) {
            this.allowJavaLocals = false;
            this.allowLocals = false;
            this.needsScope = true;
        }
    }

    void disallowJavaLocal() {
        this.allowJavaLocals = false;
    }

    void setNeedsScope() {
        if (this.parent != null) {
            this.needsScope = true;
        }
    }

    void setArguments() {
        this.needsArguments = true;
        this.setNeedsScope();
        this.disallowLocal();
    }

    boolean needsArguments() {
        return this.needsArguments;
    }

    boolean allowLocals() {
        return this.allowLocals;
    }

    boolean allowJavaLocals() {
        return this.allowLocals && this.allowJavaLocals;
    }

    void useClosureVar(ESId eSId) {
        Function function = this.parent;
        while (function != null) {
            Variable variable = (Variable)function.vars.get(eSId);
            function.needsArguments = true;
            if (variable != null) {
                variable.setUsedByClosure();
            } else {
                if (function.usedVars == null) {
                    function.usedVars = new HashMap();
                }
                function.usedVars.put(eSId, eSId);
            }
            function = function.parent;
        }
    }

    IdExpr newVar(Block block, ESId eSId) {
        Variable variable = (Variable)this.vars.get(eSId);
        if (variable == null) {
            variable = new Variable(block, eSId, false);
            this.vars.put(eSId, variable);
            if (this.usedVars != null && this.usedVars.get(eSId) != null) {
                variable.setUsedByClosure();
            }
        }
        this.useClosureVar(eSId);
        return new IdExpr(block, variable);
    }

    void addVariable(Block block, ESId eSId) {
        Variable variable;
        if (this.variables == null) {
            this.variables = new ArrayList();
        }
        if ((variable = (Variable)this.vars.get(eSId)) == null) {
            variable = new Variable(block, eSId, this.parent != null);
            this.vars.put(eSId, variable);
            if (this.usedVars != null && this.usedVars.get(eSId) != null) {
                variable.setUsedByClosure();
            }
        } else if (this.parent != null) {
            variable.setLocal();
        }
        if (!(this.variables.contains(variable) || this.formals != null && this.formals.contains(variable))) {
            this.variables.add(variable);
        }
        this.useClosureVar(eSId);
    }

    int getIter() {
        return this.iterCount++;
    }

    String getTemp() {
        return "temp" + this.tempCount++;
    }

    void setConstructor(Function function) {
        this.isClass = true;
        this.constructor = function;
    }

    int getFormalsSize() {
        return this.formals == null ? 0 : this.formals.size();
    }

    void setClassProto(ESId eSId) {
        this.isClass = true;
        this.classProto = eSId;
    }

    void setCodeNumber(int n) {
        this.num = n;
    }

    void addFormal(Block block, ESId eSId) {
        if (this.formals == null) {
            this.formals = new ArrayList();
        }
        Variable variable = new Variable(block, eSId, true);
        variable.setType(1);
        this.formals.add(variable);
        this.vars.put(eSId, variable);
    }

    int getFormalSize() {
        return this.formals == null ? 0 : this.formals.size();
    }

    Variable getFormal(int n) {
        return (Variable)this.formals.get(n);
    }

    int getVariableSize() {
        return this.variables == null ? 0 : this.variables.size();
    }

    void addFunction(Function function) {
        int n;
        if (this.functions == null) {
            this.functions = new ArrayList();
            this.funMap = new IntMap();
        }
        if ((n = this.funMap.get(function.id)) < 0) {
            this.funMap.put(function.id, this.functions.size());
            this.functions.add(function);
        } else {
            this.functions.set(n, function);
        }
    }

    int getFunctionSize() {
        return this.functions == null ? 0 : this.functions.size();
    }

    Function getFunction(int n) {
        return (Function)this.functions.get(n);
    }

    Function getFunction(ESId eSId) {
        if (this.funMap == null) {
            return null;
        }
        int n = this.funMap.get(eSId);
        if (n >= 0) {
            return (Function)this.functions.get(n);
        }
        return null;
    }

    void print(Object object) {
        if (this.tail == null) {
            this.tail = CharBuffer.allocate();
        }
        this.tail.append(String.valueOf(object));
    }

    void println(String string) {
        if (this.tail == null) {
            this.tail = CharBuffer.allocate();
        }
        this.tail.append(String.valueOf(string));
        this.tail.append('\n');
    }

    void addExpr(Expr expr) {
        if (this.tail != null) {
            this.data.add(this.tail);
        }
        this.tail = null;
        this.data.add(expr);
        expr.setUsed();
    }

    void addBoolean(Expr expr) {
        if (this.tail != null) {
            this.data.add(this.tail);
        }
        this.tail = null;
        this.data.add(expr.setBoolean());
        expr.setUsed();
    }

    Object getTop() {
        if (this.tail != null) {
            return this.tail;
        }
        if (this.data.size() > 0) {
            return this.data.get(this.data.size() - 1);
        }
        this.tail = new CharBuffer();
        return this.tail;
    }

    Object getSwitch() {
        if (this.tail != null) {
            this.data.add(this.tail);
        }
        this.tail = null;
        this.hasSwitch = true;
        return this.data.get(this.data.size() - 1);
    }

    int mark() {
        if (this.tail != null) {
            this.data.add(this.tail);
        }
        this.tail = null;
        return this.data.size();
    }

    void moveChunk(Object object, int n) {
        if (this.tail != null) {
            this.data.add(this.tail);
        }
        this.tail = null;
        int n2 = 0;
        while (n2 < n) {
            if (this.data.get(n2) == object) break;
            ++n2;
        }
        ++n2;
        int n3 = this.data.size();
        int n4 = 0;
        while (n4 < n3 - n) {
            Object e = this.data.remove(this.data.size() - 1);
            this.data.add(n2, e);
            ++n4;
        }
    }

    void writeCode(ParseClass parseClass) throws IOException {
        Object object;
        parseClass.println("public ESBase " + this.name + "(Call _env, int _length)");
        parseClass.println("throws Exception");
        parseClass.println("{");
        if (this.hasCall) {
            parseClass.println("  Call _call = _env.getCall();");
        }
        if (this.hasThis) {
            parseClass.println("  ESObject _this = _env.getThis();");
        }
        if (this.parent != null && this.functions != null && this.functions.size() > 0) {
            this.needsArguments = true;
            this.setNeedsScope();
        }
        if (this.isEval) {
            parseClass.println("ESObject _arg = _env.getEval();");
        } else {
            if (this.needsScope && this.parent != null) {
                parseClass.println("  _env.fillScope();");
            }
            if (this.needsArguments && this.parent != null) {
                parseClass.print("ESObject _arg = _env.createArg(");
                if (this.getFormalSize() > 0) {
                    parseClass.print("_a_" + this.num);
                } else {
                    parseClass.print("_a_null");
                }
                parseClass.println(", _length);");
            }
        }
        int n = 0;
        while (this.formals != null && n < this.formals.size()) {
            block56: {
                object = (Variable)this.formals.get(n);
                if (this.funMap == null || this.funMap.get(((Variable)object).getId()) < 0) {
                    int n2 = n + 1;
                    while (n2 < this.formals.size()) {
                        if (((Variable)object).getId() != ((Variable)this.formals.get(n2)).getId()) {
                            ++n2;
                            continue;
                        }
                        break block56;
                    }
                    if (this.allowLocals) {
                        parseClass.print("ESBase " + ((Variable)object).getId());
                        parseClass.println(" = _env.getArg(" + n + ", _length);");
                    }
                }
            }
            ++n;
        }
        n = 0;
        while (n < this.variables.size()) {
            object = (Variable)this.variables.get(n);
            if (this.funMap == null || this.funMap.get(((Variable)object).getId()) < 0) {
                if (this.isGlobal()) {
                    parseClass.print("  _env.global.setProperty(");
                    parseClass.printLiteral(((Variable)object).getId());
                    parseClass.println(", ESBase.esUndefined);");
                } else if (((Variable)object).isUsed() || this.useAllVariables()) {
                    if (!this.allowLocals || !((Variable)object).isJavaLocal()) {
                        if (this.isEval) {
                            parseClass.print("  if (_arg.getProperty(");
                            parseClass.printLiteral(((Variable)object).getId());
                            parseClass.println(") == ESBase.esEmpty)");
                            parseClass.print("  ");
                        }
                        if (!((Variable)object).hasInit()) {
                            parseClass.print("  _arg.put(");
                            parseClass.printLiteral(((Variable)object).getId());
                            parseClass.print(", ESBase.esUndefined, ");
                            if (!this.isEval) {
                                parseClass.print("ESBase.DONT_ENUM|ESBase.DONT_DELETE");
                            } else {
                                parseClass.print("0");
                            }
                            parseClass.println(");");
                        }
                    } else if (((Variable)object).getType() == 5) {
                        parseClass.println("  boolean " + ((Variable)object).getId() + ";");
                        if (!((Variable)object).hasInit()) {
                            parseClass.println(((Variable)object).getId() + " = false;");
                        }
                    } else if (((Variable)object).getType() == 4) {
                        parseClass.println("  int " + ((Variable)object).getId() + ";");
                        if (!((Variable)object).hasInit()) {
                            parseClass.println(((Variable)object).getId() + " = 0;");
                        }
                    } else if (((Variable)object).getType() == 3) {
                        parseClass.println("  double " + ((Variable)object).getId() + ";");
                        if (!((Variable)object).hasInit()) {
                            parseClass.println(((Variable)object).getId() + " = Double.NaN;");
                        }
                    } else if (((Variable)object).isLocal()) {
                        parseClass.println("  ESBase " + ((Variable)object).getId() + ";");
                        if (!((Variable)object).hasInit()) {
                            parseClass.println(((Variable)object).getId() + " = ESBase.esUndefined;");
                        }
                    } else {
                        parseClass.print("  _env.global.setProperty(");
                        parseClass.printLiteral(((Variable)object).getId());
                        parseClass.println(", ESBase.esUndefined);");
                    }
                }
            }
            ++n;
        }
        n = 0;
        while (this.needsArguments && this.functions != null && n < this.functions.size()) {
            if (n == 0) {
                parseClass.println("ESClosure _closure;");
            }
            object = (Function)this.functions.get(n);
            Variable variable = (Variable)this.vars.get(((Function)object).id);
            if (this.isGlobal || this.isEval || variable == null || variable.isUsed() || this.useAllVariables) {
                parseClass.print("_closure = new ESClosure(");
                parseClass.printLiteral(((Function)object).id);
                parseClass.println(", this, null, " + ((Function)object).num + ", _a_null, null);");
                parseClass.println("_closure.closure(_env);");
                if (!this.isEval && this.allowLocals && variable != null && variable.isUsed() && variable.isJavaLocal()) {
                    parseClass.println("ESBase " + ((Function)object).id + " = _closure;");
                } else {
                    if (!this.isEval && this.parent != null) {
                        parseClass.print("_arg.put(");
                    } else {
                        parseClass.print("_env.global.put(");
                    }
                    parseClass.printLiteral(((Function)object).id);
                    parseClass.print(", _closure, ");
                    if (!this.isEval) {
                        parseClass.print("ESBase.DONT_ENUM|ESBase.DONT_DELETE");
                    } else {
                        parseClass.print("0");
                    }
                    parseClass.println(");");
                }
            }
            ++n;
        }
        n = 0;
        while (n < this.iterCount) {
            parseClass.println("  java.util.Iterator iter" + n + ";");
            ++n;
        }
        n = 0;
        while (n < this.tempCount) {
            parseClass.println("  ESBase temp" + n + ";");
            ++n;
        }
        if (this.needsStatementResults()) {
            parseClass.println("  ESBase _val0 = ESBase.esUndefined;");
        }
        n = 1;
        while (n <= this.stmtTop) {
            parseClass.println("  ESBase _val" + n + " = ESBase.esUndefined;");
            ++n;
        }
        if (this.hasSwitch) {
            parseClass.println("int _switchcode;");
            parseClass.println("ESBase _switchtemp;");
        }
        n = 0;
        while (n < this.data.size()) {
            object = this.data.get(n);
            if (object instanceof CharBuffer) {
                parseClass.print((CharBuffer)object);
            } else if (object instanceof Expr) {
                Expr expr = (Expr)object;
                expr.printExpr();
            }
            ++n;
        }
        if (this.tail != null) {
            parseClass.print(this.tail);
        }
        parseClass.println("}");
        parseClass.println();
    }

    Function(ParseClass parseClass, Function function, String string, ESId eSId, boolean bl) {
        this.id = eSId;
        this.name = string;
        this.parent = function;
        this.cl = parseClass;
        this.funDepth = function == null || bl ? 0 : function.funDepth + 1;
        this.num = -1;
        this.isGlobal = function == null;
        this.allowJavaLocals = this.allowLocals = this.funDepth >= 1 || bl;
        this.needsStatementResults = function == null;
    }
}

