/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.parser;

import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.parser.Block;
import com.caucho.es.parser.Expr;
import com.caucho.es.parser.Function;
import com.caucho.es.parser.IdExpr;
import com.caucho.es.parser.LiteralExpr;
import java.io.IOException;
import java.util.ArrayList;

class CallExpr
extends Expr {
    private Expr term;
    private Expr field;
    private boolean isNew;
    private boolean isTop;
    private ArrayList args = new ArrayList();

    void exprStatement(Function function) throws ESException {
        this.isTop = true;
        function.addExpr(this);
    }

    void printImpl() throws IOException {
        Expr expr;
        if (this.term instanceof IdExpr && this.field == null && !((IdExpr)this.term).isJavaLocal()) {
            ESId eSId = ((IdExpr)this.term).getId();
            try {
                this.field = new LiteralExpr(this.block, eSId);
                this.term = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.term != null) {
            if (this.isNew) {
                this.cl.print("_call.doNew(");
            } else {
                this.cl.print("_call.call(");
            }
            this.term.print();
            if (this.field != null) {
                this.cl.print(", ");
                this.field.printStr();
            }
        } else if (this.function.isGlobalScope()) {
            if (this.isNew) {
                this.cl.print("_call.doNew(_env.global, ");
            } else {
                this.cl.print("_call.call(_env.global, ");
            }
            this.field.printStr();
        } else {
            if (this.isNew) {
                this.cl.print("_call.newScope(");
            } else {
                this.cl.print("_call.callScope(");
            }
            this.field.printStr();
        }
        int n = this.function.cl.getCallDepth();
        this.cl.print(", " + n);
        int n2 = 0;
        while (n2 < this.args.size() && n2 < 3) {
            expr = (Expr)this.args.get(n2);
            this.cl.print(", ");
            this.function.cl.pushCall();
            expr.print();
            ++n2;
        }
        if (this.args.size() >= 3) {
            this.cl.print(", 3");
        }
        n2 = 3;
        while (n2 < this.args.size()) {
            expr = (Expr)this.args.get(n2);
            this.cl.print("+ _call.arg(" + (n2 + n) + ", ");
            this.function.cl.pushCall();
            expr.print();
            this.cl.print(")");
            ++n2;
        }
        this.function.cl.popCall(this.args.size());
        this.cl.print(")");
        if (this.isTop) {
            this.cl.println(";");
        }
    }

    void addCallParam(Expr expr) {
        expr.setUsed();
        this.args.add(expr);
    }

    CallExpr(Block block, Expr expr, Expr expr2, boolean bl) throws ESException {
        super(block);
        this.term = expr;
        this.field = expr2;
        this.isNew = bl;
        if (expr != null) {
            expr.setUsed();
        }
        if (expr2 != null) {
            expr2.setUsed();
        }
        block.function.setCall();
    }
}

